<?php

/*
 * Copyright 2012 Zhtx Systems, Inc.
 */

require_once(APP_ROOT . "plugins/system/smarty/SmartyBC.class.php");
require_once(APP_ROOT . "conf/site.conf.php");
require_once(APP_ROOT . 'conf/auth.conf.php');
class Template extends SmartyBC
{
  const PER_CACHE = 2;
//  public function __construct(array $options = array())
//  {
//    parent::__construct($options);
//  }

  /*
   * Default cache time is 20 minutes
   */

  public function __construct($plugins_dir = "", $module, $caching = false, $cacheTime = 1200, array $options = array())
  {
    parent::__construct($options);
    $this->template_dir = APP_ROOT . "res/thems";
    if (!is_dir(APP_ROOT . "cache/tpl/$module/"))
    {
      @mkdir(APP_ROOT . "cache/tpl/$module/");
    }
    if (!is_dir(APP_ROOT . "cache/page/$module/"))
    {
      @mkdir(APP_ROOT . "cache/page/$module/");
    }
    $this->compile_dir = APP_ROOT . "cache/tpl/$module/";
    $this->config_dir = APP_ROOT . "configs/";
    $this->cache_dir = APP_ROOT . "cache/page/$module/";
    if ($plugins_dir)
    {
      $this->plugins_dir = $plugins_dir;
    }
    $this->left_delimiter = "<{";
    $this->right_delimiter = "}>";
    //$this->caching = true;
    if ($caching)
    {
      $this->caching = 2;
    }

    if (!is_null($cacheTime))
    {
      $this->cache_lifetime = $cacheTime;
    }
  }

  public function setCaching($c)
  {
    $this->caching = $c;
  }

  public function setCacheTime($ct)
  {
    $this->cache_lifetime = $ct;
  }

  public function set($name, $val = null)
  {
    $this->assign($name, $val);
  }

  public function isCached($tplName, $cacheId = NULL)
  {
    return $this->is_cached($tplName, $cacheId);
  }

  public function registerFunction($tagName, $funcName)
  {
    $this->register_function($tagName, $funcName);
  }

  public function registerBlock($tagName, $funcName = null)
  {
    if ($funcName == null)
    {
      $this->register_block($tagName, "default_dynamic_block_func", false);
    }
    else
    {
      $this->register_block($tagName, $funcName, false);
    }
  }

  public function getOutput($tplName, $cacheId = NULL)
  {
    return $this->fetch($tplName, $cacheId);
  }

  public function render($tplName, $cacheId = NULL, $isFetch=FALSE)
  {
    if($isFetch)
    {
      return $this->fetch($tplName, $cacheId, NULL, NULL, false);
    }
    else
    {
      $this->display($tplName, $cacheId);
    }
  }
  
public static function getRemoteData($url, $charsetfrom="", $charsetto="", $timeout=5, $post_data=array())
  {
      $ch = curl_init();
      $url = self::parseUrl($url);
      curl_setopt($ch, CURLOPT_URL, $url); 
      curl_setopt($ch, CURLOPT_USERAGENT, $_SERVER['HTTP_USER_AGENT']);
      curl_setopt($ch,CURLOPT_HEADER,0);   
      curl_setopt($ch,CURLOPT_TIMEOUT,$timeout);   
      curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1); 
      curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, $timeout);  
      if(count($post_data)>0)
      {
          curl_setopt($ch, CURLOPT_POST, 1 );
          curl_setopt($ch, CURLOPT_POSTFIELDS, $post_data);
      }

      //在需要用户检测的网页里需要增加下面两行
      /*
      curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_ANY); 
      curl_setopt($ch, CURLOPT_USERPWD, US_NAME.":".US_PWD); 
       * *
       */
      $contents = curl_exec($ch);      
      curl_close($ch); //print_r($contents);die;
      if( $charsetfrom != "" && $charsetto != "" )
      {
          $contents = iconv($charsetfrom, $charsetto,$contents);
      }
      return $contents; 

  }
  public static function parseUrl($url="")
  {
    $a = array(" ");
    $b = array("%20");
    $url = str_replace($a, $b, $url);
    return $url;
  }

}

function default_dynamic_block_func($param, $content, &$smarty)
{
  return $content;
}

?>
