<?php
/**
 * 文件上传工具类
 * @author xrx 
 */
require_once(APP_ROOT . 'conf/site.conf.php');
require_once(APP_ROOT . 'conf/ip.conf.php');
class Upload {
    /**
     * 上传目标路径
     * @var type 
     */
     static $filepath = UPLOAD_DIR;
     /**
      * 目标文件名
      * @var type 
      */
     static $filename;
     /**
      * 图片的宽度
      * @var type 
      */
     static $image_x;
     /**
      * 图片的高度
      * @var type 
      */
     static $image_y;
     /**
      * 允许上传的文件类型
      * @var type 
      */
     static $allowed = array(
            'jpg'  => 'image/jpeg',
            'jpeg' => 'image/jpeg',
            'jpe'  => 'image/jpeg',
            'gif'  => 'image/gif',
            'png'  => 'image/png',
            'csv'  => 'text/csv',
			'rar' => 'application/octet-stream' ,
			'zip' => 'application/zip' ,
			'rar' => 'video/avi' ,
			'flv' => 'application/octet-stream' ,
			'txt' => 'text/plain' ,
			'doc' => 'application/msword' ,
			'xls' => 'application/vnd.ms-excel' ,
			'ppt' => 'application/ppt' ,
			'pdf' => 'application/pdf' ,
			'xml' => 'text/xml' ,
			'psd' => 'application/octet-stream' ,
			'bmp' => 'image/bmp' ,
			'ico' => 'image/x-icon' ,
			'avi' => 'video/avi' ,
         );
     /**
      * 允许上传最大值
      * @var type 
      */
    static $max_size;
    /**
     * 构造函数
     * @param type $filepath 目标路径
     * @param type $filename 目标文件名
     * @param type $x  宽度
     * @param type $y  高度
     * @param type $max_size 最大值 
     */
    public function upload($filepath, $filename = null, $x = 0, $y = 0, $max_size = 2048)
    {
        if($filepath)
        self::$filepath = $filepath;
        self::$filename = $filename;
        self::$image_x  = $x;
        self::$image_y  = $y;
        self::$max_size = $max_size;
    }
    /**
     * 执行文件上传
     * @param type $file
     * @return boolean|string 
     */
    public static function processed($file){
        if(!is_array($file))
        {
            return FALSE;
        }
        global $ip_limit;
        if(count($ip_limit) > 0 && !in_array(self::ip(), $ip_limit))
        {
          return FALSE;
        }
//        $filesize    = $file["size"];
        $path_parts  = pathinfo($file['name']);
        $path_name_array = preg_split("/\./" , $path_parts["basename"] ) ; 
        $file_type = self::filterParam($path_name_array[count($path_name_array)-1]);
        $filename_temp = basename($file['name'],'.' . $path_parts["extension"]);
//        if($filesize >= self::$max_size)
//        {
//            return FALSE;
//        }
        if(!self::allowed(strtolower($file_type)))
        {
            return FALSE;
        }
        $upload_file = $file['tmp_name'];
        $filepath    = self::filterParam(self::$filepath);          
        $filename    = self::$filename;
        if(!$filename)
        {                                     
            $filename        = $filename_temp;
        }
        if(!file_exists($filepath))
        {
            self::rmkdir($filepath);
        }
        $file_src_name = $filepath . $filename . '.' . $path_parts["extension"];
        if(!move_uploaded_file($upload_file, $file_src_name))
        {
             return FALSE;
        }
        touch($file_src_name);
        return $file_src_name;	    
    }
    /**
     * 验证文件类型
     * @param type $type
     * @return type 
     */
    public static function allowed($type)
    {       
        $allowed = self::$allowed;
        return isset($allowed[strtolower($type)]);
    }
    /**
     * 过滤非法字符串
     * @param type $param
     * @return type 
     */
    public static function filterParam($param)
    {
//        $arr_check   = array('&','"',"'",'`','.',',','(',')','+','#',":"," ","<",">","*","?","|",'\\','%');
//        $arr_check   = array('#',"*","?","|",'\\','%');
        $arr_check = array('&', '"', "'", '`', '.', ',', '(', ')', '+', '#', ":", " ", "<", ">", "*", "?", "|", '\\', '%');
        $arr_replace = array_fill ( 0 , count($arr_check) , '-');
        return str_replace($arr_check,$arr_replace,$param);
    }
    /**
     * 创建目录
     * @param type $path
     * @param type $mode
     * @return type 
     */
    public static function rmkdir($path, $mode = 0777) {
        return is_dir($path) || ( self::rmkdir(dirname($path), $mode) && self::_mkdir($path, $mode) );
    }
    /**
     * 创建目录
     * @param type $path
     * @param type $mode
     * @return type 
     */
    public static function _mkdir($path, $mode = 0777) {
        $old = umask(0);
        $res = @mkdir($path, $mode);
        umask($old);
        return $res;
    }
    
    public static function createNewImage()
    {
        
    }
    /**
     * 获取请求ip
     * @return ip地址
     */
    static function ip() {
        if (getenv('HTTP_CLIENT_IP') && strcasecmp(getenv('HTTP_CLIENT_IP'), 'unknown')) {
            $ip = getenv('HTTP_CLIENT_IP');
        } elseif (getenv('HTTP_X_FORWARDED_FOR') && strcasecmp(getenv('HTTP_X_FORWARDED_FOR'), 'unknown')) {
            $ip = getenv('HTTP_X_FORWARDED_FOR');
        } elseif (getenv('REMOTE_ADDR') && strcasecmp(getenv('REMOTE_ADDR'), 'unknown')) {
            $ip = getenv('REMOTE_ADDR');
        } elseif (isset($_SERVER['REMOTE_ADDR']) && $_SERVER['REMOTE_ADDR'] && strcasecmp($_SERVER['REMOTE_ADDR'], 'unknown')) {
            $ip = $_SERVER['REMOTE_ADDR'];
        }
        return preg_match('/[\d\.]{7,15}/', $ip, $matches) ? $matches [0] : '';
    }
}

?>
