<?php
    /**
    * 验证码类
    * @author xrx 
    */ 
   class ValidateCode {  
          private $charset = 'abcdefghkmnprstuvwxyzABCDEFGHKMNPRSTUVWXYZ123456789'; //随机因子  
          private  $code;       //验证码  
          private $codelen = 4;     //验证码长度  
          private $width = 130;     //宽度  
          private $height = 35;     //高度  
          private $img;        //图形资源句柄  
          private $font;        //指定的字体  
          private $fontsize = 20;    //指定字体大小  
          private $fontcolor;      //指定字体颜色  
    
          //构造方法初始化  
          public function __construct() {  
             $this->font = APP_ROOT.'verdana.ttf';
             $this->code = $this->createCode();
          }  
    
        //生成随机码  
          private function createCode() {  
             $_len = strlen($this->charset)-1;
             $code = '';
             for ($i=0; $i<$this->codelen; $i++) {  
                    $code .= $this->charset[mt_rand(0,$_len)];  
             }
             return $code;
          }  
    
          //生成背景  
          private function createBg() {  
             $this->img = imagecreatetruecolor($this->width, $this->height);  
             $color = imagecolorallocate($this->img, mt_rand(150,200), mt_rand(200,250), mt_rand(250,255));  
             imagefilledrectangle($this->img,0,0,$this->width,$this->height,$color);  
          }  
    
          //生成文字  
          private function createFont() {   
             $_x = $this->width / $this->codelen;  
             for ($i=0;$i<$this->codelen;$i++) {  
                    $this->fontcolor = imagecolorallocate($this->img,mt_rand(0,100),mt_rand(0,100),mt_rand(0,100));  
                    imagettftext($this->img,$this->fontsize,mt_rand(-30,30),$_x*$i+mt_rand(5,5),$this->height / 1.3,$this->fontcolor,$this->font,$this->code[$i]);                    
             }  
          }  
    
          //生成线条、雪花  
          private function createLine() {  
             for ($i=0;$i<3;$i++) {  
                    $color = imagecolorallocate($this->img,mt_rand(100,156),mt_rand(100,156),mt_rand(100,156));  
                    imageline($this->img,mt_rand(0,$this->width),mt_rand(0,$this->height),mt_rand(0,$this->width),mt_rand(0,$this->height),$color);  
             }  
             for ($i=0;$i<10;$i++) {  
                    $color = imagecolorallocate($this->img,mt_rand(200,255),mt_rand(200,255),mt_rand(200,255));  
                    imagestring($this->img,mt_rand(1,5),mt_rand(0,$this->width),mt_rand(0,$this->height),'*',$color);  
             }  
          }  
          //构造图片
          public function createImg() {  
             $this->createBg(); 
             $this->createLine();  
             $this->createFont();           
          }
          //输出  
          public function outPut() {  
             header('Content-type:image/png');
             ob_clean();
             imagepng($this->img);  
             imagedestroy($this->img);  
          }  
              
          //获取验证码  转换成小写
          public function getCode() {  
             return strtolower($this->code);  
          }  
    
 }