<?php
/*
 * Copyright 2012 Zhtx Systems, Inc.
 */
require_once(APP_ROOT . "libary/ModuleFactory.php");
require_once(APP_ROOT . "libary/LogFactory.php");
require_once(APP_ROOT . "libary/DataMap.php");
//require_once(APP_ROOT . "libary/DB.php");
//require_once(APP_ROOT . "libary/Template.php");
require_once(APP_ROOT . "libary/Dao.php");
//require_once(APP_ROOT . 'libary/util/Page.php');
//require_once(APP_ROOT . 'libary/BaseLogic.php');
require_once(APP_ROOT . 'libary/Table.php');
//require_once(APP_ROOT . 'libary/Common.php');
require_once(APP_ROOT . 'conf/auth.conf.php');
class Zhtx
{ 
  public static function loadModule($type, $name, $table='', $table_prefix=true)
  {
    return ModuleFactory::load($type, $name, $table, $table_prefix);
  }

public static function getRemoteData($url, $charsetfrom="", $charsetto="", $timeout=5, $post_data=array())
  {
      $ch = curl_init();
      $url = self::parseUrl($url);
      curl_setopt($ch, CURLOPT_URL, $url); 
      curl_setopt($ch, CURLOPT_USERAGENT, $_SERVER['HTTP_USER_AGENT']);
      curl_setopt($ch,CURLOPT_HEADER,0);   
      curl_setopt($ch,CURLOPT_TIMEOUT,$timeout);   
      curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1); 
      curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, $timeout);  
      if(count($post_data)>0)
      {
          curl_setopt($ch, CURLOPT_POST, 1 );
          curl_setopt($ch, CURLOPT_POSTFIELDS, $post_data);
      }

      //在需要用户检测的网页里需要增加下面两行
      /*
      curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_ANY); 
      curl_setopt($ch, CURLOPT_USERPWD, US_NAME.":".US_PWD); 
       * *
       */
      $contents = curl_exec($ch);      
      curl_close($ch); //print_r($contents);die;
      if( $charsetfrom != "" && $charsetto != "" )
      {
          $contents = iconv($charsetfrom, $charsetto,$contents);
      }
      return $contents; 

  }
  public static function parseUrl($url="")
  {
    $a = array(" ");
    $b = array("%20");
    $url = str_replace($a, $b, $url);
    return $url;
  }

  public static function createDataMap()
  {
    return new DataMap();
  }

  public static function getTable($table_name)
  {
    return self::getViewHelper(ucfirst($table_name), NULL);
  }

  public static function getDAO($table)
  {
    return new Dao(Core::$conn, $table);
  }

  public static function getViewHelper($table_name, $tables)
  {
    $user_file = APP_ROOT . "app/user/table/" . ucfirst($table_name) . ".php";
    $system_file = APP_ROOT . "app/system/table/" . ucfirst($table_name) . ".php";
    if (!file_exists($user_file) && !file_exists($system_file))
    {
      require_once(APP_ROOT . "libary/DevTable.php");
      return new DevTable(strtolower($table_name));
//      throw new Exception('class not found');
    }
    else
    {
      if (file_exists($user_file))
      {
        require_once $user_file;
        return new $table_name($tables);
      }
      else if (file_exists($system_file))
      {
        require_once $system_file;
        return new $table_name($tables);
      }
    }
  }

  public static function getLog($logClass)
  {
    return LogFactory::get($logClass);
  }

  public static function &getTemplate($caching, $cache_time = 1200)
  {
    require_once(APP_ROOT . "libary/Template.php");

    return new Template($caching, $cache_time);
  }
  
  public static function session($session_name)
  {
    return isset($_SESSION[$session_name]) ? $_SESSION[$session_name] : NULL;
  }
  
  public static function setSession($session)
  {
    if (is_array($session))
    {
      foreach ($session as $key => $val)
      {
        $_SESSION[$key] = $val;
      }

    }
    else
    {
      return null;
    }
  } 
  
  public static function unSetSession()
  {
    unset($_SESSION);
    session_destroy();
  } 
  public static function unSetCookie()
  {
    foreach ($_COOKIE as $key => $value)
    {
      setcookie($key, '');
    };
    
  }

}

?>
