<?php

require_once(APP_ROOT . "libary/BaseMailer.php");

class mailerPHP extends BaseMailer
{

    private $mailer;

    public function init($cfg)
    {
        require_once(APP_ROOT . "libary/mailer/mailerPHP/class.phpmailer.php");
        $this->mailer = new PHPMailer();
        $this->mailer->IsSMTP(); // 使用SMTP方式发送
        $this->mailer->CharSet = "UTF-8"; // 设置字符集编码，GB2312 GBK
        $this->mailer->Encoding = "base64"; //设置文本编码方式
        $this->mailer->Host = $cfg["Host"]; // 您的企业邮局域名
        $this->mailer->SMTPAuth = true; // 启用SMTP验证功能
        $this->mailer->Username = $cfg["Username"]; // 邮局用户名(请填写完整的email地址)
        $this->mailer->Password = $cfg["Password"]; // 邮局密码
        $this->mailer->Port = $cfg["Port"];
        $this->mailer->From = $cfg["From"]; //邮件发送者email地址
        $this->mailer->FromName = $cfg["FromName"];
        $this->mailer->AddReplyTo($cfg["Replay"], '');
        $this->mailer->SMTPDebug = false;
        if ($cfg["SSL"] == 1)
        {
            $this->mailer->SMTPSecure = "ssl";
        }
        if ($cfg["SSL"] == 2)
        {
            $this->mailer->SMTPSecure = "tls";
        }
        $this->mailer->IsHTML(true);
    }

    public function sendTo($email, $title, $content)
    {
        $this->mailer->AddAddress($email, "");
        $this->mailer->Subject = $title;
        $this->mailer->Body = $content;
        if ($this->mailer->Send() == 1)
        {
            return true;
        }
        else
        {
            //return $this->mailer->ErrorInfo;
            return false;
        }
    } 

    public function replayTo($email, $title, $content)
    {
        $this->mailer->AddAddress($email, "");
        $this->mailer->Subject = $title;
        $this->mailer->Body = $content;
        if ($this->mailer->Send() == 1)
        {
            return true;
        }
        else
        {
            //return $this->mailer->ErrorInfo;
            return false;
        }
    } 
    
    public function responseMsg()
    {
        return $this->mailer->ErrorInfo;
    }

}

?>