<?php

class MemcacheFactory
{

  private $aOmem = array(); //服务对象组
  private $aServers; //分组
  private $try = 1; //重试次数
  private $connected = false; //是否已经连接过
  private $persistent = false; //是否长连接
  private $prefix = ''; //Key前缀
  public $selectRs;

  public function __construct()
  { 
    $this->prefix = md5($_SESSION['SERVER_NAME']);
   //构造函数
    global $memcache_cfg;
    $this->aServers = $memcache_cfg;
    if (!class_exists('Memcache'))
    { //强制使用
      die('This Lib Requires The Memcache Extention!');
    }
    $this->connect();       
  }

  /**
   * 支持多组连接.
   * @return void
   */
  private function connect()
  {
    if (!$this->connected)
    {
      $this->connected = true; //标志已经连接过一次
      $this->aOmen[0] = new Memcache;
      foreach ((array) $this->aServers as $key => $aServer)
      {
        $this->aOmen[0]->connect($aServer[0][0], $aServer[0][1]);
        break;
      }
    }
  }

  /**
   * 设置mem值 默认缓存24小时 $expire: 默认缓存时间
   * @var key 键名,键值,过期时间,是否压缩. 后两个参数对Memcachedb透明
   * @return 成功为true,否则false
   */
  public function set($key, $value, $expire = 86400, $zip = true)
  {
    $key= $this->prefix.$key;
    $this->connect();
    if ($zip)
    {
      $this->aOmen[0]->set($key, $value, MEMCACHE_COMPRESSED, $expire);
    }
    else
    {
      $this->aOmen[0]->set($key, $value, 0, $expire);
    }
  }

  /**
   * 设置多个mem值 默认缓存24小时
   * @var key array(键名=>键值),过期时间,是否压缩. 后两个参数对Memcachedb透明.此处有缺陷:键名必须是非纯数字型
   * @return 成功true,否则false
   */
  public function setMulti($items, $expire = 86400, $zip = true)
  {
    $this->connect();
    foreach ($items as $key => $item)
    {
      $key= $this->prefix.$key;
      $this->set($key, $item, $expire, $zip);
    }
  }

  /**
   * 累加/减 默认是加 永久保存
   * @var $key
   * @var $value 需要累加或减的值 注意只能是正整数.不能减成负数.不能是负数.如果为0则返回最新值
   * @var $expire 过期时间.注意过期时间由第一次添加的时候决定,后面的加减操作并不会延长过期时间!
   * @var $direct 0加1减
   * @return 成功返回最新值(>=0的正整数),否则false
   */
  public function increment($key, $value, $expire = 0, $direct = 0)
  {
    $key= $this->prefix.$key;
    $this->connect();
    $result = $this->aOmen[0]->increment($key, $value);
    return $result;
  }

  /**
   * 获取单键 $zip 是否解压缩.对应set的压缩
   * @var $inCas 是否进行cas验证 如果是则返回一个数组[结果集,cas字串] 注意不支持分组!!!
   * @return 成功返回结果,否则false
   */
  public function get($key, $zip = true, $inCas = false)
  {
    $key= $this->prefix.$key;
    $this->connect();
    if ($zip)
    {
      $result = $this->aOmen[0]->get($key, MEMCACHE_COMPRESSED);
    }
    else
    {
      $result = $this->aOmen[0]->get($key);
    }
    return $result;
  }

  /**
   * 获取多键.有缺陷,keys数组中的值必须都为字符串型.先要测试该方法是否可用,否则会引起致命错误
   * @return 成功返回结果,否则false
   */
  public function getMulti($keys, $zip = true, $inCas = false)
  {
    $this->connect();
    $result = $this->aOmen[0]->get($keys);
    return $result;
  }

  /**
   * $expire秒后删除(在此段时间内不能add和replace,也不能get,但可以set).注意当前客户端还不支持传非0值
   * @return 成功为true,否则false
   */
  public function delete($key, $expire = 0)
  {
    $key= $this->prefix.$key;
    $this->connect();
    $this->aOmen[0]->delete($key, (int) $expire);
  }

  /**
   * 把所有缓存设置为超时,以便其他key可以用
   */
  public function flush($delay = 0)
  {
    $this->connect();

    $flushOk = false; //返回标志

    foreach ((array) $this->aOmen as $oMem)
    {
      $flushOk = $oMem->flush($delay);
    }
    return $flushOk;
  }

  /**
   * 获取运行状态.有缺陷,如果分布式中某点有故障,则获取不到记录
   * @return unknown
   */
  public function getStats()
  {
    $this->connect();

    foreach ((array) $this->aOmen as $oMem)
    {
      $arrStatus[] = $oMem->getStats();
    }
    return $arrStatus;
  }

  /**
   * 获取长连接名前缀,保证相同的端口配置用同一个长连接
   */
  private function genPool($aServer)
  {
    foreach ((array) $aServer as $array)
    {
      $aList[] = $array[0] . '-' . $array[1];
    }
    $aList = array_unique((array) $aList);
    sort($aList, SORT_STRING);
    return md5(implode('-', $aList));
  }

  /**
   * 错误日志
   * @param unknown_type $key
   * @param unknown_type $try
   * @param unknown_type $group
   * @param unknown_type $msg
   */
  private function errorlog($keys, $try, $group, $msg, $method)
  {
    $error = date('Y-m-d H:i:s') . ":\nmethod:" . $method . ":\n" . var_export($group, true) . ";\nkeys:" . var_export($keys, true) . ";\ntry:{$try};\nmsg:{$msg}";

    return;
    //	oo::logs()->debug($error, 'mucache.txt');
    $logdir = "./cache/log/memcachelog";
    if (!file_exists($logdir))
    {
      mkdir($logdir, 0777);
    }
    if (!file_exists($logdir .= '/' . date('Y')))
    {
      mkdir($logdir, 0777);
    }
    if (!file_exists($logdir .= '/' . date('m')))
    {
      mkdir($logdir, 0777);
    }
    if (!file_exists($logdir .= '/' . date('d')))
    {
      mkdir($logdir, 0777);
    }
    $filename = $logdir . '/' . date('His') . '.txt';
    $fp = fopen($filename, "a+");
    fwrite($fp, $error);
    fclose($fp);
  }

}