<?php

/**
 * Smarty category block function plugin
 * 第三方登录列表
 * Type:     block function<br>
 * Name:     apisnsList<br>
 * @author  hjp
 */
function smarty_block_apisnsList($params, $content, &$smarty, &$repeat)  
{   	
    extract($params); 
    if(!isset($item))  
        $item = 'row'; 
    if(!isset($name))  
        $name = 'list'; 
    if(!isset($limit))  
        $limit = 0; 
    if(!isset($key) ) 
    {
        $key='key';
    }
    
    #注册一个block的索引，照顾smarty的版本  
    if(method_exists($smarty,'get_template_vars'))  
        $apisnsList = $smarty->get_template_vars('apisnsList');  
    else  
        $apisnsList = $smarty->getVariable('apisnsList')->value;  
      
    if(!$apisnsList)  
        $apisnsList = array();  
          
    if(!isset($apisnsList[$name]["iteration"]))  
            $apisnsList[$name]["iteration"] = 1;  
    else  
            $apisnsList[$name]["iteration"] ++;
    
    if(!isset($apisnsList[$key]["count"])) 
    {        
        $apisnsList[$key]["count"] = 0;  
    }
    else  
        $apisnsList[$key]["count"] ++;    
    
    $smarty->assign($key,$apisnsList[$key]["count"]);  
    $smarty->assign('apisnsList',$apisnsList);  
      
    #在对象$smarty上注册一个数组以供block使用  
    if(!isset($smarty->tpl_vars))  
        $smarty->tpl_vars = array();     
    #获得一个本区块的专属数据存储空间  
    $dataindex = md5(__FUNCTION__ . md5(serialize($params)));  
    $dataindex = substr($dataindex,0,16);  
    #将使用$smarty->tpl_vars[$dataindex]来存储  
    #填充数据  
    if(!$smarty->tpl_vars[$dataindex])  
    {  
        #************************************************************************  
        #主要数据填充区          
        $logic       = AppController::load('apisns');
        $language_id = (int) $language_id ;
        $cond = '(language_id=0 or language_id=' . $language_id . ') and status=1 order by listorder desc';
        $res = $logic->getList($cond);
        foreach($res['list'] as $data)
        {
            $data['param']=  json_decode($data['api_param'],TRUE);
            $data["apimodule"]='sns/'.$data['api_type'].'/index.htm';
            $data["apimodule_header"]='sns/'.$data['api_type'].'/in_header.htm';
            $smarty->tpl_vars[$dataindex][] = $data;
        }        
        #填充区完成  
        #************************************************************************  
    }  
    #如果没有数据，直接返回null,不必再执行了  
    if(!$smarty->tpl_vars[$dataindex])  
    {  
        $repeat = false;  
        return '';  
    }  
    #取一条数据出栈，并把它指派给$value，重复执行开关置位1  
    if(list($keyindex, $value) = each($smarty->tpl_vars[$dataindex]))  
    {  
        $smarty->assign($item,$value);  
        $repeat = true;  
    }  
    #判断是否是最后一个
    if($smarty->tpl_vars[$dataindex][count($smarty->tpl_vars[$dataindex])-1]==$value)
    {
        $apisnsList[$name]["last"]=TRUE;
        $smarty->assign('apisnsList',$apisnsList);
    }
    #如果已经到达最后，重置数组指针，重复执行开关置位0  
    if(!$value)  
    {          
        reset($smarty->tpl_vars[$dataindex]);  
        $repeat = false;  
        if($apisnsList[$name]["iteration"])  
        {  
            unset($apisnsList[$name]["iteration"]); 
            unset($apisnsList[$key]["count"]); 
            $smarty->assign('apisnsList',$apisnsList);  
        }  
    }  
    #打印内容  
    print $content;  
}  
?>
