<?php

/**
 * Smarty category block function plugin
 * 品牌列表
 * Type:     block function<br>
 * Name:     brandList<br>
 * @author  hjp
 */
function smarty_block_brandList($params, $content, &$smarty, &$repeat)  
{   	
    extract($params); 
    if(!isset($item))  
        $item = 'row';  
    if(!isset($imgsize))  
        $imgsize = '1'; 
    if(!isset($name))
        $name = 'list';
    if(!isset($key) ) 
    {
        $key='key';
    }
    
    #注册一个block的索引，照顾smarty的版本  
    if(method_exists($smarty,'get_template_vars'))  
        $brandList = $smarty->get_template_vars('brandList');  
    else  
        $brandList = $smarty->getVariable('brandList')->value;  
      
    if(!$brandList)  
        $brandList = array();  
          
	if(!isset($brandList[$name]["iteration"]))  
		$brandList[$name]["iteration"] = 1;  
	else  
		$brandList[$name]["iteration"] ++;  
      
    if(!isset($brandList[$key]["count"])) 
    {        
        $brandList[$key]["count"] = 0;  
    }
    else  
        $brandList[$key]["count"] ++;    
    
    $smarty->assign($key,$brandList[$key]["count"]);  
    $smarty->assign('brandList',$brandList);  
      
    #在对象$smarty上注册一个数组以供block使用  
    if(!isset($smarty->tpl_vars))  
        $smarty->tpl_vars = array();     
    #获得一个本区块的专属数据存储空间  
    $dataindex = md5(__FUNCTION__ . md5(serialize($params)));  
    $dataindex = substr($dataindex,0,16);  
    #将使用$smarty->tpl_vars[$dataindex]来存储  
    #填充数据  
    if(!$smarty->tpl_vars[$dataindex])  
    {  
        #************************************************************************  
        #主要数据填充区
		
		#goods_id language_id status orderfield orderby limit
		
		$where = "1=1";
		if($language_id)
		{
			$where .= " and l.language_id=" . $language_id;
		}
		if($status)
		{
			$where .= " and b.status=" . $status;
		}
		$orderby = $orderby? $orderby:"DESC";
		$orderfield = $orderfield? $orderfield:"id";
		$limit = $limit? $limit:20;
		$where .= " ORDER BY $orderfield $orderby limit $limit";
		
        $logic       = AppController::load('brandJoinLanguage');
        $res  = $logic->getList($where);
        foreach($res["list"] as $data)
        {
            $smarty->tpl_vars[$dataindex][] = $data;
        }
        #填充区完成  
        #************************************************************************  
    }  
    #如果没有数据，直接返回null,不必再执行了  
    if(!$smarty->tpl_vars[$dataindex])  
    {  
        $repeat = false;  
        return '';  
    }  
    #取一条数据出栈，并把它指派给$value，重复执行开关置位1  
    if(list($key, $value) = each($smarty->tpl_vars[$dataindex]))  
    {  
        $smarty->assign($item,$value);  
        $repeat = true;  
    }  
    #判断是否是最后一个
    if($smarty->tpl_vars[$dataindex][count($smarty->tpl_vars[$dataindex])-1]==$value)
    {
        $brandList[$name]["last"]=TRUE;
        $smarty->assign('brandList',$brandList);
    }
    #如果已经到达最后，重置数组指针，重复执行开关置位0  
    if(!$value)  
    {  
        reset($smarty->tpl_vars[$dataindex]);  
        $repeat = false;  
        if($brandList[$name]["iteration"])  
        {  
            unset($brandList[$name]["iteration"]);  
            unset($brandList[$key]["count"]); 
            $smarty->assign('brandList',$brandList);  
        }  
    }  
    #打印内容  
    print $content;  
}  
?>
