<?php

/**
 * Smarty category block function plugin
 * 读取购物车列表
 * Type:     block function<br>
 * Name:     cartList<br>
 * @author  hjp
 */
function smarty_block_cartList($params, $content, &$smarty, &$repeat)  
{   	
    extract($params); 
    if(!isset($item))  
        $item = 'row'; 
    if(!isset($name))
        $name = 'list';
    if(!isset($key) ) 
    {
        $key='key';
    }
    
    #注册一个block的索引，照顾smarty的版本  
    if(method_exists($smarty,'get_template_vars'))  
        $cartList = $smarty->get_template_vars('cartList');  
    else  
        $cartList = $smarty->getVariable('cartList')->value;  
      
    if(!$cartList)  
        $cartList = array();  
          
	if(!isset($cartList[$name]["iteration"]))  
		$cartList[$name]["iteration"] = 1;  
	else  
		$cartList[$name]["iteration"] ++;  
      
    if(!isset($cartList[$key]["count"])) 
    {        
        $cartList[$key]["count"] = 0;  
    }
    else  
        $cartList[$key]["count"] ++;    
    
    $smarty->assign($key,$cartList[$key]["count"]);  
    $smarty->assign('cartList',$cartList);  
      
    #在对象$smarty上注册一个数组以供block使用  
    if(!isset($smarty->tpl_vars))  
        $smarty->tpl_vars = array();     
    #获得一个本区块的专属数据存储空间  
    $dataindex = md5(__FUNCTION__ . md5(serialize($params)));  
    $dataindex = substr($dataindex,0,16);  
    #将使用$smarty->tpl_vars[$dataindex]来存储
    #填充数据  
    if(!$smarty->tpl_vars[$dataindex])  
    {  
        #************************************************************************  
        #主要数据填充区          
        $user_id     = AppController::checkLogin();
        $cartJoinSkuLogic = AppController::load('cartJoinSku');
        $cartinfo = $cartJoinSkuLogic->getCartInfo($user_id,  $language_id);
        foreach($cartinfo['orderitems'] as $data)
        {
            $smarty->tpl_vars[$dataindex][] = $data;
            if(isset($limit))
            {
                if(count($smarty->tpl_vars[$dataindex])>=$limit)
                {
                    break;
                }
            }
        }        
        #填充区完成  
        #************************************************************************  
    }  
    #如果没有数据，直接返回null,不必再执行了  
    if(!$smarty->tpl_vars[$dataindex])  
    {  
        $repeat = false;  
        return '';  
    }  
    #取一条数据出栈，并把它指派给$value，重复执行开关置位1  
    if(list($key, $value) = each($smarty->tpl_vars[$dataindex]))  
    {  
        $smarty->assign($item,$value);  
        $repeat = true;  
    }  
    #判断是否是最后一个
    if($smarty->tpl_vars[$dataindex][count($smarty->tpl_vars[$dataindex])-1]==$value)
    {
        $cartList[$name]["last"]=TRUE;
        $smarty->assign('cartList',$cartList);
    }
    #如果已经到达最后，重置数组指针，重复执行开关置位0  
    if(!$value)  
    {          
        reset($smarty->tpl_vars[$dataindex]);  
        $repeat = false;  
        if($cartList[$name]["iteration"])  
        {  
            unset($cartList[$name]["iteration"]);  
            unset($cartList[$key]["count"]); 
            $smarty->assign('cartList',$cartList);  
        }  
    }  
    #打印内容  
    print $content;  
}  
?>
