<?php

/**
 * Smarty category block function plugin
 * 读取分类列表
 * Type:     block function<br>
 * Name:     cateList<br>
 * @author  hjp
 */
function smarty_block_cateList($params, $content, &$smarty, &$repeat) {
    extract($params);
    if (!isset($item))
        $item = 'row';
    if (!isset($name))
        $name = 'list';
    if (!isset($rec_type))
        $rec_type = 0;
    if (!isset($limit))
        $limit = 20;
    if (!isset($key)) {
        $key = 'key';
    }

    #注册一个block的索引，照顾smarty的版本
    if (method_exists($smarty, 'get_template_vars'))
        $cateList = $smarty->get_template_vars('cateList');
    else
        $cateList = $smarty->getVariable('cateList')->value;

    if (!$cateList)
        $cateList = array();

    if (!isset($cateList[$name]["iteration"]))
        $cateList[$name]["iteration"] = 1;
    else
        $cateList[$name]["iteration"] ++;

    if (!isset($cateList[$key]["count"])) {
        $cateList[$key]["count"] = 0;
    } else
        $cateList[$key]["count"] ++;

    $smarty->assign($key, $cateList[$key]["count"]);
    $smarty->assign('cateList', $cateList);

    #在对象$smarty上注册一个数组以供block使用
    if (!isset($smarty->tpl_vars))
        $smarty->tpl_vars = array();
    #获得一个本区块的专属数据存储空间
    $dataindex = md5(__FUNCTION__ . md5(serialize($params)));
    $dataindex = substr($dataindex, 0, 16);

    #将使用$smarty->tpl_vars[$dataindex]来存储
    #填充数据
    if (!$smarty->tpl_vars[$dataindex]) {
        #************************************************************************
        #主要数据填充区
        $rewrite["type"] = $rewrite_type;
        $rewrite["name_type"] = "";
        $logic = AppController::load('goodsCategoryJoinLang');

        if ($smarty->tpl_vars["categories"]) {
            $categories = $smarty->tpl_vars["categories"]->value;
        } else {
            $categories = $logic->getAllByLanguageId($language_id, -1);
			$smarty->assign('categories', $categories);
        }

        $tmp_categories = $categories;
		$parent_id = $params['parent_id'];
	  if (isset($parent_id)) {
		  $tmp_categories = array();
            $tmp_categories = $categories[$parent_id]['son'];
			if($tmp_categories)
				$tmp_categories = array_slice($tmp_categories,0,$limit);
        }
        else if(isset($category_ids))
        {
            $str = $category_ids . "" ;
			if($str=="0")
			{
				$tmp_categories = $categories[0]['son'];
				if($tmp_categories)
					$tmp_categories = array_slice($tmp_categories,0,$limit);
			}
            else
            {
                $categoryids = split(',',$category_ids);
				$tmp_categories = array();
                foreach ($categoryids as $key => $value)
                {
                    if($categories[$value])
                    $tmp_categories[$value] = $categories[$value];
                    if(count($tmp_categories)>=$limit)
                    {
                        break;
                    }
                }
            }
        }
		
        foreach ($tmp_categories as $data) {
            $smarty->tpl_vars[$dataindex][] = $data;
        }
        #填充区完成
        #************************************************************************
    }
    #如果没有数据，直接返回null,不必再执行了
    if (!$smarty->tpl_vars[$dataindex]) {
        $repeat = false;
        return '';
    }
    #取一条数据出栈，并把它指派给$value，重复执行开关置位1
    if (list($keyindex, $value) = each($smarty->tpl_vars[$dataindex])) {
        $smarty->assign($item, $value);
        $repeat = true;
    }
    #判断是否是最后一个
    if ($smarty->tpl_vars[$dataindex][count($smarty->tpl_vars[$dataindex]) - 1] == $value) {
        $cateList[$name]["last"] = TRUE;
        $smarty->assign('cateList', $cateList);
    }
    #如果已经到达最后，重置数组指针，重复执行开关置位0
    if (!$value) {
        reset($smarty->tpl_vars[$dataindex]);
        $repeat = false;
        if ($cateList[$name]["iteration"]) {
            unset($cateList[$name]["iteration"]);
            unset($cateList[$key]["count"]);
            $smarty->assign('cateList', $cateList);
        }
    }
    #打印内容
    print $content;
}

?>
