<?php

/**
 * Smarty category block function plugin
 * 新品日期列表
 * Type:     block function<br>
 * Name:     dailyNewList<br>
 * @author  hjp
 */
function smarty_block_dailyNewList($params, $content, &$smarty, &$repeat)  
{   	
    extract($params); 
    if(!isset($item))  
        $item = 'row'; 
    if(!isset($name))
        $name = 'list';
    if(!isset($key) ) 
    {
        $key='key';
    }
    
    #注册一个block的索引，照顾smarty的版本  
    if(method_exists($smarty,'get_template_vars'))  
        $dailyNewList = $smarty->get_template_vars('dailyNewList');  
    else  
        $dailyNewList = $smarty->getVariable('dailyNewList')->value;  
      
    if(!$dailyNewList)  
        $dailyNewList = array();  

    if(!isset($dailyNewList[$name]["iteration"]))  
        $dailyNewList[$name]["iteration"] = 1;  
    else  
        $dailyNewList[$name]["iteration"] ++;  
      
    if(!isset($dailyNewList[$key]["count"])) 
    {        
        $dailyNewList[$key]["count"] = 0;  
    }
    else  
        $dailyNewList[$key]["count"] ++;    
    
    $smarty->assign($key,$dailyNewList[$key]["count"]);  
    $smarty->assign('dailyNewList',$dailyNewList);  
      
    #在对象$smarty上注册一个数组以供block使用  
    if(!isset($smarty->tpl_vars))  
        $smarty->tpl_vars = array();
    #获得一个本区块的专属数据存储空间  
    $dataindex = md5(__FUNCTION__ . md5(serialize($params)));  
    $dataindex = substr($dataindex,0,16);  
    #将使用$smarty->tpl_vars[$dataindex]来存储  
    #填充数据  
    if(!$smarty->tpl_vars[$dataindex])  
    {  
        #************************************************************************  
        #主要数据填充区  
        $limit = isset($limit) ? (int)$limit:10;
        $recent_days = isset($recent_days) ? (int)$recent_days:30;
        $logic       = AppController::load('goods');
        $cond = ' status=1 ';
        $tady_times = strtotime(date('Y-m-d',time()));
        $start_times = $tady_times-60*60*24*$recent_days;
        $cond .= ' and create_time>'.$start_times;
        $res = $logic->findAll($cond,false,'',array('id,create_time'));
        $daily_list = array();
        foreach($res as $data)
        {
            $daily_row = array('date'=>date('Y-m-d',$data['create_time']),'timestamp'=>strtotime(date('Y-m-d',$data['create_time'])),'num'=>1);
            $daily_row['num'] = (int)$daily_list[strtotime($daily_row['date'])]['num']+1;
            $daily_list[strtotime($daily_row['date'])] = $daily_row;
        }
        ksort($daily_list);
        $daily_list = array_reverse($daily_list);
        //var_dump($daily_list);
        foreach($daily_list as $key => $data)
        {
            if($key>=$limit)
            {
                break;
            }
            $smarty->tpl_vars[$dataindex][] = $data;
        }   
        #填充区完成  
        #************************************************************************  
    }  
    #如果没有数据，直接返回null,不必再执行了  
    if(!$smarty->tpl_vars[$dataindex])  
    {  
        $repeat = false;  
        return '';  
    }  
    #取一条数据出栈，并把它指派给$value，重复执行开关置位1  
    if(list($key, $value) = each($smarty->tpl_vars[$dataindex]))  
    {  
        $smarty->assign($item,$value);  
        $repeat = true;  
    }  
    #判断是否是最后一个
    if($smarty->tpl_vars[$dataindex][count($smarty->tpl_vars[$dataindex])-1]==$value)
    {
        $dailyNewList[$name]["last"]=TRUE;
        $smarty->assign('dailyNewList',$dailyNewList);
    }
    #如果已经到达最后，重置数组指针，重复执行开关置位0  
    if(!$value)  
    {  
        reset($smarty->tpl_vars[$dataindex]);  
        $repeat = false;  
        if($dailyNewList[$name]["iteration"])  
        {  
            unset($dailyNewList[$name]["iteration"]);  
            unset($dailyNewList[$key]["count"]); 
            $smarty->assign('dailyNewList',$dailyNewList);  
        }  
    }  
    #打印内容  
    print $content;  
}  
?>
