<?php

/**
 * Smarty category block function plugin
 * 读取商品列表
 * Type:     block function<br>
 * Name:     goodsList<br>
 * @author  hjp
 */
function smarty_block_goodsList($params, $content, &$smarty, &$repeat) {
    extract($params);
    if (!isset($item))
        $item = 'row';
    if (!isset($name))
        $name = 'list';
    if (!isset($key)) {
        $key = 'key';
    }
    #注册一个block的索引，照顾smarty的版本
    if (method_exists($smarty, 'get_template_vars'))
        $goodsList = $smarty->get_template_vars('goodsList');
    else
        $goodsList = $smarty->getVariable('goodsList')->value;

    if (!$goodsList)
        $goodsList = array();

    if (!isset($goodsList[$name]["iteration"]))
        $goodsList[$name]["iteration"] = 1;
    else
        $goodsList[$name]["iteration"] ++;

    if (!isset($goodsList[$key]["count"])) {
        $goodsList[$key]["count"] = 0;
    } else
        $goodsList[$key]["count"] ++;

    $smarty->assign($key, $goodsList[$key]["count"]);
    $smarty->assign('goodsList', $goodsList);

    #在对象$smarty上注册一个数组以供block使用
    if (!isset($smarty->tpl_vars))
        $smarty->tpl_vars = array();
    #获得一个本区块的专属数据存储空间
    $dataindex = md5(__FUNCTION__ . md5(serialize($params)));
    $dataindex = substr($dataindex, 0, 16);
    #将使用$smarty->tpl_vars[$dataindex]来存储
    #填充数据
    if (!$smarty->tpl_vars[$dataindex]) {
        #************************************************************************
        #主要数据填充区
        # brand_id
        # tag_id property_id category_id
        # orderby orderfield limit
        # language_id
        $limit = $limit ? $limit : 20;
        $language_id = (int) $language_id;
        $orderby = $orderby ? $orderby : "DESC";
        if ($orderfield == 'create_time') {
            $orderfield = "l.create_time";
        } else if ($orderfield == 'price') {
            $orderfield = "l.price";
        } else if ($orderfield == 'listorder') {
            $orderfield = "l.listorder";
        } else if ($orderfield == 'goods_id') {
            $orderfield = "l.goods_id";
        } else if (isset($orderfield)) {

        } else {
            $orderfield = "l.up_time";
        }
        $cols = array(
            'l.goods_id as id',
            'g.base_name as default_base_name',
            'g.image as image',
            'g.price as price',
            'g.old_price as old_price',
            'g.codeno as codeno',
            'g.cost_price as cost_price',
            'g.market_price as market_price',
            'g.listorder as listorder',
            'g.status as status',
            'g.page_url as page_url',
            'g.up_time as up_time',
            'g.modify_time as modify_time',
            'g.create_time as create_time',
            'g.visit_counts as visit_counts',
            'g.buy_counts as buy_counts',
            'g.wishlist_counts as wishlist_counts',
            'g.comment_counts as comment_counts',
            'g.comment_value as comment_value',
            'g.is_free_shipping as is_free_shipping',
            'g.start_time as start_time',
            'g.end_time as end_time',
            'g.discount as discount',
            'g.special_status as special_status',
            'g.special_offer_id as special_offer_id',
            'l.base_name as base_name',
            'g.stock_nums as stock_nums',
        );
        if ($brand_id && !$tag_id && !$property_id && !$category_id) {

            $where = "brand_id=$brand_id and l.status=1 and l.language_id=" . $language_id . " ORDER BY $orderfield  $orderby " . " limit " . $limit;
            $logic = AppController::load('goodsJoinLanguage');
            $key = md5($where . '_' . $brand_id);
            $cache_type = 'goods_list';
            $goods = _chkcahce($key, $cache_type);
            if (!$goods) {
                $goods = $logic->findAll($where, false, '', $cols);
                _setcahce($key, $goods, $cache_type);
            }
        } else if ($tag_id && !$property_id && !$category_id) {
            if ($brand_id) {
                $where = "g.brand_id=" . $brand_id . " and ";
            }
            $where .= "t.tag_id=$tag_id and l.status=1  and l.language_id=" . $language_id . " ORDER BY $orderfield $orderby " . " limit " . $limit;
            $logic = AppController::load('TagRelGoodsJoinLanguage');
            $key = md5($where . '_' . $tag_id);
            $cache_type = 'goods_list';
            $goods = _chkcahce($key, $cache_type);
            if (!$goods) {
                $goods = $logic->findAll($where, false, '', $cols);
                _setcahce($key, $goods, $cache_type);
            }
        } else if ($category_id && !$property_id && !$tag_id) {
            $catelogic = AppController::load('GoodsCategory');
            $category = $catelogic->getOne("id=" . $category_id);
            if ($category) {
                $logic = AppController::load('goodsJoinLanguage');

                if ($brand_id) {
                    $where = "g.brand_id=" . $brand_id . " and ";
                }
                if ($rand) {
                    srand((float) microtime() * 10000000);
                    $grouporderp1 = $logic->getCols("l.category_path like '" . $category['path_id'] . "%' and l.status=1 and l.language_id=" . $language_id . " limit 200", array('g.id'));
                    $grouporderp = array();
                    foreach ($grouporderp1 as $gkey => $value) {
                        $grouporderp[] = $value['id'];
                    }
                    shuffle($grouporderp);
					$grouporderp = array_filter($grouporderp);
                    $rand_keys = array_slice($grouporderp, 0, ($limit ? $limit : 10));
                    if (!count($rand_keys)) {
                        $rand_keys = array(0);
                    }
                    $where .= "l.goods_id in(" . join(',', $rand_keys) . ") and l.status=1 and l.language_id=" . $language_id;
                    $goods = $logic->findAll($where);
                } else {
                    $where .= "l.category_path like '" . $category['path_id'] . "%' and l.status=1  and l.language_id=" . $language_id . " ORDER BY $orderfield $orderby " . " limit " . $limit;
                    $goods = $logic->findAll($where, false, '', $cols);
                }
            }
        } else if ($property_id && !$category_id && !$tag_id) {
            $where = 'p.vid in (' . $property_id . ')';
            if ($brand_id) {
                $where .= ' and g.brand_id=' . $brand_id;
            }
            $where .= " and l.status=1 and l.language_id=" . $language_id . " ORDER BY p.goods_id desc " . " limit " . $limit;
            $logic = AppController::load('propertyRelGoodsJoinLanguage');
            $key = md5($where . '_' . $property_id);
            $cache_type = 'goods_list';
            $goods = _chkcahce($key, $cache_type);
            if (!$goods) {
                $goods = $logic->findAll($where, false, '', $cols);
                _setcahce($key, $goods, $cache_type);
            }
        } else if ($category_id && $tag_id && !$property_id) {
            $catelogic = AppController::load('GoodsCategory');
            $category = $catelogic->getOne("id=" . $category_id);
            if ($category) {
                $where = "l.category_path like '" . $category['path_id'] . "%'";
                $where .= " and t.tag_id=" . $tag_id;
                if ($brand_id) {
                    $where .= ' and g.brand_id=' . $brand_id;
                }
                $where .= " and l.status=1  and l.language_id=" . $language_id . " ORDER BY $orderfield $orderby " . " limit " . $limit;
                $logic = AppController::load('categoryJoinTagJoinGoodsJoinLanguage');
                $goods = $logic->findAll($where, false, '', $cols);
            }
        } else if ($category_id && $property_id && $tag_id) {
            $catelogic = AppController::load('GoodsCategory');
            $category = $catelogic->getOne("id=" . $category_id);
            if ($category) {
                $where = "l.category_path like '" . $category['path_id'] . "%'";
                $where .= ' and p.vid in (' . $property_id . ')';
                $where .= " and t.tag_id=" . $tag_id;
                if ($brand_id) {
                    $where .= ' and g.brand_id=' . $brand_id;
                }
                $where .= " and l.status=1  and l.language_id=" . $language_id . " ORDER BY p.goods_id desc " . " limit " . $limit;
                $logic = AppController::load('catJoinTagJoinPropertyJoinGoodsJoinLang');

                $goods = $logic->findAll($where, false, '', $cols);
            }
        } else if (!$category_id && $property_id && $tag_id) {
            $where = 'p.vid in (' . $property_id . ')';
            $where .= " and t.tag_id=" . $tag_id;
            if ($brand_id) {
                $where .= ' and g.brand_id=' . $brand_id;
            }
            $where .= " and l.status=1 and l.language_id=" . $language_id . " ORDER BY p.goods_id desc " . " limit " . $limit;
            $logic = AppController::load('tagJoinPropertyJoinGoodsJoinLang');

            $goods = $logic->findAll($where, false, '', $cols);
        } else if ($category_id && $property_id && !$tag_id) {
            $catelogic = AppController::load('GoodsCategory');
            $category = $catelogic->getOne("id=" . $category_id);
            if ($category) {
                $where = "l.category_path like '" . $category['path_id'] . "%'";
                $where .= ' and p.vid in (' . $property_id . ')';
                if ($brand_id) {
                    $where .= ' and g.brand_id=' . $brand_id;
                }
                $where .= " and g.status=1 and l.language_id=" . $language_id . " ORDER BY p.goods_id desc " . " limit " . $limit;
                $logic = AppController::load('catJoinPropertyJoinGoodsJoinLang');

                $goods = $logic->findAll($where, false, '', $cols);
            }
        } else if (isset($special_id) && !$category_id && !$property_id && !$tag_id) {
            //--------------------------------获取特价活动商品开始------------------------------------------
            $specialLogic = AppController::load('specialOffer');
            if ($special_id>0) {
                //获取指定特价活动商品
                $where = "l.status=1 and special_status = 1 and special_offer_id=" . $special_id . " and l.language_id=" . $language_id . " ORDER BY $orderfield $orderby " . " limit " . $limit;
            } else {
                //获取所有特价活动商品
                
                $where = "l.status=1 and special_status = 1 and special_offer_id >0 and l.language_id=" . $language_id . " ORDER BY $orderfield $orderby " . " limit " . $limit;
            }
            $goodsLogic = AppController::load('goodsJoinLanguage');
            $goods = $goodsLogic->findAll($where, false, '', $cols);
            //-----------------------------获取特价商品结束------------------------------------------
        } else {
            $logic = AppController::load('goodsJoinLanguage');
            $where .= " l.status=1  and l.language_id=" . $language_id . " ORDER BY $orderfield $orderby " . " limit " . $limit;
            $key = md5($where . '_' . $language_id . '_' . $limit);
            $cache_type = 'goods_list';
            $goods = _chkcahce($key, $cache_type);
            if (!$goods) {
                $goods = $logic->findAll($where, false, '', $cols);
                _setcahce($key, $goods, $cache_type);
            }
        }
        if ($goods) {
            foreach ($goods as $data) {
                $smarty->tpl_vars[$dataindex][] = $data;
            }
        }
        #填充区完成
        #************************************************************************
    }
    #如果没有数据，直接返回null,不必再执行了
    if (!$smarty->tpl_vars[$dataindex]) {
        $repeat = false;
        return '';
    }
    #取一条数据出栈，并把它指派给$value，重复执行开关置位1
    if (list($key, $value) = each($smarty->tpl_vars[$dataindex])) {
        $smarty->assign($item, $value);
        $repeat = true;
    }
    #判断是否是第一个
    if ($smarty->tpl_vars[$dataindex][0] == $value) {
        $goodsList[$name]["first"] = TRUE;
        $goodsList[$name]["iteration"] = 1;
        $smarty->assign('goodsList', $goodsList);
    }
    #判断是否是最后一个
    if ($smarty->tpl_vars[$dataindex][count($smarty->tpl_vars[$dataindex]) - 1] == $value) {
        $goodsList[$name]["last"] = TRUE;
        $smarty->assign('goodsList', $goodsList);
    }
    #如果已经到达最后，重置数组指针，重复执行开关置位0
    if (!$value) {
        reset($smarty->tpl_vars[$dataindex]);
        $repeat = false;
        if ($goodsList[$name]["iteration"]) {
            unset($goodsList[$name]["iteration"]);
            unset($goodsList[$key]["count"]);
            $smarty->assign('goodsList', $goodsList);
        }
    }
    #打印内容
    print $content;
}

?>
