<?php

/**
 * Smarty category block function plugin
 * 读取导航列表
 * Type:     block function<br>
 * Name:     navList<br>
 * @author  hjp
 */
function smarty_block_navList($params, $content, &$smarty, &$repeat)  
{   	
    extract($params); 
    if(!isset($item))  
        $item = 'row'; 
    if(!isset($name))
        $name = 'list';
    if(!isset($key) ) 
    {
        $key='key';
    }
    
    #注册一个block的索引，照顾smarty的版本  
    if(method_exists($smarty,'get_template_vars'))  
        $navList = $smarty->get_template_vars('navList');  
    else  
        $navList = $smarty->getVariable('navList')->value;  
      
    if(!$navList)  
        $navList = array();  
          
	if(!isset($navList[$name]["iteration"]))  
		$navList[$name]["iteration"] = 1;  
	else  
		$navList[$name]["iteration"] ++;  
      
    if(!isset($navList[$key]["count"])) 
    {        
        $navList[$key]["count"] = 0;  
    }
    else  
        $navList[$key]["count"] ++;    
    
    $smarty->assign($key,$navList[$key]["count"]);  
    $smarty->assign('navList',$navList);  
      
    #在对象$smarty上注册一个数组以供block使用  
    if(!isset($smarty->tpl_vars))  
        $smarty->tpl_vars = array();
    #获得一个本区块的专属数据存储空间  
    $dataindex = md5(__FUNCTION__ . md5(serialize($params)));  
    $dataindex = substr($dataindex,0,16);  
    #将使用$smarty->tpl_vars[$dataindex]来存储  
    #填充数据  
    if(!$smarty->tpl_vars[$dataindex])  
    {  
        #************************************************************************  
        #主要数据填充区  
        
		# brand_id 
		# tag_id property_id category_id
		# orderby orderfield limit
		# language_id
		if(!$parent_id)
		{
			return ;	
		}
		$limit = $limit? $limit:20;
		$language_id = (int)$language_id;
		$orderby = $orderby? $orderby:"desc";
		$orderfield = $orderfield? $orderfield:"listorder";
		$parent_id = (int)$parent_id;
		$logic = AppController::load('navJoinLanguage');
        $resList = $logic->getNavByParentId($parent_id, $language_id, $orderfield, $orderby, $limit);
		foreach($resList as $data)
        {
            $smarty->tpl_vars[$dataindex][] = $data;
        }
        #填充区完成  
        #************************************************************************  
    }  
    #如果没有数据，直接返回null,不必再执行了  
    if(!$smarty->tpl_vars[$dataindex])  
    {  
        $repeat = false;  
        return '';  
    }  
    #取一条数据出栈，并把它指派给$value，重复执行开关置位1  
    if(list($key, $value) = each($smarty->tpl_vars[$dataindex]))  
    {  
        $smarty->assign($item,$value);  
        $repeat = true;  
    }  
    #判断是否是第一个
    if ($smarty->tpl_vars[$dataindex][0] == $value)
    {
        $navList[$name]["first"] = TRUE;
        $navList[$name]["iteration"] = 1;
        $smarty->assign('goodsList', $goodsList);
    }
    #判断是否是最后一个
    if($smarty->tpl_vars[$dataindex][count($smarty->tpl_vars[$dataindex])-1]==$value)
    {
        $navList[$name]["last"]=TRUE;
        $smarty->assign('navList',$navList);
    }
    #如果已经到达最后，重置数组指针，重复执行开关置位0  
    if(!$value)  
    {  
        reset($smarty->tpl_vars[$dataindex]);  
        $repeat = false;  
        if($navList[$name]["iteration"])  
        {  
            unset($navList[$name]["iteration"]);  
            unset($navList[$key]["count"]); 
            $smarty->assign('navList',$navList);  
        }  
    }  
    #打印内容  
    print $content;  
}  
?>
