<?php

/**
 * Smarty category modifier plugin
 * 面包屑
 * Type:     function<br>
 * Name:     breadcrumb<br>
 * @author  xrx
 * @return string
 */
function smarty_function_breadcrumb($params, &$smarty) {
    $lang = Common::lang(Core::$controller, Core::$module, Core::$language);
    $language_id = Common::queryInt($params['language_id']);
    $rewrite["type"] = Common::queryInt($params['rewrite_type']);
    $rewrite["name_type"] = "";
    $urlMaker = AppController::load('UrlMaker');

    $str = '<a href="' . FOLDER_ROOT . '">' . $lang['home'] . '</a>';
    $a = strtolower(_g('a'));
    $c = strtolower(_g('c'));
    if ($c == "product" && $a == "search") {
        $str .= ' > <a href="javascript:;" >' . $lang['search'] . '</a> > <span>' . Common::jsUnescape($_GET['keywords']) . '</span>';
    } else if (($c == "product" && $a == "list") || ($c == "channel" && $a == "detail")) {
        $category_id = Common::queryInt(_g('category_id'));
        $brand_id = Common::queryInt(_g('brand_id'));
        $tag_id = Common::queryInt(_g('tag_id'));
        //分类
        if (method_exists($smarty, 'get_template_vars')) {
            $categories = $smarty->get_template_vars('categories');
        } else {
            $categories = $smarty->getVariable('categories')->value;
        }
        //搜索条件
        if (method_exists($smarty, 'get_template_vars')) {
            $search_cond = $smarty->get_template_vars('search_cond');
        } else {
            $search_cond = $smarty->getVariable('search_cond')->value;
        }
        //create_breadcrumb
        $path_count = substr_count($categories[$category_id]['path_id'], ',');
        if ($path_count >= 1) {
            $categoryJoinLangLogic = AppController::load('goodsCategoryJoinLang');
            $path_id = substr($categories[$category_id]['path_id'], 0, strlen($categories[$category_id]['path_id']) - 1);
            $cond = 'c.id in (' . $path_id . ') and l.language_id=' . $language_id;
            $parents = $categoryJoinLangLogic->findAll($cond, true);
            $category_order = explode(',', $path_id);
            foreach ($category_order as $value) {
                if(isset($parents[$value])){
                    $parents_order[] = $parents[$value];
                }
            }
            foreach ($parents_order as $parent) {
                $curl = $urlMaker->getCategoryUrl($parent['id'], $language_id, $rewrite, 0, $parent);
                $str .= ' > <a href="' . $curl . '">' . $parent['base_name'] . '</a>';
            }
        }
    } else if ($c == "product" && $a == "detail") {
        //分类
        if (method_exists($smarty, 'get_template_vars')) {
            $category = $smarty->get_template_vars('category');
        } else {
            $category = $smarty->getVariable('category')->value;
        }
        //判断是否有父类
        $path_count = substr_count($category['path_id'], ',');
        if ($path_count >= 1) {
            $categoryJoinLangLogic = AppController::load('goodsCategoryJoinLang');
            $path_id = substr($category['path_id'], 0, strlen($category['path_id']) - 1);
            $cond = 'c.id in (' . $path_id . ') and l.language_id=' . $language_id;
            $parents = $categoryJoinLangLogic->findAll($cond, true);
            $category_order = explode(',', $path_id);
            foreach ($category_order as $value) {
                if(isset($parents[$value])){
                    $parents_order[] = $parents[$value];
                }
            }
            foreach ($parents_order as $parent) {
                $curl = $urlMaker->getCategoryUrl($parent['id'], $language_id, $rewrite, 0, $parent);
                $str .= ' > <a href="' . $curl . '">' . $parent['base_name'] . '</a>';
            }
        }
        //搜索条件
        if (method_exists($smarty, 'get_template_vars')) {
            $goods = $smarty->get_template_vars('goods');
        } else {
            $goods = $smarty->getVariable('goods')->value;
        }
        $purl = $urlMaker->getCategoryUrl((int)$category['id'], $language_id, $rewrite, 0, $category);
        $str .= ' > <span>' . $goods['base_name'] . '</span>';
    } else if ($c == "product" && $a == "commentall") {
        $category_id = Common::queryInt(_g('category_id'));
        $categoryLogic = AppController::load('goodsCategory');
        //分类
        $category = $categoryLogic->getOneById($category_id);
        //判断是否有父类
        $path_count = substr_count($category['path_id'], ',');

        if ($path_count >= 1) {
            $str.=" > <a href='/Comment/c0/list-r1.html'>Customer Reviews</a>";
            $categoryJoinLangLogic = AppController::load('goodsCategoryJoinLang');
            $path_id = substr($category['path_id'], 0, strlen($category['path_id']) - 1);
            $cond = 'c.id in (' . $path_id . ') and l.language_id=' . $language_id;
            $parents = $categoryJoinLangLogic->findAll($cond, true);
            $category_order = explode(',', $path_id);
            foreach ($category_order as $value) {
                if(isset($parents[$value])){
                    $parents_order[] = $parents[$value];
                }
            }
            foreach ($parents_order as $parent) {
                $curl = "/Comment/c" . $parent['id'] . "/list-r1.html";
                $str .= ' > <a href="' . $curl . '">' . $parent['base_name'] . '</a>';
            }
        } else {
            $str.=" > Customer Reviews";
        }
    }

    return $str;
}

?>