<?php
/**
 * goods        商品总量
 * Favorites    收藏量
 * Visits       访问量
 * Orders       订单量(已发货)
 * Reviews      点评量
 * @author zjh
 */
function smarty_function_getAllCounts($params, &$smarty){
    $name = $params['name'];
    $goodsLogic = AppController::load('goods');
    $orderLogic = AppController::load('order');
    $goodsCols=array("count(id) as goods","sum(wishlist_counts) as favorites","sum(comment_counts) as reviews","sum(visit_counts) as visits");
    $goodsData = $goodsLogic->getOne("1=1",$goodsCols);
    $orderCols=array("count(shipping_status) as orders");
    $orderData = $orderLogic->getOne("shipping_status between 203 and 300",$orderCols);
    $result= array();
    $result['goods']=$goodsData['goods'];
    $result['favorites']=$goodsData['favorites'];
    $result['visits']=$goodsData['visits'];
    $result['reviews']=$goodsData['reviews'];
    $result['orders']=$orderData['orders'];   
    if(isset($name)){
        $smarty->assign($name, $result);
    }else{
        $smarty->assign("counts", $result);
    } 
}
