<?php

/**
 * Smarty category modifier plugin
 * 前台商品分类
 * Type:     modifier<br>
 * Name:     category<br>
 * @author  xrx
 * @param string pic
 * @param string style
 * @return string
 */
function smarty_function_getCatlist($params, &$smarty) {
    $language_id = $params['sites_id'];
    $parent_id = $params['parent_id'];
    $name = $params['name'];
    if (!$name) {
        $name = "categories";
    }
    $logic = AppController::load('goodsCategoryJoinLang');
    if ($smarty->tpl_vars[$name]) {
        $categories = $smarty->tpl_vars[$name]->value;
    } else {
        $categories = $logic->getAllByLanguageId($language_id, -1);
    }

    if ($parent_id) {
        if (count($categories[$parent_id]['son']) > 0) {
            $categories['cur'] = $categories[$parent_id];
        } else {
            $last_parent_id = $categories[$parent_id]['parent_id'];
            $categories['cur'] = $categories[$last_parent_id];
        }
    }
    $smarty->assign($name, $categories);
}

?>
