<?php

/*
 * CopyRight © 2013
 *
  -------------------------------------------------------------
 * File:     function.getLastestPromotion.php
 * Type:     api
 * Name:     smarty_function_getLastestPromotion
 * Version:  1.0 
 * Date:     
 * Directory: /src/plugins/showdata/
 * Author:   NT <nit@35zh.com>
 * Purpose: operate for get Lastest Promotion
  -------------------------------------------------------------
 */

function smarty_function_getLastestPromotion($params, &$smarty) {
    $cart_price = $params['cart_price'];
    $cart_num = $params['cart_num'];
    $language_id = $params['language_id'];
    $user_level = $params['user_level'] ? $params['user_level'] : 0;
    $type = $params['type'] ? $params['type'] : 'cart_price';
    $name = $params['name'];
    $offerJoinLanguageLogic = AppController::load('offerJoinLanguage');
    
    $promotionlist = $offerJoinLanguageLogic->getListByLanguageId($language_id);     
    $offer = array();
    $minus    = array();
    $discount = array();
    foreach ($promotionlist['cart'] as $list)
    {                
        if($list['offer_type'] == 1 && isset($promotionlist['rules'][$list['id']]) && $list['start_time'] <= SYS_TIME && $list['end_time'] >= SYS_TIME && ($list['user_group_id'] == 0 || $list['user_group_id'] == $user_level))
        {
            foreach ($promotionlist['rules'][$list['id']] as $key => $value)
            {
                if($value['min_buynum'] && $cart_num < $value['min_buynum'])
                {
                    $offer1[$list['id']] = $list;
                    $offer1[$list['id']]['min_buynum'] = $value['min_buynum'];
                    $offer1[$list['id']]['buynum'] = $cart_num;
                    $offer1[$list['id']]['diff_num'] = $value['min_buynum'] - $cart_num;
                }elseif($value['min_amount'] && $cart_price < $value['min_amount'])
                {
                    $offer2[$list['id']] = $list;
                    $offer2[$list['id']]['min_amount'] = $value['min_amount'];
                    $offer2[$list['id']]['amount'] = $cart_price;
                    $offer2[$list['id']]['diff_amount'] = $value['min_amount'] - $cart_price;
                }
            }
        }
    }
    switch ($type) {
        case 'cart_num':
            Common::sort_rows($offer1,'diff_num',SORT_ASC);
            $return = $offer1[0];
            break;
        case 'cart_price':
            Common::sort_rows($offer2,'diff_amount',SORT_ASC);
            $return = $offer2[0];
            break;
        default:
            break;
    }
    $smarty->assign($name, $return);
}

?>
