<?php

/**
 * Smarty category modifier plugin
 * 读取标签商品
 * Type:     function<br>
 * Name:     getGoodsListByTag<br>
 * @author  xrx
 * @return string
 */
function smarty_function_seo($params, &$smarty) {
    global $cfg;
    $language_id = $params['language_id'];
    $meta = array();
    $seo = AppController::load('SeoMetaMaker');
    $lang = Common::lang(Core::$controller, Core::$module, Core::$language);
    $a = strtolower($_GET["a"]);
    $c = strtolower($_GET["c"]);
	
	if($smarty->tpl_vars["seo_title"])
	{
		 $str = "<title>" . $smarty->tpl_vars["seo_title"] . "</title>";
		if ($smarty->tpl_vars["seo_keywords"])
			$str .= "<meta name=\"keywords\" content=\"" . $smarty->tpl_vars["seo_keywords"] . "\" />";
	
		if ($smarty->tpl_vars["seo_descript"])
			$str .= "<meta name=\"description\" content=\"" . $smarty->tpl_vars["seo_descript"] . "\" />";
		return $str;	
	}
	
    // 特殊处理，只要是 404 直接 return ;
    if ($_GET['page_code'] == 404) {
        $meta["title"] = $lang['seo_title_404'] . " - " . $_SERVER['SERVER_NAME'];
    } else if (($c == "index" && $a == "default") || (!$c && !$a)) {
        $meta = $seo->getIndexMeta($language_id, 3);
    } else if ($c == "product" && $a == "search") {
        $p['category_id'] = $_GET['category_id'];
        $p['keywords'] = $_GET['keywords'];
        $meta = $seo->getSearchMeta($language_id, 151, $p, $page);
    } else if ($c == "product" && $a == "commentlist") {
        $goods_id = _g('goods_id');
        $goodLanguageLogic = AppController::load('GoodsJoinLanguage');
        $goods_detail = $goodLanguageLogic->getDetailByGoodsId($goods_id, $language_id);
        $meta["title"] = $goods_detail['goods']['base_name'] . " " . $lang["seo_title_comment"] . " - " . $_SERVER['SERVER_NAME'];
    } else if ($c == "navpage" && $a == "detail") {
        $navPageLogic = AppController::load('NavPageJoinLanguage');
        $navPage = $navPageLogic->getItem($_GET["navpage_id"], $language_id);
        $meta["title"] = $navPage['base_name'] . " - " . $_SERVER['SERVER_NAME'];
		$meta["title"] = $navPage["title"]? $navPage["title"] : $meta["title"];
		$meta["keywords"] = $navPage["keywords"]? $navPage["keywords"] : "";
		$meta["descript"] = $navPage["descript"]? $navPage["descript"] : "";
    } else if ($c == "picklist" && $a == "list") {
        $logic = AppController::load('GoodsPackageSaleJoinLanguage');
        $id = _g("id");
        $res = $logic->getOne("p.id = '{$id}' and l.language_id=" . $language_id);
        if ($res) {
            $meta["title"] = $lang["seo_title_package"] . " : " . $res['base_name'] . " - " . $_SERVER['SERVER_NAME'];
        }
    }else if ($c == "daily" && $a == "list") {
        $meta["title"] = $lang["seo_title_daily"] . " " . $_GET['create_time'] . " - " . $_SERVER['SERVER_NAME'];
    } else if ($c == "product" && $a == "list") {
        $category_id = $_GET["category_id"];
        if (is_array($_GET["brand_id"]))
			$brand_id = $_GET["brand_id"][0];
		else	
			$brand_id = $_GET["brand_id"];
		
		 if (is_array($_GET["tag_id"]))
			$tag_id = $_GET["tag_id"][0];
		else	
			$tag_id = $_GET["tag_id"];
		
		
        $property_id = $_GET["property_id"];
        $page = $_GET["page"];
        if ($category_id && !$brand_id && !$tag_id && !$property_id) {
            $meta = $seo->getCategoryMeta($language_id, 7, $category_id, $page);
        } else if ($brand_id && !$category_id && !$tag_id && !$property_id) {
            $meta = $seo->getBrandMeta($language_id, 8, $brand_id, $page);
        } else if ($tag_id && !$category_id && !$brand_id && !$property_id) {
            $meta = $seo->getTagMeta($language_id, 11, $tag_id, $page);
        } else
            $meta = $seo->getNarrowPageMeta($language_id, 6, $category_id, $brand_id, $tag_id, $property_id, $page);
    }
    else if ($c == "channel" && $a == "detail") {
        $category_id = $_GET["category_id"];
        $meta = $seo->getCategoryMeta($language_id, 7, $category_id, $page);
    } else if ($c == "product" && $a == "detail") {
        $goods_id = $_GET["goods_id"];
        $meta = $seo->getProductMeta($language_id, 1, $goods_id, _g('sku_code'));
    } else if ($c == "article" && $a == "list") {
        $article_category_id = $_GET["article_category_id"];
        $page = $_GET["page"];
        $meta = $seo->getArticleCategoryMeta($language_id, 5, $article_category_id, $page);
    } else if ($c == "article" && $a == "detail") {
        $article_id = $_GET["id"];
        $meta = $seo->getArticleMeta($language_id, 4, $article_id);
    } else if ($c == "deals" && $a == "list") {
        $deals_id = $_GET["offer_id"];
        $meta = $seo->getDealsMeta($language_id, 150, $deals_id, $page);
    } else if ($c == "category" && $a == "list") {
        $category_id = $_GET["category_id"];
        $goodsCategoryLogic = AppController::load('goodsCategoryJoinLang');
        $category = $goodsCategoryLogic->getOne("l.goods_category_id=" . $category_id . ' and l.language_id=' . $language_id);
        if ($category) {
            $meta["title"] = $category['base_name'] . " - " . $_SERVER['SERVER_NAME'];
        }
    } else if ($c == "topic" && $a == "detail") {
        $topic = $smarty->get_template_vars('topic');
        $str = "<title>" . $topic["title"] . "</title>";
        if ($topic["keywords"])
            $str .= "<meta name=\"keywords\" content=\"" . $topic["keywords"] . "\" />";

        if ($topic["descript"])
            $str .= "<meta name=\"description\" content=\"" . $topic["descript"] . "\" />";
        return $str;
    }else if ($c == "product" && $a == "commentall") {
        $category_id = $_GET["category_id"];
        $goodsCategoryLogic = AppController::load('goodsCategoryJoinLang');
        $category = $goodsCategoryLogic->getOne("l.goods_category_id=" . $category_id . ' and l.language_id=' . $language_id);
        $categoryName = $lang["all"];
        if ($category) {
            $categoryName = $category['base_name'];
        }
        $str = "<title>" . $categoryName . " " . $lang['seo_title_comment'] . " - " . $_SERVER['SERVER_NAME'] . "</title>";
        return $str;
    } else {
        $module_seo_data[] = array(array("c" => "cart", "a" => "list"), $lang["seo_title_shopcart"]);
        $module_seo_data[] = array(array("c" => "deals", "a" => "default"), $lang["seo_title_deals_default"]);
        $module_seo_data[] = array(array("c" => "module", "a" => "feedback"), $lang["seo_title_feedback"]);
        $module_seo_data[] = array(array("c" => "account", "a" => "myProfile"), $lang["seo_title_myprofile"]);
        $module_seo_data[] = array(array("c" => "account", "a" => "profile"), $lang["seo_title_myprofile"]);
        $module_seo_data[] = array(array("c" => "account", "a" => "index"), $lang["seo_title_accountcenter"]);
        $module_seo_data[] = array(array("c" => "account", "a" => "editPassword"), $lang["seo_title_setting"]);
        $module_seo_data[] = array(array("c" => "account", "a" => "changepwd"), $lang["seo_title_setting"]);
        $module_seo_data[] = array(array("c" => "account", "a" => "myAddress"), $lang["seo_title_myaddress"]);
        $module_seo_data[] = array(array("c" => "account", "a" => "myMessage"), $lang["seo_title_mymessages"]);
        $module_seo_data[] = array(array("c" => "account", "a" => "editAddress"), $lang["seo_title_myaddress"]);
        $module_seo_data[] = array(array("c" => "account", "a" => "myBillingAddress"), $lang["seo_title_bill_address"]);
        $module_seo_data[] = array(array("c" => "account", "a" => "EditBillingAddress"), $lang["seo_title_bill_address"]);

        $module_seo_data[] = array(array("c" => "account", "a" => "address"), $lang["seo_title_myaddress"]);
        $module_seo_data[] = array(array("c" => "account", "a" => "addAddress"), $lang["seo_title_myaddress"]);
        $module_seo_data[] = array(array("c" => "account", "a" => "favorites"), $lang["seo_title_myfovorite"]);
        $module_seo_data[] = array(array("c" => "account", "a" => "leaveMessage"), $lang["seo_title_leaveamessage"]);
        $module_seo_data[] = array(array("c" => "account", "a" => "orders"), $lang["seo_title_myorders"]);
        $module_seo_data[] = array(array("c" => "account", "a" => "orderDetail"), $lang["seo_title_myorders"]);
        $module_seo_data[] = array(array("c" => "user", "a" => "register"), $lang["seo_title_register"]);
        $module_seo_data[] = array(array("c" => "user", "a" => "LoginOrRegister"), $lang["seo_title_register"]);
        $module_seo_data[] = array(array("c" => "account", "a" => "message"), $lang["seo_title_mymessages"]);
        $module_seo_data[] = array(array("c" => "account", "a" => "messageDetail"), $lang["seo_title_mymessages"]);
        $module_seo_data[] = array(array("c" => "account", "a" => "affiliate"), $lang["seo_title_affiliate"]);

        $module_seo_data[] = array(array("c" => "account", "a" => "creditlist"), $lang["seo_title_mycredits"]);
        $module_seo_data[] = array(array("c" => "account", "a" => "couponList"), $lang["seo_title_couponlist"]);
        $module_seo_data[] = array(array("c" => "account", "a" => "growthList"), $lang["seo_title_growthlist"]);

        $module_seo_data[] = array(array("c" => "user", "a" => "login"), $lang["seo_title_signin"]);
        $module_seo_data[] = array(array("c" => "account", "a" => "coupon"), $lang["seo_title_mycouponcode"]);
        $module_seo_data[] = array(array("c" => "user", "a" => "forgetPassword"), $lang["seo_title_pwdforget"]);
        $module_seo_data[] = array(array("c" => "user", "a" => "answerQuestion"), $lang["seo_title_pwdforget"]);
        $module_seo_data[] = array(array("c" => "account", "a" => "newsletter"), $lang["seo_title_newsletter"]);
        $module_seo_data[] = array(array("c" => "order", "a" => "add"), $lang["seo_title_shipment"]);
        $module_seo_data[] = array(array("c" => "quickorder", "a" => "add"), $lang["seo_title_shipment"]);
        $module_seo_data[] = array(array("c" => "order", "a" => "showPaymentInfo"), $lang["seo_title_payment"]);
        $module_seo_data[] = array(array("c" => "order", "a" => "step2"), $lang["seo_title_payment"]);
        $module_seo_data[] = array(array("c" => "order", "a" => "eCStep2"), $lang["seo_order_eCStep2"]);
        $module_seo_data[] = array(array("c" => "order", "a" => "payment"), $lang["seo_title_payment"]);
        $module_seo_data[] = array(array("c" => "order", "a" => "paymentInterface"), $lang["seo_title_checkout"]);
        $module_seo_data[] = array(array("c" => "order", "a" => "success"), $lang["seo_title_payment"]);
        $module_seo_data[] = array(array("c" => "order", "a" => "failure"), $lang["seo_title_payment"]);
        $module_seo_data[] = array(array("c" => "search", "a" => "default"), $lang["seo_title_search"]);
        $module_seo_data[] = array(array("c" => "module", "a" => "login"), $lang["seo_title_security_login"]);
        $module_seo_data[] = array(array("c" => "category", "a" => "default"), $lang["seo_title_category"]);
        $module_seo_data[] = array(array("c" => "navpage", "a" => "help"), $lang["seo_title_helpcenter"]);
        $module_seo_data[] = array(array("c" => "brands", "a" => "list"), $lang["seo_title_brands"]);
        $module_seo_data[] = array(array("c" => "sitemap", "a" => "pc"), $lang["seo_title_sitemap"]);
        $module_seo_data[] = array(array("c" => "account", "a" => "trackingOrder"), $lang["seo_title_trackingno"]);
        $module_seo_data[] = array(array("c" => "account", "a" => "trackno"), $lang["seo_title_trackingno"]);
        $module_seo_data[] = array(array("c" => "history", "a" => "list"), $lang["seo_title_history"]);
        $module_seo_data[] = array(array("c" => "product", "a" => "descript"), $lang["seo_title_descript"]);
		$module_seo_data[] = array(array("c" => "product", "a" => "specificat"), $lang["seo_title_specificat"]);
        $module_seo_data[] = array(array("c" => "apilogin", "a" => "register"), $lang["seo_title_sns_login"]);
        $module_seo_data[] = array(array("c" => "product", "a" => "commentall"), $lang["seo_title_commentall"]);
		$module_seo_data[] = array(array("c" => "module", "a" => "page"), $lang["seo_title_page_".$_GET['tpl']]);
        $module_seo_data[] = array(array("c" => "module", "a" => "404"), $lang["seo_title_404"]);
        $module_seo_data[] = array(array("c" => "user", "a" => "forgetpasswordreset"), $lang["seo_title_forgetpreset"]);

        foreach ($module_seo_data as $key => $value) {
            if ($c == strtolower($value[0]["c"]) && $a == strtolower($value[0]["a"])) {
                $meta["title"] = $value[1] . " - " . $_SERVER['SERVER_NAME'];
                break;
            }
        }
		
		if(!$meta["title"])
		{
			$meta["title"] = $lang[strtolower("seo_title_".$c."_".$a)] . " - " . $_SERVER['SERVER_NAME'];
		}
    }

    $str = "<title>" . $meta["title"] . "</title>";
    if ($meta["keywords"])
        $str .= "<meta name=\"keywords\" content=\"" . $meta["keywords"] . "\" />";

    if ($meta["descript"])
        $str .= "<meta name=\"description\" content=\"" . $meta["descript"] . "\" />";
    return $str;
}

?>