<?php

/**
 * Smarty lower modifier plugin
 * 支付手续费
 * Type:   modifier<br>
 * Name:    payment_status<br>
 * @author  NT
 * @param string subtotalprice
 * @param string payment_id
 * @param string language_id
 * @param string style
 * @return string
 */
function smarty_modifier_payment_status($subtotalprice, $payment_id, $language_id) {
    $paymentLogic = AppController::load('payment');
   $cond = '(language_id=0 or language_id=' . $language_id . ') and status=1 and id=' . $payment_id . ' order by listorder asc';
    $payment = $paymentLogic->getOne($cond);
    if ($payment) {
        $order_param = array(
            'totalprice' => $subtotalprice
        );
        $fee = $paymentLogic->getPaymentFee($order_param, $payment['config_param'], $payment['formula']);
        if ($fee) {
            $fee = AppController::toolPrice($fee, TRUE);
        } else {
            $fee = 0;
        }
        $subtotalprice += $fee;
        if ($subtotalprice < $payment['min_order_amount'] && $payment['min_order_amount'] != 0) {
            $status = 0;
        } else if ($subtotalprice > $payment['max_order_amount'] && $payment['max_order_amount'] != 0) {
            $status = 0;
        } else {
            $status = 1;
        }
    } else {
        $status = 0;
    }
    return $status;
}

?>
