(function ($){
var tool,loaded,style,emails;
style='.email_list{position:absolute;left:0px;top:0px;z-index:9;border:1px solid #ccc;background:#FFF;width:200px;display:none;overflow:hidden;}'
    +'.email_list a, .email_list div{display:block;zoom:1;cursor:pointer;font: 12px/1 verdana;color:#000000;text-decoration:none;padding:4px 10px;}'
    +'.email_list a:hover, .email_list .current{background:#999;color:#FFF;}  ';
emails = ['gmail.com','hotmail.com','yahoo.com','msn.com','live.com','googlemail.com','aol.com','hotmail.co.uk','yahoo.co.uk','laposte.net'];
tool= {
    addStyle: function (cssText){
        if (!loaded) {
            loaded = true;
            var css, head = document.getElementsByTagName('head')[0],
                styles = head.getElementsByTagName("style");
            if (styles.length == 0) {
                if (window.attachEvent) {
                    document.createStyleSheet()                    
                }else{
                    var css = head.appendChild(document.createElement('style'));
                    css.setAttribute('type','text/css')
                }
            }
            css = styles[styles.length - 1];
            if (css.styleSheet) {
                css.styleSheet.cssText += cssText
            } else {
                css.appendChild(document.createTextNode(cssText))
            }
        }
    },
    createLay: function (){
        this.addStyle(style);
        return  $('<div/>').appendTo(document.body).addClass('email_list');
    },
    fillMenu: function (menu, list, name){
        //var html = ['<div>Select the mailbox type</div>'];
        var html = [];
        var en = name.split('@');
        if(en[1]){
            var end = en[1];
            list = list.slice().sort(function(a, b){
                var a = a.indexOf(end) == 0 ? 1 : 0;
                var b = b.indexOf(end) == 0 ? 1 : 0;
                return a > b ? -1 : 1;
            }); 
        }
        $.each(list, function (i, title){
            var em = en[0]+'@'+title;
            html[i+1] = '<a href="javascript:void 0" data-index="'+i+'" title="'+em+'">'+em+'</a>'
        });
        menu.html(html.join(''))
    },
    show: function (menu, el){
        var pos = $(el).offset();
        menu.css({
            left: pos.left,
            top: pos.top+$(el).height()+2,
            width: $(el).innerWidth()
        }).fadeIn(200)
    },
    focus: function (links, n){
        links.removeClass('current').eq(n).addClass('current')  
    }
};
$.fn.autoEmail = function (list){
    var el = this.eq(0), menu, prev, current = 0;
    list = list instanceof Array ? list : emails;
    if (!el.data('addEmailMenu')) {
        el.data('addEmailMenu', true);
        el.attr('autocomplete', 'off');
        menu = tool.createLay();
        el.focus(function (){
            if ($.trim(this.value.split('@')[0])) {
                 tool.fillMenu(menu, list, this.value);
                 tool.show(menu, this);
                 current = -1;
            }
        }).blur(function (){
            setTimeout(function() {
                menu.hide()
            },10);
        }).keydown(function (e){
            var key = e.keyCode;
            if (key==13) {
                 e.preventDefault();
                 e.stopPropagation(); 
                 return false
            }
        }).keyup(function (e){
            var key = e.keyCode, a= $('.email_list a');
            switch(key){
            case 40:
                current++;
                 if (current>a.size()-1) {current = 0}
                return tool.focus(a, current)
            case 38:
                current--;
                if (current < 0) {
                    current = a.size()-1;
                }                
                return  tool.focus(a, current)
             case 13: 
                menu.hide();
                if (this.value) {
                    this.value =  menu.find('a').eq(current).html();
                }     
                 current = 0;
                return false
            }
            if (/[^\d\w-.@]/.test(this.value)) {
                this.value = this.value.replace(/[^\d\w-_.@]/i,'')
            }
            if (prev != this.value) {
                 prev = this.value;
                 tool.fillMenu(menu, list, this.value);
                 tool.show(menu, this);
                 a= $('.email_list a');
                 current = 0;
                 tool.focus(a, 0)
             }
             if ($.trim(this.value) == '') {
                   current = -1;
                   menu.hide()
             }
        });
        $('.email_list a').live('mousedown', function (){
            el.val(this.innerHTML);
        }).live('mouseover', function (){
            current = parseInt(this.getAttribute('data-index'))||0;
            tool.focus($('.email_list a'), current);          
        })
    }
    return this
};
})(jQuery);
//$('#email').autoEmail();