/*
 * @param:
 *	1. stateKey - undefined: Default code || ru[string]: Russia code
 *	2. reverse - true || false, for default icon reverse
 */
(function( $ ) {
/* store ajax data */
$.ajaxHolder = {
	data: {}
};

$.extend( $.ajaxHolder, {
	autoClose: 15 * 1000,
	
	// save data into ajaxHolder.data
	set: function( key, value ) {
		if( !$.ajaxHolder.data[ key ] ) {
			$.ajaxHolder.data[ key ] = null;
		}
		
		$.ajaxHolder.data[ key ] = value;
	},
	
	// get data into ajaxHolder.data
	get: function( a, func ) {
		a = $.isArray( arguments[0] ) ? a : [ a ];
		
		for( var i = 0; i < a.length; i ++ ) {
			var ah = new $.ah( a[i], func );
			
			ah.init();
		}
	}
});
$.ah = function( key, func ) {
	this.key = key;
	this.func = func;
};

$.extend( $.ah, {
	timerId: null,
	timers: [],
	
	// timeDown listener
	tick: function() {
		for( var i = 0, fn = $.ah.timers; i < fn.length; i ++ ) {
			fn[ i ].step();
		}
		
		if( !$.ah.timers.length ) {
			clearInterval( $.ah.timerId );
			$.ah.timerId = null;
		}
	}
});
$.ah.prototype = {
	init: function() {
		this.start = ( new Date() ).getTime();
		
		if( $.ah.timers.push( this ) && !$.ah.timerId ) {
			$.ah.timerId = setInterval( $.ah.tick, 1000 );
			$.ah.tick();
		}
	},
	
	step: function() {
		// Out of the max time
		if( ( new Date() ).getTime() - this.start > $.ajaxHolder.autoClose ) {
			this.func.call( this, null );
			
			this.stop();
		} else {
			// Find the data
			if( $.ajaxHolder.data[ this.key ] ) {
				if( this.func && $.isFunction( this.func ) ) {
					this.func.call( this, this.key, $.ajaxHolder.data[ this.key ] );
				}
				
				this.stop();
			}
		}
	},
	
	stop: function() {
		for ( var i = 0; i < $.ah.timers.length; i ++ ) {
			if( $.ah.timers[i].key === this.key ) {
				$.ah.timers.splice( i, 1 );
			}
		}
	}
};
})( jQuery );
var gvs = {};
gvs.langcode = 'en-uk';

(function( $ ) {
	
	$.fn.getAddthis=function(){};

	$(function() {
	
		var langCodeMap = {
			'ja-jp': 'ja_JP',
			'fr-fr': 'fr_FR',
			'es-sp': 'es_ES',
			'de-ge': 'de_DE',
			'it-it': 'it_IT',
			'ru-ru': 'ru_RU'
			
		};
	
		var FBCodeWidth = {
			'ja-jp': 131,
			'fr-fr': 116,
			'es-sp': 133,
			'de-ge': 137,
			'it-it': 126,
			'ru-ru': 160
			
		};
	
		var TTCodeWidth = {
			'ja-jp': 131,
			'fr-fr': 116,
			'es-sp': 133,
			'de-ge': 137,
			'it-it': 126,
			'ru-ru': 160
			
		};
		
		var _langcode = langCodeMap[ gvs.langcode ] || 'en_US';
		var _FBWidth = FBCodeWidth[ gvs.langcode ] || 104;
		var _TTWidth = TTCodeWidth[ gvs.langcode ] || 89;
	        var user_id = jQuery.ajaxHolder.data[ 'user_id' ];
	        var goods_id = jQuery.ajaxHolder.data[ 'goods_id' ];
	        var goods_price = jQuery.ajaxHolder.data[ 'goods_price' ];
	        var lcoin = jQuery.ajaxHolder.data[ 'lcoin' ];
	        var goods_name = jQuery.ajaxHolder.data[ 'goods_name' ];
                var goods_url = jQuery.ajaxHolder.data[ 'goods_url' ];
                if(!user_id)
                    user_id=0;
		jQuery.ajaxHolder.get( 'pro_imgurl', function( key ) {
                        document.title =goods_name+" "+lcoin+goods_price;
			var medUrl = jQuery.ajaxHolder.data[ key ];
			var key = 'ra-4e142e195c4a0844';
			var nowUrl = goods_url+'?source_user='+user_id+'&source=';
                        nowUrl = encodeURIComponent(nowUrl);
			//nowUrl = 'http://www.milanoo.com
                        //';
			var pinitUrl = 'http://pinterest.com/pin/create/button/?url='+ nowUrl+'sns_share_pin' + '&media='+ medUrl;


			if(_langcode=='ru_RU'){

			var addthisHtmlStr= '<div class="sns_all">'+
				'<div id="vk_share_button"></div>'+
				'<div id="fb-root"></div>'+
				'<div class="fb-like" data-href="'+nowUrl+'sns_share_facebook'+'" data-send="false" data-layout="button_count" data-width="'+ _FBWidth +'" data-show-faces="true"></div>'+
				'<div class="tweet">'+
				'<a href="https://twitter.com/share" class="twitter-share-button" data-url="'+nowUrl+'sns_share_twitter'+'" data-width="'+ _TTWidth +'" data-lang="'+ _langcode +'">Twitter</a>'+
				'</div>'+
				'<div class="pinit">'+
				'<div class="pinit_a">'+
				'<a href="'+ pinitUrl +'"'+
				'class="pin-it-button" count-layout="horizontal" title="test pin title">Pin It</a></div>'+
				'<scr'+'ipt type="text/javascript" src="http://assets.pinterest.com/js/pinit.js"></scr'+'ipt>'+
				'</div>'+
				'<div class="img_000"></div>'+			
				'<div class="google_1">'+
				'<a class="addthis_button_google_plusone" g:plusone:size="medium" ></a>'+
				'</div>'+
				'<div class="eamil">'+
				'<a href="http://www.addthis.com/bookmark.php" class="addthis_button_email"></a>'+
				'</div>'+
				'<div class="share">'+
				'<a class="addthis_counter addthis_pill_style" ></a>'+
				'</div>';
               if(user_id>0)
	       addthisHtmlStr +='<div class="promotion"><a class="promotion-share-button" onclick="javascript:shareGoods.exec('+goods_id+');"></a></div>';
	       addthisHtmlStr +='</div>'+
				'<script>!function(d,s,id){var js,fjs=d.getElementsByTagName(s)[0];if(!d.getElementById(id))'+
				'{js=d.createElement(s);js.id=id;js.src="//platform.twitter.com/widgets.js?lang='+ _langcode +'";fjs.parent'+
				'Node.insertBefore(js,fjs);}}(document,"script","twitter-wjs");</script>'+
			
				'<scr'+'ipt type="text/javascript">'+
				'(function() {'+
				'var js, fjs = document.getElementsByTagName( "script" )[0];'+
				'if (document.getElementById( "facebook-jssdk" )) return;'+
				'js = document.createElement( "script" ); js.id = "facebook-jssdk";'+
				'js.src = "//connect.facebook.net/'+ _langcode +'/all.js#xfbml=1";'+
				'fjs.parentNode.insertBefore(js, fjs);'+
				'})();'+
				'</scr'+'ipt>'+
				'<scr'+'ipt type="text/javascript" src="//apis.google.com/js/plusone.js">'+
				'</scr'+'ipt>'+
                                '<scr'+'ipt type="text/javascript">var addthis_share = {url : "'+nowUrl+'sns_share_addthis",title:"'+goods_name+' '+lcoin+' '+goods_price+'",description:"'+goods_name+' '+lcoin+' '+goods_price+'"};</scr'+'ipt>'+
				'<scr'+'ipt type="text/javascript" src="//s7.addthis.com/js/250/addthis_widget.js#pubid='+key+'"></scr'+'ipt>'+
				'<scr'+'ipt type="text/javascript" src="//vkontakte.ru/js/api/share.js?9" charset="windows-1251"></scr'+'ipt>';
			}else{
				var addthisHtmlStr= '<div class="sns_all">'+
				'<div class="pinit">'+
				'<div class="pinit_a">'+
				'<a href="'+ pinitUrl +'"'+
				'class="pin-it-button" count-layout="horizontal">Pin It</a></div>'+
				'<scr'+'ipt type="text/javascript" src="http://assets.pinterest.com/js/pinit.js"></scr'+'ipt>'+
				'</div>'+
				'<div class="img_000"></div>'+
				'<div id="fb-root"></div>'+
				'<div class="fb-like" data-href="'+nowUrl+'sns_share_facebook'+'" data-send="false" data-layout="button_count" data-width="'+ _FBWidth +'" data-show-faces="true"></div>'+
				'<div class="tweet">'+
				'<a href="https://twitter.com/share" class="twitter-share-button" data-url="'+nowUrl+'sns_share_twitter'+'" data-width="'+ _TTWidth +'" data-lang="'+ _langcode +'">Twitter</a>'+
				'</div>'+
				'<div class="google_1">'+
				'<a class="addthis_button_google_plusone" g:plusone:size="medium" ></a>'+
				'</div>'+
				'<div class="eamil">'+
				'<a href="http://www.addthis.com/bookmark.php" class="addthis_button_email"></a>'+
				'</div>'+
				'<div class="share">'+
				'<a class="addthis_counter addthis_pill_style" ></a>'+
				'</div>';
               if(user_id>0)
	       addthisHtmlStr +='<div class="promotion"><a class="promotion-share-button" onclick="javascript:shareGoods.exec('+goods_id+');"></a></div>';
	       addthisHtmlStr +='</div>'+
				'<script>!function(d,s,id){var js,fjs=d.getElementsByTagName(s)[0];if(!d.getElementById(id))'+
				'{js=d.createElement(s);js.id=id;js.src="//platform.twitter.com/widgets.js?lang='+ _langcode +'";fjs.parent'+
				'Node.insertBefore(js,fjs);}}(document,"script","twitter-wjs");</script>'+
				
				'<scr'+'ipt type="text/javascript">'+
					'(function() {'+
					'var js, fjs = document.getElementsByTagName( "script" )[0];'+
					'if (document.getElementById( "facebook-jssdk" )) return;'+
					'js = document.createElement( "script" ); js.id = "facebook-jssdk";'+
					'js.src = "//connect.facebook.net/'+ _langcode +'/all.js#xfbml=1";'+
					'fjs.parentNode.insertBefore(js, fjs);'+
					'})();'+
					'</scr'+'ipt>'+
					'<scr'+'ipt type="text/javascript" src="//apis.google.com/js/plusone.js">'+
					'</scr'+'ipt>'+
                                        '<scr'+'ipt type="text/javascript">var addthis_share = {url : "'+nowUrl+'sns_share_addthis",title:"'+goods_name+' '+lcoin+' '+goods_price+'",description:"'+goods_name+' '+lcoin+' '+goods_price+'"};</scr'+'ipt>'+
					'<scr'+'ipt type="text/javascript" src="//s7.addthis.com/js/250/addthis_widget.js#pubid='+key+'"></scr'+'ipt>';
			}
			$(window).load(function(){
				$( '.epaddthis' ).html( addthisHtmlStr );
				if(_langcode=='ru_RU'){			
					function VK_delay(){
						if(VK){
							$('#vk_share_button').html(VK.Share.button({url: false,image: medUrl}, {type: 'custom',text:'<img src="http://vk.com/images/vk32.png" />'}));
							clearInterval(vkTimer);
						}
					}
					var vkTimer = setInterval(VK_delay,2000);		
				}
			});

		});
	});
})( jQuery );