 /*
 * bwTableList! jQuery plugin
 * version 1.0
 * author: Baiwapak
 * email: baiwapak@qq.com
 */
;(function($){
	$.fn.bwTableList = function(options){
		var defaults = {
			odd : "odd",  			 //奇数行的样式
			even: "even", 			 //偶数行的样式
			current: "current", 	 //选中状态的样式
			selected:"selected", 	 //鼠标移动的样式
			orderdesc: "orderdesc",  //排序的元素样式 desc
			orderasc: "orderasc",    //排序的元素样式 asc
			ajaxInput: [],           //哪几列需要动态输入框的[0,1,2]
			ajaxButtonFunction:[],
			bw_orderString: "bw_orderString",  //字符串排序Class
			bw_orderNumber: "bw_orderNumber",  //数字排序Class
			bw_selectAll: "bw_selectAll",      //全选按钮Class
			bw_selectAnti: "bw_selectAnti",    //反选按钮Class
			bw_selectNo: "bw_selectNo",        //全不选按钮Class
			bw_checkbox: "bw_checkbox",        //列表复选框对象Class
			bwCheckbox : "bwCheckbox", //默认样式
			bwCheckboxHover : "bwCheckboxHover", //触摸样式
			bwCheckboxSelected : "bwCheckboxSelected", //选中样式
			bw_ajax_edit_input: "bw_ajax_edit_input", //动态输入框样式
			bw_ajax_edit_ok: "bw_ajax_edit_ok",	      //动态输入框确定按钮样式
			bw_ajax_edit_no: "bw_ajax_edit_no", 	  //动态输入框取消按钮样式
			bw_ajax_edit_ok_text: "Yes", 			  //动态输入框确定按钮文字
			bw_ajax_edit_no_text: "Cancel" 			  //动态输入框取消按钮文字
		}
		var options = $.extend(defaults, options);
		
		var obj = $(this);
		var $bwCheckbox = $("."+options.bwCheckbox);
		
		//初始化样式
		$(this).find("tbody:first > tr:odd").addClass(options.odd);
		$(this).find("tbody:first > tr:even").addClass(options.even);
		//表格行移动样式
		$(this).find("tbody:first > tr").hover(
			function(){
				$(this).addClass(options.selected);	
			},
			function(){
				$(this).removeClass(options.selected);		
			}
		);
		
		//排序按钮动作(数字)
		$(this).find("thead:first th."+options.bw_orderNumber).click(function(){
			var hasOrder = $(this).hasClass(options.orderasc);	
			$(this)[hasOrder ? "removeClass" : "addClass"](options.orderasc);
			if(hasOrder){
				$(this).find("img").attr("src", "images/order_down.jpg");	
			}else{
				$(this).find("img").attr("src", "images/order_up.jpg");
			}
			var thisIndex = $(this).index();
			var orderList = new Array();
			var trObj = $(this).closest("table").find("tbody > tr");
			trObj.each(function(){
				 orderList.push($(this).find("td").eq(thisIndex).text());														  
			});

			hasOrder ? orderTrNumber(orderList, trObj, thisIndex, "asc") : orderTrNumber(orderList, trObj, thisIndex, "desc");

			return false;
		});
		//排序按钮动作(字符串)
		$(this).find("thead:first th."+options.bw_orderString).click(function(){
			var hasOrder = $(this).hasClass(options.orderasc);	
			$(this)[hasOrder ? "removeClass" : "addClass"](options.orderasc);
			var thisIndex = $(this).index();
			var orderList = new Array();
			var trObj = $(this).closest("table").find("tbody > tr");
			trObj.each(function(){
				 orderList.push($(this).find("td").eq(thisIndex).text());														  
			});

			hasOrder ? orderTrString(orderList, trObj, thisIndex, "asc") : orderTrString(orderList, trObj, thisIndex, "desc");

			return false;
		});
		
		/**
		* 排序组动作
		*/
		$(this).find("tbody:first > tr > td").live("dblclick", function(){
			var thisIndex = Number($(this).index());
			if(in_array(thisIndex, options.ajaxInput)){
				var thisText = $(this).html();
				
				var htmlText = "<div id='ajaxEdit' style='position:relative;'><span>"+thisText+"</span><div class='bw_ajax_div'><input class='"+options.bw_ajax_edit_input+"' value='"+thisText+"' style='border:none; color:#8C8C8C; width:238px; height:25px; line-height:25px; background:none; position:absolute; left:5px; top:12px;' type='text' /><div style='width:100px; height:22px; line-height:22px; color:#fff; position:absolute; top:12px; right:5px;'><a class='"+options.bw_ajax_edit_ok+"' href='#' style='color:#fff;'>"+options.bw_ajax_edit_ok_text+"</a>&nbsp;|&nbsp;<a class='"+options.bw_ajax_edit_no+"' style='color:#fff;' href='###'>"+options.bw_ajax_edit_no_text+"</a></div></div></div>";
				
				if(!$(this).children().is("#ajaxEdit")){
					$(this).html('');
					$(htmlText).appendTo($(this));
					$("."+options.bw_ajax_edit_input).focus();
					$("."+options.bw_ajax_edit_input).select();
					
				}
			}
			return false;
		});
		//动态框取消按钮
		$("."+options.bw_ajax_edit_no).live("click", function(){
			var thisSiblingTextObj = $("."+options.bw_ajax_edit_input);
			var thisSiblingText = thisSiblingTextObj.get(0).defaultValue;
			$(this).closest("td").html(thisSiblingText);
			return false;
		});
		//动态框确定按钮
		$("."+options.bw_ajax_edit_ok).live("click", function(){
			var thisSiblingText = $("."+options.bw_ajax_edit_input).val();
			var thisIndex = Number($(this).closest("td").index());
			var thisAjaxIndex = $.inArray(thisIndex,options.ajaxInput);
			td = $(this).closest("td") ;
			td.html(thisSiblingText);
			fun = options.ajaxButtonFunction[thisAjaxIndex] ;
			result = eval(fun+"('"+ $(td).attr("rel") + "','"+ thisSiblingText +"')");
			return false;
		});
		
		
		//点击复选框动作
		$bwCheckbox.click(function(){
			var hasClass = $(this).hasClass(options.bwCheckboxSelected);
			var hasId = $(this).attr("id");
			if(hasId == options.bw_selectAll){ return false;}
			$(this).closest("tr")[hasClass?"addClass":"removeClass"](options.current);
		});
		
		//全选
		$(this).find($("#"+options.bw_selectAll)).click(function(){
			var hasClass = $(this).hasClass(options.bwCheckboxSelected);												 
				if(hasClass){
					$(this).closest("table").find("tbody:first > tr").addClass(options.current).find($bwCheckbox).addClass(options.bwCheckboxSelected).find(":checkbox").attr("checked", hasClass);
				}else{
					$(this).closest("table").find("tbody:first > tr").removeClass(options.current).find($bwCheckbox).removeClass(options.bwCheckboxSelected).find(":checkbox").attr("checked", hasClass);
				}
				return false;
		});
		//反选
		$(this).find($("."+options.bw_selectAnti)).click(function(){
			$(this).closest("table").find("tbody:first > tr").each(function(){
				var hasChecked = $(this).hasClass(options.current);
				$(this)[hasChecked?"removeClass":"addClass"](options.current).find("."+options.bw_checkbox).attr("checked", !hasChecked);
			});
		});
		//全不选
		$(this).find($("."+options.bw_selectNo)).click(function(){
			$(this).closest("table").find("tbody:first > tr").removeClass(options.current).find("."+options.bw_checkbox).attr("checked", false);	
		});
		
		//表格排序
		orderTrNumber = function(orderList, trObj, thisIndex, order){
			var trLength = orderList.length;
			if(order == "asc"){
				orderList.sort(function compare(a,b){
						return a-b;
				});
			}else if(order == "desc"){
				orderList.sort(function compare(a,b){
					return b-a;
				});
			}
			
			for(var i = 0; i < trLength; i++){
				trObj.each(function(e){
					if(orderList[i] == $(this).find("td").eq(thisIndex).text()){
						$(this).appendTo($(this).parent());
					}
				});
			}
			obj.find("tbody:first > tr:odd").removeClass(options.even).addClass(options.odd);
			obj.find("tbody:first > tr:even").removeClass(options.odd).addClass(options.even);
		};
		orderTrString = function(orderList, trObj, thisIndex, order){
			var trLength = orderList.length;
			if(order == "asc"){
				orderList.sort(function compare(a,b){
						if(a == b){return 0;}
						return a > b ? 1 : -1;
				});
			}else if(order == "desc"){
				orderList.sort(function compare(a,b){
						if(a == b){return 0;}
						return a <b ? 1 : -1;
				});
			}
			
			for(var i = 0; i < trLength; i++){
				trObj.each(function(e){
					if(orderList[i] == $(this).find("td").eq(thisIndex).text()){
						$(this).appendTo($(this).parent());
					}
				});
			}
			obj.find("tbody:first > tr:odd").removeClass(options.even).addClass(options.odd);
			obj.find("tbody:first > tr:even").removeClass(options.odd).addClass(options.even);
		};
		
		//in_array()
		in_array = function(needle, haystack) {
			var type = typeof needle;
			 if(type == 'string' || type =='number'){
				  for(var i in haystack){
					   if(haystack[i] == needle) {
						 return true;
					   }
				  }
			 }
			 return false;
		};
		
		return this;
	}		   
})(jQuery);