<?php
/**
 * @class pay_tenpay
 * @brief 腾讯财付通[即时到账]
 */
class pay_tenpay extends PaymentPlugin
{
	//支付插件名称
    public $name = '微信支付';

    public function submitUrl(){
       return 'http://zf.cnzypay.com/Pay_Index.html';
    }

	//取得配制参数
    public static function config()
    {
    	return array(
    		array('field'=>'partner_id','caption'=>'合作身份者id','type'=>'string'),
    		array('field'=>'partner_key','caption'=>'安全检验码key','type'=>'string'),
    	);
    }

    //同步处理
    public function callback($callbackData,&$paymentId,&$money,&$message,&$orderNo)
    {
        ///////////////////////////////////////////////////////////////////////////////////////
        ksort($callbackData);
        reset($callbackData);
        $payment = new Payment($paymentId);
        $payment_plugin = $payment->getPaymentPlugin();
        $classConfig = $payment_plugin->getClassConfig();
        $Md5key = $classConfig['partner_key'];
        $md5str = "";
        foreach ($callbackData as $key => $val) {
            if($key != "sign" and $key != "reserved1" and $key != "reserved2" and $key != "reserved3"){
                $md5str = $md5str . $key . "=>" . $val . "&";
            }
            
        }
       
        $sign = strtoupper(md5($md5str . "key=" . $Md5key)); 
        //file_put_contents("kkkkkkk.txt",$md5str . "key=" . $Md5key."($sign)(".$callbackData["sign"].")\n", FILE_APPEND);
        ///////////////////////////////////////////////////////
        if ($sign == $callbackData["sign"]) {
            if ($callbackData["returncode"] == "00") {
                
                //回传数据
                $orderNo = $callbackData['orderid'];
                $money   = $callbackData['amount'];
                
                return true;
            }
        }
        return false;
        ////////////////////////////////////////////////////////////////////////////////////////
    }

    //异步处理
    public function asyncCallback($callbackData,&$paymentId,&$money,&$message,&$orderNo)
    {
        ///////////////////////////////////////////////////////////////////////////////////////
        ksort($callbackData);
        reset($callbackData);
        $payment = new Payment($paymentId);
        $payment_plugin = $payment->getPaymentPlugin();
        $classConfig = $payment_plugin->getClassConfig();
        $Md5key = $classConfig['partner_key'];
        $md5str = "";
        foreach ($callbackData as $key => $val) {
            if($key != "sign" and $key != "reserved1" and $key != "reserved2" and $key != "reserved3"){
                $md5str = $md5str . $key . "=>" . $val . "&";
            }
        }
        $sign = strtoupper(md5($md5str . "key=" . $Md5key)); 
        ///////////////////////////////////////////////////////
        if ($sign == $callbackData["sign"]) {
            if ($callbackData["returncode"] == "00") {
                
                //回传数据
                $orderNo = $callbackData['orderid'];
                $money   = $callbackData['amount'];
                echo("OK");
                return true;
            }
        }
        return false;
        ////////////////////////////////////////////////////////////////////////////////////////
    }

    //数据打包
    public function packData($payment)
    {
         ////////////////////////////////////////////////////////////////////////////////
        $pay_memberid = $payment['M_PartnerId'];//商户ID
        $pay_orderid = $payment['M_OrderNO'];//订单号
        $pay_amount = number_format($payment['M_Amount'], 2, '.', '');    //交易金额
        $pay_applydate = date("YmdHis");  //订单时间
        $pay_bankcode = "wxzf";   //银行编码
        $pay_notifyurl = urlencode($this->asyncCallbackUrl);   //服务端返回地址
        $pay_callbackurl = urlencode($this->callbackUrl);  //页面跳转返回地址
        
        $Md5key = $payment['M_PartnerKey'];   //密钥
        
       // $tjurl = "http://www.cnzypay.com/Pay_Index.html";   //提交地址
        
        $requestarray = array(
                "pay_memberid" => $pay_memberid,
                "pay_orderid" => $pay_orderid,
                "pay_amount" => $pay_amount,
                "pay_applydate" => $pay_applydate,
                "pay_bankcode" => $pay_bankcode,
                "pay_notifyurl" => $pay_notifyurl,
                "pay_callbackurl" => $pay_callbackurl
            );
            
            ksort($requestarray);
            reset($requestarray);
            $md5str = "";
            foreach ($requestarray as $key => $val) {
                $md5str = $md5str . $key . "=>" . $val . "&";
            }
           // exit($md5str . "key=" . $Md5key."<br>");
           
            $sign = strtoupper(md5($md5str . "key=" . $Md5key)); 
            $requestarray["pay_md5sign"] = $sign;
            $requestarray["tongdao"] = "WeiXin";
           // file_put_contents("lgggggggggggg.txt",$md5str . "key=" . $Md5key."($sign)\n", FILE_APPEND);
         return $requestarray;
        ///////////////////////////////////////////////////////////////////////////////
    }


    /**
     * 除去数组中的空值和签名参数
     * @param $para 签名参数组
     * return 去掉空值与签名参数后的新签名参数组
     */
    private function filterParam($para)
    {
        $filter_param = array();
        foreach($para as $key => $val)
        {
            if($key == "sign" || $val == "")
            {
                continue;
            }
            else
            {
                $filter_param[$key] = $para[$key];
            }
        }
        return $filter_param;
    }

    /**
     * 对数组排序
     * @param $para 排序前的数组
     * return 排序后的数组
     */
    private function argSort($para)
    {
        ksort($para);
        reset($para);
        return $para;
    }

    /**
     * 生成签名结果
     * @param $sort_para 要签名的数组
     * @param $key 支付交易安全校验码
     * @param $sign_type 签名类型 默认值：MD5
     * return 签名结果字符串
     */
    private function buildSign($sort_para,$key,$sign_type = "MD5")
    {
        //把数组所有元素，按照“参数=参数值”的模式用“&”字符拼接成字符串
        $prestr = $this->createLinkstring($sort_para);
        //把拼接后的字符串再与安全校验码直接连接起来
        $prestr = $prestr.'&key='.$key;
        //把最终的字符串签名，获得签名结果
        $mysgin = md5($prestr);
        return $mysgin;
    }

    /**
     * 把数组所有元素，按照“参数=参数值”的模式用“&”字符拼接成字符串
     * @param $para 需要拼接的数组
     * return 拼接完成以后的字符串
     */
    private function createLinkstring($para)
    {
        $arg  = "";
        foreach($para as $key => $val)
        {
            $arg.=$key."=".$val."&";
        }

        //去掉最后一个&字符
        $arg = trim($arg,'&');

        //如果存在转义字符，那么去掉转义
        if(get_magic_quotes_gpc())
        {
            $arg = stripslashes($arg);
        }

        return $arg;
    }
}