/*
 * Decompiled with CFR 0.152.
 */
package wjhk.jupload2.policies;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import wjhk.jupload2.context.JUploadContext;
import wjhk.jupload2.policies.UploadPolicy;

public class UploadPolicyFactory {
    public static UploadPolicy getUploadPolicy(JUploadContext theAppletContext) throws Exception {
        UploadPolicy uploadPolicy = theAppletContext.getUploadPolicy();
        if (uploadPolicy == null) {
            String uploadPolicyStr = theAppletContext.getParameter("uploadPolicy", "DefaultUploadPolicy");
            int debugLevel = theAppletContext.getParameter("debugLevel", 0);
            String action = null;
            boolean usingDefaultUploadPolicy = false;
            try {
                UploadPolicyFactory.logDebug("Trying to load the given uploadPolicy: " + uploadPolicyStr, debugLevel);
                action = uploadPolicyStr;
                Class<?> uploadPolicyClass = null;
                if (!uploadPolicyStr.contains(".")) {
                    try {
                        uploadPolicyClass = Class.forName("wjhk.jupload2.policies." + uploadPolicyStr);
                        UploadPolicyFactory.logDebug("wjhk.jupload2.policies." + uploadPolicyStr + " class found.", debugLevel);
                    }
                    catch (ClassNotFoundException e1) {
                        UploadPolicyFactory.logDebug(e1.getClass().getName() + " when looking for [wjhk.jupload2.policies.]" + uploadPolicyStr, debugLevel);
                        uploadPolicyClass = null;
                    }
                }
                if (null == uploadPolicyClass) {
                    try {
                        uploadPolicyClass = Class.forName(uploadPolicyStr);
                        UploadPolicyFactory.logDebug(uploadPolicyStr + " class found.", debugLevel);
                    }
                    catch (ClassNotFoundException e2) {
                        UploadPolicyFactory.logDebug(e2.getClass().getName() + " when looking for the given uploadPolicy (" + uploadPolicyStr + ")", debugLevel);
                        usingDefaultUploadPolicy = true;
                        uploadPolicyClass = Class.forName("wjhk.jupload2.policies.DefaultUploadPolicy");
                        UploadPolicyFactory.logDebug("Using default upload policy: wjhk.jupload2.policies.DefaultUploadPolicy", debugLevel);
                    }
                }
                action = "constructorParameters";
                Class[] constructorParameters = new Class[]{Class.forName("wjhk.jupload2.context.JUploadContext")};
                Constructor<?> constructor = uploadPolicyClass.getConstructor(constructorParameters);
                Object[] params = new Object[]{theAppletContext};
                action = "newInstance";
                uploadPolicy = (UploadPolicy)constructor.newInstance(params);
            }
            catch (Exception e) {
                if (e instanceof InvocationTargetException) {
                    Throwable t = ((InvocationTargetException)e).getTargetException();
                    System.out.println("-ERROR- " + e.getClass().getName() + " (message: " + t.getMessage() + ")");
                    t.printStackTrace();
                }
                System.out.println("-ERROR- " + e.getClass().getName() + " in " + action + "(error message: " + e.getMessage() + ")");
                throw e;
            }
            uploadPolicy.displayDebug("uploadPolicy parameter = " + uploadPolicyStr, 1);
            if (usingDefaultUploadPolicy) {
                uploadPolicy.displayWarn("Unable to create the '" + uploadPolicyStr + "'. Using the DefaultUploadPolicy instead.");
            } else {
                uploadPolicy.displayDebug("uploadPolicy = " + uploadPolicy.getClass().getName(), 20);
            }
            uploadPolicy.displayParameterStatus();
        }
        return uploadPolicy;
    }

    private static void logDebug(String msg, int currentDebugLevel) {
        if (currentDebugLevel > 0) {
            System.out.println("[DEBUG] " + msg);
        }
    }
}

