# Host: 127.0.0.1  (Version: 5.6.17)
# Date: 2015-11-19 13:34:56
# Generator: MySQL-Front 5.3  (Build 4.214)

/*!40101 SET NAMES utf8 */;

#
# Structure for table "travel_banners"
#

DROP TABLE IF EXISTS `travel_banners`;
CREATE TABLE `travel_banners` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` enum('image','code') DEFAULT NULL,
  `target` enum('_blank','_self') DEFAULT NULL,
  `status` enum('T','F') DEFAULT 'T',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

#
# Data for table "travel_banners"
#

INSERT INTO `travel_banners` VALUES (1,'image','_blank','T');

#
# Structure for table "travel_comments"
#

DROP TABLE IF EXISTS `travel_comments`;
CREATE TABLE `travel_comments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `listing_id` int(10) unsigned NOT NULL,
  `title` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `rating` int(11) DEFAULT NULL,
  `comment` text,
  `created` datetime DEFAULT NULL,
  `status` enum('Confirmed','New') DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `listing_id` (`listing_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

#
# Data for table "travel_comments"
#

INSERT INTO `travel_comments` VALUES (1,9,'武汉的小吃是非常之多的','个斑马','zebra@wuhan.com',4,'武汉的小吃是非常之多的，并且大街小巷都有很多，热干面、面窝、豆皮、鸭脖子、鱼汁糊粉、烧梅、欢喜坨、发糕、锅贴饺......一定不要错过。 关于开销：武汉的物价不高，景点里也只有黄鹤楼和东湖收费，武汉的特产也主要是小吃，都是在街边的小店里几元钱就能吃到的，因此开销主要是取决于餐饮，购物，住宿的质量了。总体上开销是非常容易控制的。如果是正常消费，3天人均1000元左右很容易。','2015-11-17 11:34:04','Confirmed'),(2,10,'介绍点经验','傻狍子','pygargus@harbin.com',5,'哈尔滨作为东北三省的省会之一，自然也是要去的。冬天去看冰雕，夏季去避暑。两三天的时间也可以感受到一点哈尔滨的味道。圣索菲亚教堂，现在是一个建筑博物馆，外观很好看。里面也还好。门票不贵，有学生票。其实哈尔滨还有其他一些教堂，那些也可以去看看。中央大街，我个人不是很喜欢逛街，觉得街道都大同小异。我也不是很喜欢中央大街，但是建议还是去看，毕竟到了哈尔滨，在这还是可以看到一些不同的东西。太阳岛可以坐船去的，但是要备好干粮，上面除了一家很贵的肯德基就没什么了。里面有一个俄罗斯小镇，其实我觉得也不是很有看头，但是还是可以看到一点不同的东西。冬天去哈尔滨一定要注意防冻，而且冬季天黑很早，大概在下午四点左右。','2015-11-17 12:03:07','Confirmed'),(3,13,'蓟城幽州顺天府，大都京师北平城','Tom','tom@bj.com',5,'蓟城幽州顺天府，大都京师北平城。虽然你没有经历过这些历史年代，但你知道我要说的是哪里； 东来顺的涮肉全聚德的鸭，六必居的酱菜张一元的茶。虽然你觉得传统老字号已成为历史符号，但你知道我要说的是哪里； 卤煮火烧炸酱面，炒肝焦圈爆肚冯。虽然你未必一一尝过这些小吃，但你知道我要说的是哪里； 故宫天坛琉璃厂，北海后海潘家园。香山玉泉陶然亭，北大清华颐和园。王府井三里屯，八达岭五道营… …把这些名词串起来，得嘞您呐，您知道我要说的就是北京！','2015-11-17 13:51:30','Confirmed');

#
# Structure for table "travel_destinations"
#

DROP TABLE IF EXISTS `travel_destinations`;
CREATE TABLE `travel_destinations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `seo_url` varchar(100) DEFAULT NULL,
  `country_id` int(10) unsigned DEFAULT NULL,
  `image_original` varchar(255) DEFAULT NULL,
  `image_thumb` varchar(255) DEFAULT NULL,
  `on_home` tinyint(1) unsigned DEFAULT '0',
  `status` enum('T','F') DEFAULT 'T',
  PRIMARY KEY (`id`),
  UNIQUE KEY `seo_url` (`seo_url`),
  KEY `country_id` (`country_id`),
  KEY `on_home` (`on_home`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

#
# Data for table "travel_destinations"
#

INSERT INTO `travel_destinations` VALUES (1,'paris',284,'app/web/upload/destinations/o_c4ca4238a0b923820dcc509a6f75849b.jpg','app/web/upload/destinations/t_c4ca4238a0b923820dcc509a6f75849b.jpg',1,'T'),(2,'hongkong',282,'app/web/upload/destinations/o_c81e728d9d4c2f636f067f89cc14862c.png','app/web/upload/destinations/t_c81e728d9d4c2f636f067f89cc14862c.png',1,'T');

#
# Structure for table "travel_enquiries"
#

DROP TABLE IF EXISTS `travel_enquiries`;
CREATE TABLE `travel_enquiries` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `listing_id` int(10) unsigned NOT NULL,
  `date_from` date DEFAULT NULL,
  `date_to` date DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `notes` text,
  `created` datetime DEFAULT NULL,
  `status` enum('Confirmed','New') DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `listing_id` (`listing_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

#
# Data for table "travel_enquiries"
#

INSERT INTO `travel_enquiries` VALUES (2,9,'2015-11-18','2015-11-23','张益达','yider@iPartment.com','123456789','本人晕车。。','2015-11-17 11:40:04','Confirmed');

#
# Structure for table "travel_features"
#

DROP TABLE IF EXISTS `travel_features`;
CREATE TABLE `travel_features` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=69 DEFAULT CHARSET=utf8;

#
# Data for table "travel_features"
#

INSERT INTO `travel_features` VALUES (59,'T'),(60,'T'),(61,'T'),(62,'T'),(63,'T'),(64,'T'),(65,'T'),(66,'T'),(67,'T'),(68,'T');

#
# Structure for table "travel_fields"
#

DROP TABLE IF EXISTS `travel_fields`;
CREATE TABLE `travel_fields` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(255) DEFAULT NULL,
  `type` enum('backend','frontend','arrays') DEFAULT NULL,
  `label` varchar(255) DEFAULT NULL,
  `source` enum('script','plugin') DEFAULT 'script',
  `modified` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `key` (`key`)
) ENGINE=InnoDB AUTO_INCREMENT=2170 DEFAULT CHARSET=utf8;

#
# Data for table "travel_fields"
#

INSERT INTO `travel_fields` VALUES (1,'addLocale','backend','Add language','script','2015-11-11 05:07:32'),(2,'adminForgot','backend','Forgot password','script','2015-11-11 05:07:32'),(3,'adminLogin','backend','Admin Login','script','2015-11-11 05:07:32'),(4,'backend','backend','Backend titles','script','2015-11-16 05:26:18'),(5,'btnAdd','backend','Button Add','script','2015-11-11 05:07:32'),(6,'btnAddPeriod','backend','Button / Add Period & Price','script','2015-11-16 03:38:43'),(7,'btnBack','backend','Button Back','script','2015-11-11 05:07:32'),(9,'btnCancel','backend','Button Cancel','script','2015-11-11 05:07:32'),(10,'btnContinue','backend','Button Continue','script','2015-11-11 05:07:32'),(11,'btnDelete','backend','Button Delete','script','2015-11-11 05:07:32'),(12,'btnGoogleMapsApi','backend','Button / Google Maps API','script','2015-11-16 03:38:43'),(13,'btnLogin','backend','Login','script','2015-11-11 05:07:32'),(14,'btnReset','backend','Reset','script','2015-11-11 05:07:32'),(15,'btnSave','backend','Save','script','2015-11-11 05:07:32'),(16,'btnSearch','backend','Search','script','2015-11-11 05:07:32'),(17,'btnSend','backend','Button Send','script','2015-11-11 05:09:11'),(18,'btnUpdate','backend','Update','script','2015-11-17 11:41:36'),(19,'created','backend','Created','script','2015-11-11 05:09:11'),(20,'email','backend','E-Mail','script',NULL),(21,'emailForgotBody','backend','Email / Forgot Body','script','2015-11-11 05:09:11'),(22,'emailForgotSubject','backend','Email / Forgot Subject','script','2015-11-11 05:09:11'),(23,'frontend','backend','Front-end titles','script','2015-11-16 05:26:08'),(62,'gridActionTitle','backend','Grid / Action Title','script','2015-11-11 09:32:47'),(63,'gridBtnCancel','backend','Grid / Button Cancel','script','2015-11-11 05:09:11'),(64,'gridBtnDelete','backend','Grid / Button Delete','script','2015-11-11 05:09:11'),(65,'gridBtnOk','backend','Grid / Button OK','script','2015-11-11 05:09:11'),(66,'gridChooseAction','backend','Grid / Choose Action','script','2015-11-11 09:32:47'),(67,'gridConfirmationTitle','backend','Grid / Confirmation Title','script','2015-11-11 05:09:11'),(68,'gridDeleteConfirmation','backend','Grid / Delete confirmation','script','2015-11-11 05:09:11'),(69,'gridEmptyResult','backend','Grid / Empty resultset','script','2015-11-11 05:09:11'),(70,'gridGotoPage','backend','Grid / Go to page','script','2015-11-11 05:13:00'),(71,'gridItemsPerPage','backend','Grid / Items per page','script','2015-11-11 05:13:00'),(72,'gridNext','backend','Grid / Next','script','2015-11-11 05:13:00'),(73,'gridNextPage','backend','Grid / Next page','script','2015-11-11 05:13:00'),(74,'gridPrev','backend','Grid / Prev','script','2015-11-11 05:13:00'),(75,'gridPrevPage','backend','Grid / Prev page','script','2015-11-11 05:13:00'),(76,'gridTotalItems','backend','Grid / Total items','script','2015-11-11 05:13:00'),(77,'infoEmailBody','backend','Infobox / Email body','script','2015-11-16 03:49:51'),(78,'infoEmailTitle','backend','Infobox / Email title','script','2015-11-11 05:13:00'),(79,'infoFeaturesBody','backend','Infobox / Features Body','script','2015-11-16 03:49:51'),(80,'infoFeaturesCreateBody','backend','Infobox / Add Feature Body','script','2015-11-16 03:49:51'),(81,'infoFeaturesCreateTitle','backend','Infobox / Add Feature Title','script','2015-11-16 03:49:51'),(82,'infoFeaturesTitle','backend','Infobox / Features Title','script','2015-11-16 03:49:51'),(83,'infoFeaturesUpdateBody','backend','Infobox / Update Feature Body','script','2015-11-16 03:49:51'),(84,'infoFeaturesUpdateTitle','backend','Infobox / Update Feature Title','script','2015-11-16 03:49:51'),(85,'infoListingAddressBody','backend','Infobox / Listing Address Body','script','2015-11-16 04:02:12'),(86,'infoListingAddressTitle','backend','Infobox / Listing Address Title','script','2015-11-11 09:34:13'),(87,'infoListingBookingsBody','backend','Infobox / Listing Bookings Body','script',NULL),(88,'infoListingBookingsTitle','backend','Infobox / Listing Bookings Title','script',NULL),(89,'infoListingContactBody','backend','Infobox / Listing Contact Body','script',NULL),(90,'infoListingContactTitle','backend','Infobox / Listing Contact Title','script',NULL),(91,'infoListingExtendBody','backend','Infobox / Extend exp.date Body','script',NULL),(92,'infoListingExtendTitle','backend','Infobox / Extend exp.date Title','script',NULL),(93,'infoListingPricesBody','backend','Infobox / Listing Prices Body','script','2015-11-16 04:02:12'),(94,'infoListingPricesTitle','backend','Infobox / Listing Prices Title','script','2015-11-16 04:02:12'),(95,'infoLocalesArraysBody','backend','Locale / Languages Array Body','script',NULL),(96,'infoLocalesArraysTitle','backend','Locale / Languages Array Title','script',NULL),(97,'infoLocalesBackendBody','backend','Infobox / Locales Backend Body','script',NULL),(98,'infoLocalesBackendTitle','backend','Infobox / Locales Backend Title','script',NULL),(99,'infoLocalesBody','backend','Infobox / Locales Body','script',NULL),(100,'infoLocalesFrontendBody','backend','Infobox / Locales Frontend Body','script',NULL),(101,'infoLocalesFrontendTitle','backend','Infobox / Locales Frontend Title','script',NULL),(102,'infoLocalesTitle','backend','Infobox / Locales Title','script',NULL),(103,'infoSubmissionsBody','backend','Infobox / Submission Body','script','2015-11-16 04:12:44'),(104,'infoSubmissionsTitle','backend','Infobox / Submission Title','script','2015-11-16 04:12:44'),(105,'infoTypesBody','backend','Infobox / Types Body','script','2015-11-16 04:12:44'),(106,'infoTypesCreateBody','backend','Infobox / Add Type Body','script','2015-11-16 04:12:44'),(107,'infoTypesCreateTitle','backend','Infobox / Add Type Title','script','2015-11-16 04:12:44'),(108,'infoTypesTitle','backend','Infobox / Property Types','script','2015-11-16 04:12:44'),(109,'infoTypesUpdateBody','backend','Infobox / Update Type Body','script','2015-11-16 04:12:44'),(110,'infoTypesUpdateTitle','backend','Infobox / Update Type Title','script','2015-11-16 04:12:44'),(111,'lblAddedOn','backend','Label / Added on','script','2015-11-16 04:46:15'),(112,'lblAddEnquiry','backend','Label / Add enquiry','script','2015-11-16 04:12:44'),(113,'lblAddUser','backend','Add user','script','2015-11-11 09:34:40'),(114,'lblAutumn','backend','Label / Autumn','script','2015-11-11 09:34:40'),(117,'lblChoose','backend','Choose','script','2015-11-11 09:35:30'),(118,'lblChooseOwner','backend','Label / Choose Owner','script','2015-11-17 11:03:58'),(119,'lblChoosePackage','backend','Label / Choose package','script','2015-11-16 04:15:11'),(120,'lblCommentComment','backend','Label / Comment','script','2015-11-11 09:35:30'),(121,'lblCommentEmail','backend','Label / Email','script',NULL),(122,'lblCommentName','backend','Label / Name','script','2015-11-17 12:12:51'),(123,'lblCommentPackage','backend','Label / Package','script','2015-11-16 04:14:39'),(124,'lblCommentStatus','backend','Label / Status','script','2015-11-11 09:35:30'),(125,'lblCommentTitle','backend','Label / Title','script','2015-11-11 09:35:30'),(126,'lblContactEmail','backend','Label / Contact email','script','2015-11-16 04:14:27'),(127,'lblContactFax','backend','Label / Contact fax','script','2015-11-16 04:14:27'),(128,'lblContactFirstName','backend','Label / Contact first name','script','2015-11-16 04:14:27'),(129,'lblContactLastName','backend','Label / Contact last name','script','2015-11-16 04:14:27'),(130,'lblContactMobile','backend','Label / Contact mobile phone','script','2015-11-16 04:14:27'),(131,'lblContactPhone','backend','Label / Contact phone','script','2015-11-16 04:14:27'),(132,'lblContactTitle','backend','Label / Contact title','script','2015-11-16 04:17:48'),(133,'lblContactWebsite','backend','Label / Contact website','script','2015-11-11 09:39:58'),(134,'lblCountry','backend','Label / Country','script','2015-11-18 12:51:38'),(135,'lblDays','backend','Days','script','2015-11-18 03:56:13'),(136,'lblDelete','backend','Delete','script','2015-11-11 09:39:58'),(137,'lblEmailBody','backend','Label / Email body','script','2015-11-11 09:39:58'),(138,'lblEmailSubject','backend','Label / Subject','script','2015-11-11 09:39:58'),(139,'lblEnquiries','backend','Label / Enquiries','script','2015-11-16 04:17:48'),(140,'lblEnquiryEmail','backend','Label / Email','script',NULL),(141,'lblEnquiryFrom','backend','Label / From','script','2015-11-17 13:52:33'),(142,'lblEnquiryName','backend','Label / Name','script','2015-11-11 09:39:58'),(143,'lblEnquiryNotes','backend','Label / Notes','script','2015-11-17 13:52:53'),(144,'lblEnquiryPackage','backend','Label / Package','script','2015-11-16 04:17:48'),(145,'lblEnquiryPhone','backend','Label / Phone','script','2015-11-11 09:39:58'),(146,'lblEnquiryStatus','backend','Label / Status','script','2015-11-11 09:39:58'),(147,'lblEnquiryTo','backend','Label / To','script','2015-11-17 13:52:39'),(148,'lblError','backend','Error','script','2015-11-11 09:40:29'),(149,'lblExport','backend','Export','script','2015-11-11 09:40:29'),(150,'lblFeature','backend','Label / Feature','script','2015-11-16 04:19:29'),(151,'lblFlightIncluded','backend','Label / Flight included','script','2015-11-16 04:19:29'),(152,'lblForgot','backend','Forgot password','script','2015-11-11 09:40:29'),(153,'lblInstallFeatured','backend','Label / Featured packages','script','2015-11-16 04:19:29'),(154,'lblInstallFeat_1','backend','Install / Feature step 1','script',NULL),(155,'lblInstallFeat_2','backend','Install / Feature step 2','script',NULL),(156,'lblInstallFeat_3','backend','Install / Feature step 3','script',NULL),(157,'lblInstallListing','backend','Install / Listing','script',NULL),(158,'lblInstallPhp1Title','backend','Listing install infobox','script',NULL),(159,'lblInstallPhp1_1','backend','Install / Step 1','script',NULL),(160,'lblInstallPhp1_2','backend','Install / Step 2','script',NULL),(161,'lblInstallPhp1_2a','backend','Install / Step 2a','script',NULL),(162,'lblInstallPhp1_3','backend','Install / Step 3','script',NULL),(163,'lblInstallPhp3Title','backend','Label / Install feature info','script',NULL),(164,'lblIp','backend','IP address','script','2015-11-11 09:41:05'),(165,'lblIsActive','backend','Is Active','script','2015-11-16 04:24:05'),(166,'lblKeyword','backend','Label / Keyword','script','2015-11-16 04:24:05'),(167,'lblLastUpdateOn','backend','Label / Last update on','script','2015-11-16 04:24:05'),(168,'lblListingAddDesc','backend','Label / Add packace description','script','2015-11-16 04:24:05'),(169,'lblListingAddress','backend','Label / Address','script','2015-11-11 09:41:05'),(170,'lblListingAddTitle','backend','Label / Add new package','script','2015-11-16 04:24:05'),(171,'lblListingCheckin','backend','Label / Check-in','script','2015-11-17 11:52:01'),(172,'lblListingCheckout','backend','Label / Check-out','script','2015-11-17 11:52:10'),(173,'lblListingCity','backend','Label / City','script','2015-11-11 09:41:05'),(174,'lblListingCommentNotifyEmail','backend','Label / New comment notification','script','2015-11-11 09:41:05'),(175,'lblListingCommentNotifyTokens','backend','Tokens / new comment tokens','script','2015-11-16 04:24:36'),(176,'lblListingConfirmEmail','backend','Listing / Confirm email','script','2015-11-16 04:24:05'),(177,'lblListingConfirmTokens','backend','Listing / Confirm Tokens','script','2015-11-16 04:33:13'),(178,'lblListingCountry','backend','Label / Country','script','2015-11-18 12:51:38'),(179,'lblListingDetails','backend','Label / Details','script','2015-11-11 09:41:56'),(180,'lblListingEmail','backend','Listing / Email','script','2015-11-11 09:41:56'),(181,'lblListingExpire','backend','Label / Expire date','script','2015-11-11 09:41:56'),(182,'lblListingExpireTip','backend','Label / Expire tip','script','2015-11-17 09:12:15'),(183,'lblListingExtend','backend','Label / Extend expire date','script',NULL),(184,'lblListingFax','backend','Listing / Fax','script','2015-11-11 09:41:56'),(185,'lblListingFeatured','backend','Label / Is featured','script','2015-11-16 04:33:13'),(186,'lblListingFeatures','backend','Label / Features','script','2015-11-16 04:33:13'),(187,'lblListingFees','backend','Label / Fees','script','2015-11-17 11:09:49'),(188,'lblListingFirstName','backend','Listing / First name','script','2015-11-11 09:41:56'),(189,'lblListingFlight','backend','Label / Flight','script','2015-11-16 04:33:13'),(190,'lblListingFlightNotes','backend','Label / Flight notes','script','2015-11-16 04:33:13'),(191,'lblListingGMapNote','backend','Label / Gmap notes','script','2015-11-16 04:33:13'),(192,'lblListingInBoundArrives','backend','Label / Inbound Arrives','script','2015-11-16 04:36:39'),(193,'lblListingInBoundDeparts','backend','Label / Inbound Departs','script','2015-11-16 04:36:39'),(194,'lblListingInboundFlight','backend','Label / Inbound flight','script','2015-11-16 04:36:39'),(195,'lblListingInboundFrom','backend','Label / Inbound From','script','2015-11-16 04:36:39'),(196,'lblListingInBoundTo','backend','Label / Inbound To','script','2015-11-16 04:36:39'),(197,'lblListingLastName','backend','Listing / Last name','script','2015-11-11 09:43:11'),(198,'lblListingLat','backend','Label / Latitude','script','2015-11-11 09:43:11'),(199,'lblListingLng','backend','Label / Longitude','script','2015-11-11 09:43:11'),(200,'lblListingMetaDesc','backend','Listing / Meta description','script','2015-11-11 09:43:11'),(201,'lblListingMetaKeywords','backend','Listing / Meta keywords','script','2015-11-11 09:43:11'),(202,'lblListingMetaTitle','backend','Listing / Meta title','script','2015-11-11 09:43:11'),(203,'lblListingMobile','backend','Listing / Mobile phone','script','2015-11-11 09:43:11'),(204,'lblListingOutboundArrives','backend','Label / Outbound Arrives','script','2015-11-16 04:36:39'),(205,'lblListingOutboundDeparts','backend','Label / Outbound Departs','script','2015-11-16 04:36:39'),(206,'lblListingOutboundFlight','backend','Label / Outbound flight','script','2015-11-16 04:36:39'),(207,'lblListingOutboundFrom','backend','Label / From','script','2015-11-16 04:39:27'),(208,'lblListingOutboundTo','backend','Label / Outbound To','script','2015-11-16 04:39:27'),(209,'lblListingOwner','backend','Label / Owner','script','2015-11-17 11:29:48'),(210,'lblListingPackage','backend','Label / Package','script','2015-11-16 04:39:27'),(211,'lblListingPets','backend','Label / Pets','script','2015-11-17 11:58:58'),(212,'lblListingPhone','backend','Listing / Phone','script','2015-11-11 09:43:38'),(213,'lblListingPhotos','backend','Label / Photos','script','2015-11-11 09:43:38'),(214,'lblListingPolicies','backend','Label / Policies','script','2015-11-17 11:10:46'),(215,'lblListingPrice','backend','Label / Price','script','2015-11-16 04:40:18'),(216,'lblListingPriceFrom','backend','Listing / Price from','script','2015-11-16 04:39:27'),(217,'lblListingPriceNotFound','backend','Label / Price not found','script','2015-11-16 04:39:27'),(218,'lblListingPrices','backend','Label / Prices','script','2015-11-16 04:40:18'),(219,'lblListingPriceTitle','backend','Listing / Price title','script','2015-11-16 04:40:18'),(220,'lblListingPriceTo','backend','Listing / Price to','script','2015-11-16 04:39:27'),(221,'lblListingPriceType','backend','Label / Price type','script','2015-11-16 04:39:27'),(222,'lblListingPublishPeriod','backend','Listing / Publish period','script','2015-11-16 04:43:39'),(223,'lblListingRefid','backend','Label / Reference ID','script','2015-11-16 04:43:39'),(224,'lblListingRegisterNotifyTokens','backend','label / Register tokens','script','2015-11-16 04:43:39'),(225,'lblListingRegistrationNotifyEmail','backend','Label / New owner account notification','script','2015-11-16 04:43:39'),(226,'lblListingSeo','backend','Listing / SEO','script',NULL),(227,'lblListingState','backend','Label / State','script','2015-11-11 09:44:29'),(228,'lblListingStatus','backend','Label / Status','script','2015-11-17 09:09:54'),(229,'lblListingStatusTip','backend','Label / Status tip','script','2015-11-17 09:10:55'),(230,'lblListingSummary','backend','Label / Summary','script','2015-11-16 04:43:39'),(231,'lblListingTerms','backend','Label / Terms','script','2015-11-17 11:30:04'),(232,'lblListingTitle','backend','Listing / Title','script','2015-11-11 09:44:29'),(233,'lblListingUrl','backend','Listing / Website','script','2015-11-11 09:44:29'),(234,'lblListingZip','backend','Label / Zip','script','2015-11-11 09:44:29'),(235,'lblName','backend','Name','script','2015-11-11 09:44:29'),(236,'lblNights','backend','Label / Nights','script','2015-11-16 04:43:39'),(237,'lblNo','backend','No','script','2015-11-16 04:44:57'),(238,'lblOption','backend','Option','script','2015-11-11 09:45:08'),(239,'lblOptionList','backend','Option list','script','2015-11-16 04:44:57'),(240,'lblOwner','backend','Label / Owner','script','2015-11-16 04:44:57'),(241,'lblOwnerShow','backend','Label / Show owner contact','script','2015-11-16 04:44:57'),(242,'lblPackageDescription','backend','Label / Package description','script','2015-11-16 04:44:58'),(243,'lblPackageTitle','backend','Label / Package title','script','2015-11-16 04:44:58'),(244,'lblPhone','backend','Label / Phone','script','2015-11-11 09:45:08'),(245,'lblRating','backend','Label / Rating','script','2015-11-16 04:44:58'),(246,'lblRole','backend','Role','script','2015-11-11 09:45:08'),(247,'lblSeasonAvailability','backend','Label / Season availability','script','2015-11-16 04:44:58'),(248,'lblShowOnMap','backend','Label / Show on map','script','2015-11-11 09:45:08'),(249,'lblSpring','backend','Label / Spring','script','2015-11-16 04:44:58'),(250,'lblStatus','backend','Status','script','2015-11-11 09:45:08'),(251,'lblSummer','backend','Label / Summer','script','2015-11-11 09:45:08'),(252,'lblTerms','backend','Label / Booking terms','script','2015-11-17 11:09:31'),(253,'lblType','backend','Type','script','2015-11-11 09:46:01'),(254,'lblUpdateComment','backend','Label / Update comment','script','2015-11-17 11:41:36'),(255,'lblUpdateEnquiry','backend','Label / Update enquiry','script','2015-11-17 11:41:16'),(256,'lblUpdateUser','backend','Update user','script','2015-11-17 11:41:16'),(257,'lblUserCreated','backend','User / Registration Date & Time','script','2015-11-11 09:46:01'),(258,'lblValue','backend','Value','script','2015-11-18 20:38:08'),(259,'lblViews','backend','Label / Views','script','2015-11-16 04:45:49'),(260,'lblWinter','backend','Label / Winter','script','2015-11-11 09:46:01'),(261,'lblYes','backend','Yes','script','2015-11-11 09:46:01'),(262,'listing_payment_free','backend','Listing / FREE','script','2015-11-11 09:46:01'),(263,'listing_payment_period','backend','Listing / Period','script','2015-11-11 09:46:01'),(264,'listing_payment_price','backend','Listing / Price','script','2015-11-11 09:46:01'),(265,'listing_payment_renew_free','backend','Listing / Extend your period for FREE','script',NULL),(266,'listing_payment_renew_paypal','backend','Listing / Buy now','script','2015-11-11 09:46:01'),(267,'lnkBack','backend','Link Back','script','2015-11-11 09:46:41'),(268,'localeArrays','backend','Locale / Arrays titles','script',NULL),(269,'locales','backend','Languages','script','2015-11-11 09:46:41'),(270,'locale_flag','backend','Locale / Flag','script','2015-11-11 09:46:41'),(271,'locale_is_default','backend','Locale / Is default','script','2015-11-11 09:46:41'),(272,'locale_order','backend','Locale / Order','script','2015-11-11 09:46:41'),(273,'locale_title','backend','Locale / Title','script','2015-11-11 09:46:41'),(274,'menuAddPackage','backend','Menu / Add package','script','2015-11-16 04:48:30'),(276,'menuComments','backend','Menu / Comments','script','2015-11-11 09:46:42'),(277,'menuCountries','backend','Menu / Countries','script','2015-11-18 12:51:38'),(278,'menuDashboard','backend','Menu Dashboard','script','2015-11-11 09:46:42'),(279,'menuEmails','backend','Menu / Emails','script','2015-11-11 09:46:42'),(280,'menuEnquiries','backend','Menu / Enquiries','script','2015-11-16 04:48:30'),(281,'menuFeatures','backend','Menu / Features','script','2015-11-16 04:48:30'),(282,'menuInstall','backend','Menus / Install','script','2015-11-11 09:46:42'),(283,'menuLang','backend','Menu Multi lang','script','2015-11-11 09:47:19'),(284,'menuLocales','backend','Menu Languages','script','2015-11-11 09:47:19'),(285,'menuLogout','backend','Menu Logout','script','2015-11-11 09:47:19'),(286,'menuOptions','backend','Menu Options','script','2015-11-11 09:47:19'),(287,'menuPackages','backend','Menu / Packages','script','2015-11-16 04:50:12'),(288,'menuPlugins','backend','Menu Plugins','script','2015-11-11 09:47:19'),(289,'menuPreview','backend','Menus / Preview','script','2015-11-11 09:47:19'),(290,'menuProfile','backend','Menu Profile','script',NULL),(291,'menuSubmissions','backend','Menus / Submissions','script','2015-11-16 04:50:12'),(292,'menuTypes','backend','Menu / Types','script','2015-11-17 09:07:19'),(293,'menuUsers','backend','Menu Users','script','2015-11-11 09:47:19'),(294,'multilangTooltip','backend','MultiLang / Tooltip','script','2015-11-16 04:50:12'),(295,'opt_o_allow_add_package','backend','Label / Allow user to add package','script','2015-11-16 04:50:12'),(296,'opt_o_allow_add_property','backend','Options / Allow add property','script','2015-11-16 04:50:12'),(297,'opt_o_comment_and_rating','backend','Options / Number of comments and average rating','script','2015-11-16 04:50:12'),(298,'opt_o_comment_default_status','backend','Options / Show visitors\' comments','script','2015-11-18 20:37:43'),(299,'opt_o_currency','backend','Options / Currency','script','2015-11-16 04:54:38'),(300,'opt_o_date_format','backend','Options / Date format','script','2015-11-16 04:54:38'),(301,'opt_o_email_address','backend','Options / Email address','script','2015-11-16 04:54:38'),(302,'opt_o_featured_properties','backend','Options / Featured properties','script','2015-11-16 04:54:38'),(303,'opt_o_is_active_owner','backend','Options / User account confirmed by default','script','2015-11-16 04:54:38'),(304,'opt_o_items_per_page','backend','Options / Items per page','script','2015-11-16 04:54:38'),(307,'opt_o_owner_is_active','backend','Label / Owner account status','script','2015-11-16 04:54:38'),(308,'opt_o_paypal_address','backend','Options / Paypal address','script','2015-11-16 04:54:38'),(309,'opt_o_send_email','backend','opt_o_send_email','script','2015-11-16 04:54:38'),(310,'opt_o_smtp_host','backend','opt_o_smtp_host','script','2015-11-16 04:54:38'),(311,'opt_o_smtp_pass','backend','opt_o_smtp_pass','script','2015-11-16 04:54:38'),(312,'opt_o_smtp_port','backend','opt_o_smtp_port','script','2015-11-16 04:54:38'),(313,'opt_o_smtp_user','backend','opt_o_smtp_user','script','2015-11-16 04:54:38'),(314,'opt_o_timezone','backend','Options / Timezone','script','2015-11-16 04:54:38'),(315,'opt_o_time_format','backend','Options / Time format','script','2015-11-16 05:03:44'),(316,'opt_o_week_start','backend','Options / First day of the week','script','2015-11-16 05:03:44'),(317,'opt_period_note','backend','Submissions / Period note','script','2015-11-16 05:03:44'),(318,'pass','backend','Password','script','2015-11-16 05:03:44'),(341,'revert_status','backend','Revert status','script',NULL),(342,'url','backend','URL','script',NULL),(343,'user','backend','Username','script','2015-11-16 05:03:44'),(344,'vk_active','backend','vk_active','script','2015-11-16 05:06:00'),(345,'vk_address_not_found','backend','vk_address_not_found','script','2015-11-16 05:03:44'),(346,'vk_confirm_selected','backend','Label / Confirm selected','script','2015-11-16 05:03:44'),(347,'vk_date_from','backend','vk_date_from','script','2015-11-16 05:03:44'),(348,'vk_date_submitted','backend','Label / Date submitted','script','2015-11-16 05:03:44'),(349,'vk_date_to','backend','vk_date_to','script','2015-11-16 05:03:44'),(350,'vk_delete_confirmation','backend','Label / Delete confirmation','script','2015-11-16 05:03:44'),(351,'vk_delete_selected','backend','vk_delete_selected','script','2015-11-16 05:03:44'),(352,'vk_dismiss_selected','backend','Label / Dismiss selected','script','2015-11-16 05:05:51'),(353,'vk_email_invalid','backend','vk_email_invalid','script','2015-11-16 05:05:51'),(354,'vk_email_taken','backend','Users / Email already taken','script','2015-11-16 05:05:51'),(355,'vk_expire','backend','Listings / Expire','script','2015-11-16 05:05:51'),(356,'vk_export_selected','backend','vk_export_selected','script','2015-11-16 05:05:51'),(357,'vk_exp_date','backend','Listings / Exp.date','script','2015-11-16 05:05:51'),(358,'vk_exp_date_plus_30','backend','Listings / Expiration date +30 days','script','2015-11-16 05:05:51'),(359,'vk_extend_exp_date','backend','Listings / Extend expiration date','script',NULL),(360,'vk_field_required','backend','vk_field_required','script','2015-11-16 05:06:35'),(361,'vk_image','backend','vk_image','script','2015-11-16 05:05:51'),(362,'vk_inactive','backend','vk_inactive','script','2015-11-16 05:05:51'),(363,'vk_listing','backend','vk_listing','script','2015-11-16 05:05:51'),(364,'vk_make_all_active','backend','Label / Make all active','script','2015-11-16 05:05:51'),(365,'vk_make_all_inactive','backend','Label / Make all inactive','script','2015-11-16 05:05:51'),(366,'vk_make_selected_active','backend','Label / Make selected active','script','2015-11-16 05:05:51'),(367,'vk_make_selected_inactive','backend','Label / Make selected inactive','script',NULL),(368,'vk_name','backend','Label / Name','script',NULL),(369,'vk_not_published','backend','vk_not_published','script',NULL),(370,'vk_owner','backend','Listing / Owner','script','2015-11-17 13:34:56'),(371,'vk_publish','backend','Label / Publish','script',NULL),(372,'vk_published','backend','vk_published','script',NULL),(373,'vk_ref_id','backend','vk_ref_id','script',NULL),(374,'vk_revert_status','backend','vk_revert_status','script',NULL),(375,'vk_title','backend','Label / Title','script',NULL),(376,'vk_view_enquiries','backend','Listing / View enquiries','script',NULL),(377,'font_label_of','frontend','Label / of','script',NULL),(378,'front_button_login','frontend','Button / Login','script',NULL),(379,'front_button_register','frontend','Button / Register','script',NULL),(380,'front_label_address','frontend','Label / Address','script',NULL),(381,'front_label_arrival','frontend','Label / Arrival','script','2015-11-17 12:06:18'),(382,'front_label_availability','frontend','Label / Availability','script',NULL),(383,'front_label_available','frontend','Label / Available','script','2015-11-17 09:02:54'),(384,'front_label_avg_users_rating','frontend','Label / Average Users Rating','script','2015-11-16 05:11:05'),(385,'front_label_booking_terms','frontend','Label / Booking terms','script','2015-11-17 11:16:45'),(386,'front_label_by','frontend','Label / by','script','2015-11-17 11:43:12'),(387,'front_label_captcha','frontend','Label / Captcha','script','2015-11-16 05:11:05'),(388,'front_label_checkin','frontend','Label / Check-in','script','2015-11-17 11:52:01'),(389,'front_label_checkout','frontend','Label / Check-out','script','2015-11-17 11:52:10'),(390,'front_label_comment','frontend','Label / Comment','script','2015-11-16 05:11:05'),(391,'front_label_comments','frontend','Label / Comments','script','2015-11-16 05:11:05'),(392,'front_label_departure','frontend','Label / Departure','script','2015-11-16 05:11:05'),(393,'front_label_description','frontend','Label / Description','script','2015-11-17 12:15:36'),(394,'front_label_details','frontend','Label / View details','script','2015-11-16 05:11:05'),(395,'front_label_disabled_package','frontend','Label / Disabled package','script','2015-11-16 05:11:05'),(396,'front_label_duration','frontend','Lable / Duration','script','2015-11-16 05:11:05'),(397,'front_label_email','frontend','Label / Email','script',NULL),(398,'front_label_enquiry','frontend','Label / Enquiry','script','2015-11-16 05:11:56'),(399,'front_label_fax','frontend','Label / Fax','script','2015-11-16 05:11:56'),(400,'front_label_features','frontend','Label / Amenities','script','2015-11-17 11:16:14'),(401,'front_label_fees','frontend','Label / Fees','script','2015-11-17 11:17:26'),(402,'front_label_filter_by_location','frontend','Label / Filter by location','script','2015-11-16 05:11:56'),(403,'front_label_filter_by_price','frontend','Label / Filter by price','script','2015-11-16 05:11:56'),(404,'front_label_filter_by_rating','frontend','Label / Filter by rating','script','2015-11-16 05:11:56'),(405,'front_label_filter_by_season','frontend','Label / Filter by season','script','2015-11-16 05:11:56'),(406,'front_label_filter_by_type','frontend','Label / Filter by type','script','2015-11-16 05:11:56'),(407,'front_label_flight_details','frontend','Label / Flight details','script','2015-11-16 05:11:56'),(408,'front_label_flight_included','frontend','Label / Flight included','script','2015-11-16 05:11:56'),(409,'front_label_flight_info','frontend','Label / Flight information','script','2015-11-16 05:11:56'),(410,'front_label_from','frontend','Label / From','script','2015-11-17 11:15:29'),(411,'front_label_hour','frontend','Label / h','script',NULL),(412,'front_label_inbound_arrive','frontend','Label / Inbound arrive','script','2015-11-16 05:13:16'),(413,'front_label_inbound_depart','frontend','Label / Inbound depart','script','2015-11-16 05:13:16'),(414,'front_label_inbound_flight','frontend','Label / Inbound Flight','script','2015-11-16 05:13:16'),(415,'front_label_inbound_from','frontend','Label / Inbound from','script','2015-11-16 05:13:16'),(416,'front_label_inbound_to','frontend','Label / Inbound to','script','2015-11-16 05:13:16'),(417,'front_label_location','frontend','Label / Location','script','2015-11-16 05:13:16'),(418,'front_label_minute','frontend','Label / m','script',NULL),(419,'front_label_mobile','frontend','Label / Mobile','script','2015-11-16 05:13:16'),(420,'front_label_name','frontend','Label / Name','script','2015-11-17 11:18:05'),(421,'front_label_nights','frontend','Label / Nights','script','2015-11-16 05:13:16'),(422,'front_label_notes','frontend','Label / Notes','script','2015-11-16 05:13:16'),(423,'front_label_not_found','frontend','Label / No package found.','script','2015-11-16 05:13:16'),(424,'front_label_no_comment','frontend','Label / No comment','script','2015-11-16 05:13:16'),(425,'front_label_of','frontend','Label / of','script',NULL),(426,'front_label_outbound_arrive','frontend','Outbound arrive','script','2015-11-16 05:13:16'),(427,'front_label_outbound_depart','frontend','Label / Outbound depart','script','2015-11-16 05:14:18'),(428,'front_label_outbound_flight','frontend','Label / Outbound Flight','script','2015-11-16 05:14:18'),(429,'front_label_outbound_from','frontend','Label / Outbound from','script','2015-11-16 05:14:18'),(430,'front_label_outbound_to','frontend','Label / Outbound to','script','2015-11-16 05:14:18'),(431,'front_label_owner','frontend','Label / Owner contact','script','2015-11-16 05:14:18'),(432,'front_label_package','frontend','Label / Package','script','2015-11-16 05:14:18'),(433,'front_label_password','frontend','Label / Password','script','2015-11-16 05:14:18'),(434,'front_label_per_person','frontend','Label / per person','script','2015-11-17 11:25:12'),(435,'front_label_pets','frontend','Label / Pets','script','2015-11-17 11:58:58'),(436,'front_label_phone','frontend','Label / Phone','script','2015-11-16 05:14:18'),(437,'front_label_policies','frontend','Label / Policies','script','2015-11-17 11:17:10'),(438,'front_label_policies_fees','frontend','Label / Policies & Fees','script','2015-11-17 11:17:52'),(439,'front_label_post_review','frontend','Label / Post Review','script','2015-11-17 11:20:30'),(440,'front_label_price','frontend','Label / Price','script','2015-11-16 05:14:18'),(441,'front_label_prices','frontend','Label / Availability & Prices','script','2015-11-17 11:15:59'),(442,'front_label_rating','frontend','Labe / Rating','script','2015-11-16 05:15:30'),(443,'front_label_retype_password','frontend','Label / Re-type password','script','2015-11-16 05:15:30'),(444,'front_label_send_enquiry','frontend','Label / Send Enquiry','script','2015-11-16 05:15:30'),(445,'front_label_send_request','frontend','Label / Send request','script','2015-11-17 11:39:56'),(446,'front_label_star','frontend','Label / star','script','2015-11-16 05:15:30'),(447,'front_label_stars','frontend','Label / stars','script','2015-11-16 05:15:30'),(448,'front_label_title','frontend','Label / Title','script','2015-11-16 05:15:30'),(449,'front_label_to','frontend','Label / To','script','2015-11-17 11:15:42'),(450,'front_label_total_duration','frontend','Label / Total Duration','script','2015-11-16 05:15:30'),(451,'front_label_users_rating','frontend','Label / Users rating','script','2015-11-16 05:15:30'),(452,'front_label_website','frontend','Label / Website','script','2015-11-16 05:15:30'),(453,'front_lable_stars','frontend','Label / Stars','script','2015-11-16 05:15:30'),(454,'front_link_back','frontend','Link / Back','script','2015-11-16 05:15:30'),(455,'front_link_clear_filter','frontend','Link / Clear filter','script','2015-11-16 05:15:30'),(456,'front_menu_login','frontend','Menu / Login','script','2015-11-16 05:15:30'),(457,'front_menu_register','frontend','Menu / Register','script','2015-11-16 05:16:18'),(458,'front_paging_next','frontend','Label / Next','script','2015-11-16 05:16:18'),(459,'front_paging_previous','frontend','Label / Prev','script','2015-11-16 05:16:18'),(460,'comment_statuses_ARRAY_Confirmed','arrays','comment_statuses_ARRAY_Confirmed','script','2015-11-17 11:36:36'),(461,'comment_statuses_ARRAY_New','arrays','comment_statuses_ARRAY_New','script','2015-11-17 11:36:23'),(462,'days_ARRAY_0','arrays','days_ARRAY_0','script','2015-11-16 05:16:18'),(463,'days_ARRAY_1','arrays','days_ARRAY_1','script','2015-11-16 05:16:18'),(464,'days_ARRAY_2','arrays','days_ARRAY_2','script','2015-11-16 05:16:18'),(465,'days_ARRAY_3','arrays','days_ARRAY_3','script','2015-11-16 05:16:18'),(466,'days_ARRAY_4','arrays','days_ARRAY_4','script','2015-11-16 05:16:18'),(467,'days_ARRAY_5','arrays','days_ARRAY_5','script','2015-11-16 05:16:18'),(468,'days_ARRAY_6','arrays','days_ARRAY_6','script','2015-11-16 05:16:18'),(469,'day_names_ARRAY_0','arrays','day_names_ARRAY_0','script',NULL),(470,'day_names_ARRAY_1','arrays','day_names_ARRAY_1','script',NULL),(471,'day_names_ARRAY_2','arrays','day_names_ARRAY_2','script',NULL),(472,'day_names_ARRAY_3','arrays','day_names_ARRAY_3','script',NULL),(473,'day_names_ARRAY_4','arrays','day_names_ARRAY_4','script',NULL),(474,'day_names_ARRAY_5','arrays','day_names_ARRAY_5','script',NULL),(475,'day_names_ARRAY_6','arrays','day_names_ARRAY_6','script',NULL),(476,'enquiry_statuses_ARRAY_Confirmed','arrays','enquiry_statuses_ARRAY_Confirmed','script','2015-11-16 05:18:36'),(477,'enquiry_statuses_ARRAY_New','arrays','enquiry_statuses_ARRAY_New','script','2015-11-16 05:18:36'),(478,'error_bodies_ARRAY_AA10','arrays','error_bodies_ARRAY_AA10','script','2015-11-16 05:18:36'),(479,'error_bodies_ARRAY_AA11','arrays','error_bodies_ARRAY_AA11','script','2015-11-16 05:18:36'),(480,'error_bodies_ARRAY_AA12','arrays','error_bodies_ARRAY_AA12','script','2015-11-16 05:18:36'),(481,'error_bodies_ARRAY_AA13','arrays','error_bodies_ARRAY_AA13','script','2015-11-16 05:18:36'),(482,'error_bodies_ARRAY_AB01','arrays','error_bodies_ARRAY_AB01','script','2015-11-16 05:18:36'),(483,'error_bodies_ARRAY_AB02','arrays','error_bodies_ARRAY_AB02','script','2015-11-16 05:18:36'),(484,'error_bodies_ARRAY_AB03','arrays','error_bodies_ARRAY_AB03','script','2015-11-16 05:18:36'),(485,'error_bodies_ARRAY_AB04','arrays','error_bodies_ARRAY_AB04','script','2015-11-16 05:18:36'),(486,'error_bodies_ARRAY_AC01','arrays','error_bodies_ARRAY_AC01','script','2015-11-16 05:18:36'),(487,'error_bodies_ARRAY_AC02','arrays','error_bodies_ARRAY_AC02','script','2015-11-16 05:21:33'),(488,'error_bodies_ARRAY_AC08','arrays','error_bodies_ARRAY_AC08','script','2015-11-16 05:21:33'),(489,'error_bodies_ARRAY_AC09','arrays','error_bodies_ARRAY_AC09','script','2015-11-16 05:23:38'),(490,'error_bodies_ARRAY_AE01','arrays','error_bodies_ARRAY_AE01','script','2015-11-16 09:04:02'),(491,'error_bodies_ARRAY_AE03','arrays','error_bodies_ARRAY_AE03','script','2015-11-16 05:21:33'),(492,'error_bodies_ARRAY_AE04','arrays','error_bodies_ARRAY_AE04','script','2015-11-16 05:21:33'),(493,'error_bodies_ARRAY_AE08','arrays','error_bodies_ARRAY_AE08','script','2015-11-16 05:23:38'),(494,'error_bodies_ARRAY_AF01','arrays','error_bodies_ARRAY_AF01','script','2015-11-16 09:04:02'),(495,'error_bodies_ARRAY_AF03','arrays','error_bodies_ARRAY_AF03','script','2015-11-16 05:23:38'),(496,'error_bodies_ARRAY_AF04','arrays','error_bodies_ARRAY_AF04','script','2015-11-16 05:23:38'),(497,'error_bodies_ARRAY_AF08','arrays','error_bodies_ARRAY_AF08','script','2015-11-16 05:23:38'),(498,'error_bodies_ARRAY_AL01','arrays','error_bodies_ARRAY_AL01','script','2015-11-16 09:04:02'),(499,'error_bodies_ARRAY_AL03','arrays','error_bodies_ARRAY_AL03','script','2015-11-16 05:23:38'),(500,'error_bodies_ARRAY_AL04','arrays','error_bodies_ARRAY_AL04','script','2015-11-16 05:23:38'),(501,'error_bodies_ARRAY_AL08','arrays','error_bodies_ARRAY_AL08','script','2015-11-16 05:23:38'),(502,'error_bodies_ARRAY_AL09','arrays','error_bodies_ARRAY_AL09','script','2015-11-16 09:05:37'),(503,'error_bodies_ARRAY_AL10','arrays','error_bodies_ARRAY_AL10','script','2015-11-16 09:05:37'),(504,'error_bodies_ARRAY_AL41','arrays','error_bodies_ARRAY_AL41','script','2015-11-16 09:05:37'),(505,'error_bodies_ARRAY_AL91','arrays','error_bodies_ARRAY_AL91','script','2015-11-16 09:05:37'),(506,'error_bodies_ARRAY_ALC01','arrays','error_bodies_ARRAY_ALC01','script','2015-11-16 09:05:37'),(507,'error_bodies_ARRAY_AO01','arrays','error_bodies_ARRAY_AO01','script','2015-11-16 09:05:37'),(508,'error_bodies_ARRAY_AO02','arrays','error_bodies_ARRAY_AO02','script','2015-11-16 09:05:37'),(509,'error_bodies_ARRAY_AO03','arrays','error_bodies_ARRAY_AO03','script','2015-11-16 09:05:37'),(510,'error_bodies_ARRAY_AO04','arrays','error_bodies_ARRAY_AO04','script','2015-11-16 09:05:37'),(511,'error_bodies_ARRAY_AO05','arrays','error_bodies_ARRAY_AO05','script','2015-11-16 09:05:38'),(512,'error_bodies_ARRAY_AT01','arrays','error_bodies_ARRAY_AT01','script','2015-11-16 09:05:38'),(513,'error_bodies_ARRAY_AT03','arrays','error_bodies_ARRAY_AT03','script','2015-11-16 09:05:38'),(514,'error_bodies_ARRAY_AT04','arrays','error_bodies_ARRAY_AT04','script','2015-11-16 09:05:38'),(515,'error_bodies_ARRAY_AT08','arrays','error_bodies_ARRAY_AT08','script','2015-11-16 09:05:38'),(516,'error_bodies_ARRAY_AU01','arrays','error_bodies_ARRAY_AU01','script','2015-11-16 09:05:38'),(517,'error_bodies_ARRAY_AU02','arrays','error_bodies_ARRAY_AU02','script','2015-11-17 11:41:36'),(518,'error_bodies_ARRAY_AU03','arrays','error_bodies_ARRAY_AU03','script','2015-11-16 09:07:08'),(519,'error_bodies_ARRAY_AU04','arrays','error_bodies_ARRAY_AU04','script','2015-11-16 09:07:08'),(520,'error_bodies_ARRAY_AU08','arrays','error_bodies_ARRAY_AU08','script','2015-11-16 09:07:08'),(523,'error_titles_ARRAY_AA10','arrays','error_titles_ARRAY_AA10','script','2015-11-16 09:07:08'),(524,'error_titles_ARRAY_AA11','arrays','error_titles_ARRAY_AA11','script','2015-11-16 09:07:08'),(525,'error_titles_ARRAY_AA12','arrays','error_titles_ARRAY_AA12','script','2015-11-16 09:07:08'),(526,'error_titles_ARRAY_AA13','arrays','error_titles_ARRAY_AA13','script','2015-11-17 11:41:36'),(527,'error_titles_ARRAY_AB01','arrays','error_titles_ARRAY_AB01','script','2015-11-16 09:07:08'),(528,'error_titles_ARRAY_AB02','arrays','error_titles_ARRAY_AB02','script','2015-11-16 09:07:08'),(529,'error_titles_ARRAY_AB03','arrays','error_titles_ARRAY_AB03','script','2015-11-16 09:07:08'),(530,'error_titles_ARRAY_AB04','arrays','error_titles_ARRAY_AB04','script','2015-11-16 09:07:08'),(531,'error_titles_ARRAY_AC01','arrays','error_titles_ARRAY_AC01','script','2015-11-16 09:07:08'),(532,'error_titles_ARRAY_AC02','arrays','error_titles_ARRAY_AC02','script','2015-11-16 09:07:08'),(533,'error_titles_ARRAY_AC08','arrays','error_titles_ARRAY_AC08','script','2015-11-16 09:07:08'),(534,'error_titles_ARRAY_AC09','arrays','error_titles_ARRAY_AC09','script','2015-11-16 09:08:59'),(535,'error_titles_ARRAY_AE01','arrays','error_titles_ARRAY_AE01','script','2015-11-16 09:08:59'),(536,'error_titles_ARRAY_AE03','arrays','error_titles_ARRAY_AE03','script','2015-11-16 09:08:59'),(537,'error_titles_ARRAY_AE04','arrays','error_titles_ARRAY_AE04','script','2015-11-16 09:08:59'),(538,'error_titles_ARRAY_AE08','arrays','error_titles_ARRAY_AE09','script','2015-11-16 09:08:59'),(539,'error_titles_ARRAY_AF01','arrays','error_titles_ARRAY_AF01','script','2015-11-16 09:08:59'),(540,'error_titles_ARRAY_AF03','arrays','error_titles_ARRAY_AF03','script','2015-11-16 09:08:59'),(541,'error_titles_ARRAY_AF04','arrays','error_titles_ARRAY_AF04','script','2015-11-16 09:08:59'),(542,'error_titles_ARRAY_AF08','arrays','error_titles_ARRAY_AF08','script','2015-11-16 09:08:59'),(543,'error_titles_ARRAY_AL01','arrays','error_titles_ARRAY_AL01','script','2015-11-16 09:08:59'),(544,'error_titles_ARRAY_AL03','arrays','error_titles_ARRAY_AL03','script','2015-11-16 09:08:59'),(545,'error_titles_ARRAY_AL04','arrays','error_titles_ARRAY_AL04','script','2015-11-16 09:08:59'),(546,'error_titles_ARRAY_AL08','arrays','error_titles_ARRAY_AL08','script','2015-11-16 09:08:59'),(547,'error_titles_ARRAY_AL09','arrays','error_titles_ARRAY_AL09','script','2015-11-16 09:08:59'),(548,'error_titles_ARRAY_AL10','arrays','error_titles_ARRAY_AL10','script','2015-11-16 09:08:59'),(549,'error_titles_ARRAY_AL41','arrays','error_titles_ARRAY_AL41','script','2015-11-16 09:10:35'),(550,'error_titles_ARRAY_AL91','arrays','error_titles_ARRAY_AL91','script','2015-11-16 09:10:35'),(551,'error_titles_ARRAY_AO01','arrays','error_titles_ARRAY_AO01','script','2015-11-16 09:10:35'),(552,'error_titles_ARRAY_AO02','arrays','error_titles_ARRAY_AO02','script','2015-11-16 09:10:35'),(553,'error_titles_ARRAY_AO03','arrays','error_titles_ARRAY_AO03','script',NULL),(554,'error_titles_ARRAY_AO04','arrays','error_titles_ARRAY_AO04','script','2015-11-16 09:10:35'),(555,'error_titles_ARRAY_AO05','arrays','error_titles_ARRAY_AO05','script','2015-11-16 09:10:35'),(556,'error_titles_ARRAY_AT01','arrays','error_titles_ARRAY_AT01','script','2015-11-16 09:10:35'),(557,'error_titles_ARRAY_AT03','arrays','error_titles_ARRAY_AT03','script','2015-11-16 09:10:35'),(558,'error_titles_ARRAY_AT04','arrays','error_titles_ARRAY_AT04','script','2015-11-16 09:10:35'),(559,'error_titles_ARRAY_AT08','arrays','error_titles_ARRAY_AT08','script','2015-11-16 09:10:35'),(560,'error_titles_ARRAY_AU01','arrays','error_titles_ARRAY_AU01','script','2015-11-17 11:41:36'),(561,'error_titles_ARRAY_AU02','arrays','error_titles_ARRAY_AU02','script','2015-11-17 11:41:36'),(562,'error_titles_ARRAY_AU03','arrays','error_titles_ARRAY_AU03','script','2015-11-16 09:10:35'),(563,'error_titles_ARRAY_AU04','arrays','error_titles_ARRAY_AU04','script','2015-11-16 09:10:35'),(564,'error_titles_ARRAY_AU08','arrays','error_titles_ARRAY_AU08','script','2015-11-16 09:11:51'),(567,'filter_ARRAY_active','arrays','filter_ARRAY_active','script','2015-11-17 11:30:43'),(568,'filter_ARRAY_featured','arrays','filter_ARRAY_featured','script','2015-11-16 09:11:51'),(569,'filter_ARRAY_inactive','arrays','filter_ARRAY_inactive','script','2015-11-17 11:30:43'),(570,'filter_ARRAY_non_featured','arrays','filter_ARRAY_non_featured','script','2015-11-16 09:11:51'),(571,'filter_prices_ARRAY_1','arrays','filter_prices_ARRAY_1','script','2015-11-16 09:11:51'),(572,'filter_prices_ARRAY_2','arrays','filter_prices_ARRAY_2','script','2015-11-16 09:11:52'),(573,'filter_prices_ARRAY_3','arrays','filter_prices_ARRAY_3','script','2015-11-16 09:11:52'),(574,'filter_prices_ARRAY_4','arrays','filter_prices_ARRAY_4','script','2015-11-16 09:11:52'),(575,'filter_seasons_ARRAY_1','arrays','filter_seasons_ARRAY_1','script','2015-11-16 09:11:52'),(576,'filter_seasons_ARRAY_2','arrays','filter_seasons_ARRAY_2','script','2015-11-16 09:11:52'),(577,'filter_seasons_ARRAY_3','arrays','filter_seasons_ARRAY_3','script','2015-11-16 09:11:52'),(578,'filter_seasons_ARRAY_4','arrays','filter_seasons_ARRAY_4','script','2015-11-16 09:11:52'),(579,'front_error_ARRAY_FR01','arrays','front_error_ARRAY_FR01','script','2015-11-16 09:11:52'),(580,'front_error_ARRAY_FR02','arrays','front_error_ARRAY_FR02','script','2015-11-16 09:11:52'),(581,'front_error_ARRAY_FR03','arrays','front_error_ARRAY_FR03','script','2015-11-16 09:13:24'),(582,'front_error_ARRAY_FRC01','arrays','front_error_ARRAY_FRC01','script','2015-11-16 09:13:25'),(583,'front_error_ARRAY_FRC02','arrays','front_error_ARRAY_FRC02','script','2015-11-16 09:13:25'),(584,'front_error_ARRAY_FRC03','arrays','front_error_ARRAY_FRC03','script','2015-11-16 09:13:25'),(585,'front_error_ARRAY_FRC04','arrays','front_error_ARRAY_FRC04','script','2015-11-16 09:13:25'),(586,'front_sys_ARRAY_bf_captcha','arrays','front_sys_ARRAY_bf_captcha','script','2015-11-16 09:13:25'),(587,'front_sys_ARRAY_bf_captcha_inc','arrays','front_sys_ARRAY_bf_captcha_inc','script','2015-11-16 09:13:25'),(588,'front_sys_ARRAY_bf_comment','arrays','front_sys_ARRAY_bf_comment','script','2015-11-16 09:13:25'),(589,'front_sys_ARRAY_bf_email','arrays','front_sys_ARRAY_bf_email','script','2015-11-16 09:13:25'),(590,'front_sys_ARRAY_bf_email_inv','arrays','front_sys_ARRAY_bf_email_inv','script','2015-11-16 09:13:25'),(591,'front_sys_ARRAY_bf_name','arrays','front_sys_ARRAY_bf_name','script','2015-11-16 09:13:25'),(592,'front_sys_ARRAY_bf_not_match_password','arrays','front_sys_ARRAY_bf_not_match_password','script','2015-11-16 09:13:25'),(593,'front_sys_ARRAY_bf_password','arrays','front_sys_ARRAY_bf_password','script','2015-11-16 09:13:25'),(594,'front_sys_ARRAY_bf_retype_password','arrays','front_sys_ARRAY_bf_retype_password','script','2015-11-16 09:13:25'),(595,'login_err_ARRAY_1','arrays','login_err_ARRAY_1','script','2015-11-16 09:13:25'),(596,'login_err_ARRAY_2','arrays','login_err_ARRAY_2','script',NULL),(597,'login_err_ARRAY_3','arrays','login_err_ARRAY_3','script','2015-11-16 09:14:20'),(598,'months_ARRAY_1','arrays','months_ARRAY_1','script','2015-11-16 09:14:20'),(599,'months_ARRAY_10','arrays','months_ARRAY_10','script','2015-11-16 09:14:20'),(600,'months_ARRAY_11','arrays','months_ARRAY_11','script','2015-11-16 09:14:20'),(601,'months_ARRAY_12','arrays','months_ARRAY_12','script','2015-11-16 09:14:20'),(602,'months_ARRAY_2','arrays','months_ARRAY_2','script','2015-11-16 09:14:20'),(603,'months_ARRAY_3','arrays','months_ARRAY_3','script','2015-11-16 09:14:20'),(604,'months_ARRAY_4','arrays','months_ARRAY_4','script','2015-11-16 09:14:20'),(605,'months_ARRAY_5','arrays','months_ARRAY_5','script','2015-11-16 09:14:20'),(606,'months_ARRAY_6','arrays','months_ARRAY_6','script','2015-11-16 09:14:20'),(607,'months_ARRAY_7','arrays','months_ARRAY_7','script','2015-11-16 09:14:20'),(608,'months_ARRAY_8','arrays','months_ARRAY_8','script','2015-11-16 09:14:20'),(609,'months_ARRAY_9','arrays','months_ARRAY_9','script','2015-11-16 09:14:20'),(610,'personal_titles_ARRAY_dr','arrays','personal_titles_ARRAY_dr','script',NULL),(611,'personal_titles_ARRAY_miss','arrays','personal_titles_ARRAY_miss','script','2015-11-16 09:16:27'),(612,'personal_titles_ARRAY_mr','arrays','personal_titles_ARRAY_mr','script','2015-11-16 09:16:27'),(613,'personal_titles_ARRAY_mrs','arrays','personal_titles_ARRAY_mrs','script','2015-11-16 09:16:27'),(614,'personal_titles_ARRAY_ms','arrays','personal_titles_ARRAY_ms','script','2015-11-16 09:16:27'),(615,'personal_titles_ARRAY_other','arrays','personal_titles_ARRAY_other','script','2015-11-16 09:16:27'),(616,'personal_titles_ARRAY_prof','arrays','personal_titles_ARRAY_prof','script',NULL),(617,'personal_titles_ARRAY_rev','arrays','personal_titles_ARRAY_rev','script',NULL),(618,'price_types_ARRAY_night','arrays','price_types_ARRAY_night','script','2015-11-16 09:16:27'),(619,'price_types_ARRAY_person','arrays','price_types_ARRAY_person','script','2015-11-16 09:16:27'),(620,'price_types_ARRAY_total','arrays','price_types_ARRAY_total','script','2015-11-16 09:16:27'),(621,'publish_status_ARRAY_E','arrays','publish_status_ARRAY_E','script','2015-11-17 09:11:45'),(622,'publish_status_ARRAY_F','arrays','publish_status_ARRAY_F','script','2015-11-17 09:10:28'),(623,'publish_status_ARRAY_T','arrays','publish_status_ARRAY_T','script','2015-11-17 09:10:28'),(624,'register_status_ARRAY_9901','arrays','register_status_ARRAY_9901','script','2015-11-16 09:16:27'),(625,'register_status_ARRAY_9902','arrays','register_status_ARRAY_9902','script','2015-11-16 09:16:27'),(626,'register_status_ARRAY_9903','arrays','register_status_ARRAY_9903','script','2015-11-16 09:17:56'),(627,'register_status_ARRAY_9904','arrays','register_status_ARRAY_9904','script','2015-11-16 09:17:56'),(628,'register_status_ARRAY_9905','arrays','register_status_ARRAY_9905','script','2015-11-16 09:17:56'),(629,'register_status_ARRAY_9906','arrays','register_status_ARRAY_9906','script','2015-11-16 09:17:56'),(630,'register_status_ARRAY_9907','arrays','register_status_ARRAY_9907','script','2015-11-16 09:17:56'),(631,'register_status_ARRAY_9908','arrays','register_status_ARRAY_9908','script','2015-11-16 09:17:56'),(632,'register_status_ARRAY_9909','arrays','register_status_ARRAY_9909','script','2015-11-16 09:17:56'),(633,'register_status_ARRAY_9910','arrays','register_status_ARRAY_9910','script','2015-11-16 09:17:56'),(634,'register_status_ARRAY_9911','arrays','register_status_ARRAY_9911','script','2015-11-16 09:17:56'),(635,'register_status_ARRAY_9912','arrays','register_status_ARRAY_9912','script','2015-11-16 09:17:56'),(636,'register_status_ARRAY_9913','arrays','register_status_ARRAY_9913','script','2015-11-16 09:17:56'),(637,'register_status_ARRAY_9997','arrays','register_status_ARRAY_9997','script','2015-11-16 09:17:56'),(638,'register_status_ARRAY_9998','arrays','register_status_ARRAY_9998','script','2015-11-16 09:17:56'),(639,'register_status_ARRAY_9999','arrays','register_status_ARRAY_9999','script','2015-11-16 09:17:56'),(640,'short_months_ARRAY_1','arrays','short_months_ARRAY_1','script','2015-11-16 09:17:56'),(641,'short_months_ARRAY_10','arrays','short_months_ARRAY_10','script','2015-11-16 09:19:12'),(642,'short_months_ARRAY_11','arrays','short_months_ARRAY_11','script','2015-11-16 09:19:12'),(643,'short_months_ARRAY_12','arrays','short_months_ARRAY_12','script','2015-11-16 09:19:12'),(644,'short_months_ARRAY_2','arrays','short_months_ARRAY_2','script','2015-11-16 09:19:12'),(645,'short_months_ARRAY_3','arrays','short_months_ARRAY_3','script','2015-11-16 09:19:12'),(646,'short_months_ARRAY_4','arrays','short_months_ARRAY_4','script','2015-11-16 09:19:12'),(647,'short_months_ARRAY_5','arrays','short_months_ARRAY_5','script','2015-11-16 09:19:12'),(648,'short_months_ARRAY_6','arrays','short_months_ARRAY_6','script','2015-11-16 09:19:12'),(649,'short_months_ARRAY_7','arrays','short_months_ARRAY_7','script','2015-11-16 09:19:12'),(650,'short_months_ARRAY_8','arrays','short_months_ARRAY_8','script','2015-11-16 09:19:12'),(651,'short_months_ARRAY_9','arrays','short_months_ARRAY_9','script','2015-11-16 09:19:12'),(652,'status_ARRAY_1','arrays','status_ARRAY_1','script','2015-11-16 09:19:12'),(653,'status_ARRAY_123','arrays','status_ARRAY_123','script','2015-11-16 09:19:12'),(654,'status_ARRAY_2','arrays','status_ARRAY_2','script','2015-11-16 09:19:12'),(655,'status_ARRAY_3','arrays','status_ARRAY_3','script','2015-11-16 09:19:12'),(656,'status_ARRAY_7','arrays','status_ARRAY_7','script','2015-11-16 09:20:32'),(657,'status_ARRAY_996','arrays','status_ARRAY_996','script','2015-11-16 09:20:32'),(658,'status_ARRAY_997','arrays','status_ARRAY_997','script','2015-11-16 09:20:32'),(659,'status_ARRAY_998','arrays','status_ARRAY_998','script','2015-11-16 09:20:32'),(660,'status_ARRAY_999','arrays','status_ARRAY_999','script','2015-11-16 09:20:32'),(661,'status_ARRAY_9997','arrays','status_ARRAY_9997','script','2015-11-16 09:20:32'),(662,'status_ARRAY_9998','arrays','status_ARRAY_9998','script','2015-11-16 09:20:32'),(663,'status_ARRAY_9999','arrays','status_ARRAY_9999','script','2015-11-16 09:20:32'),(664,'timezones_ARRAY_-10800','arrays','timezones_ARRAY_-10800','script',NULL),(665,'timezones_ARRAY_-14400','arrays','timezones_ARRAY_-14400','script',NULL),(666,'timezones_ARRAY_-18000','arrays','timezones_ARRAY_-18000','script',NULL),(667,'timezones_ARRAY_-21600','arrays','timezones_ARRAY_-21600','script',NULL),(668,'timezones_ARRAY_-25200','arrays','timezones_ARRAY_-25200','script',NULL),(669,'timezones_ARRAY_-28800','arrays','timezones_ARRAY_-28800','script',NULL),(670,'timezones_ARRAY_-32400','arrays','timezones_ARRAY_-32400','script',NULL),(671,'timezones_ARRAY_-3600','arrays','timezones_ARRAY_-3600','script',NULL),(672,'timezones_ARRAY_-36000','arrays','timezones_ARRAY_-36000','script',NULL),(673,'timezones_ARRAY_-39600','arrays','timezones_ARRAY_-39600','script',NULL),(674,'timezones_ARRAY_-43200','arrays','timezones_ARRAY_-43200','script',NULL),(675,'timezones_ARRAY_-7200','arrays','timezones_ARRAY_-7200','script',NULL),(676,'timezones_ARRAY_0','arrays','timezones_ARRAY_0','script',NULL),(677,'timezones_ARRAY_10800','arrays','timezones_ARRAY_10800','script',NULL),(678,'timezones_ARRAY_14400','arrays','timezones_ARRAY_14400','script',NULL),(679,'timezones_ARRAY_18000','arrays','timezones_ARRAY_18000','script',NULL),(680,'timezones_ARRAY_21600','arrays','timezones_ARRAY_21600','script',NULL),(681,'timezones_ARRAY_25200','arrays','timezones_ARRAY_25200','script',NULL),(682,'timezones_ARRAY_28800','arrays','timezones_ARRAY_28800','script',NULL),(683,'timezones_ARRAY_32400','arrays','timezones_ARRAY_32400','script',NULL),(684,'timezones_ARRAY_3600','arrays','timezones_ARRAY_3600','script',NULL),(685,'timezones_ARRAY_36000','arrays','timezones_ARRAY_36000','script',NULL),(686,'timezones_ARRAY_39600','arrays','timezones_ARRAY_39600','script',NULL),(687,'timezones_ARRAY_43200','arrays','timezones_ARRAY_43200','script',NULL),(688,'timezones_ARRAY_46800','arrays','timezones_ARRAY_46800','script',NULL),(689,'timezones_ARRAY_7200','arrays','timezones_ARRAY_7200','script',NULL),(690,'u_statarr_ARRAY_F','arrays','u_statarr_ARRAY_F','script','2015-11-16 09:21:14'),(691,'u_statarr_ARRAY_T','arrays','u_statarr_ARRAY_T','script','2015-11-16 09:21:14'),(692,'_yesno_ARRAY_F','arrays','_yesno_ARRAY_F','script','2015-11-16 09:21:14'),(693,'_yesno_ARRAY_T','arrays','_yesno_ARRAY_T','script','2015-11-16 09:21:14'),(758,'front_label_filter_by','frontend','Label / Filter by','script','2015-11-16 09:21:14'),(759,'front_label_season','frontend','Label / Season','script','2015-11-16 09:21:14'),(760,'front_label_type','frontend','Label / Type','script','2015-11-16 09:21:14'),(764,'front_label_clear','frontend','Label / Clear','script','2015-11-16 09:21:14'),(765,'front_label_filter','frontend','Label / Filter','script','2015-11-16 09:21:14'),(766,'front_label_photo','frontend','Label / Photo','script','2015-11-16 09:21:20'),(767,'front_label_photos','frontend','Label / Photos','script','2015-11-16 09:21:20'),(832,'lblNotActive','backend','Label / Not active','script','2015-11-16 09:22:36'),(833,'front_label_sort_by','frontend','Label / Sort by','script','2015-11-16 09:22:36'),(835,'front_label_show','frontend','Label / Show','script','2015-11-17 09:05:54'),(836,'front_label_packages','frontend','Label / packages','script','2015-11-16 09:22:36'),(837,'front_label_per_page','frontend','Label / per page','script','2015-11-17 09:05:54'),(838,'item_per_page_ARRAY_10','arrays','item_per_page_ARRAY_10','script','2015-11-16 09:22:36'),(839,'item_per_page_ARRAY_20','arrays','item_per_page_ARRAY_20','script','2015-11-16 09:22:36'),(840,'item_per_page_ARRAY_30','arrays','item_per_page_ARRAY_30','script','2015-11-16 09:22:36'),(841,'item_per_page_ARRAY_50','arrays','item_per_page_ARRAY_50','script','2015-11-16 09:22:36'),(842,'item_per_page_ARRAY_100','arrays','item_per_page_ARRAY_100','script','2015-11-16 09:22:36'),(843,'front_label_type_city_country','frontend','Label / type city or country','script','2015-11-18 12:51:38'),(844,'front_label_top','frontend','Label / top','script','2015-11-16 09:22:36'),(845,'error_titles_ARRAY_AL20','arrays','error_titles_ARRAY_AL20','script','2015-11-16 09:22:36'),(846,'error_bodies_ARRAY_AL20','arrays','error_bodies_ARRAY_AL20','script','2015-11-16 09:22:36'),(847,'lblPostedDateTime','backend','Label / Date/time','script','2015-11-16 09:22:36'),(912,'lblDashPackages','backend','Dashboard / Packages','script','2015-11-16 09:24:04'),(914,'lblDashEnquiries','backend','Dashboard / Enquiries','script','2015-11-16 09:24:04'),(915,'lblDashEnquiry','backend','Dashboard / Enquiry','script','2015-11-16 09:24:04'),(916,'lblDashComments','backend','Dashboard / Comments','script','2015-11-16 09:24:04'),(917,'lblDashComment','backend','Dashboard / Comment','script','2015-11-16 09:24:04'),(918,'lblDashMostPopular','backend','Dashboard / Most popular','script','2015-11-16 09:24:04'),(919,'lblDashLatestEnquiries','backend','Dashboard / Latest enquiries','script','2015-11-16 09:24:04'),(920,'lblDashLatestComments','backend','Dashboard / Latest Comments','script','2015-11-16 09:24:04'),(921,'lblDashViews','backend','Dashboard / Views','script','2015-11-16 09:24:04'),(922,'lblDashView','backend','Dashboard / View','script','2015-11-16 09:24:04'),(923,'lblEnquiryNotFound','backend','Label / No enquiry found','script','2015-11-16 09:24:04'),(924,'lblDashNights','backend','Dashboard / nights','script','2015-11-16 09:24:04'),(925,'lblDashNight','backend','Dashboard / night','script','2015-11-16 09:24:04'),(926,'lblListingNotFound','backend','Label / No package found.','script','2015-11-16 09:24:04'),(927,'lblCommentNotFound','backend','Label / No comment found','script','2015-11-16 09:24:04'),(928,'lblAddTypeMessage','backend','Label / Add type message','script','2015-11-16 09:25:31'),(929,'infoFlightTitle','backend','Infobox / Flight title','script','2015-11-16 09:25:31'),(930,'infoFlightBody','backend','Infobox / Flight body','script','2015-11-16 09:31:17'),(931,'infoFeatureTitle','backend','Infobox / Feature Title','script','2015-11-16 09:25:31'),(932,'infoFeatureBody','backend','Infobox / Feature Body','script','2015-11-16 09:31:17'),(933,'infoOwnerContactTitle','backend','Infobox / Owner contact title','script','2015-11-16 09:25:31'),(934,'infoOwnerContactBody','backend','Infobox / Owner contact body','script','2015-11-16 09:31:17'),(935,'infoSEOTitle','backend','Infobox / SEO Title','script','2015-11-16 09:25:31'),(936,'infoSEOBody','backend','Infobox / SEO body','script','2015-11-16 09:31:17'),(937,'front_label_cancel','frontend','Label / Cancel','script','2015-11-16 09:25:31'),(938,'lblInstallOptional','backend','Label / Optional','script','2015-11-16 09:25:31'),(940,'lblInstallPhp4Title','backend','Label / PHP install step 4','script','2015-11-16 09:31:17'),(941,'lblInstallPhp1_4','backend','Label / Install step 1-4','script','2015-11-16 09:31:17'),(942,'lblInstallPhp1_5','backend','Label / Install step 1-5','script','2015-11-16 09:31:17'),(943,'front_label_show_all','frontend','Label / Show all','script','2015-11-16 09:25:31'),(944,'front_label_show_less','frontend','Label / Show less','script','2015-11-16 09:54:16'),(945,'front_label_review','frontend','Label / review','script','2015-11-17 12:19:13'),(946,'front_login_info','frontend','Label / Login info','script','2015-11-18 20:24:03'),(947,'front_register_info','frontend','Label / Register info','script','2015-11-18 20:24:11'),(948,'front_label_forgot_password','frontend','Label / Forgot password','script','2015-11-16 09:54:16'),(949,'front_forgot_info','frontend','Label / Forgot password info','script','2015-11-18 20:24:45'),(950,'front_button_send','frontend','Button / Send','script','2015-11-16 09:54:16'),(951,'lblForgotPasswordEmail','backend','Label / Forgot password email','script','2015-11-16 09:54:16'),(952,'lblForgotPasswordTokens','backend','Label / Forgot password tokens','script','2015-11-16 09:54:16'),(953,'forgot_status_ARRAY_9901','arrays','forgot_status_ARRAY_9901','script','2015-11-16 09:54:16'),(954,'forgot_status_ARRAY_9906','arrays','forgot_status_ARRAY_9906','script','2015-11-16 09:54:16'),(955,'forgot_status_ARRAY_9912','arrays','forgot_status_ARRAY_9912','script','2015-11-16 09:54:16'),(956,'forgot_status_ARRAY_9997','arrays','forgot_status_ARRAY_9997','script','2015-11-16 09:54:16'),(957,'forgot_status_ARRAY_9999','arrays','forgot_status_ARRAY_9999','script','2015-11-16 09:54:16'),(958,'front_label_id','frontend','Label / ID','script',NULL),(959,'gridEmptyDate','backend','Grid / (empty date)','script','2015-11-16 09:55:12'),(960,'gridInvalidDate','backend','Grid / (invalid date)','script','2015-11-16 09:55:12'),(961,'gridEmptyDateTime','backend','Grid / (empty date time)','script','2015-11-16 09:55:12'),(962,'gridInvalidDateTime','backend','Grid / (invalid date time)','script','2015-11-16 09:55:12'),(963,'lblListingRefIDTip','backend','Tooltip / Ref ID','script','2015-11-17 07:02:51'),(964,'lblListingFeaturedTip','backend','Tooltip / Featured','script','2015-11-17 07:02:51'),(965,'lblListingOwnerTip','backend','Tooltip / Owner contact','script','2015-11-17 07:02:51'),(966,'lblListingCityTip','backend','Tooltip / City','script','2015-11-17 07:02:51'),(967,'lblListingMetaTitleTip','backend','Tooltip / Meta title','script','2015-11-17 07:02:51'),(968,'lblListingMetaKeywordTip','backend','Tooltip / Meta keyword','script','2015-11-17 07:02:51'),(969,'lblListingMetaDescTip','backend','Tooltip / Meta description','script','2015-11-17 07:02:51'),(970,'lblOptionFirstDayTip','backend','Tooltip / First day of week','script','2015-11-17 07:02:51'),(971,'lblOptionCommentsTip','backend','Tooltip / Comment and rating','script','2015-11-17 07:02:51'),(972,'lblOptionCurrencyTip','backend','Tooltip / Currency','script','2015-11-17 07:02:51'),(973,'lblOptionsConfirmEmailTip','backend','Tooltip / Confirm email','script','2015-11-17 07:02:51'),(974,'lblOptionsCommentEmailTip','backend','Tooltip / Comment notify email','script','2015-11-17 07:12:31'),(975,'lblOptionsRegistrationEmailTip','backend','Tooltip / Regstration email','script','2015-11-17 07:12:31'),(976,'lblOptionsForgotEmailTip','backend','Tooltip / Forgot email','script','2015-11-17 07:12:31'),(977,'lblUnlimited','backend','Label / Unlimited','script','2015-11-17 07:12:31'),(978,'lblOptionEmailTip','backend','Tooltip / Email account','script','2015-11-17 07:12:31'),(979,'lblOptionAutoActiveTip','backend','Tooltip / Auto active account','script','2015-11-17 07:12:31'),(980,'infoUserTitle','backend','Infobox / Manage user title','script','2015-11-17 07:12:31'),(981,'infoUserBody','backend','Infobox / Manage user body','script','2015-11-17 07:12:31'),(982,'infoAddPackageTitle','backend','Infobox / Add package title','script','2015-11-17 07:12:31'),(1000,'infoAddPackageBody','backend','Infobox / Add package body','script','2015-11-17 07:12:31'),(1001,'infoListingSummaryTitle','backend','Infobox / Summary title','script','2015-11-17 07:12:31'),(1002,'infoListingSummaryBody','backend','Infobox / Summary body','script','2015-11-17 07:12:31'),(1003,'infoOwnerFlightTitle','backend','Infobox / Owner flight title','script','2015-11-17 07:12:31'),(1004,'infoOwnerFlightBody','backend','Infobox / Owner flight body','script','2015-11-17 07:12:31'),(1005,'infoOwnerFeatureTitle','backend','Infobox / Feature title','script','2015-11-17 07:12:31'),(1006,'infoOwnerFeatureBody','backend','Infobox / Feature body','script','2015-11-17 07:16:11'),(1007,'infoOwnerContact2Title','backend','Infobox / Owner contact title','script','2015-11-17 07:16:11'),(1008,'infoOwnerContact2Body','backend','Infobox / Owner contact body','script','2015-11-17 07:16:11'),(1009,'infoEditorEmailTitle','backend','Infobox / Editor email title','script','2015-11-17 07:16:11'),(1010,'infoEditorEmailBody','backend','Infobox / Editor email body','script','2015-11-17 07:16:11'),(1081,'front_label_reviews','frontend','Label / reviews','script','2015-11-17 07:16:11'),(1082,'front_label_view_all_reviews','frontend','Label / View All Reviews','script','2015-11-17 07:16:11'),(1083,'front_label_type_country','frontend','Label / type Country and/or city','script','2015-11-18 12:51:38'),(1084,'lblIntegrationMethod','backend','Label / Integration method','script','2015-11-17 07:16:11'),(1085,'integration_methods_ARRAY_all','arrays','integration_methods_ARRAY_all','script','2015-11-17 07:16:11'),(1086,'integration_methods_ARRAY_each','arrays','integration_methods_ARRAY_each','script','2015-11-17 07:16:11'),(1087,'lblListingNumberOfFeaturedTip','backend','Tips / Number of featured packages','script','2015-11-17 07:16:11'),(1089,'register_status_ARRAY_9914','arrays','register_status_ARRAY_9914','script','2015-11-17 07:16:11'),(1090,'register_status_ARRAY_9915','arrays','register_status_ARRAY_9915','script','2015-11-17 07:16:11'),(1160,'menuPages','backend','Menu / Pages','script','2015-11-18 13:11:31'),(1161,'menuDestinations','backend','Menu / Destinations','script','2015-11-17 07:20:17'),(1162,'menuSlides','backend','Menu / Slides','script','2015-11-17 07:20:17'),(1163,'dest_create','backend','Destinations / Add destination','script','2015-11-17 07:20:17'),(1164,'dest_country','backend','Destinations / Country','script','2015-11-18 12:51:38'),(1165,'dest_full_desc','backend','Destinations / Description','script','2015-11-17 07:20:17'),(1166,'dest_name','backend','Destinations / Name','script','2015-11-17 07:20:17'),(1167,'dest_update','backend','Destinations / Update destination','script','2015-11-17 07:20:17'),(1168,'all','backend','All','script','2015-11-17 07:20:17'),(1169,'error_titles_ARRAY_AD08','arrays','error_titles_ARRAY_AD08','script','2015-11-17 07:20:17'),(1170,'error_bodies_ARRAY_AD01','arrays','error_bodies_ARRAY_AD01','script','2015-11-17 07:20:17'),(1171,'error_bodies_ARRAY_AD03','arrays','error_bodies_ARRAY_AD03','script','2015-11-17 07:20:17'),(1172,'error_bodies_ARRAY_AD04','arrays','error_bodies_ARRAY_AD04','script','2015-11-17 07:20:17'),(1173,'error_bodies_ARRAY_AD08','arrays','error_bodies_ARRAY_AD08','script','2015-11-17 07:20:17'),(1174,'error_titles_ARRAY_AD01','arrays','error_titles_ARRAY_AD01','script','2015-11-17 07:20:17'),(1175,'error_titles_ARRAY_AD03','arrays','error_titles_ARRAY_AD03','script','2015-11-17 07:20:17'),(1176,'error_titles_ARRAY_AD04','arrays','error_titles_ARRAY_AD04','script','2015-11-17 07:28:43'),(1177,'error_titles_ARRAY_AD10','arrays','error_titles_ARRAY_AD10','script','2015-11-17 07:28:43'),(1178,'error_bodies_ARRAY_AD10','arrays','error_bodies_ARRAY_AD10','script','2015-11-17 07:28:43'),(1179,'error_titles_ARRAY_AD11','arrays','error_titles_ARRAY_AD11','script','2015-11-17 07:28:43'),(1180,'error_bodies_ARRAY_AD11','arrays','error_bodies_ARRAY_AD11','script','2015-11-17 07:28:43'),(1181,'error_titles_ARRAY_AD12','arrays','error_titles_ARRAY_AD12','script','2015-11-17 07:28:43'),(1182,'error_bodies_ARRAY_AD12','arrays','error_bodies_ARRAY_AD12','script','2015-11-17 07:28:43'),(1183,'page_create','backend','Pages / Add page','script','2015-11-17 07:28:43'),(1184,'page_update','backend','Pages / Update page','script','2015-11-17 07:28:43'),(1185,'page_full_desc','backend','Pages / Description','script','2015-11-17 07:28:43'),(1186,'error_bodies_ARRAY_AP12','arrays','error_bodies_ARRAY_AP12','script','2015-11-17 07:28:43'),(1187,'error_titles_ARRAY_AP12','arrays','error_titles_ARRAY_AP12','script','2015-11-17 07:28:43'),(1188,'error_bodies_ARRAY_AP11','arrays','error_bodies_ARRAY_AP11','script','2015-11-17 07:28:43'),(1189,'error_titles_ARRAY_AP11','arrays','error_titles_ARRAY_AP11','script','2015-11-17 07:28:43'),(1190,'error_bodies_ARRAY_AP10','arrays','error_bodies_ARRAY_AP10','script','2015-11-17 07:28:43'),(1191,'error_titles_ARRAY_AP10','arrays','error_titles_ARRAY_AP10','script','2015-11-17 07:31:06'),(1192,'error_titles_ARRAY_AP08','arrays','error_titles_ARRAY_AP08','script','2015-11-17 07:31:06'),(1193,'error_titles_ARRAY_AP04','arrays','error_titles_ARRAY_AP04','script','2015-11-17 07:31:06'),(1194,'error_titles_ARRAY_AP03','arrays','error_titles_ARRAY_AP03','script','2015-11-17 07:31:06'),(1195,'error_titles_ARRAY_AP01','arrays','error_titles_ARRAY_AP01','script','2015-11-17 07:31:06'),(1196,'error_bodies_ARRAY_AP08','arrays','error_bodies_ARRAY_AP08','script','2015-11-17 07:31:06'),(1197,'error_bodies_ARRAY_AP04','arrays','error_bodies_ARRAY_AP04','script','2015-11-17 07:31:06'),(1198,'error_bodies_ARRAY_AP03','arrays','error_bodies_ARRAY_AP03','script','2015-11-17 07:31:06'),(1199,'error_bodies_ARRAY_AP01','arrays','error_bodies_ARRAY_AP01','script','2015-11-17 07:31:06'),(1200,'page_meta_title','backend','Pages / Meta title','script','2015-11-17 07:31:06'),(1201,'page_meta_desc','backend','Pages / Meta description','script','2015-11-17 07:31:06'),(1202,'page_name','backend','Pages / Name','script','2015-11-17 07:31:06'),(1203,'page_url','backend','Pages / Seo URL','script','2015-11-17 07:31:06'),(1204,'slide_create','backend','Slides / Add slide','script','2015-11-17 07:31:06'),(1205,'slide_update','backend','Slides / Update slide','script','2015-11-17 07:31:06'),(1206,'slide_sort','backend','Slides / Sort','script','2015-11-17 13:59:36'),(1207,'slide_image','backend','Slides / Image','script','2015-11-17 13:59:20'),(1208,'slide_url','backend','Slides / URL','script','2014-02-13 15:26:29'),(1209,'slide_target','backend','Slides / Target','script','2015-11-17 07:34:18'),(1210,'slide_title','backend','Slides / Title','script','2015-11-17 07:34:18'),(1211,'slide_desc','backend','Slides / Description','script','2015-11-17 07:34:18'),(1212,'url_target_ARRAY__blank','arrays','URL Target / Blank','script','2015-11-17 07:34:18'),(1213,'url_target_ARRAY__self','arrays','URL Target / Self','script','2015-11-17 07:34:18'),(1214,'error_bodies_ARRAY_AS12','arrays','error_bodies_ARRAY_AS12','script','2015-11-17 07:34:18'),(1215,'error_titles_ARRAY_AS04','arrays','error_titles_ARRAY_AS04','script','2015-11-17 07:34:18'),(1216,'error_titles_ARRAY_AS10','arrays','error_titles_ARRAY_AS10','script','2015-11-17 07:34:18'),(1217,'error_bodies_ARRAY_AS10','arrays','error_bodies_ARRAY_AS10','script','2015-11-17 07:34:18'),(1218,'error_titles_ARRAY_AS11','arrays','error_titles_ARRAY_AS11','script','2015-11-17 07:34:18'),(1219,'error_bodies_ARRAY_AS11','arrays','error_bodies_ARRAY_AS11','script','2015-11-17 07:34:18'),(1220,'error_titles_ARRAY_AS12','arrays','error_titles_ARRAY_AS12','script','2015-11-17 07:34:18'),(1221,'error_titles_ARRAY_AS08','arrays','error_titles_ARRAY_AS08','script','2015-11-17 07:40:12'),(1222,'error_bodies_ARRAY_AS01','arrays','error_bodies_ARRAY_AS01','script','2015-11-17 07:40:12'),(1223,'error_bodies_ARRAY_AS03','arrays','error_bodies_ARRAY_AS03','script','2015-11-17 07:40:12'),(1224,'error_bodies_ARRAY_AS04','arrays','error_bodies_ARRAY_AS04','script','2015-11-17 07:40:12'),(1225,'error_bodies_ARRAY_AS08','arrays','error_bodies_ARRAY_AS08','script','2015-11-17 07:40:12'),(1226,'error_titles_ARRAY_AS01','arrays','error_titles_ARRAY_AS01','script','2015-11-17 07:40:12'),(1227,'error_titles_ARRAY_AS03','arrays','error_titles_ARRAY_AS03','script','2015-11-17 07:40:12'),(1228,'slide_del_img_title','backend','Slides / Delete image confirmation','script','2015-11-17 07:40:12'),(1229,'slide_del_img_desc','backend','Slides / Delete image question','script','2015-11-17 07:40:12'),(1230,'slide_crop_img_title','backend','Slides / Crop image','script','2015-11-17 07:40:12'),(1231,'dest_url','backend','Destinations / Seo URL','script','2014-03-05 07:39:11'),(1232,'dest_on_home','backend','Destinations / On home','script','2015-11-17 07:40:12'),(1233,'_bool_ARRAY_1','arrays','_bool_ARRAY_1','script','2015-11-17 07:40:12'),(1234,'_bool_ARRAY_0','arrays','_bool_ARRAY_0','script','2015-11-17 07:40:12'),(1235,'lblListingBestDealTip','backend','Tooltip / Best Deal','script','2015-11-17 07:40:12'),(1236,'lblListingBestDeal','backend','Label / Is Best deal','script','2015-11-17 07:45:12'),(1237,'lblAll','backend','Label / All','script','2015-11-17 07:45:12'),(1238,'filter_ARRAY_best_deal','arrays','filter_ARRAY_best_deal','script','2015-11-17 07:45:12'),(1239,'front_label_night','frontend','Label / Night','script','2015-11-17 07:45:12'),(1240,'lblContactFormEmail','backend','Label / Contact Form email','script','2015-11-17 07:45:12'),(1241,'lblContactFormTokens','backend','Label / Contact Form tokens','script','2015-11-17 07:45:12'),(1242,'lblOptionsContactFormTip','backend','Tooltip / Contact Form','script','2015-11-17 07:45:12'),(1243,'dest_image','backend','Destinations / Image','script','2015-11-17 07:45:12'),(1244,'page_image','backend','Pages / Image','script','2015-11-17 07:45:12'),(1245,'dest_title','backend','Destinations / Title','script','2015-11-17 07:45:12'),(1246,'page_title','backend','Pages / Title','script','2015-11-17 07:45:12'),(1247,'opt_o_facebook','backend','Options / Facebook fan page','script','2015-11-17 07:45:12'),(1248,'opt_o_twitter','backend','Options / Twitter account','script','2015-11-17 07:45:12'),(1249,'menuSubscriptions','backend','Menu / Subscribers','script','2015-11-17 07:45:12'),(1250,'subscription_create','backend','Subscriptions / Add subscriber','script','2015-11-17 07:45:12'),(1251,'subscription_update','backend','Subscriptions / Update subscriber','script','2015-11-17 11:41:36'),(1252,'subscription_email','backend','Subscriptions / Email','script','2014-03-11 14:32:31'),(1253,'subscription_date_subscr','backend','Subscriptions / Subscribed at','script','2015-11-17 13:53:42'),(1254,'subscription_date_unsubscr','backend','Subscriptions / Unsubscribed at','script','2015-11-17 13:53:42'),(1255,'subscription_is_subscribed','backend','Subscriptions / Is subscribed','script','2015-11-17 07:49:13'),(1256,'error_bodies_ARRAY_ASP01','arrays','error_bodies_ARRAY_ASP01','script','2015-11-17 07:49:13'),(1257,'error_bodies_ARRAY_ASP03','arrays','error_bodies_ARRAY_ASP03','script','2015-11-17 07:49:13'),(1258,'error_bodies_ARRAY_ASP04','arrays','error_bodies_ARRAY_ASP04','script','2015-11-17 07:49:13'),(1259,'error_bodies_ARRAY_ASP08','arrays','error_bodies_ARRAY_ASP08','script','2015-11-17 07:49:13'),(1260,'error_bodies_ARRAY_ASP10','arrays','error_bodies_ARRAY_ASP10','script','2015-11-17 07:49:13'),(1261,'error_bodies_ARRAY_ASP11','arrays','error_bodies_ARRAY_ASP11','script','2015-11-17 07:49:13'),(1262,'error_bodies_ARRAY_ASP12','arrays','error_bodies_ARRAY_ASP12','script','2015-11-17 07:49:13'),(1263,'error_titles_ARRAY_ASP12','arrays','error_titles_ARRAY_ASP12','script','2015-11-17 07:49:13'),(1264,'error_titles_ARRAY_ASP01','arrays','error_titles_ARRAY_ASP01','script','2015-11-17 07:49:13'),(1265,'error_titles_ARRAY_ASP03','arrays','error_titles_ARRAY_ASP03','script','2015-11-17 07:49:13'),(1266,'error_titles_ARRAY_ASP04','arrays','error_titles_ARRAY_ASP04','script','2015-11-17 07:52:19'),(1267,'error_titles_ARRAY_ASP08','arrays','error_titles_ARRAY_ASP08','script','2015-11-17 07:52:19'),(1268,'error_titles_ARRAY_ASP10','arrays','error_titles_ARRAY_ASP10','script','2015-11-17 07:52:19'),(1269,'error_titles_ARRAY_ASP11','arrays','error_titles_ARRAY_ASP11','script','2015-11-17 07:52:19'),(1270,'error_bodies_ARRAY_ASP05','arrays','error_bodies_ARRAY_ASP05','script','2015-11-17 07:52:19'),(1271,'error_titles_ARRAY_ASP05','arrays','error_titles_ARRAY_ASP05','script','2015-11-17 07:52:19'),(1396,'error_titles_ARRAY_ABR04','arrays','error_titles_ARRAY_ABR04','script','2015-11-17 07:52:19'),(1397,'error_titles_ARRAY_ABR08','arrays','error_titles_ARRAY_ABR08','script','2015-11-17 07:52:19'),(1398,'error_bodies_ARRAY_ABR01','arrays','error_bodies_ARRAY_ABR01','script','2015-11-17 07:52:19'),(1399,'error_bodies_ARRAY_ABR03','arrays','error_bodies_ARRAY_ABR03','script','2015-11-17 07:52:19'),(1400,'error_bodies_ARRAY_ABR04','arrays','error_bodies_ARRAY_ABR04','script','2015-11-17 07:52:19'),(1401,'error_bodies_ARRAY_ABR08','arrays','error_bodies_ARRAY_ABR08','script','2015-11-17 07:52:19'),(1402,'error_titles_ARRAY_ABR01','arrays','error_titles_ARRAY_ABR01','script','2015-11-17 07:52:19'),(1403,'error_titles_ARRAY_ABR03','arrays','error_titles_ARRAY_ABR03','script','2015-11-17 07:52:19'),(1404,'error_bodies_ARRAY_ABR12','arrays','error_bodies_ARRAY_ABR12','script','2015-11-17 07:52:19'),(1405,'error_titles_ARRAY_ABR10','arrays','error_titles_ARRAY_ABR10','script','2015-11-17 07:54:09'),(1406,'error_bodies_ARRAY_ABR10','arrays','error_bodies_ARRAY_ABR10','script','2015-11-17 07:54:09'),(1407,'error_titles_ARRAY_ABR11','arrays','error_titles_ARRAY_ABR11','script','2015-11-17 07:54:09'),(1408,'error_bodies_ARRAY_ABR11','arrays','error_bodies_ARRAY_ABR11','script','2015-11-17 07:54:09'),(1409,'error_titles_ARRAY_ABR12','arrays','error_titles_ARRAY_ABR12','script','2015-11-17 07:54:09'),(1410,'banner_create','backend','Banners / Add banner','script','2015-11-17 07:54:09'),(1411,'banner_update','backend','Banners / Update banner','script','2015-11-17 07:54:09'),(1412,'banner_url','backend','Banners / URL','script','2014-03-13 07:59:47'),(1413,'banner_target','backend','Banners / Target','script','2015-11-17 07:54:09'),(1414,'menuBanners','backend','Menu / Banners','script','2015-11-17 07:54:09'),(1415,'banner_type','backend','Banners / Type','script','2015-11-17 07:54:09'),(1416,'banner_types_ARRAY_image','arrays','Banners / Type (Image)','script','2015-11-17 07:54:09'),(1418,'banner_types_ARRAY_code','arrays','Banners / Type (HTML code)','script','2015-11-17 07:54:09'),(1419,'banner_code','backend','Banners / HTML code','script','2015-11-17 07:54:09'),(1420,'banner_image','backend','Banners / Image','script','2015-11-17 07:54:09'),(1421,'menuContent','backend','Menu / Content','script','2015-11-17 07:56:01'),(1422,'banner_alt','backend','Banners / Alt attribute','script','2015-11-17 07:56:01'),(1423,'banner_title','backend','Banners / Title attribute','script','2015-11-17 07:56:01'),(1424,'error_bodies_ARRAY_WC01','arrays','error_bodies_ARRAY_WC01','script','2015-11-17 07:56:01'),(1425,'error_titles_ARRAY_WC01','arrays','error_titles_ARRAY_WC01','script','2015-11-17 07:56:01'),(1426,'error_titles_ARRAY_WC02','arrays','error_titles_ARRAY_WC02','script','2015-11-17 07:56:01'),(1427,'error_bodies_ARRAY_WC02','arrays','error_bodies_ARRAY_WC02','script','2015-11-19 11:27:58'),(1428,'error_titles_ARRAY_WC03','arrays','error_titles_ARRAY_WC03','script','2015-11-17 07:56:01'),(1429,'error_bodies_ARRAY_WC03','arrays','error_bodies_ARRAY_WC03','script','2015-11-17 07:56:01'),(1430,'error_titles_ARRAY_WL01','arrays','error_titles_ARRAY_WL01','script','2015-11-17 07:56:01'),(1431,'error_bodies_ARRAY_WL01','arrays','error_bodies_ARRAY_WL01','script','2015-11-17 07:56:01'),(1432,'error_titles_ARRAY_WF01','arrays','error_titles_ARRAY_WF01','script','2015-11-17 07:56:01'),(1433,'error_bodies_ARRAY_WF01','arrays','error_bodies_ARRAY_WF01','script','2015-11-17 07:56:01'),(1434,'error_titles_ARRAY_WF02','arrays','error_titles_ARRAY_WF02','script','2015-11-17 07:56:01'),(1435,'error_bodies_ARRAY_WF02','arrays','error_bodies_ARRAY_WF02','script','2015-11-17 07:56:01'),(1436,'error_titles_ARRAY_WF03','arrays','error_titles_ARRAY_WF03','script','2015-11-17 07:57:01'),(1437,'error_bodies_ARRAY_WF03','arrays','error_bodies_ARRAY_WF03','script','2015-11-17 07:57:01'),(1438,'error_titles_ARRAY_WF05','arrays','error_titles_ARRAY_WF05','script','2015-11-17 07:57:01'),(1439,'error_bodies_ARRAY_WF05','arrays','error_bodies_ARRAY_WF05','script','2015-11-17 07:57:01'),(1440,'error_titles_ARRAY_WF04','arrays','error_titles_ARRAY_WF04','script','2015-11-17 07:57:01'),(1441,'error_bodies_ARRAY_WF04','arrays','error_bodies_ARRAY_WF04','script','2015-11-17 07:57:01'),(1442,'error_titles_ARRAY_WR01','arrays','error_titles_ARRAY_WR01','script','2015-11-17 07:57:01'),(1443,'error_bodies_ARRAY_WR01','arrays','error_bodies_ARRAY_WR01','script','2015-11-17 07:57:01'),(1444,'error_titles_ARRAY_WR02','arrays','error_titles_ARRAY_WR02','script','2015-11-17 07:57:01'),(1445,'error_bodies_ARRAY_WR02','arrays','error_bodies_ARRAY_WR02','script','2015-11-18 20:26:23'),(1446,'error_bodies_ARRAY_WR03','arrays','error_bodies_ARRAY_WR03','script','2015-11-17 07:57:01'),(1447,'error_titles_ARRAY_WR03','arrays','error_titles_ARRAY_WR03','script','2015-11-17 07:57:01'),(1448,'error_titles_ARRAY_WR04','arrays','error_titles_ARRAY_WR04','script','2015-11-17 07:57:01'),(1449,'error_titles_ARRAY_WR05','arrays','error_titles_ARRAY_WR05','script','2015-11-17 07:57:01'),(1450,'error_bodies_ARRAY_WR04','arrays','error_bodies_ARRAY_WR04','script','2015-11-17 07:57:01'),(1451,'error_bodies_ARRAY_WR05','arrays','error_bodies_ARRAY_WR05','script','2015-11-17 07:58:09'),(1452,'error_titles_ARRAY_WR06','arrays','error_titles_ARRAY_WR06','script','2015-11-17 07:58:09'),(1453,'error_bodies_ARRAY_WR06','arrays','error_bodies_ARRAY_WR06','script','2015-11-18 20:26:38'),(1482,'menuLogos','backend','Menu / Logo','script','2014-03-14 09:40:23'),(1483,'logo_title','backend','Logos / Title','script','2015-11-17 07:58:09'),(1484,'logo_alt','backend','Logos / Alt','script','2015-11-17 07:58:09'),(1485,'logo_image','backend','Logos / Image','script','2015-11-17 07:58:09'),(1486,'_bool_deal_ARRAY_1','arrays','_bool_deal_ARRAY_1','script','2015-11-17 07:58:09'),(1487,'_bool_deal_ARRAY_0','arrays','_bool_deal_ARRAY_0','script','2015-11-17 07:58:09'),(1488,'_bool_deal_ARRAY_2','arrays','_bool_deal_ARRAY_2','script','2015-11-17 07:58:09'),(1695,'front_sys_ARRAY_bf_phone','arrays','front_sys_ARRAY_bf_phone','script','2015-11-17 07:58:09'),(1696,'front_sys_ARRAY_bf_question','arrays','front_sys_ARRAY_bf_question','script','2015-11-18 03:54:59'),(1697,'front_label_reload','frontend','Label / Click to reload','script','2015-11-17 07:58:09'),(1699,'front_label_question','frontend','Label / Question','script','2015-11-18 03:54:59'),(1700,'front_contact_info','frontend','Label / Contact info','script','2015-11-18 20:23:52'),(1701,'front_label_contact','frontend','Label / Contact Us','script','2015-11-17 07:59:37'),(1702,'front_menu_home','frontend','Menu / Home','script','2015-11-17 07:59:37'),(1703,'front_menu_packages','frontend','Menu / Holiday Packages','script','2015-11-17 07:59:37'),(1704,'front_menu_deals','frontend','Menu / Best Deals','script','2015-11-17 07:59:37'),(1706,'front_menu_destinations','frontend','Menu / Destinations','script','2015-11-17 07:59:37'),(1707,'front_menu_about','frontend','Menu / About','script','2015-11-17 07:59:37'),(1708,'front_menu_contact','frontend','Menu / Contact','script','2015-11-17 07:59:37'),(1709,'front_button_subscribe','frontend','Button / Subscribe','script','2015-11-17 07:59:37'),(1710,'front_subscribe_info','frontend','Label / Subscribe info','script','2015-11-17 11:46:28'),(1711,'front_sys_ARRAY_bf_email_placeholder','arrays','front_sys_ARRAY_bf_email_placeholder','script','2015-11-17 07:59:37'),(1712,'front_label_follow_fb','frontend','Label / Follow us on Facebook','script','2015-11-17 07:59:37'),(1713,'front_label_follow_tw','frontend','Label / Follow us on Twitter','script','2015-11-17 07:59:37'),(1714,'front_label_copyright','frontend','Label / Copyright','script','2015-11-17 07:59:37'),(1715,'front_menu_terms','frontend','Menu / Terms of Use','script','2015-11-17 07:59:37'),(1716,'front_label_select_dest','frontend','Label / Select destination','script','2015-11-17 07:59:37'),(1717,'front_label_popular_dest','frontend','Label / Most popular destinations','script','2015-11-17 08:01:07'),(1718,'front_label_deals','frontend','Label / Best deals','script','2015-11-17 08:01:07'),(1719,'front_label_featured','frontend','Label / Featured holiday packages','script','2015-11-17 08:01:07'),(1720,'front_button_find_holiday','frontend','Button / Find Your Holiday','script','2015-11-17 08:01:07'),(1721,'front_label_price_filter','frontend','Label / Price to filter','script','2015-11-17 08:01:07'),(1722,'front_label_price_from','frontend','Label / Price from','script','2015-11-17 11:46:49'),(1723,'front_label_grid','frontend','Label / Grid view','script','2015-11-17 09:03:57'),(1724,'front_label_list','frontend','Label / List view','script','2015-11-17 09:03:57'),(1725,'front_label_map','frontend','Label / Map view','script','2015-11-17 08:01:07'),(1726,'front_sys_ARRAY_bf_notes','arrays','front_sys_ARRAY_bf_notes','script','2015-11-17 08:01:07'),(1727,'front_sys_ARRAY_bf_comment_title','arrays','front_sys_ARRAY_bf_comment_title','script','2015-11-17 08:01:07'),(1728,'front_sys_ARRAY_bf_captcha_min','arrays','front_sys_ARRAY_bf_captcha_min','script','2015-11-17 08:01:07'),(1729,'front_sys_ARRAY_bf_captcha_max','arrays','front_sys_ARRAY_bf_captcha_max','script','2015-11-17 08:01:07'),(1730,'front_sys_ARRAY_bf_date_from','arrays','front_sys_ARRAY_bf_date_from','script','2015-11-17 08:01:07'),(1731,'front_sys_ARRAY_bf_date_to','arrays','front_sys_ARRAY_bf_date_to','script','2015-11-17 08:01:07'),(1732,'front_label_notice','frontend','Label / Notice','script','2015-11-17 08:11:38'),(1733,'opt_o_view_deals','backend','Options / Best Deals view','script','2015-11-17 08:11:38'),(1734,'opt_o_view_packages','backend','Options / Holiday Packages view','script','2015-11-17 08:11:38'),(1735,'front_noscript','frontend','Label / Noscript warning','script','2015-11-17 08:11:38'),(1736,'front_menu_select','frontend','Menu / Select','script','2015-11-17 08:11:38'),(1943,'error_titles_ARRAY_AE10','arrays','error_titles_ARRAY_AE10','script','2015-11-17 08:11:38'),(1944,'error_bodies_ARRAY_AE10','arrays','error_bodies_ARRAY_AE10','script','2015-11-17 08:11:38'),(1945,'error_bodies_ARRAY_ALG01','arrays','error_bodies_ARRAY_ALG01','script','2015-11-17 08:11:38'),(1946,'error_titles_ARRAY_ALG01','arrays','error_titles_ARRAY_ALG01','script','2015-11-17 08:11:38'),(1947,'error_titles_ARRAY_ALG10','arrays','error_titles_ARRAY_ALG10','script','2015-11-17 08:11:38'),(1948,'error_bodies_ARRAY_ALG10','arrays','error_bodies_ARRAY_ALG10','script','2015-11-17 08:11:38'),(1949,'tip_img_alt','backend','Tooltip / Image ALT','script','2015-11-17 08:11:38'),(1950,'tip_img_title','backend','Tooltip / Image TITLE','script','2015-11-17 08:11:38'),(1951,'error_titles_ARRAY_AC10','arrays','error_titles_ARRAY_AC10','script','2015-11-17 08:11:38'),(1952,'error_bodies_ARRAY_AC10','arrays','error_bodies_ARRAY_AC10','script','2015-11-17 08:11:38'),(1953,'error_titles_ARRAY_AO10','arrays','error_titles_ARRAY_AO10','script','2015-11-17 08:26:50'),(1954,'error_bodies_ARRAY_AO10','arrays','error_bodies_ARRAY_AO10','script','2015-11-17 08:26:50'),(1955,'menuGeneralOptions','backend','Menu General Options','script','2015-11-17 08:26:50'),(1956,'opt_o_view_subscribe','backend','Options / Subscribe to newsletter feature','script','2015-11-17 08:26:50'),(1957,'lblOptionViewSubscribeTip','backend','Tooltip / Subscribe to newsletter','script','2015-11-17 08:26:50'),(1958,'lblOptionAvgRatingTip','backend','Tooltip / Show/Hide Average Users Rating','script','2015-11-17 08:26:50'),(1959,'error_bodies_ARRAY_AL11','arrays','error_bodies_ARRAY_AL11','script','2015-11-17 08:26:50'),(1960,'error_titles_ARRAY_AL11','arrays','error_titles_ARRAY_AL11','script','2015-11-17 08:26:50'),(1961,'lblEdit','backend','Edit','script','2015-11-17 08:26:50'),(1962,'tip_seo_url','backend','Tooltip / SEO URL','script','2015-11-17 08:26:50'),(1963,'tip_meta_title','backend','Tooltip / Meta Title','script','2015-11-17 08:26:50'),(1964,'tip_meta_desc','backend','Tooltip / Meta Description','script','2015-11-17 08:26:50'),(1965,'dest_on_home_title','backend','Destinations / On home','script','2015-11-17 08:26:50'),(1966,'lblPackageTitleGrid','backend','Label / Package title','script','2015-11-17 08:26:50'),(1967,'vk_dt','backend','Enquiries / Date From/To','script','2015-11-17 08:26:50'),(1968,'listing_bd_price','backend','Listing / Best Deal Price','script','2015-11-17 09:13:51'),(1969,'listing_bd_discount','backend','Listing / Best Deal Discount','script','2015-11-17 09:13:51'),(1970,'front_label_start_from','frontend','Label / Start from','script','2015-11-17 11:44:53'),(1971,'subscription_export_all','backend','Subscriptions / Export All','script','2015-11-17 08:32:51'),(1972,'menuSeo','backend','Menu / Seo','script','2014-04-29 08:09:47'),(1973,'error_titles_ARRAY_AO11','arrays','error_titles_ARRAY_AO11','script','2015-11-17 08:32:51'),(1974,'error_bodies_ARRAY_AO11','arrays','error_bodies_ARRAY_AO11','script','2015-11-17 08:32:51'),(1975,'seo_home_m_title','backend','SEO / Home page - Meta title','script','2015-11-17 08:32:51'),(1976,'seo_home_m_desc','backend','SEO / Home page - Meta description','script','2015-11-17 08:32:51'),(1977,'seo_contact_m_title','backend','SEO / Contact page - Meta title','script','2015-11-17 08:32:51'),(1978,'seo_contact_m_desc','backend','SEO / Contact page - Meta description','script','2015-11-17 08:32:51'),(1979,'seo_login_m_title','backend','SEO / Login page - Meta title','script','2015-11-17 08:32:51'),(1980,'seo_login_m_desc','backend','SEO / Login page - Meta description','script','2015-11-17 08:32:51'),(1981,'seo_forgot_m_desc','backend','SEO / Forgot password page - Meta description','script','2015-11-17 08:32:51'),(1982,'seo_forgot_m_title','backend','SEO / Forgot password page - Meta title','script','2015-11-17 08:32:51'),(1983,'seo_register_m_title','backend','SEO / Register page - Meta title','script','2015-11-17 08:35:01'),(1984,'seo_register_m_desc','backend','SEO / Register page - Meta description','script','2015-11-17 08:35:01'),(1985,'seo_pckg_m_desc','backend','SEO / Holiday Packages page - Meta description','script','2015-11-17 08:35:01'),(1986,'seo_pckg_m_title','backend','SEO / Holiday Packages page - Meta title','script','2015-11-17 08:35:01'),(1987,'seo_deals_m_title','backend','SEO / Best Deals page - Meta title','script','2015-11-17 08:35:01'),(1988,'seo_deals_m_desc','backend','SEO / Best Deals page - Meta description','script','2015-11-17 08:35:01'),(1989,'error_bodies_ARRAY_AO06','arrays','error_bodies_ARRAY_AO06','script','2015-11-17 08:35:01'),(1990,'error_titles_ARRAY_AO06','arrays','error_titles_ARRAY_AO06','script','2015-11-17 08:35:01'),(1991,'error_titles_ARRAY_AL12','arrays','error_titles_ARRAY_AL12','script','2015-11-17 08:35:01'),(1992,'error_bodies_ARRAY_AL12','arrays','error_bodies_ARRAY_AL12','script','2015-11-17 08:35:01'),(1993,'error_bodies_ARRAY_AL13','arrays','error_bodies_ARRAY_AL13','script','2015-11-17 08:35:01'),(1994,'error_titles_ARRAY_AL13','arrays','error_titles_ARRAY_AL13','script','2015-11-17 08:35:01'),(1995,'front_package_expired','frontend','Label / Package is not published.','script','2015-11-17 08:35:01'),(1996,'plugin_locale_languages','backend','Locale plugin / Languages','plugin','2015-11-17 08:35:01'),(1997,'plugin_locale_titles','backend','Locale plugin / Title','plugin','2015-11-17 08:35:01'),(1998,'plugin_locale_index_title','backend','Locale plugin / Languages info title','plugin','2015-11-17 08:37:18'),(1999,'plugin_locale_index_body','backend','Locale plugin / Languages info body','plugin','2015-11-17 08:37:18'),(2000,'plugin_locale_titles_title','backend','Locale plugin / Titles info title','plugin','2015-11-17 08:37:18'),(2001,'plugin_locale_titles_body','backend','Locale plugin / Titles info body','plugin','2015-11-17 08:37:18'),(2002,'plugin_locale_lbl_title','backend','Locale plugin / Title','plugin','2015-11-17 08:37:18'),(2003,'plugin_locale_lbl_flag','backend','Locale plugin / Flag','plugin','2015-11-17 08:37:18'),(2004,'plugin_locale_lbl_is_default','backend','Locale plugin / Is default','plugin','2015-11-17 08:37:18'),(2005,'plugin_locale_lbl_order','backend','Locale plugin / Order','plugin','2015-11-17 08:37:18'),(2006,'plugin_locale_add_lang','backend','Locale plugin / Add Language','plugin','2015-11-17 08:37:18'),(2007,'plugin_locale_lbl_field','backend','Locale plugin / Field','plugin',NULL),(2008,'plugin_locale_lbl_value','backend','Locale plugin / Value','plugin',NULL),(2009,'plugin_locale_type_backend','backend','Locale plugin / Back-end title','plugin','2015-11-17 08:37:18'),(2010,'plugin_locale_type_frontend','backend','Locale plugin / Front-end title','plugin','2015-11-17 08:37:18'),(2011,'plugin_locale_type_arrays','backend','Locale plugin / Special title','plugin','2015-11-17 08:37:18'),(2012,'error_titles_ARRAY_PAL01','arrays','Locale plugin / Status title','plugin','2015-11-17 11:41:36'),(2013,'error_bodies_ARRAY_PAL01','arrays','Locale plugin / Status body','plugin','2015-11-17 08:50:18'),(2014,'plugin_locale_lbl_rows','backend','Locale plugin / Per page','plugin','2015-11-17 08:39:11'),(2015,'error_titles_ARRAY_PAL02','arrays','Locale plugin / Status title','plugin','2015-11-17 08:39:11'),(2016,'error_bodies_ARRAY_PAL02','arrays','Locale plugin / Status body','plugin','2015-11-17 08:39:11'),(2017,'error_titles_ARRAY_PAL03','arrays','Locale plugin / Status title','plugin','2015-11-17 08:39:11'),(2018,'error_bodies_ARRAY_PAL03','arrays','Locale plugin / Status body','plugin','2015-11-17 08:39:11'),(2019,'error_titles_ARRAY_PAL04','arrays','Locale plugin / Status title','plugin','2015-11-17 08:39:11'),(2020,'error_bodies_ARRAY_PAL04','arrays','Locale plugin / Status body','plugin','2015-11-17 08:39:11'),(2021,'error_titles_ARRAY_PAL05','arrays','Locale plugin / Status title','plugin','2015-11-17 08:39:11'),(2022,'error_bodies_ARRAY_PAL05','arrays','Locale plugin / Status body','plugin','2015-11-17 08:39:11'),(2023,'plugin_locale_import_export','backend','Locale plugin / Import Export menu','plugin','2015-11-17 08:39:11'),(2024,'plugin_locale_import','backend','Locale plugin / Import','plugin','2015-11-17 08:39:11'),(2025,'plugin_locale_export','backend','Locale plugin / Export','plugin','2015-11-17 08:39:11'),(2026,'plugin_locale_language','backend','Locale plugin / Language','plugin','2015-11-17 08:39:11'),(2027,'plugin_locale_browse','backend','Locale plugin / Browse your computer','plugin','2015-11-17 08:39:11'),(2028,'plugin_locale_ie_title','backend','Locale plugin / Import Export (title)','plugin','2015-11-17 08:44:42'),(2029,'plugin_locale_ie_body','backend','Locale plugin / Import Export (body)','plugin','2015-11-17 08:44:42'),(2030,'plugin_locale_separator','backend','Locale plugin / Delimiter','plugin','2015-11-17 08:44:42'),(2031,'plugin_locale_separators_ARRAY_comma','arrays','Locale plugin / Delimiter: comma','plugin','2015-11-17 08:44:42'),(2032,'plugin_locale_separators_ARRAY_semicolon','arrays','Locale plugin / Delimiter: semicolon','plugin','2015-11-17 08:44:42'),(2033,'plugin_locale_separators_ARRAY_tab','arrays','Locale plugin / Delimiter: tab','plugin','2014-07-16 14:03:09'),(2034,'error_bodies_ARRAY_PAL20','arrays','error_bodies_ARRAY_PAL20','plugin','2015-11-17 08:44:42'),(2035,'error_titles_ARRAY_PAL20','arrays','error_titles_ARRAY_PAL20','plugin','2015-11-17 08:44:42'),(2036,'error_titles_ARRAY_PAL11','arrays','error_titles_ARRAY_PAL11','plugin','2015-11-17 08:44:42'),(2037,'error_bodies_ARRAY_PAL11','arrays','error_bodies_ARRAY_PAL11','plugin','2015-11-17 08:44:42'),(2038,'error_titles_ARRAY_PAL12','arrays','error_titles_ARRAY_PAL12','plugin','2015-11-17 08:44:42'),(2039,'error_bodies_ARRAY_PAL12','arrays','error_bodies_ARRAY_PAL12','plugin','2015-11-17 08:44:42'),(2040,'error_titles_ARRAY_PAL13','arrays','error_titles_ARRAY_PAL13','plugin','2015-11-17 08:44:42'),(2041,'error_bodies_ARRAY_PAL13','arrays','error_bodies_ARRAY_PAL13','plugin','2015-11-17 08:44:42'),(2042,'error_titles_ARRAY_PAL14','arrays','error_titles_ARRAY_PAL14','plugin','2015-11-17 08:44:42'),(2043,'error_bodies_ARRAY_PAL14','arrays','error_bodies_ARRAY_PAL14','plugin','2015-11-17 08:46:26'),(2044,'error_titles_ARRAY_PAL15','arrays','error_titles_ARRAY_PAL15','plugin','2015-11-17 08:46:26'),(2045,'error_bodies_ARRAY_PAL15','arrays','error_bodies_ARRAY_PAL15','plugin','2015-11-17 08:46:26'),(2046,'error_titles_ARRAY_PAL16','arrays','error_titles_ARRAY_PAL16','plugin','2015-11-17 08:46:26'),(2047,'error_bodies_ARRAY_PAL16','arrays','error_bodies_ARRAY_PAL16','plugin','2015-11-17 08:46:26'),(2048,'error_titles_ARRAY_PAL17','arrays','error_titles_ARRAY_PAL17','plugin','2015-11-17 08:46:26'),(2049,'error_bodies_ARRAY_PAL17','arrays','error_bodies_ARRAY_PAL17','plugin','2015-11-17 08:46:26'),(2050,'error_titles_ARRAY_PAL18','arrays','error_titles_ARRAY_PAL18','plugin','2015-11-17 08:46:26'),(2051,'error_bodies_ARRAY_PAL18','arrays','error_bodies_ARRAY_PAL18','plugin','2015-11-17 08:46:26'),(2052,'error_titles_ARRAY_PAL19','arrays','error_titles_ARRAY_PAL19','plugin','2015-11-17 08:46:26'),(2053,'error_bodies_ARRAY_PAL19','arrays','error_bodies_ARRAY_PAL19','plugin','2015-11-17 08:46:26'),(2054,'plugin_locale_showid_dialog_title','backend','Label / Show IDs','plugin','2015-11-17 08:46:26'),(2055,'plugin_locale_showid_dialog_desc','backend','Label / Show IDs','plugin','2015-11-17 08:46:26'),(2056,'plugin_locale_button_confirm','backend','Button / Confirm','plugin','2015-11-17 08:46:26'),(2057,'plugin_locale_button_cancel','backend','Button / Cancel','plugin','2015-11-17 08:46:26'),(2058,'plugin_locale_default','backend','Label / default','plugin','2015-11-17 08:47:24'),(2059,'plugin_locale_lbl_id','backend','Label / ID:','plugin',NULL),(2060,'plugin_locale_lbl_show_id','backend','Label / Show ID in all titles to easily locate them','plugin','2015-11-17 08:47:24'),(2061,'error_titles_ARRAY_PBU01','arrays','error_titles_ARRAY_PBU01','plugin','2015-11-17 08:47:24'),(2062,'error_titles_ARRAY_PBU02','arrays','error_titles_ARRAY_PBU02','plugin','2015-11-17 08:47:24'),(2063,'error_titles_ARRAY_PBU03','arrays','error_titles_ARRAY_PBU03','plugin','2015-11-17 08:47:24'),(2064,'error_titles_ARRAY_PBU04','arrays','error_titles_ARRAY_PBU04','plugin','2015-11-17 08:47:24'),(2065,'error_bodies_ARRAY_PBU01','arrays','error_bodies_ARRAY_PBU01','plugin','2015-11-17 08:47:24'),(2066,'error_bodies_ARRAY_PBU02','arrays','error_bodies_ARRAY_PBU02','plugin','2015-11-17 08:47:24'),(2067,'error_bodies_ARRAY_PBU03','arrays','error_bodies_ARRAY_PBU03','plugin','2015-11-17 08:47:24'),(2068,'error_bodies_ARRAY_PBU04','arrays','error_bodies_ARRAY_PBU04','plugin','2015-11-17 08:47:24'),(2069,'plugin_backup_menu_backup','backend','Backup plugin / Menu Backup','plugin','2015-11-11 05:19:47'),(2070,'plugin_backup_database','backend','Backup plugin / Backup database','plugin','2015-11-11 05:19:47'),(2071,'plugin_backup_files','backend','Backup plugin / Backup files','plugin','2015-11-11 05:19:47'),(2072,'plugin_backup_btn_backup','backend','Backup plugin / Backup button','plugin','2015-11-11 05:19:47'),(2073,'error_titles_ARRAY_PBU05','arrays','error_titles_ARRAY_PBU05','plugin','2015-11-11 05:19:30'),(2074,'error_bodies_ARRAY_PBU05','arrays','error_bodies_ARRAY_PBU05','plugin','2015-11-11 05:19:30'),(2075,'error_titles_ARRAY_PBU06','arrays','error_titles_ARRAY_PBU06','plugin','2015-11-11 05:19:30'),(2076,'error_bodies_ARRAY_PBU06','arrays','error_bodies_ARRAY_PBU06','plugin','2015-11-11 05:19:30'),(2077,'plugin_log_menu_log','backend','Log plugin / Menu Log','plugin','2015-11-17 08:49:47'),(2078,'plugin_log_menu_config','backend','Log plugin / Menu Config','plugin','2015-11-17 08:49:47'),(2079,'plugin_log_btn_empty','backend','Log plugin / Empty button','plugin','2015-11-17 08:49:47'),(2080,'error_titles_ARRAY_PLG01','arrays','error_titles_ARRAY_PLG01','plugin','2015-11-17 08:49:47'),(2081,'error_bodies_ARRAY_PLG01','arrays','error_bodies_ARRAY_PLG01','plugin','2015-11-17 08:49:47'),(2082,'plugin_one_admin_menu_index','backend','One Admin plugin / List','plugin','2015-11-17 08:49:47'),(2083,'plugin_one_admin_btn_add','backend','One Admin plugin / Add button','plugin','2015-11-17 08:49:47'),(2084,'error_titles_ARRAY_POA01','arrays','error_titles_ARRAY_POA01','plugin','2015-11-17 08:49:47'),(2085,'error_bodies_ARRAY_POA01','arrays','error_bodies_ARRAY_POA01','plugin','2015-11-17 08:49:47'),(2086,'plugin_gallery_alt','backend','Gallery plugin / ALT','plugin','2015-11-17 08:49:47'),(2087,'plugin_gallery_watermark_position','backend','Gallery plugin / Watermark position','plugin','2015-11-17 08:49:47'),(2088,'plugin_gallery_position','backend','Gallery plugin / Position','plugin','2015-11-17 08:52:07'),(2089,'plugin_gallery_image_settings','backend','Gallery plugin / Image settings','plugin','2015-11-17 08:52:07'),(2090,'plugin_gallery_confirmation_multi','backend','Gallery plugin / Delete all confirmation','plugin','2015-11-17 08:52:07'),(2091,'plugin_gallery_confirmation_single','backend','Gallery plugin / Delete image confirmation','plugin','2015-11-17 08:52:07'),(2092,'plugin_gallery_delete_confirmation','backend','Gallery plugin / Delete confirmation','plugin','2015-11-17 08:52:07'),(2093,'plugin_gallery_compression_note','backend','Gallery plugin / Compression note','plugin','2015-11-17 08:52:07'),(2094,'plugin_gallery_btn_delete','backend','Gallery plugin / Button Delete','plugin','2015-11-17 08:52:07'),(2095,'plugin_gallery_btn_cancel','backend','Gallery plugin / Button Cancel','plugin','2015-11-17 08:52:07'),(2096,'plugin_gallery_btn_save','backend','Gallery plugin / Button Save','plugin','2015-11-17 08:52:07'),(2097,'plugin_gallery_btn_set_watermark','backend','Gallery plugin / Set watermark','plugin','2015-11-17 08:52:07'),(2098,'plugin_gallery_btn_clear_current','backend','Gallery plugin / Clear current one','plugin','2015-11-17 08:52:07'),(2099,'plugin_gallery_btn_compress','backend','Gallery plugin / Button Compress','plugin','2015-11-17 08:52:07'),(2100,'plugin_gallery_btn_recreate','backend','Gallery plugin / Button Recreate','plugin','2015-11-17 08:52:07'),(2101,'plugin_gallery_top_left','backend','Gallery plugin / Top Left','plugin','2015-11-17 08:52:07'),(2102,'plugin_gallery_top_center','backend','Gallery plugin / Top Center','plugin','2015-11-17 08:52:07'),(2103,'plugin_gallery_bottom_left','backend','Gallery plugin / Bottom Left','plugin','2015-11-17 08:53:06');
INSERT INTO `travel_fields` VALUES (2104,'plugin_gallery_bottom_right','backend','Gallery plugin / Bottom Right','plugin','2015-11-17 08:53:06'),(2105,'plugin_gallery_bottom_center','backend','Gallery plugin / Bottom Center','plugin','2015-11-17 08:53:06'),(2106,'plugin_gallery_center_left','backend','Gallery plugin / Center Left','plugin','2015-11-17 08:53:06'),(2107,'plugin_gallery_center_right','backend','Gallery plugin / Center Right','plugin','2015-11-17 08:53:06'),(2108,'plugin_gallery_center_center','backend','Gallery plugin / Center Center','plugin','2015-11-17 08:53:06'),(2109,'plugin_gallery_top_right','backend','Gallery plugin / Top Right','plugin','2015-11-17 08:53:06'),(2110,'plugin_gallery_empty_result','backend','Gallery plugin / Empty result set','plugin','2015-11-17 08:53:06'),(2111,'plugin_gallery_move','backend','Gallery plugin / Move','plugin','2015-11-11 05:17:06'),(2112,'plugin_gallery_edit','backend','Gallery plugin / Edit','plugin','2015-11-11 05:17:06'),(2113,'plugin_gallery_delete','backend','Gallery plugin / Delete','plugin','2015-11-11 05:17:06'),(2114,'plugin_gallery_resize','backend','Gallery plugin / Resize','plugin','2015-11-11 05:17:06'),(2115,'plugin_gallery_rotate','backend','Gallery plugin / Rotate','plugin','2015-11-11 05:17:06'),(2116,'plugin_gallery_watermark','backend','Gallery plugin / Watermark','plugin','2015-11-11 05:17:06'),(2117,'plugin_gallery_compression','backend','Gallery plugin / Compression','plugin','2015-11-11 05:17:06'),(2118,'plugin_gallery_delete_all','backend','Gallery plugin / Delete All','plugin','2015-11-17 08:54:41'),(2119,'plugin_gallery_originals','backend','Gallery plugin / Originals','plugin','2015-11-17 08:54:41'),(2120,'plugin_gallery_thumbs','backend','Gallery plugin / Thumbs','plugin','2015-11-17 08:54:41'),(2121,'plugin_gallery_photos','backend','Gallery plugin / photos','plugin','2015-11-17 08:54:41'),(2122,'plugin_gallery_upload','backend','Gallery plugin / Upload','plugin','2015-11-17 08:54:41'),(2123,'plugin_gallery_recreate','backend','Gallery plugin / Recreate from original','plugin','2015-11-17 08:54:41'),(2124,'plugin_gallery_original','backend','Gallery plugin / Original','plugin','2015-11-17 08:54:41'),(2125,'plugin_gallery_preview','backend','Gallery plugin / Preview','plugin','2015-11-17 08:54:41'),(2126,'plugin_gallery_thumb','backend','Gallery plugin / Thumb','plugin','2015-11-17 08:54:41'),(2127,'plugin_gallery_btn_back','backend','Gallery plugin / Button Back','plugin','2015-11-17 08:54:41'),(2128,'plugin_gallery_resize_body','backend','Gallery plugin / Resize Notice body','plugin','2015-11-17 08:54:41'),(2129,'plugin_gallery_resize_title','backend','Gallery plugin / Resize Notice title','plugin','2015-11-17 08:54:41'),(2130,'plugin_paypal_dt','backend','Paypal plugin / Date & Time','plugin','2015-11-17 08:54:41'),(2131,'plugin_paypal_mc_gross','backend','Paypal plugin / MC Gross','plugin','2014-07-18 14:21:59'),(2132,'plugin_paypal_mc_currency','backend','Paypal plugin / MC Currency','plugin','2014-07-18 14:22:15'),(2133,'plugin_paypal_payer_email','backend','Paypal plugin / Payer email','plugin','2014-07-18 14:22:31'),(2134,'plugin_paypal_txn_type','backend','Paypal plugin / Txn type','plugin','2014-07-18 14:22:49'),(2135,'plugin_paypal_txn_id','backend','Paypal plugin / Txn ID','plugin','2014-07-18 14:22:58'),(2136,'plugin_paypal_subscr_id','backend','Paypal plugin / Subscription ID','plugin','2014-07-18 14:23:13'),(2137,'plugin_paypal_foreign_id','backend','Paypal plugin / Foreign ID','plugin','2014-07-18 14:23:25'),(2138,'plugin_paypal_btn_close','backend','Paypal plugin / Close','plugin','2015-11-11 05:16:30'),(2139,'plugin_paypal_info_title','backend','Paypal plugin / Transaction details','plugin','2014-07-18 14:30:48'),(2140,'plugin_paypal_btn_view','backend','Paypal plugin / View','plugin','2014-07-18 14:37:18'),(2141,'plugin_paypal_menu_ipn','backend','Paypal plugin / IPN','plugin','2014-07-18 14:53:47'),(2142,'plugin_country_name','backend','Country plugin / Country name','plugin','2015-11-18 12:51:38'),(2143,'plugin_country_alpha_2','backend','Country plugin / Alpha 2','plugin','2015-11-17 08:55:07'),(2144,'plugin_country_alpha_3','backend','Country plugin / Alpha 3','plugin','2015-11-17 08:55:07'),(2145,'plugin_country_status','backend','Country plugin / Status','plugin','2015-11-11 05:16:30'),(2146,'plugin_country_btn_add','backend','Country plugin / Button Add','plugin','2015-11-11 05:16:30'),(2147,'plugin_country_statuses_ARRAY_T','arrays','Country plugin / Status (active)','plugin','2015-11-11 05:16:30'),(2148,'plugin_country_statuses_ARRAY_F','arrays','Country plugin / Status (inactive)','plugin','2015-11-11 05:16:05'),(2149,'plugin_country_btn_save','backend','Country plugin / Button Save','plugin','2015-11-11 05:16:05'),(2150,'plugin_country_btn_cancel','backend','Country plugin / Button Cancel','plugin','2015-11-11 05:16:05'),(2151,'plugin_country_menu_countries','backend','Country plugin / Menu Countries','plugin','2015-11-18 12:51:38'),(2152,'error_titles_ARRAY_PCY01','arrays','error_titles_ARRAY_PCY01','plugin','2015-11-18 12:51:38'),(2153,'error_titles_ARRAY_PCY03','arrays','error_titles_ARRAY_PCY03','plugin','2015-11-18 12:51:38'),(2154,'error_titles_ARRAY_PCY04','arrays','error_titles_ARRAY_PCY04','plugin','2015-11-18 12:51:38'),(2155,'error_titles_ARRAY_PCY08','arrays','error_titles_ARRAY_PCY08','plugin','2015-11-18 12:51:38'),(2156,'error_titles_ARRAY_PCY10','arrays','error_titles_ARRAY_PCY10','plugin','2015-11-18 12:51:38'),(2157,'error_titles_ARRAY_PCY11','arrays','error_titles_ARRAY_PCY11','plugin','2015-11-18 12:51:38'),(2158,'error_titles_ARRAY_PCY12','arrays','error_titles_ARRAY_PCY12','plugin','2015-11-18 12:51:38'),(2159,'error_bodies_ARRAY_PCY01','arrays','error_bodies_ARRAY_PCY01','plugin','2015-11-18 12:51:52'),(2160,'error_bodies_ARRAY_PCY03','arrays','error_bodies_ARRAY_PCY03','plugin','2015-11-18 12:51:52'),(2161,'error_bodies_ARRAY_PCY04','arrays','error_bodies_ARRAY_PCY04','plugin','2015-11-18 12:51:52'),(2162,'error_bodies_ARRAY_PCY08','arrays','error_bodies_ARRAY_PCY08','plugin','2015-11-18 12:51:52'),(2163,'error_bodies_ARRAY_PCY10','arrays','error_bodies_ARRAY_PCY10','plugin','2015-11-18 12:51:52'),(2164,'error_bodies_ARRAY_PCY11','arrays','error_bodies_ARRAY_PCY11','plugin','2015-11-18 12:51:52'),(2165,'error_bodies_ARRAY_PCY12','arrays','error_bodies_ARRAY_PCY12','plugin','2015-11-18 12:51:52'),(2166,'plugin_country_delete_confirmation','backend','Country plugin / Delete confirmation','plugin','2015-11-18 12:51:52'),(2167,'plugin_country_delete_selected','backend','Country plugin / Delete selected','plugin','2015-11-11 05:14:36'),(2168,'plugin_country_btn_all','backend','Country plugin / Button All','plugin','2015-11-11 05:14:36'),(2169,'plugin_country_btn_search','backend','Country plugin / Button Search','plugin','2015-11-11 05:14:36');

#
# Structure for table "travel_listings"
#

DROP TABLE IF EXISTS `travel_listings`;
CREATE TABLE `travel_listings` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `owner_id` int(10) DEFAULT NULL,
  `type_id` int(10) unsigned DEFAULT NULL,
  `country_id` int(10) unsigned DEFAULT NULL,
  `owner_show` enum('F','T') NOT NULL DEFAULT 'T',
  `flight_included` enum('T','F') DEFAULT 'F',
  `outbound_from` varchar(255) DEFAULT NULL,
  `outbound_to` varchar(255) DEFAULT NULL,
  `outbound_departs` datetime DEFAULT NULL,
  `outbound_arrives` datetime DEFAULT NULL,
  `inbound_from` varchar(255) DEFAULT NULL,
  `inbound_to` varchar(255) DEFAULT NULL,
  `inbound_departs` datetime DEFAULT NULL,
  `inbound_arrives` datetime DEFAULT NULL,
  `lat` varchar(255) DEFAULT NULL,
  `lng` varchar(255) DEFAULT NULL,
  `address_map` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `address_postcode` varchar(255) DEFAULT NULL,
  `address_content` tinytext,
  `address_city` varchar(255) DEFAULT NULL,
  `address_state` varchar(255) DEFAULT NULL,
  `listing_refid` varchar(255) DEFAULT NULL,
  `listing_rating` tinyint(1) unsigned DEFAULT NULL,
  `listing_season` varchar(255) DEFAULT NULL,
  `listing_nights` tinyint(2) DEFAULT NULL,
  `contact_show` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `bd_price` decimal(9,2) unsigned DEFAULT NULL,
  `bd_discount` decimal(9,2) unsigned DEFAULT NULL,
  `views` int(10) unsigned NOT NULL DEFAULT '0',
  `created` datetime NOT NULL,
  `modified` datetime DEFAULT NULL,
  `expire` date DEFAULT NULL,
  `last_extend` enum('free','paid') DEFAULT NULL,
  `status` enum('T','F','E') NOT NULL DEFAULT 'F',
  `is_featured` enum('F','T') NOT NULL DEFAULT 'F',
  `is_best_deal` tinyint(1) unsigned DEFAULT '0' COMMENT '0 - NOT Best Deal, 1 - Best Deal, 2 - Best Deal listed on home',
  `added_by` enum('other','owner') NOT NULL DEFAULT 'other',
  PRIMARY KEY (`id`),
  UNIQUE KEY `listing_refid` (`listing_refid`),
  KEY `type_id` (`type_id`),
  KEY `country_id` (`country_id`),
  KEY `owner_id` (`owner_id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8;

#
# Data for table "travel_listings"
#

INSERT INTO `travel_listings` VALUES (9,NULL,5,256,'F','F',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'430070','湖北省武汉市','武汉',NULL,'YQ1447751571',4,'2|4',3,0,356.00,70.00,17,'2015-11-17 09:14:02','2015-11-18 13:09:11','2017-11-29','free','E','T',2,'other'),(10,NULL,2,262,'F','T','北京','哈尔滨','2015-11-07 12:00:00','2015-11-07 15:00:00','哈尔滨','北京','2015-11-11 13:00:00','2015-11-11 17:00:00',NULL,NULL,0,'150000','黑龙江省哈尔滨市','哈尔滨',NULL,'ZZ1447761004',5,'1',5,0,1153.00,80.00,9,'2015-11-17 11:50:25','2015-11-18 13:03:54',NULL,'free','T','T',2,'other'),(11,NULL,4,284,'F','F',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'澳大利亚墨尔本','墨尔本',NULL,'NM1447766473',4,'1|2|3|4',10,0,0.00,0.00,4,'2015-11-17 13:21:21','2015-11-18 13:03:18',NULL,'free','T','T',0,'other'),(12,NULL,3,253,'F','F',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'重庆市','重庆市',NULL,'MA1447767360',4,'1|2|3|4',1,0,120.00,10.00,9,'2015-11-17 13:36:17','2015-11-18 13:08:34',NULL,'free','T','T',2,'other'),(13,NULL,1,250,'F','F',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,'北京市','北京市',NULL,'PO1447767784',4,'1|2|3|4',3,0,560.00,20.00,28,'2015-11-17 13:43:20','2015-11-18 13:01:44',NULL,'free','T','T',1,'other');

#
# Structure for table "travel_listings_availabilities"
#

DROP TABLE IF EXISTS `travel_listings_availabilities`;
CREATE TABLE `travel_listings_availabilities` (
  `listing_id` int(10) unsigned NOT NULL,
  `month` tinyint(2) unsigned NOT NULL,
  PRIMARY KEY (`listing_id`,`month`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# Data for table "travel_listings_availabilities"
#


#
# Structure for table "travel_listings_features"
#

DROP TABLE IF EXISTS `travel_listings_features`;
CREATE TABLE `travel_listings_features` (
  `listing_id` int(10) unsigned NOT NULL,
  `feature_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`listing_id`,`feature_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# Data for table "travel_listings_features"
#

INSERT INTO `travel_listings_features` VALUES (9,59),(9,60),(9,66),(9,68),(10,59),(10,61),(10,67),(11,62),(11,66),(11,68),(12,61),(12,65),(13,60),(13,61),(13,66);

#
# Structure for table "travel_logins"
#

DROP TABLE IF EXISTS `travel_logins`;
CREATE TABLE `travel_logins` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `created` datetime DEFAULT NULL,
  `ip` varchar(15) DEFAULT NULL,
  `is_successful` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8;

#
# Data for table "travel_logins"
#

INSERT INTO `travel_logins` VALUES (1,1,'2015-10-05 07:32:48','79.132.27.63',1),(2,1,'2015-11-11 05:01:37','127.0.0.1',1),(3,1,'2015-11-11 05:13:26','127.0.0.1',1),(4,1,'2015-11-11 09:28:58','127.0.0.1',1),(5,1,'2015-11-16 02:26:07','127.0.0.1',1),(6,1,'2015-11-16 08:58:50','127.0.0.1',1),(7,1,'2015-11-16 09:56:51','127.0.0.1',1),(8,1,'2015-11-16 12:11:12','127.0.0.1',1),(9,1,'2015-11-17 06:56:54','127.0.0.1',1),(10,1,'2015-11-17 10:29:08','127.0.0.1',1),(11,1,'2015-11-18 03:17:25','127.0.0.1',1),(12,1,'2015-11-18 19:27:15','127.0.0.1',1),(13,1,'2015-11-18 20:31:19','127.0.0.1',1),(14,1,'2015-11-18 20:40:00','127.0.0.1',1),(15,1,'2015-11-18 20:53:22','127.0.0.1',1),(16,1,'2015-11-18 20:57:51','127.0.0.1',1),(17,1,'2015-11-19 11:25:34','127.0.0.1',1);

#
# Structure for table "travel_multi_lang"
#

DROP TABLE IF EXISTS `travel_multi_lang`;
CREATE TABLE `travel_multi_lang` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `foreign_id` int(10) unsigned DEFAULT NULL,
  `model` varchar(80) DEFAULT NULL,
  `locale` tinyint(3) unsigned DEFAULT NULL,
  `field` varchar(100) DEFAULT NULL,
  `content` text,
  `source` enum('script','plugin','data') DEFAULT 'script',
  PRIMARY KEY (`id`),
  UNIQUE KEY `foreign_id` (`foreign_id`,`model`,`locale`,`field`)
) ENGINE=InnoDB AUTO_INCREMENT=28555 DEFAULT CHARSET=utf8;

#
# Data for table "travel_multi_lang"
#

INSERT INTO `travel_multi_lang` VALUES (832,12,'pjFeature',1,'name','Laundry area - garage','script'),(893,1,'pjField',1,'title','Add language','script'),(896,2,'pjField',1,'title','Password reminder','script'),(899,3,'pjField',1,'title','Admin Login','script'),(902,4,'pjField',1,'title','Back-end titles','script'),(905,5,'pjField',1,'title','Add +','script'),(908,6,'pjField',1,'title','+ Add period / price','script'),(911,7,'pjField',1,'title','« Back','script'),(917,9,'pjField',1,'title','Cancel','script'),(920,10,'pjField',1,'title','Continue','script'),(923,11,'pjField',1,'title','Delete','script'),(926,12,'pjField',1,'title','Get coordinates from Google Maps API','script'),(929,13,'pjField',1,'title','Login','script'),(932,14,'pjField',1,'title','Reset','script'),(935,15,'pjField',1,'title','Save','script'),(938,16,'pjField',1,'title','Search','script'),(941,17,'pjField',1,'title','Send','script'),(944,18,'pjField',1,'title','Update','script'),(947,19,'pjField',1,'title','DateTime','script'),(950,20,'pjField',1,'title','Email','script'),(953,21,'pjField',1,'title','Dear {Name},Your password: {Password}','script'),(956,22,'pjField',1,'title','Password reminder','script'),(959,23,'pjField',1,'title','Front-end titles','script'),(1076,62,'pjField',1,'title','Action confirmation','script'),(1079,63,'pjField',1,'title','Cancel','script'),(1082,64,'pjField',1,'title','Delete','script'),(1085,65,'pjField',1,'title','OK','script'),(1088,66,'pjField',1,'title','Choose Action','script'),(1091,67,'pjField',1,'title','Are you sure you want to delete selected record?','script'),(1094,68,'pjField',1,'title','Delete confirmation','script'),(1097,69,'pjField',1,'title','No records found','script'),(1100,70,'pjField',1,'title','Go to page:','script'),(1103,71,'pjField',1,'title','Items per page','script'),(1106,72,'pjField',1,'title','Next »','script'),(1109,73,'pjField',1,'title','Next page','script'),(1112,74,'pjField',1,'title','« Prev','script'),(1115,75,'pjField',1,'title','Prev page','script'),(1118,76,'pjField',1,'title','Total items:','script'),(1121,77,'pjField',1,'title','The system will send email notifications automatically in some cases as defined below. Use the available tokens and manage the emails’ subjects and messages to personalize them. For your convenience we have set default messages, which we highly recommend to be customized. You can manage the email account that will be used as ‘email from’ when sending these notifications on Settings menu -> General Options tab.','script'),(1124,78,'pjField',1,'title','Email notifications','script'),(1127,79,'pjField',1,'title','You can set up and manage a list with pre-defined amenities / features which can be used to describe in brief package features or accommodation amenities. The pre-defined amenities / features list which is set here, will show up on Features tab while editing a package.','script'),(1130,80,'pjField',1,'title','Enter feature name and then click Save button.','script'),(1133,81,'pjField',1,'title','Add feature','script'),(1136,82,'pjField',1,'title','Amenities / Features list','script'),(1139,83,'pjField',1,'title','Edit the feature name and then click Save button.','script'),(1142,84,'pjField',1,'title','Update feature','script'),(1145,85,'pjField',1,'title','You can show a map with the location of the package accommodation on the package details page. Submit the full address first and then click on ‘Get coordinates from Google Maps API’ button. Save your data.','script'),(1148,86,'pjField',1,'title','Location and Address','script'),(1151,87,'pjField',1,'title','Listing Bookings Body','script'),(1154,88,'pjField',1,'title','Listing Bookings Title','script'),(1157,89,'pjField',1,'title','Listing Contact Body','script'),(1160,90,'pjField',1,'title','Listing Contact Title','script'),(1163,91,'pjField',1,'title','To publish your package or to extend its expiration date (if the package has already been published) choose the appropriate submission period. If for the desired period charges are applicable, then click on ‘Buy now’ button and make the payment required. After payment is received the package will be automatically published / extended.','script'),(1166,92,'pjField',1,'title','Extend expiration date','script'),(1169,93,'pjField',1,'title','Here you can define all the options that your holiday package offers, if you have such. Name each offer accordingly and set its price and the period when valid. Set at least one price offer if you wish to show a package price. You can use Terms tab to describe in more details the package policies, fees and booking terms. ','script'),(1172,94,'pjField',1,'title','Availability & Prices','script'),(1175,95,'pjField',1,'title','Languages Array Body','script'),(1178,96,'pjField',1,'title','Languages Arrays Title','script'),(1181,97,'pjField',1,'title','Languages Backend Body','script'),(1184,98,'pjField',1,'title','Languages Backend Title','script'),(1187,99,'pjField',1,'title','Languages Body','script'),(1190,100,'pjField',1,'title','Languages Frontend Body','script'),(1193,101,'pjField',1,'title','Languages Frontend Title','script'),(1196,102,'pjField',1,'title','Languages Title','script'),(1199,103,'pjField',1,'title','You can allow/disallow website users to submit their own holiday packages after registering into the system. These users are named “Owners”. You can manage owners’ accounts through Users menu. You can also charge owners for publishing their packages. If you wish to enable user submissions set carefully all options bellow and also set the Emails tab options.','script'),(1202,104,'pjField',1,'title','Package Submissions by Users','script'),(1205,105,'pjField',1,'title','Here you can add, delete and manage package types. It is mandatory to have at least one package type added into the system, because it is mandatory to assign a type to each package.','script'),(1208,106,'pjField',1,'title','Enter type name and then click Save button.','script'),(1211,107,'pjField',1,'title','Add package type','script'),(1214,108,'pjField',1,'title','Package Types','script'),(1217,109,'pjField',1,'title','Edit the name of package type and then click Save button.','script'),(1220,110,'pjField',1,'title','Update package type','script'),(1223,111,'pjField',1,'title','Added on','script'),(1226,112,'pjField',1,'title','Add new enquiry','script'),(1229,113,'pjField',1,'title','Add user','script'),(1232,114,'pjField',1,'title','Autumn','script'),(1241,117,'pjField',1,'title','Choose','script'),(1244,118,'pjField',1,'title','Choose Owner','script'),(1247,119,'pjField',1,'title','Filter by package','script'),(1250,120,'pjField',1,'title','Comment','script'),(1253,121,'pjField',1,'title','Email','script'),(1256,122,'pjField',1,'title','Name','script'),(1259,123,'pjField',1,'title','Package','script'),(1262,124,'pjField',1,'title','Status','script'),(1265,125,'pjField',1,'title','Title','script'),(1268,126,'pjField',1,'title','Contact email','script'),(1271,127,'pjField',1,'title','Contact fax','script'),(1274,128,'pjField',1,'title','Contact first name','script'),(1277,129,'pjField',1,'title','Contact last name','script'),(1280,130,'pjField',1,'title','Contact mobile phone','script'),(1283,131,'pjField',1,'title','Contact phone','script'),(1286,132,'pjField',1,'title','Contact title','script'),(1289,133,'pjField',1,'title','Contact website','script'),(1292,134,'pjField',1,'title','Country','script'),(1295,135,'pjField',1,'title','days','script'),(1298,136,'pjField',1,'title','Delete','script'),(1301,137,'pjField',1,'title','Email body','script'),(1304,138,'pjField',1,'title','Subject','script'),(1307,139,'pjField',1,'title','Enquiries','script'),(1310,140,'pjField',1,'title','Email','script'),(1313,141,'pjField',1,'title','From','script'),(1316,142,'pjField',1,'title','Name','script'),(1319,143,'pjField',1,'title','Notes','script'),(1322,144,'pjField',1,'title','Package','script'),(1325,145,'pjField',1,'title','Phone','script'),(1328,146,'pjField',1,'title','Status','script'),(1331,147,'pjField',1,'title','To','script'),(1334,148,'pjField',1,'title','Error','script'),(1337,149,'pjField',1,'title','Export','script'),(1340,150,'pjField',1,'title','Feature','script'),(1343,151,'pjField',1,'title','Flight Included','script'),(1346,152,'pjField',1,'title','Forgot password','script'),(1349,153,'pjField',1,'title','Featured packages','script'),(1352,154,'pjField',1,'title','Step 1. Copy and paste the code below at the very top of your .php page. It should be line 1 of your .php web page.','script'),(1355,155,'pjField',1,'title','Step 2. Copy and paste the code below into your html code, where featured listings will be displayed.','script'),(1358,156,'pjField',1,'title','Step 3. Copy and paste the code below at the very bottom of your .php web page after all the other code.','script'),(1361,157,'pjField',1,'title','Listing','script'),(1364,158,'pjField',1,'title','Follow these steps to insert the Vacation Packages listing on your .php web page using PHP include code:','script'),(1367,159,'pjField',1,'title','Step 1. Copy and paste the code below at the very top of your .php page. It should be line 1 of your .php web page.','script'),(1370,160,'pjField',1,'title','Step 2. Copy and paste the code below into your html code, where the packages listing will be displayed.','script'),(1373,161,'pjField',1,'title','Step 2a (Optional). Copy and paste the code below inside the part of your page, where the meta tags will be printed.','script'),(1376,162,'pjField',1,'title','Step 3. Copy and paste the code below at the very bottom of your .php web page after all the other code.','script'),(1379,163,'pjField',1,'title','Follow these steps to insert the Featured Packages listing on your .php web page using PHP include code:','script'),(1382,164,'pjField',1,'title','IP address','script'),(1385,165,'pjField',1,'title','Is confirmed','script'),(1388,166,'pjField',1,'title','Keyword or Name','script'),(1391,167,'pjField',1,'title','Last update on','script'),(1394,168,'pjField',1,'title','Start submitting your package with choosing its type, status and reference ID. All of them are mandatory fields. If you are using the system for the first time and you do not have a type to choose (or you do not see the type you need) then go to Settings menu -> Types tab and add the package types you wish to use.','script'),(1397,169,'pjField',1,'title','Location','script'),(1400,170,'pjField',1,'title','Add new package','script'),(1403,171,'pjField',1,'title','Check-in','script'),(1406,172,'pjField',1,'title','Check-out','script'),(1409,173,'pjField',1,'title','City','script'),(1412,174,'pjField',1,'title','New comment notification','script'),(1415,175,'pjField',1,'title','Available tokens: {OwnerName} - Package owner\'s name{Name} - Name {Email} - Email {Rating} - Rating {Title} - Title {Comment} - Comment {RefID} - Package RefID{ListingTitle} - Package title','script'),(1418,176,'pjField',1,'title','New enquiry notification email','script'),(1421,177,'pjField',1,'title','Available tokens: {OwnerName} - Package owner\'s name{FullName} - Enquiry sender name {Email} - E-mail {Phone} - Phone number {Notes} - Additional notes {StartDate} - Start date {EndDate} - End date {ListingID} - Package ID {ListingTitle} - Package title{EnquiryID} - Enquiry ID','script'),(1424,178,'pjField',1,'title','Country','script'),(1427,179,'pjField',1,'title','Details','script'),(1430,180,'pjField',1,'title','Email','script'),(1433,181,'pjField',1,'title','Expire date','script'),(1436,182,'pjField',1,'title','Set a date until the package will be published. Make sure Publish status is set based on exp. date','script'),(1439,183,'pjField',1,'title','Extend expire date','script'),(1442,184,'pjField',1,'title','Fax','script'),(1445,185,'pjField',1,'title','Make featured','script'),(1448,186,'pjField',1,'title','Features','script'),(1451,187,'pjField',1,'title','Fees','script'),(1454,188,'pjField',1,'title','First name','script'),(1457,189,'pjField',1,'title','Flight','script'),(1460,190,'pjField',1,'title','Flight notes','script'),(1463,191,'pjField',1,'title','Click on the button to get the location coordinates from Google Maps API. The full address should be submitted above first. You can also enter long/lat coordinates for your package on your own.','script'),(1466,192,'pjField',1,'title','Inbound Arrives','script'),(1469,193,'pjField',1,'title','Inbound Departs','script'),(1472,194,'pjField',1,'title','Inbound flight','script'),(1475,195,'pjField',1,'title','Inbound From','script'),(1478,196,'pjField',1,'title','Inbound To','script'),(1481,197,'pjField',1,'title','Last name','script'),(1484,198,'pjField',1,'title','Latitude','script'),(1487,199,'pjField',1,'title','Longitude','script'),(1490,200,'pjField',1,'title','Meta description','script'),(1493,201,'pjField',1,'title','Meta keywords','script'),(1496,202,'pjField',1,'title','Meta title','script'),(1499,203,'pjField',1,'title','Mobile phone','script'),(1502,204,'pjField',1,'title','Outbound Arrives','script'),(1505,205,'pjField',1,'title','Outbound Departs','script'),(1508,206,'pjField',1,'title','Outbound flight','script'),(1511,207,'pjField',1,'title','Outboud From','script'),(1514,208,'pjField',1,'title','Outbound To','script'),(1517,209,'pjField',1,'title','Owner contact','script'),(1520,210,'pjField',1,'title','Package','script'),(1523,211,'pjField',1,'title','Pets','script'),(1526,212,'pjField',1,'title','Phone','script'),(1529,213,'pjField',1,'title','Photos','script'),(1532,214,'pjField',1,'title','Policies','script'),(1535,215,'pjField',1,'title','Price','script'),(1538,216,'pjField',1,'title','Price from','script'),(1541,217,'pjField',1,'title','Price not found','script'),(1544,218,'pjField',1,'title','Prices','script'),(1547,219,'pjField',1,'title','Price title','script'),(1550,220,'pjField',1,'title','Price to','script'),(1553,221,'pjField',1,'title','Price type','script'),(1556,222,'pjField',1,'title','Publish period','script'),(1559,223,'pjField',1,'title','Reference ID','script'),(1562,224,'pjField',1,'title','Available tokens: {Email} - email {Name} - full name','script'),(1565,225,'pjField',1,'title','New owner account notification','script'),(1568,226,'pjField',1,'title','SEO','script'),(1571,227,'pjField',1,'title','State','script'),(1574,228,'pjField',1,'title','Publish','script'),(1577,229,'pjField',1,'title','You can add a package but choose not to show it on the website listing by choosing ‘No’. You can publish the package by choosing ‘Yes’ or you can make it live only till a certain date by choosing ‘Based on expiration date’.','script'),(1580,230,'pjField',1,'title','Summary','script'),(1583,231,'pjField',1,'title','Terms','script'),(1586,232,'pjField',1,'title','Title','script'),(1589,233,'pjField',1,'title','Website','script'),(1592,234,'pjField',1,'title','Zip','script'),(1595,235,'pjField',1,'title','Name','script'),(1598,236,'pjField',1,'title','Nights','script'),(1601,237,'pjField',1,'title','No','script'),(1604,238,'pjField',1,'title','Option','script'),(1607,239,'pjField',1,'title','Option list','script'),(1610,240,'pjField',1,'title','Owner','script'),(1613,241,'pjField',1,'title','Show owner contact','script'),(1616,242,'pjField',1,'title','Package description','script'),(1619,243,'pjField',1,'title','Package title','script'),(1622,244,'pjField',1,'title','Phone','script'),(1625,245,'pjField',1,'title','Rating','script'),(1628,246,'pjField',1,'title','Role','script'),(1631,247,'pjField',1,'title','Season availability','script'),(1634,248,'pjField',1,'title','Show on map','script'),(1637,249,'pjField',1,'title','Spring','script'),(1640,250,'pjField',1,'title','Status','script'),(1643,251,'pjField',1,'title','Summer','script'),(1646,252,'pjField',1,'title','Booking terms','script'),(1649,253,'pjField',1,'title','Type','script'),(1652,254,'pjField',1,'title','Update comment','script'),(1655,255,'pjField',1,'title','Update enquiry','script'),(1658,256,'pjField',1,'title','Update user','script'),(1661,257,'pjField',1,'title','Registration date/time','script'),(1664,258,'pjField',1,'title','Value','script'),(1667,259,'pjField',1,'title','Views','script'),(1670,260,'pjField',1,'title','Winter','script'),(1673,261,'pjField',1,'title','Yes','script'),(1676,262,'pjField',1,'title','FREE','script'),(1679,263,'pjField',1,'title','Period','script'),(1682,264,'pjField',1,'title','Price','script'),(1685,265,'pjField',1,'title','Extend your period for FREE','script'),(1688,266,'pjField',1,'title','Buy now','script'),(1691,267,'pjField',1,'title','Back','script'),(1694,268,'pjField',1,'title','Arrays titles','script'),(1697,269,'pjField',1,'title','Languages','script'),(1700,270,'pjField',1,'title','Flag','script'),(1703,271,'pjField',1,'title','Is default','script'),(1706,272,'pjField',1,'title','Order','script'),(1709,273,'pjField',1,'title','Title','script'),(1712,274,'pjField',1,'title','Add  new package','script'),(1718,276,'pjField',1,'title','Comments','script'),(1721,277,'pjField',1,'title','Countries','script'),(1724,278,'pjField',1,'title','Dashboard','script'),(1727,279,'pjField',1,'title','Emails','script'),(1730,280,'pjField',1,'title','Enquiries','script'),(1733,281,'pjField',1,'title','Features','script'),(1736,282,'pjField',1,'title','Install','script'),(1739,283,'pjField',1,'title','Multi Lang','script'),(1742,284,'pjField',1,'title','Languages','script'),(1745,285,'pjField',1,'title','Logout','script'),(1748,286,'pjField',1,'title','Settings','script'),(1751,287,'pjField',1,'title','Packages','script'),(1754,288,'pjField',1,'title','Plugins','script'),(1757,289,'pjField',1,'title','Preview','script'),(1760,290,'pjField',1,'title','Profile','script'),(1763,291,'pjField',1,'title','Submissions','script'),(1766,292,'pjField',1,'title','Types','script'),(1769,293,'pjField',1,'title','Users','script'),(1772,294,'pjField',1,'title','Click on the flag icon to choose which language version you wish to edit.','script'),(1775,295,'pjField',1,'title','Allow users to submit packages','script'),(1778,296,'pjField',1,'title','Allow users to add properties','script'),(1781,297,'pjField',1,'title','Show/Hide \'Average Users Rating\'','script'),(1784,298,'pjField',1,'title','Show visitors\' comments','script'),(1787,299,'pjField',1,'title','Currency','script'),(1790,300,'pjField',1,'title','Date format','script'),(1793,301,'pjField',1,'title','Email account for email notifications','script'),(1796,302,'pjField',1,'title','Number of packages to shown on Featured Packages listing','script'),(1799,303,'pjField',1,'title','User account confirmed by default','script'),(1802,304,'pjField',1,'title','Number of packages to shown on a listing page (by default)','script'),(1811,307,'pjField',1,'title','Automatically activate new owner accounts','script'),(1814,308,'pjField',1,'title','Set your Paypal address','script'),(1817,309,'pjField',1,'title','Select the email sending method that your server supports','script'),(1820,310,'pjField',1,'title','SMTP Host','script'),(1823,311,'pjField',1,'title','SMTP Password','script'),(1826,312,'pjField',1,'title','SMTP Port','script'),(1829,313,'pjField',1,'title','SMTP Username','script'),(1832,314,'pjField',1,'title','Timezone','script'),(1835,315,'pjField',1,'title','Time format','script'),(1838,316,'pjField',1,'title','First day of the week','script'),(1841,317,'pjField',1,'title','Set prices for submitting packages by owners. You can charge different price according to the length of time that the holiday package is active (visible) on your listing. To do this add and manage ‘period / price’ rows below. If you wish to set a ‘free trial’ period then set the number of the days and set ‘0’ into the price field. If you do not wish to charge owners for submitting their packages, then leave just one ‘period / price’ row, define a relevant large number of days into the period filed, and set ‘0’ into the price field.','script'),(1844,318,'pjField',1,'title','Password','script'),(1913,341,'pjField',1,'title','Revert status','script'),(1916,342,'pjField',1,'title','URL','script'),(1919,343,'pjField',1,'title','Username','script'),(1922,344,'pjField',1,'title','Active','script'),(1925,345,'pjField',1,'title','Address not found','script'),(1928,346,'pjField',1,'title','Confirm selected','script'),(1931,347,'pjField',1,'title','Date from','script'),(1934,348,'pjField',1,'title','Date submitted','script'),(1937,349,'pjField',1,'title','Date to','script'),(1940,350,'pjField',1,'title','Do you really want to delete the selected record(s)?','script'),(1943,351,'pjField',1,'title','Delete selected','script'),(1946,352,'pjField',1,'title','Dismiss selected','script'),(1949,353,'pjField',1,'title','Please enter a valid email address.','script'),(1952,354,'pjField',1,'title','Email address is already in use','script'),(1955,355,'pjField',1,'title','Expire','script'),(1958,356,'pjField',1,'title','Export selected','script'),(1961,357,'pjField',1,'title','Exp.date','script'),(1964,358,'pjField',1,'title','Expiration date +30 days','script'),(1967,359,'pjField',1,'title','Extend expiration date','script'),(1970,360,'pjField',1,'title','This field is required.','script'),(1973,361,'pjField',1,'title','Image','script'),(1976,362,'pjField',1,'title','Inactive','script'),(1979,363,'pjField',1,'title','Package','script'),(1982,364,'pjField',1,'title','Make all active','script'),(1985,365,'pjField',1,'title','Make all inactive','script'),(1988,366,'pjField',1,'title','Make selected active','script'),(1991,367,'pjField',1,'title','Make selected inactive','script'),(1994,368,'pjField',1,'title','Name','script'),(1997,369,'pjField',1,'title','Make selected Inactive','script'),(2000,370,'pjField',1,'title','Owner','script'),(2003,371,'pjField',1,'title','Publish','script'),(2006,372,'pjField',1,'title','Make selected Active','script'),(2009,373,'pjField',1,'title','Ref ID','script'),(2012,374,'pjField',1,'title','Revert status','script'),(2015,375,'pjField',1,'title','Title','script'),(2018,376,'pjField',1,'title','View enquiries','script'),(2021,377,'pjField',1,'title','of','script'),(2024,378,'pjField',1,'title','Login','script'),(2027,379,'pjField',1,'title','Register','script'),(2030,380,'pjField',1,'title','Address','script'),(2033,381,'pjField',1,'title','Arrival','script'),(2036,382,'pjField',1,'title','Availability','script'),(2039,383,'pjField',1,'title','Available','script'),(2042,384,'pjField',1,'title','Average Users Rating','script'),(2045,385,'pjField',1,'title','Booking terms','script'),(2048,386,'pjField',1,'title','by','script'),(2051,387,'pjField',1,'title','Captcha','script'),(2054,388,'pjField',1,'title','Check-in','script'),(2057,389,'pjField',1,'title','Check-out','script'),(2060,390,'pjField',1,'title','Comment','script'),(2063,391,'pjField',1,'title','Comments','script'),(2066,392,'pjField',1,'title','Departure','script'),(2069,393,'pjField',1,'title','Description','script'),(2072,394,'pjField',1,'title','View details','script'),(2075,395,'pjField',1,'title','We sorry that the current package may be disabled or deleted by the administrator.','script'),(2078,396,'pjField',1,'title','Duration','script'),(2081,397,'pjField',1,'title','Email','script'),(2084,398,'pjField',1,'title','Enquiry','script'),(2087,399,'pjField',1,'title','Fax','script'),(2090,400,'pjField',1,'title','Amenities','script'),(2093,401,'pjField',1,'title','Fees','script'),(2096,402,'pjField',1,'title','Filter by location','script'),(2099,403,'pjField',1,'title','Filter by price','script'),(2102,404,'pjField',1,'title','Filter by rating','script'),(2105,405,'pjField',1,'title','Filter by season','script'),(2108,406,'pjField',1,'title','Filter by type','script'),(2111,407,'pjField',1,'title','Flight details','script'),(2114,408,'pjField',1,'title','Flight included','script'),(2117,409,'pjField',1,'title','Flight','script'),(2120,410,'pjField',1,'title','From','script'),(2123,411,'pjField',1,'title','h','script'),(2126,412,'pjField',1,'title','Inbound arrive','script'),(2129,413,'pjField',1,'title','Inbound depart','script'),(2132,414,'pjField',1,'title','Inbound Flight','script'),(2135,415,'pjField',1,'title','Inbound from','script'),(2138,416,'pjField',1,'title','Inbound to','script'),(2141,417,'pjField',1,'title','Location','script'),(2144,418,'pjField',1,'title','m','script'),(2147,419,'pjField',1,'title','Mobile','script'),(2150,420,'pjField',1,'title','Name','script'),(2153,421,'pjField',1,'title','Nights','script'),(2156,422,'pjField',1,'title','Notes','script'),(2159,423,'pjField',1,'title','No package found.','script'),(2162,424,'pjField',1,'title','There is no comment.','script'),(2165,425,'pjField',1,'title','of','script'),(2168,426,'pjField',1,'title','Outbound arrive','script'),(2171,427,'pjField',1,'title','Outbound depart','script'),(2174,428,'pjField',1,'title','Outbound Flight','script'),(2177,429,'pjField',1,'title','Outbound from','script'),(2180,430,'pjField',1,'title','Outbound to','script'),(2183,431,'pjField',1,'title','Owner contact','script'),(2186,432,'pjField',1,'title','Package','script'),(2189,433,'pjField',1,'title','Password','script'),(2192,434,'pjField',1,'title','per person','script'),(2195,435,'pjField',1,'title','Pets','script'),(2198,436,'pjField',1,'title','Phone','script'),(2201,437,'pjField',1,'title','Policies','script'),(2204,438,'pjField',1,'title','Policies & Fees','script'),(2207,439,'pjField',1,'title','Post Review','script'),(2210,440,'pjField',1,'title','Price','script'),(2213,441,'pjField',1,'title','Availability & Prices','script'),(2216,442,'pjField',1,'title','Rating','script'),(2219,443,'pjField',1,'title','Re-type password','script'),(2222,444,'pjField',1,'title','Send Enquiry','script'),(2225,445,'pjField',1,'title','Send request','script'),(2228,446,'pjField',1,'title','star','script'),(2231,447,'pjField',1,'title','stars','script'),(2234,448,'pjField',1,'title','Title','script'),(2237,449,'pjField',1,'title','To','script'),(2240,450,'pjField',1,'title','Total Duration','script'),(2243,451,'pjField',1,'title','Average Users Rating','script'),(2246,452,'pjField',1,'title','Website','script'),(2249,453,'pjField',1,'title','Stars','script'),(2252,454,'pjField',1,'title','Back','script'),(2255,455,'pjField',1,'title','Clear filter','script'),(2258,456,'pjField',1,'title','Log in','script'),(2261,457,'pjField',1,'title','Register','script'),(2264,458,'pjField',1,'title','Next','script'),(2267,459,'pjField',1,'title','Prev','script'),(2270,460,'pjField',1,'title','Confirmed','script'),(2273,461,'pjField',1,'title','New','script'),(2276,462,'pjField',1,'title','Sunday','script'),(2279,463,'pjField',1,'title','Monday','script'),(2282,464,'pjField',1,'title','Tuesday','script'),(2285,465,'pjField',1,'title','Wednesday','script'),(2288,466,'pjField',1,'title','Thursday','script'),(2291,467,'pjField',1,'title','Friday','script'),(2294,468,'pjField',1,'title','Saturday','script'),(2297,469,'pjField',1,'title','S','script'),(2300,470,'pjField',1,'title','M','script'),(2303,471,'pjField',1,'title','T','script'),(2306,472,'pjField',1,'title','W','script'),(2309,473,'pjField',1,'title','T','script'),(2312,474,'pjField',1,'title','F','script'),(2315,475,'pjField',1,'title','S','script'),(2318,476,'pjField',1,'title','Confirmed','script'),(2321,477,'pjField',1,'title','Not confirmed','script'),(2324,478,'pjField',1,'title','Given email address is not associated with any account.','script'),(2327,479,'pjField',1,'title','For further instructions please check your mailbox.','script'),(2330,480,'pjField',1,'title','We\'re sorry, please try again later.','script'),(2333,481,'pjField',1,'title','All the changes made to your profile have been saved.','script'),(2336,482,'pjField',1,'title','To protect your system from loses perform a backup anytime you wish. Click on the generated file link to download the backup file.  ','script'),(2339,483,'pjField',1,'title','All backup files have been saved.','script'),(2342,484,'pjField',1,'title','No option was selected.','script'),(2345,485,'pjField',1,'title','Backup not performed.','script'),(2348,486,'pjField',1,'title','All changes to the comment have been saved.','script'),(2351,487,'pjField',1,'title','The comment data you entered is not valid.','script'),(2354,488,'pjField',1,'title','We are sorry that the current comment does not exist anymore.','script'),(2357,489,'pjField',1,'title','The comment is for non-existing package. Please check the package status again.','script'),(2360,490,'pjField',1,'title','All changes made to the enquiry have been saved.','script'),(2363,491,'pjField',1,'title','A new enquiry has been added to the list.','script'),(2366,492,'pjField',1,'title','An error occurred! it failed to add new enquiry.','script'),(2369,493,'pjField',1,'title','We are sorry that the enquiry you are looking for is missing.','script'),(2372,494,'pjField',1,'title','All changes made to the feature have been saved.','script'),(2375,495,'pjField',1,'title','A new feature has been added to the list.','script'),(2378,496,'pjField',1,'title','Error occurred! it failed to add new feature.','script'),(2381,497,'pjField',1,'title','We are sorry, but the feature you are looking for is missing.','script'),(2384,498,'pjField',1,'title','All changes made to the package have been saved.','script'),(2387,499,'pjField',1,'title','A new package has been added to the list.','script'),(2390,500,'pjField',1,'title','An error occurred! it failed to add new package.','script'),(2393,501,'pjField',1,'title','We are sorry, but the package you are looking for is missing.','script'),(2396,502,'pjField',1,'title','You have no permission to edit the package.','script'),(2399,503,'pjField',1,'title','Your plan has been extended.','script'),(2402,504,'pjField',1,'title','Upload as many images as you want for this package. You can resize, crop, rotate, watermark and complress the uploaded images. Drag & drop to change their order.','script'),(2405,505,'pjField',1,'title','You can define here all policies and fees that your package has. ‘Booking terms’ field text will show up in a special box next to the enquiry form on your package details page. You can use it to highlight your booking conditions.','script'),(2408,506,'pjField',1,'title','All the changes made to titles have been saved.','script'),(2411,507,'pjField',1,'title','All the changes made to options have been saved.','script'),(2414,508,'pjField',1,'title','All the changes made to submissions have been saved.','script'),(2417,509,'pjField',1,'title','Your configuration settings have been saved.','script'),(2420,510,'pjField',1,'title','You have just defined email notification successfully.','script'),(2423,511,'pjField',1,'title','All changes made to emails have been saved.','script'),(2426,512,'pjField',1,'title','All changes made to the type have been saved.','script'),(2429,513,'pjField',1,'title','A new type has been added to the list.','script'),(2432,514,'pjField',1,'title','Error occurred! it failed to add a new type.','script'),(2435,515,'pjField',1,'title','We are sorry! the types your are looking for are missing.','script'),(2438,516,'pjField',1,'title','All the changes made to this user have been saved.','script'),(2441,517,'pjField',1,'title','An error occurred when trying to update user.','script'),(2444,518,'pjField',1,'title','All the changes made to this user have been saved.','script'),(2447,519,'pjField',1,'title','We are sorry, but the user has not been added.','script'),(2450,520,'pjField',1,'title','User your looking for is missing.','script'),(2459,523,'pjField',1,'title','Account not found!','script'),(2462,524,'pjField',1,'title','Password send!','script'),(2465,525,'pjField',1,'title','Password not send!','script'),(2468,526,'pjField',1,'title','Profile updated!','script'),(2471,527,'pjField',1,'title','Backup','script'),(2474,528,'pjField',1,'title','Backup complete!','script'),(2477,529,'pjField',1,'title','Backup failed!','script'),(2480,530,'pjField',1,'title','Backup failed!','script'),(2483,531,'pjField',1,'title','Comment updated','script'),(2486,532,'pjField',1,'title','Data invalid','script'),(2489,533,'pjField',1,'title','Comment not found','script'),(2492,534,'pjField',1,'title','Package missing','script'),(2495,535,'pjField',1,'title','Enquiry updated','script'),(2498,536,'pjField',1,'title','Enquiry added','script'),(2501,537,'pjField',1,'title','Error! failed to add enquiry','script'),(2504,538,'pjField',1,'title','Enquiry not found','script'),(2507,539,'pjField',1,'title','Feature updated','script'),(2510,540,'pjField',1,'title','Feature added','script'),(2513,541,'pjField',1,'title','Error! failed to add feature','script'),(2516,542,'pjField',1,'title','Feature not found','script'),(2519,543,'pjField',1,'title','Package updated','script'),(2522,544,'pjField',1,'title','Package added','script'),(2525,545,'pjField',1,'title','Error! failed to add package','script'),(2528,546,'pjField',1,'title','Package not found','script'),(2531,547,'pjField',1,'title','Error occured','script'),(2534,548,'pjField',1,'title','System notice','script'),(2537,549,'pjField',1,'title','Photos','script'),(2540,550,'pjField',1,'title','Policies & Fees / Booking terms','script'),(2543,551,'pjField',1,'title','Options updated!','script'),(2546,552,'pjField',1,'title','Submissions updated','script'),(2549,553,'pjField',1,'title','Installation Settings Updated','script'),(2552,554,'pjField',1,'title','Emails added','script'),(2555,555,'pjField',1,'title','Email updated','script'),(2558,556,'pjField',1,'title','Type updated','script'),(2561,557,'pjField',1,'title','Type added','script'),(2564,558,'pjField',1,'title','Adding type error','script'),(2567,559,'pjField',1,'title','Type not found','script'),(2570,560,'pjField',1,'title','User updated!','script'),(2573,561,'pjField',1,'title','User failed to update','script'),(2576,562,'pjField',1,'title','User added!','script'),(2579,563,'pjField',1,'title','User failed to add.','script'),(2582,564,'pjField',1,'title','User not found.','script'),(2591,567,'pjField',1,'title','Active','script'),(2594,568,'pjField',1,'title','Featured','script'),(2597,569,'pjField',1,'title','Inactive','script'),(2600,570,'pjField',1,'title','Not featured','script'),(2603,571,'pjField',1,'title','$ 100 - $ 500','script'),(2606,572,'pjField',1,'title','$ 500 - $ 1,000','script'),(2609,573,'pjField',1,'title','$ 1,000 - $ 1,500','script'),(2612,574,'pjField',1,'title','> $ 1,500','script'),(2615,575,'pjField',1,'title','Winter','script'),(2618,576,'pjField',1,'title','Spring','script'),(2621,577,'pjField',1,'title','Summer','script'),(2624,578,'pjField',1,'title','Autumn','script'),(2627,579,'pjField',1,'title','Input data is not valid.','script'),(2630,580,'pjField',1,'title','Your request has been sent successfully to the package owner.','script'),(2633,581,'pjField',1,'title','Sorry! An error occurred and the request could not be sent.','script'),(2636,582,'pjField',1,'title','The comment data is invalid.','script'),(2639,583,'pjField',1,'title','You comment has been posted successfully. Please wait for administrator\'s confirmation to have the comment shown.','script'),(2642,584,'pjField',1,'title','Your comment has posted successfully.','script'),(2645,585,'pjField',1,'title','Some error occurred! The comment could not be saved correctly.','script'),(2648,586,'pjField',1,'title','Captcha is required.','script'),(2651,587,'pjField',1,'title','Captcha is incorrect.','script'),(2654,588,'pjField',1,'title','Comment is required.','script'),(2657,589,'pjField',1,'title','Email is required.','script'),(2660,590,'pjField',1,'title','Email is invalid.','script'),(2663,591,'pjField',1,'title','Name is required.','script'),(2666,592,'pjField',1,'title','Re-type password does not match.','script'),(2669,593,'pjField',1,'title','Password is required.','script'),(2672,594,'pjField',1,'title','Re-type password is required.','script'),(2675,595,'pjField',1,'title','Wrong username or password','script'),(2678,596,'pjField',1,'title','Access denied','script'),(2681,597,'pjField',1,'title','Account is disabled','script'),(2684,598,'pjField',1,'title','January','script'),(2687,599,'pjField',1,'title','October','script'),(2690,600,'pjField',1,'title','November','script'),(2693,601,'pjField',1,'title','December','script'),(2696,602,'pjField',1,'title','February','script'),(2699,603,'pjField',1,'title','March','script'),(2702,604,'pjField',1,'title','April','script'),(2705,605,'pjField',1,'title','May','script'),(2708,606,'pjField',1,'title','June','script'),(2711,607,'pjField',1,'title','July','script'),(2714,608,'pjField',1,'title','August','script'),(2717,609,'pjField',1,'title','September','script'),(2720,610,'pjField',1,'title','Dr.','script'),(2723,611,'pjField',1,'title','Miss','script'),(2726,612,'pjField',1,'title','Mr.','script'),(2729,613,'pjField',1,'title','Mrs.','script'),(2732,614,'pjField',1,'title','Ms.','script'),(2735,615,'pjField',1,'title','Other','script'),(2738,616,'pjField',1,'title','Prof.','script'),(2741,617,'pjField',1,'title','Rev.','script'),(2744,618,'pjField',1,'title','per night','script'),(2747,619,'pjField',1,'title','per person','script'),(2750,620,'pjField',1,'title','total price','script'),(2753,621,'pjField',1,'title','Based on expiration date','script'),(2756,622,'pjField',1,'title','No','script'),(2759,623,'pjField',1,'title','Yes','script'),(2762,624,'pjField',1,'title','Email is missing.','script'),(2765,625,'pjField',1,'title','Password is missing.','script'),(2768,626,'pjField',1,'title','Re-type password is missing.','script'),(2771,627,'pjField',1,'title','Name is missing.','script'),(2774,628,'pjField',1,'title','Captcha is missing.','script'),(2777,629,'pjField',1,'title','Email cannot be empty.','script'),(2780,630,'pjField',1,'title','Password cannot be empty.','script'),(2783,631,'pjField',1,'title','Re-type password cannot be empty.','script'),(2786,632,'pjField',1,'title','Name cannot be empty.','script'),(2789,633,'pjField',1,'title','Captcha cannot be empty.','script'),(2792,634,'pjField',1,'title','Captcha is not correct.','script'),(2795,635,'pjField',1,'title','Email is invalid.','script'),(2798,636,'pjField',1,'title','Re-type password does not match.','script'),(2801,637,'pjField',1,'title','Email was already used.','script'),(2804,638,'pjField',1,'title','Your account has been created successfully, but needs to be approved and activated by the website administrator first.','script'),(2807,639,'pjField',1,'title','Your account has been created successfully. You can log in and start submitting your travel packages.','script'),(2810,640,'pjField',1,'title','Jan','script'),(2813,641,'pjField',1,'title','Oct','script'),(2816,642,'pjField',1,'title','Nov','script'),(2819,643,'pjField',1,'title','Dec','script'),(2822,644,'pjField',1,'title','Feb','script'),(2825,645,'pjField',1,'title','Mar','script'),(2828,646,'pjField',1,'title','Apr','script'),(2831,647,'pjField',1,'title','May','script'),(2834,648,'pjField',1,'title','Jun','script'),(2837,649,'pjField',1,'title','Jul','script'),(2840,650,'pjField',1,'title','Aug','script'),(2843,651,'pjField',1,'title','Sep','script'),(2846,652,'pjField',1,'title','You are not loged in.','script'),(2849,653,'pjField',1,'title','Your hosting account does not allow uploading such a large image.','script'),(2852,654,'pjField',1,'title','Access denied. You have not requisite rights to.','script'),(2855,655,'pjField',1,'title','Empty resultset.','script'),(2858,656,'pjField',1,'title','The operation is not allowed in demo mode.','script'),(2861,657,'pjField',1,'title','No property for the reservation found','script'),(2864,658,'pjField',1,'title','No reservation found','script'),(2867,659,'pjField',1,'title','No permisions to edit the reservation','script'),(2870,660,'pjField',1,'title','No permisions to edit the property','script'),(2873,661,'pjField',1,'title','E-Mail address already exist','script'),(2876,662,'pjField',1,'title','Your registration was successfull. Your account needs to be approved.','script'),(2879,663,'pjField',1,'title','Your registration was successfull.','script'),(2882,664,'pjField',1,'title','GMT-03:00','script'),(2885,665,'pjField',1,'title','GMT-04:00','script'),(2888,666,'pjField',1,'title','GMT-05:00','script'),(2891,667,'pjField',1,'title','GMT-06:00','script'),(2894,668,'pjField',1,'title','GMT-07:00','script'),(2897,669,'pjField',1,'title','GMT-08:00','script'),(2900,670,'pjField',1,'title','GMT-09:00','script'),(2903,671,'pjField',1,'title','GMT-01:00','script'),(2906,672,'pjField',1,'title','GMT-10:00','script'),(2909,673,'pjField',1,'title','GMT-11:00','script'),(2912,674,'pjField',1,'title','GMT-12:00','script'),(2915,675,'pjField',1,'title','GMT-02:00','script'),(2918,676,'pjField',1,'title','GMT','script'),(2921,677,'pjField',1,'title','GMT+03:00','script'),(2924,678,'pjField',1,'title','GMT+04:00','script'),(2927,679,'pjField',1,'title','GMT+05:00','script'),(2930,680,'pjField',1,'title','GMT+06:00','script'),(2933,681,'pjField',1,'title','GMT+07:00','script'),(2936,682,'pjField',1,'title','GMT+08:00','script'),(2939,683,'pjField',1,'title','GMT+09:00','script'),(2942,684,'pjField',1,'title','GMT+01:00','script'),(2945,685,'pjField',1,'title','GMT+10:00','script'),(2948,686,'pjField',1,'title','GMT+11:00','script'),(2951,687,'pjField',1,'title','GMT+12:00','script'),(2954,688,'pjField',1,'title','GMT+13:00','script'),(2957,689,'pjField',1,'title','GMT+02:00','script'),(2960,690,'pjField',1,'title','Inactive','script'),(2963,691,'pjField',1,'title','Active','script'),(2966,692,'pjField',1,'title','No','script'),(2969,693,'pjField',1,'title','Yes','script'),(2972,758,'pjField',1,'title','Filter by','script'),(2975,759,'pjField',1,'title','Season','script'),(2978,760,'pjField',1,'title','Type','script'),(2981,764,'pjField',1,'title','Clear','script'),(2984,765,'pjField',1,'title','Filter','script'),(2987,766,'pjField',1,'title','Photo','script'),(2990,767,'pjField',1,'title','Photos','script'),(2993,832,'pjField',1,'title','Not active','script'),(2996,833,'pjField',1,'title','Sort by','script'),(2999,835,'pjField',1,'title','Show','script'),(3002,836,'pjField',1,'title','packages','script'),(3005,837,'pjField',1,'title','per page','script'),(3008,838,'pjField',1,'title','10 packages','script'),(3011,839,'pjField',1,'title','20 packages','script'),(3014,840,'pjField',1,'title','30 packages','script'),(3017,841,'pjField',1,'title','50 packages','script'),(3020,842,'pjField',1,'title','100 packages','script'),(3023,843,'pjField',1,'title','type Country and/or city','script'),(3026,844,'pjField',1,'title','top','script'),(3029,845,'pjField',1,'title','Price warning','script'),(3032,846,'pjField',1,'title','Overlapping prices can lead to unexpected results.','script'),(3035,847,'pjField',1,'title','Date/time','script'),(3038,912,'pjField',1,'title','Packages','script'),(3041,914,'pjField',1,'title','Enquiries','script'),(3044,915,'pjField',1,'title','Enquiry','script'),(3047,916,'pjField',1,'title','Comments','script'),(3050,917,'pjField',1,'title','Comment','script'),(3053,918,'pjField',1,'title','Most popular','script'),(3056,919,'pjField',1,'title','Latest enquiries','script'),(3059,920,'pjField',1,'title','Latest comments','script'),(3062,921,'pjField',1,'title','Views','script'),(3065,922,'pjField',1,'title','View','script'),(3068,923,'pjField',1,'title','No enquiry found','script'),(3071,924,'pjField',1,'title','nights','script'),(3074,925,'pjField',1,'title','night','script'),(3077,926,'pjField',1,'title','No package found.','script'),(3080,927,'pjField',1,'title','No comment found','script'),(3083,928,'pjField',1,'title','You need to add at least one type. Click {ADD_TYPE_TAG}here{ADD_TYPE_ENDTAG} to add.','script'),(3086,929,'pjField',1,'title','Flight Details','script'),(3089,930,'pjField',1,'title','If there is a flight that is available along with the package, then choose ‘Yes’ for Flight Included option and fill in the flight details and conditions. By default at the front-end will show airplane icon and ‘Flight included’ text on the package listing. If you need to change the ‘Flight included’ text then go to Settings menu -> Languages Tab, search for this front-end title and edit it.','script'),(3092,931,'pjField',1,'title','Amenities / Features','script'),(3095,932,'pjField',1,'title','You can use the pre-defined list of features below to describe in brief the accommodation amenities or package features. To manage the list with pre-defined features go to Settings menu -> Features tab.','script'),(3098,933,'pjField',1,'title','Package Owner','script'),(3101,934,'pjField',1,'title','If you have ‘Owner’ type of users into the system, then you can assign an owner to a package. If owners submit packages through their accounts then an owner and a package will be linked together automatically.','script'),(3104,935,'pjField',1,'title','SEO settings','script'),(3107,936,'pjField',1,'title','For search engines it is important that your web pages have Meta tags. These Meta tags refer to your package details page. They not only give relevant information to the search engines, but are usually used as snippets when the page appears in a search engine results page (as a result of a conducted search). So, use them to define before searchers that use Google, Yahoo or Bing what is this page for.','script'),(3110,937,'pjField',1,'title','Cancel','script'),(3113,938,'pjField',1,'title','Optional','script'),(3119,940,'pjField',1,'title','Follow these steps to turn on the SEO URL module and have search engine friendly URLs for your package details pages.','script'),(3122,941,'pjField',1,'title','Step 1. Create a file named \".htaccess\" in the same directory where your .php page with package listing is. Then copy and paste the following code into the file.','script'),(3125,942,'pjField',1,'title','(Optional) If you are experiencing problems with styling (CSS) put the following code into the HEAD part of your web page.','script'),(3128,943,'pjField',1,'title','Show all','script'),(3131,944,'pjField',1,'title','Show less','script'),(3134,945,'pjField',1,'title','review','script'),(3137,946,'pjField',1,'title','Aenean sollicitudin, lorem quis bibendum auctor, nisi elit consequat ipsum, nec sagittis sem nibh id elit. Duis sed odio sit amet nibh vulputate cursus a sit amet mauris. Morbi accumsan ipsum velit. Nam nec tellus a odio tincidunt auctor a ornare odio. Sed non  mauris vitae erat consequat auctor eu in elit. ','script'),(3140,947,'pjField',1,'title','Aenean sollicitudin, lorem quis bibendum auctor, nisi elit consequat ipsum, nec sagittis sem nibh id elit. Duis sed odio sit amet nibh vulputate cursus a sit amet mauris. Morbi accumsan ipsum velit. Nam nec tellus a odio tincidunt auctor a ornare odio. Sed non  mauris vitae erat consequat auctor eu in elit. ','script'),(3143,948,'pjField',1,'title','Forgot password?','script'),(3146,949,'pjField',1,'title','Aenean sollicitudin, lorem quis bibendum auctor, nisi elit consequat ipsum, nec sagittis sem nibh id elit. Duis sed odio sit amet nibh vulputate cursus a sit amet mauris. Morbi accumsan ipsum velit. Nam nec tellus a odio tincidunt auctor a ornare odio. Sed non mauris vitae erat consequat auctor eu in elit. ','script'),(3149,950,'pjField',1,'title','Send','script'),(3152,951,'pjField',1,'title','Forgot password email','script'),(3155,952,'pjField',1,'title','Available tokens:{Password} - Password','script'),(3158,953,'pjField',1,'title','Email is missing.','script'),(3161,954,'pjField',1,'title','Email cannot be empty.','script'),(3164,955,'pjField',1,'title','Email is not valid.','script'),(3167,956,'pjField',1,'title','Email does not exist.','script'),(3170,957,'pjField',1,'title','The password has been sent to you email.','script'),(3173,958,'pjField',1,'title','ID','script'),(3176,959,'pjField',1,'title','(empty date)','script'),(3179,960,'pjField',1,'title','(invalid date)','script'),(3182,961,'pjField',1,'title','(empty date time)','script'),(3185,962,'pjField',1,'title','(invalid date time)','script'),(3188,963,'pjField',1,'title','The system auto fills a random ID. You can replace it with an ID of your choice any time.','script'),(3191,964,'pjField',1,'title','Featured packages go at the top of Holiday Packages listing page and have a \"Featured\" badge. They are also displayed at Featured Holidays Packages section on Home page.','script'),(3194,965,'pjField',1,'title','Choose Yes/No to show/hide the owner contact information on the package details page.','script'),(3197,966,'pjField',1,'title','Note that the city you enter will be used on Filter by Location autofill filter field at the front-end. Keep the same cites written consistently. ‘NY’ and ‘New York’ are recognized as two different cities by the system.','script'),(3200,967,'pjField',1,'title','Give a title to your package details web page. For search engines it is highly recommended to have nice, descriptive title with your main keyword phrase. It will also appear in browser headers.','script'),(3203,968,'pjField',1,'title','This meta tag has lost its importance. You can leave it empty or use it to lit your keywords. Use comma to separate you keyword phrases.','script'),(3206,969,'pjField',1,'title','Write a short description of your holiday package. It is best if you limit your description to 160 characters (with the spaces).','script'),(3209,970,'pjField',1,'title','that will show on all website and admin panel calendars and date pickers.','script'),(3212,971,'pjField',1,'title','that will show on all website and admin panel calendars and date pickers.','script'),(3215,972,'pjField',1,'title','Set the default currency for the whole system (front-end and admin panel).','script'),(3218,973,'pjField',1,'title','This email will be sent to owners, right after someone sends an enquiry about their package. If there is no owner assigned to a package this email notification will be send to the admin.','script'),(3221,974,'pjField',1,'title','This email will be sent to owners, right after someone posts a comment about their package. If there is no owner assigned to a package this email notification will be send to the admin.','script'),(3224,975,'pjField',1,'title','This email notification will be sent to the system admin, right after an owner registers a new account.','script'),(3227,976,'pjField',1,'title','This email will be sent to anyone who has requested a password recovery.','script'),(3230,977,'pjField',1,'title','Unlimited','script'),(3233,978,'pjField',1,'title','Set the email which users will see when they receive emails from the system. Go to Emails menu to manage automated email notifications.','script'),(3236,979,'pjField',1,'title','If you choose \'Yes\' new owner accounts will be active immediately after they are created. If you choose \'No\' you will have to activate new accounts manually (through Users menu), and after that owners will be able to log in and use them.','script'),(3239,980,'pjField',1,'title','Manage system users','script'),(3242,981,'pjField',1,'title','There are 3 user roles with different access rights. \'Admins\' have full access to the system admin panel. \'Editors\' have limited access. Editors cannot set the general and submission website options; they do not have an access to the Translate and Backup menus; and they cannot manage admin and other editors\'\' user accounts. \'Owners\' can add and manage only their packages and the comments and enquiries received about them. Through Settings menu -> Submissions tab you can allow/disallow owners to register and create accounts through the front-end.','script'),(3245,982,'pjField',1,'title','Add new package','script'),(3248,1000,'pjField',1,'title','Start submitting your package with choosing its type and reference ID. Both of them are mandatory fields. The system assigns a Reference ID automatically, but you can edit it anytime.','script'),(3251,1001,'pjField',1,'title','Package Summary','script'),(3254,1002,'pjField',1,'title','Pay attention to Expire date status. If it says ‘Not active’ then your package is not published on the website listing yet. Click on ‘Publish’ button and choose the appropriate submission period for you. If there is a specific date as a status, then your package will be live on the website listing till that date. You can extend that period by clicking on ‘Extend expire date’ button. If the status says ‘Unlimited’, then the package will be live until not deleted.','script'),(3257,1003,'pjField',1,'title','Flight Details','script'),(3260,1004,'pjField',1,'title','If there is a flight that is available along with the package, then choose ‘Yes’ for Flight Included option and fill in the flight details and conditions.','script'),(3263,1005,'pjField',1,'title','Amenities / Features','script'),(3266,1006,'pjField',1,'title','You can use the pre-defined list of features below to describe in brief the accommodation amenities or package features.','script'),(3269,1007,'pjField',1,'title','Package Owner','script'),(3272,1008,'pjField',1,'title','Choose whether you wish to show your contact detail on package details page or not. You can edit your contact details on Profile menu.','script'),(3275,1009,'pjField',1,'title','Email notifications','script'),(3278,1010,'pjField',1,'title','The system will send email notifications automatically in some cases as defined below. Use the available tokens and manage the emails’ subjects and messages to personalize them. For your convenience we have set default messages, which we highly recommend to be customized.','script'),(3281,1,'pjNotification',1,'confirm_subject','New enquiry has been received','script'),(3282,1,'pjNotification',1,'confirm_message','Dear {OwnerName},\r\n\r\nYou have just received the following enquiry for {ListingID} package:\r\n\r\nEnquiry ID : {EnquiryID}\r\nFrom: {FullName}\r\nE-mail: {Email}\r\nPhone number: {Phone}\r\nAbout: {ListingTitle}, {ListingID} package\r\nCheck-in date: {StartDate}\r\nCheck-out date: {EndDate}\r\nNotes: {Notes}\r\n\r\nThanks.\r\n','script'),(3283,1,'pjNotification',1,'notify_subject','New vacation package comment has been received','script'),(3284,1,'pjNotification',1,'notify_message','Dear {OwnerName},\r\n\r\nA new comment about your {RefID} vacation package has been just posted.\r\n\r\nFrom: {Name}\r\nE-mail: {Email} \r\nAbout: {ListingTitle}, {RefID} package\r\nRating: {Rating}\r\nComment Title: {Title}\r\nComment: {Comment}\r\n\r\nThanks.\r\n\r\n','script'),(3285,1,'pjNotification',1,'new_account_subject','New owner account was created','script'),(3286,1,'pjNotification',1,'new_account_message','Dear admin,\r\n\r\nA new owner account was just registered by:\r\nName: {Name}\r\nEmail: {Email}\r\n\r\nGo to the admin panel for more details and if activation/d?activation is needed.\r\n\r\nThanks.','script'),(3287,1,'pjNotification',1,'forgot_subject','Password recovery','script'),(3288,1,'pjNotification',1,'forgot_message','Dear,\r\n\r\nWe have received a password recovery request by this email. Please, find below your password:\r\n\r\nPassword: {Password}\r\n\r\nThanks.','script'),(3437,1081,'pjField',1,'title','reviews','script'),(3440,1082,'pjField',1,'title','View All Reviews','script'),(3443,1083,'pjField',1,'title','type Country and/or city','script'),(3446,1084,'pjField',1,'title','Integration method','script'),(3449,1085,'pjField',1,'title','All languages on 1 page','script'),(3452,1086,'pjField',1,'title','Each language on separate page','script'),(3455,1087,'pjField',1,'title','If the number of the packages marked as featured is bigger than the one set here, then they will show on random basis in the Featured Packages listing.','script'),(3458,1089,'pjField',1,'title','Comment is missing.','script'),(3461,1090,'pjField',1,'title','Comment cannot be empty.','script'),(3719,1160,'pjField',1,'title','Website Pages','script'),(3722,1161,'pjField',1,'title','Destinations','script'),(3725,1162,'pjField',1,'title','Home Page Slides','script'),(3728,1163,'pjField',1,'title','Add destination','script'),(3731,1164,'pjField',1,'title','Country','script'),(3734,1165,'pjField',1,'title','Description','script'),(3737,1166,'pjField',1,'title','Name','script'),(3746,1167,'pjField',1,'title','Update destination','script'),(3761,1168,'pjField',1,'title','All','script'),(3782,1169,'pjField',1,'title','Destination not found.','script'),(3785,1170,'pjField',1,'title','All the changes made to this destination have been saved.','script'),(3788,1171,'pjField',1,'title','All the changes made to this destination have been saved.','script'),(3791,1172,'pjField',1,'title','We are sorry, but the destination has not been added.','script'),(3794,1173,'pjField',1,'title','Destination you\'re looking for is missing.','script'),(3797,1174,'pjField',1,'title','Destination updated!','script'),(3800,1175,'pjField',1,'title','Destination added!','script'),(3803,1176,'pjField',1,'title','Destination failed to add.','script'),(3806,1177,'pjField',1,'title','Manage destinations list','script'),(3809,1178,'pjField',1,'title','Review and manage all Destination pages. You can show a quick link to a destination page on website home page by setting its ‘Show on home’ option to ‘Yes’. You can make a destination page ‘Inactive’, which will hide it from the website menu, while you keep the page data here at the back-end.','script'),(3812,1179,'pjField',1,'title','Add new destination.','script'),(3815,1180,'pjField',1,'title','Use the form below to add new destination page. Use the ‘Description’ editor to add text, images, video, links and tables to the page content. You will also be able to upload a primary image to your page after you create new destination. The ‘Title’ field text will be uploaded over that primary image and they both together will form the page header. The system will create SEO friendly URL for this page using the ‘Name’ of the destination. You can edit this URL for optimizing your SEO efforts. Use also ‘Meta title’ and ‘Meta description’ fields to add page Meta tags and strengthen your SEO. If you have multi language website, do not forget to fill in the data in all languages.','script'),(3818,1181,'pjField',1,'title','Update a destination.','script'),(3821,1182,'pjField',1,'title','Use the form below to update this destination page. Primary image size is limited to 705 x 355px. If your image is bigger than this you’ll be able to crop it during upload. Use the ‘Description’ editor to add text, images, video, links and tables to the page content. The ‘Title’ field text will be uploaded over that primary image and they both together will form the page header. You can edit the automated page URL for optimizing your SEO efforts. Use also ‘Meta title’ and ‘Meta description’ fields to add page Meta tags and strengthen your SEO. If you have multi language website, do not forget to fill in the data in all languages.','script'),(3824,1183,'pjField',1,'title','Add page','script'),(3827,1184,'pjField',1,'title','Update page','script'),(3830,1185,'pjField',1,'title','Description','script'),(3833,1186,'pjField',1,'title','Use the form below to update your website page. Primary image size is limited to 705 x 355px. If your image is bigger than this you’ll be able to crop it during upload. You can rename your page by editing the ‘Name’ field. This will change the page title on the website menu too. The system creates SEO friendly URL for this page using the ‘Name’ of the page. You can edit the automated page URL for optimizing your SEO efforts. Use the ‘Description’ editor to add text, images, video, links and tables to the page content. The ‘Title’ field text will be uploaded over that primary image and they both together will form the page header. Use also ‘Meta title’ and ‘Meta description’ fields to add page Meta tags and strengthen your SEO. If you have multi language website, do not forget to fill in the data in all languages.','script'),(3836,1187,'pjField',1,'title','Update a page.','script'),(3839,1188,'pjField',1,'title','Use form below to add a page.','script'),(3842,1189,'pjField',1,'title','Add a page.','script'),(3845,1190,'pjField',1,'title','You can fully edit your content website pages. You cannot add or delete pages, but you can change their names, URLs and content. You can also hide a page from the website front-end by changing its status to ‘Incative’.','script'),(3848,1191,'pjField',1,'title','Manage website pages','script'),(3851,1192,'pjField',1,'title','Page not found.','script'),(3854,1193,'pjField',1,'title','Page failed to add.','script'),(3857,1194,'pjField',1,'title','Page added!','script'),(3860,1195,'pjField',1,'title','Page updated!','script'),(3863,1196,'pjField',1,'title','Page you\'re looking for is missing.','script'),(3866,1197,'pjField',1,'title','We are sorry, but the page has not been added.','script'),(3869,1198,'pjField',1,'title','All the changes made to this page have been saved.','script'),(3872,1199,'pjField',1,'title','All the changes made to this page have been saved.','script'),(3875,1200,'pjField',1,'title','Meta title','script'),(3878,1201,'pjField',1,'title','Meta description','script'),(3881,1202,'pjField',1,'title','Name','script'),(3884,1203,'pjField',1,'title','Seo URL','script'),(3923,1204,'pjField',1,'title','Add new slide','script'),(3926,1205,'pjField',1,'title','Update slide','script'),(3929,1206,'pjField',1,'title','Sort','script'),(3932,1207,'pjField',1,'title','Ad Image','script'),(3935,1208,'pjField',1,'title','URL','script'),(3938,1209,'pjField',1,'title','Target','script'),(3941,1210,'pjField',1,'title','Title','script'),(3944,1211,'pjField',1,'title','Description','script'),(3947,1212,'pjField',1,'title','New window','script'),(3950,1213,'pjField',1,'title','Same window','script'),(3959,1214,'pjField',1,'title','Use the form below to update your slide ad. The ad image size is limited to 291 x 302 px. If your image is bigger than this you’ll be able to crop it during upload. You can specify a destination URL which will open if website visitors click on the ad. This URL might be from your website or from other website. If you leave the ‘URL’ field empty, visitors will not be able to click on your ad, but only view it. Beware from having multiple slide ads with same sort number. If you have multi language website, do not forget to fill in the data in all languages. You can specify different URL address for each language.','script'),(3962,1215,'pjField',1,'title','Slide failed to add.','script'),(3965,1216,'pjField',1,'title','Manage home page slides','script'),(3968,1217,'pjField',1,'title','Below you will find a list with all slide ads on your home page. You can add unlimited number of ads and order them. However, we recommend keeping the number of slides that show on your home page less than 8. This will prevent from slowing down the page load. You can prevent a slide from showing on your home page without entirely deleting it by changing its status to ‘Inactive’.','script'),(3971,1218,'pjField',1,'title','Add a home page slide','script'),(3974,1219,'pjField',1,'title','Use the form below to add new slide on your home page. The ad image size is limited to 291 x 302 px. If your image is bigger than this you’ll be able to crop it during upload. You can specify a destination URL which will open if website visitors click on the ad. This URL might be from your website or from other website. If you leave the ‘URL’ field empty, visitors will not be able to click on your ad, but only view it. Beware from having multiple slide ads with same sort number. If you have multi language website, do not forget to fill in the data in all languages. You can specify different URL address for each language.','script'),(3977,1220,'pjField',1,'title','Update a slide ad','script'),(3980,1221,'pjField',1,'title','Slide not found.','script'),(3983,1222,'pjField',1,'title','All the changes made to this slide have been saved.','script'),(3986,1223,'pjField',1,'title','All the changes made to this slide have been saved.','script'),(3989,1224,'pjField',1,'title','We are sorry, but the slide has not been added.','script'),(3992,1225,'pjField',1,'title','Slide you\'re looking for is missing.','script'),(3995,1226,'pjField',1,'title','Slide updated!','script'),(3998,1227,'pjField',1,'title','Slide added!','script'),(4025,1228,'pjField',1,'title','Delete image confirmation','script'),(4028,1229,'pjField',1,'title','Are you sure you want to delete selected image?','script'),(4043,1230,'pjField',1,'title','Crop image','script'),(4401,1231,'pjField',1,'title','Seo URL','script'),(4500,1232,'pjField',1,'title','Show on Home','script'),(4503,1233,'pjField',1,'title','Yes','script'),(4506,1234,'pjField',1,'title','No','script'),(4857,1235,'pjField',1,'title','Best deals packages are presented at special Best Deals page and on Holiday Packages page. They are marked with discount badges. Best Deals packages will be also displayed at Best Deals section on Home page if you choose \"Yes (listed on home)\" option.','script'),(4860,1236,'pjField',1,'title','Make Best deal','script'),(4863,1237,'pjField',1,'title','All','script'),(4974,1238,'pjField',1,'title','Best Deal','script'),(5085,1239,'pjField',1,'title','Night','script'),(5088,1240,'pjField',1,'title','Contact Form email','script'),(5091,1241,'pjField',1,'title','Available tokens:{Name} - Name{Email} - Email{Phone} - Phone{Question} - Question{IP} - IP address','script'),(5094,1242,'pjField',1,'title','This email will be sent to administrator.','script'),(5108,1,'pjNotification',1,'contact_subject','Contact form','script'),(5109,1,'pjNotification',1,'contact_message','Name: {Name}\r\nEmail: {Email}\r\nPhone: {Phone}\r\nQuestion: {Question}\r\n\r\nIP: {IP}','script'),(5130,1243,'pjField',1,'title','Primary Image','script'),(5163,1244,'pjField',1,'title','Primary Image','script'),(5418,1245,'pjField',1,'title','Title','script'),(5691,1246,'pjField',1,'title','Title','script'),(5695,1,'pjPage',1,'title','About Us Page Title - goes here','script'),(5710,3,'pjPage',1,'title','Terms of Use - Page Title Goes Here','script'),(5725,2,'pjPage',1,'title','Destinations Page Title - Lorem ipsum dolor sit amet','script'),(5739,1247,'pjField',1,'title','Facebook fan page','script'),(5742,1248,'pjField',1,'title','Twitter account','script'),(5745,1249,'pjField',1,'title','Subscribers','script'),(5748,1250,'pjField',1,'title','Add subscriber','script'),(5751,1251,'pjField',1,'title','Update subscriber','script'),(5754,1252,'pjField',1,'title','Email','script'),(5757,1253,'pjField',1,'title','Subscribed at','script'),(5760,1254,'pjField',1,'title','Unsubscribed at','script'),(5763,1255,'pjField',1,'title','Is subscribed','script'),(5775,1256,'pjField',1,'title','All the changes made to this subscription have been saved.','script'),(5778,1257,'pjField',1,'title','All the changes made to this subscription have been saved.','script'),(5781,1258,'pjField',1,'title','We are sorry, but the subscription has not been added.','script'),(5784,1259,'pjField',1,'title','Subscription you\'re looking for is missing.','script'),(5787,1260,'pjField',1,'title','Below you will find a list with all subscribers\" emails. You can export this list and use it for sending your newsletter. You can export the whole list using the \"Export All\" button. You can also export only chosen by you subscribers. To do so, you need to select them first and then choose \"Export\" option on \"Choose Action\" drop-down at the bottom of the list. Both ways a csv file will be generated.','script'),(5790,1261,'pjField',1,'title','Use form below to add a subscriber.','script'),(5793,1262,'pjField',1,'title','Use form below to update a subscriber.','script'),(5796,1263,'pjField',1,'title','Update a subscriber.','script'),(5799,1264,'pjField',1,'title','Subscription updated!','script'),(5802,1265,'pjField',1,'title','Subscription added!','script'),(5805,1266,'pjField',1,'title','Subscription failed to add.','script'),(5808,1267,'pjField',1,'title','Subscription not found.','script'),(5811,1268,'pjField',1,'title','Subscriber\'s list','script'),(5814,1269,'pjField',1,'title','Add a subscriber.','script'),(5817,1270,'pjField',1,'title','We are sorry, but the email address is already in use.','script'),(5820,1271,'pjField',1,'title','Email address warning','script'),(7533,1396,'pjField',1,'title','Banner failed to add.','script'),(7536,1397,'pjField',1,'title','Banner not found.','script'),(7539,1398,'pjField',1,'title','All the changes made to this banner have been saved.','script'),(7542,1399,'pjField',1,'title','All the changes made to this banner have been saved.','script'),(7545,1400,'pjField',1,'title','We are sorry, but the banner has not been added.','script'),(7548,1401,'pjField',1,'title','Banner you\'re looking for is missing.','script'),(7551,1402,'pjField',1,'title','Banner updated!','script'),(7554,1403,'pjField',1,'title','Banner added!','script'),(7557,1404,'pjField',1,'title','Use the form below to update your banner. If you have multi language website, do not forget to fill in the data in all languages.','script'),(7560,1405,'pjField',1,'title','Manage banner placeholder','script'),(7563,1406,'pjField',1,'title','You can add unlimited number of banners to your banner placeholder on website home page. They will rotate randomly of home page load. If you do not want to have banner on you home page, just delete all banners and leave the list empty.','script'),(7566,1407,'pjField',1,'title','Add new banner','script'),(7569,1408,'pjField',1,'title','Use the form below to add new banner. You can choose between HTML code and Image format banner. You can upload different banner for each language version you use.','script'),(7572,1409,'pjField',1,'title','Update a banner','script'),(7575,1410,'pjField',1,'title','Add banner','script'),(7578,1411,'pjField',1,'title','Update banner','script'),(7581,1412,'pjField',1,'title','URL','script'),(7584,1413,'pjField',1,'title','Target','script'),(7587,1414,'pjField',1,'title','Banners','script'),(7590,1415,'pjField',1,'title','Type','script'),(7593,1416,'pjField',1,'title','Image (JPG, PNG, GIF)','script'),(7599,1418,'pjField',1,'title','HTML code (Iframe, Javascript, etc.)','script'),(7608,1419,'pjField',1,'title','HTML code','script'),(7611,1420,'pjField',1,'title','Image','script'),(7614,1421,'pjField',1,'title','Content','script'),(7617,1422,'pjField',1,'title','Image ALT attribute','script'),(7620,1423,'pjField',1,'title','Image TITLE attribute','script'),(7635,1424,'pjField',1,'title','Your question have been sent successfully. Thank you!','script'),(7638,1425,'pjField',1,'title','System message','script'),(7644,1426,'pjField',1,'title','System message','script'),(7647,1427,'pjField',1,'title','Your question have not been sent. Please try again later.','script'),(7650,1428,'pjField',1,'title','System message','script'),(7653,1429,'pjField',1,'title','Missing, empty or invalid parameters.','script'),(7656,1430,'pjField',1,'title','System message','script'),(7659,1431,'pjField',1,'title','Sorry, but the submissions are not allowed.','script'),(7662,1432,'pjField',1,'title','System message','script'),(7665,1433,'pjField',1,'title','The password have been sent to your email address. Thank you.','script'),(7668,1434,'pjField',1,'title','System message','script'),(7671,1435,'pjField',1,'title','Sorry, we have a problem with sending your password. Please try again later.','script'),(7674,1436,'pjField',1,'title','System message','script'),(7677,1437,'pjField',1,'title','Missing, empty or invalid parameters.','script'),(7680,1438,'pjField',1,'title','System message','script'),(7683,1439,'pjField',1,'title','Unexpected problem occurred, please report it to the site owner.','script'),(7689,1440,'pjField',1,'title','System message','script'),(7692,1441,'pjField',1,'title','Account not found for the given email address.','script'),(7698,1442,'pjField',1,'title','System message','script'),(7701,1443,'pjField',1,'title','You have been registered successfully. Thank you.','script'),(7704,1444,'pjField',1,'title','System message','script'),(7707,1445,'pjField',1,'title','You have been registered successfully, but for some reason the confirmation email failed to sent.','script'),(7710,1446,'pjField',1,'title','Missing, empty or invalid parameters.','script'),(7713,1447,'pjField',1,'title','System message','script'),(7716,1448,'pjField',1,'title','System message','script'),(7719,1449,'pjField',1,'title','System message','script'),(7722,1450,'pjField',1,'title','The given email address is already taken. Please use another email address.','script'),(7725,1451,'pjField',1,'title','You have not been registered. Please try again later.','script'),(7728,1452,'pjField',1,'title','System message','script'),(7731,1453,'pjField',1,'title','You have been registered successfully, but an unexpected error occurs when trying to send confirmation email.','script'),(8595,1482,'pjField',1,'title','Logo','script'),(8601,1483,'pjField',1,'title','Image TITLE attribute','script'),(8604,1484,'pjField',1,'title','Logo image ALT attribute','script'),(8607,1485,'pjField',1,'title','Image','script'),(8610,1,'pjOption',1,'title','Travel website','script'),(8611,1,'pjOption',1,'alt','Find your holiday home!','script'),(8616,1486,'pjField',1,'title','Yes','script'),(8619,1487,'pjField',1,'title','No','script'),(8622,1488,'pjField',1,'title','Yes (list on home page)','script'),(9741,1,'pjPage',1,'name','About Us','script'),(9743,1,'pjPage',1,'full_desc','<p>&nbsp;</p>\r\n<p><span style=\"font-weight: bold;\">Proin ante sapien, porta eu malesuada vitae, pulvinar eget erat.</span></p>\r\n<p>&nbsp;</p>\r\n<p>Proin ante sapien, porta eu malesuada vitae, pulvinar eget erat. Fusce eget orci ut erat sollicitudin venenatis quis quis lacus. Nullam feugiat risus quis diam interdum cursus. Donec quis sem vel felis consectetur adipiscing nec sed orci. Maecenas eget mi id turpis tempor vehicula.</p>\r\n<p>&nbsp;</p>\r\n<p>Proin ante sapien, porta eu malesuada vitae, pulvinar eget erat. Fusce eget orci ut erat sollicitudin venenatis quis quis lacus. Nullam feugiat risus quis diam interdum cursus. Donec quis sem vel felis consectetur adipiscing nec sed orci. Maecenas eget mi id turpis tempor vehicula.</p>\r\n<p>&nbsp;</p>\r\n<p>Proin ante sapien, porta eu malesuada vitae, pulvinar eget erat. Fusce eget orci ut erat sollicitudin venenatis quis quis lacus. Nullam feugiat risus quis diam interdum cursus. Donec quis sem vel felis consectetur adipiscing nec sed orci. Maecenas eget mi id turpis tempor vehicula.</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<table style=\"height: 82px;\" width=\"498\">\r\n<tbody>\r\n<tr>\r\n<td>\r\n<p><span style=\"font-size: 11pt; font-weight: bold;\">Lorem ipsum dolor sit amet.</span></p>\r\n<p>&nbsp;</p>\r\n<p><span style=\"font-weight: bold;\">Proin ante sapien, porta eu malesuada vitae, pulvinar eget erat.</span></p>\r\n<p>&nbsp;</p>\r\nProin ante sapien, porta eu malesuada vitae, pulvinar eget erat. Fusce eget orci ut erat sollicitudin venenatis quis quis lacus. Nullam feugiat risus quis diam interdum cursus. Donec quis sem vel felis consectetur adipiscing nec sed orci. Maecenas eget mi id turpis tempor vehicula.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>\r\n<td>&nbsp;<img src=\"app/web/upload/tinymce-source/About us iamge small.jpg\" alt=\"\" width=\"338\" height=\"241\" /></td>\r\n</tr>\r\n<tr>\r\n<td>&nbsp;\r\n<p><span style=\"font-size: 11pt; font-weight: bold;\">Lorem ipsum dolor sit amet.</span></p>\r\n<p>&nbsp;</p>\r\n<p><span style=\"font-weight: bold;\">Proin ante sapien, porta eu malesuada vitae, pulvinar eget erat.</span></p>\r\n<p>&nbsp;</p>\r\nProin ante sapien, porta eu malesuada vitae, pulvinar eget erat. Fusce eget orci ut erat sollicitudin venenatis quis quis lacus. Nullam feugiat risus quis diam interdum cursus. Donec quis sem vel felis consectetur adipiscing nec sed orci. Maecenas eget mi id turpis tempor vehicula.</td>\r\n<td>&nbsp; <img src=\"app/web/upload/tinymce-source/About us iamge small.jpg\" alt=\"\" width=\"338\" height=\"241\" /></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>','script'),(9744,1,'pjPage',1,'meta_title','About Us | Travel Agency','script'),(9745,1,'pjPage',1,'meta_desc','About us page meta description text goes here.','script'),(9786,2,'pjPage',1,'name','Destinations','script'),(9788,2,'pjPage',1,'full_desc','<p>&nbsp;</p>\r\n<p><span style=\"font-weight: bold; font-size: 11pt;\">Lorem ipsum dolor sit amet, consectetur adipiscing elit.</span></p>\r\n<p>&nbsp;</p>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc malesuada accumsan luctus. Sed consequat fermentum metus, eu accumsan mi. Nullam a diam sit amet purus tincidunt volutpat. Donec ante nunc, gravida sed congue sit amet, ultrices sed turpis. Etiam congue sed urna vel vestibulum. Ut tempus faucibus luctus.</p>\r\n<p>&nbsp;</p>\r\n<p>Proin posuere nulla commodo diam suscipit congue. Vivamus pulvinar sed odio non fringilla. Aliquam enim ante, lobortis non enim eget, fringilla fermentum leo. Vestibulum lacus erat, porta at aliquam eget, aliquam id ligula. Vivamus lobortis consequat felis, sit amet facilisis velit rhoncus vitae. Nunc consequat, purus ut sagittis mollis, diam magna consequat risus, in sagittis felis leo vel diam. Nulla laoreet sollicitudin magna, sit amet gravida mauris.</p>\r\n<p>&nbsp;</p>\r\n<table style=\"height: 82px;\" width=\"498\">\r\n<tbody>\r\n<tr>\r\n<td>\r\n<p><span style=\"font-size: 11pt; font-weight: bold;\">Lorem ipsum dolor sit amet.</span></p>\r\n<p>&nbsp;</p>\r\n<p><span style=\"font-weight: bold;\">Proin ante sapien, porta eu malesuada vitae, pulvinar eget erat.</span></p>\r\n<p>&nbsp;</p>\r\nProin ante sapien, porta eu malesuada vitae, pulvinar eget erat. Fusce eget orci ut erat sollicitudin venenatis quis quis lacus. Nullam feugiat risus quis diam interdum cursus. Donec quis sem vel felis consectetur adipiscing nec sed orci. Maecenas eget mi id turpis tempor vehicula.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>\r\n<td>&nbsp;<img src=\"app/web/upload/tinymce-source/About us iamge small.jpg\" alt=\"\" width=\"338\" height=\"241\" /></td>\r\n</tr>\r\n<tr>\r\n<td>&nbsp;\r\n<p><span style=\"font-size: 11pt; font-weight: bold;\">Lorem ipsum dolor sit amet.</span></p>\r\n<p>&nbsp;</p>\r\n<p><span style=\"font-weight: bold;\">Proin ante sapien, porta eu malesuada vitae, pulvinar eget erat.</span></p>\r\n<p>&nbsp;</p>\r\nProin ante sapien, porta eu malesuada vitae, pulvinar eget erat. Fusce eget orci ut erat sollicitudin venenatis quis quis lacus. Nullam feugiat risus quis diam interdum cursus. Donec quis sem vel felis consectetur adipiscing nec sed orci. Maecenas eget mi id turpis tempor vehicula.</td>\r\n<td>&nbsp; <img src=\"app/web/upload/tinymce-source/Hawai - small 2.jpg\" alt=\"\" width=\"338\" height=\"241\" /></td>\r\n</tr>\r\n</tbody>\r\n</table>','script'),(9789,2,'pjPage',1,'meta_title','Destinations Page Meta Title','script'),(9790,2,'pjPage',1,'meta_desc','Destinations page meta description text.','script'),(9816,3,'pjPage',1,'name','Terms of Use','script'),(9818,3,'pjPage',1,'full_desc','<div id=\"lipsum\">\r\n<p>&nbsp;</p>\r\n<p><span style=\"font-weight: bold;\">Pellentesque volutpat sit amet sapien nec sagittis.</span></p>\r\n<p>&nbsp;</p>\r\n<p>Pellentesque volutpat sit amet sapien nec sagittis. Morbi malesuada ullamcorper turpis, vel aliquet dui tristique ac. Sed nunc nisi, vehicula ut lorem a, molestie semper risus. Nulla vehicula bibendum erat a facilisis. Curabitur tempor elit quis dapibus aliquet. Aliquam id quam vel dolor vehicula facilisis. Suspendisse eu arcu ac mi cursus consequat.</p>\r\n<p>&nbsp;</p>\r\n<p>Etiam hendrerit diam suscipit neque dignissim, in aliquam magna feugiat. Nullam eu consequat felis. Curabitur lacinia lectus non neque cursus tempus. Curabitur sit amet nulla adipiscing, porta metus nec, adipiscing quam.</p>\r\n<p>&nbsp;</p>\r\n<p>Sed nec magna interdum dui bibendum luctus. Duis nec sapien velit. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Nam placerat libero at quam dignissim, non fringilla ante interdum.</p>\r\n<p>&nbsp;</p>\r\n<p>Aliquam lobortis, est a luctus luctus, risus neque ullamcorper ligula, pharetra adipiscing purus orci condimentum velit. Quisque molestie porta elementum. Integer eleifend consectetur quam. Vestibulum vitae nulla nulla.</p>\r\n<p>&nbsp;</p>\r\n<p>Suspendisse pharetra, leo ut luctus commodo, diam leo laoreet leo, eu aliquam neque sem nec est.</p>\r\n</div>','script'),(9819,3,'pjPage',1,'meta_title','Terms Of Use |Travel Agency Website','script'),(9820,3,'pjPage',1,'meta_desc','Terms Of Use meta description.','script'),(9927,1695,'pjField',1,'title','Phone is required.','script'),(9930,1696,'pjField',1,'title','Question is required.','script'),(9933,1697,'pjField',1,'title','Click to reload captcha','script'),(9942,1699,'pjField',1,'title','Question','script'),(9945,1700,'pjField',1,'title','Aenean sollicitudin, lorem quis bibendum auctor, nisi elit consequat ipsum, nec sagittis sem nibh id elit. Duis sed odio sit amet nibh vulputate cursus a sit amet mauris. Morbi accumsan ipsum velit. Nam nec tellus a odio tincidunt auctor a ornare odio. Sed non  mauris vitae erat consequat auctor eu in elit. ','script'),(9948,1701,'pjField',1,'title','Contact Us','script'),(9951,1702,'pjField',1,'title','Home','script'),(9954,1703,'pjField',1,'title','Holiday Packages','script'),(9957,1704,'pjField',1,'title','Best Deals','script'),(9960,1706,'pjField',1,'title','Destinations','script'),(9963,1707,'pjField',1,'title','About Us','script'),(9966,1708,'pjField',1,'title','Contact','script'),(9972,1709,'pjField',1,'title','Subscribe','script'),(9975,1710,'pjField',1,'title','Subscribe to our FREE WEEKLY NEWSLETTER!','script'),(9978,1711,'pjField',1,'title','Type your email address','script'),(9981,1712,'pjField',1,'title','Follow us on Facebook','script'),(9984,1713,'pjField',1,'title','Follow us on Twitter','script'),(9987,1714,'pjField',1,'title','Company, LLC. All rights reserved.','script'),(9990,1715,'pjField',1,'title','Terms of Use','script'),(10023,1716,'pjField',1,'title','Select destination','script'),(10026,1717,'pjField',1,'title','Most popular destinations','script'),(10029,1718,'pjField',1,'title','Best deals','script'),(10032,1719,'pjField',1,'title','Featured holiday packages','script'),(10035,1720,'pjField',1,'title','Find Your Holiday','script'),(10038,1721,'pjField',1,'title','Price to filter','script'),(10077,1722,'pjField',1,'title','from','script'),(10110,1723,'pjField',1,'title','Grid view','script'),(10113,1724,'pjField',1,'title','List view','script'),(10116,1725,'pjField',1,'title','Map view','script'),(10119,1726,'pjField',1,'title','Notes is required.','script'),(10122,1727,'pjField',1,'title','Title is required.','script'),(10125,1728,'pjField',1,'title','Please enter at least 6 characters.','script'),(10131,1729,'pjField',1,'title','Please enter no more than 6 characters.','script'),(10134,1730,'pjField',1,'title','Date From is required.','script'),(10137,1731,'pjField',1,'title','Date To is required.','script'),(10182,1732,'pjField',1,'title','Notice','script'),(10185,1733,'pjField',1,'title','Best Deals default view','script'),(10191,1734,'pjField',1,'title','Holiday Packages default view','script'),(10197,1735,'pjField',1,'title','This website works best with JavaScript enabled','script'),(10200,1736,'pjField',1,'title','Menu','script'),(12066,1,'pjType',1,'name','Family Sun & Beach','data'),(12069,2,'pjType',1,'name','Beach & Party','data'),(12072,3,'pjType',1,'name','SPA & Wellness','data'),(12075,4,'pjType',1,'name','Ski Resorts','data'),(12078,5,'pjType',1,'name','Must See Cities','data'),(15008,1,'pjDestination',1,'name','Paris','data'),(15009,1,'pjDestination',1,'title','Paris The City of Lovers','data'),(15010,1,'pjDestination',1,'full_desc','<p>&nbsp;</p>\r\n<p><span style=\"font-weight: bold; font-size: 11pt;\">Lorem ipsum dolor sit amet, consectetur adipisicing elit.</span></p>\r\n<p>&nbsp;</p>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<table style=\"height: 82px;\" width=\"498\">\r\n<tbody>\r\n<tr>\r\n<td>\r\n<p><span style=\"font-size: 11pt; font-weight: bold;\">Lorem ipsum dolor sit amet.</span></p>\r\n<p>&nbsp;</p>\r\n<p><span style=\"font-weight: bold;\">Proin ante sapien, porta eu malesuada vitae, pulvinar eget erat.</span></p>\r\n<p>&nbsp;</p>\r\nProin ante sapien, porta eu malesuada vitae, pulvinar eget erat. Fusce eget orci ut erat sollicitudin venenatis quis quis lacus. Nullam feugiat risus quis diam interdum cursus. Donec quis sem vel felis consectetur adipiscing nec sed orci. Maecenas eget mi id turpis tempor vehicula.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>\r\n<td>&nbsp; <img src=\"app/web/upload/tinymce-source/10-Paris.jpg\" alt=\"\" width=\"350\" height=\"176\" /></td>\r\n</tr>\r\n<tr>\r\n<td>&nbsp;\r\n<p><span style=\"font-size: 11pt; font-weight: bold;\">Lorem ipsum dolor sit amet.</span></p>\r\n<p>&nbsp;</p>\r\n<p><span style=\"font-weight: bold;\">Proin ante sapien, porta eu malesuada vitae, pulvinar eget erat.</span></p>\r\n<p>&nbsp;</p>\r\nProin ante sapien, porta eu malesuada vitae, pulvinar eget erat. Fusce eget orci ut erat sollicitudin venenatis quis quis lacus. Nullam feugiat risus quis diam interdum cursus. Donec quis sem vel felis consectetur adipiscing nec sed orci. Maecenas eget mi id turpis tempor vehicula.</td>\r\n<td>&nbsp; <img src=\"app/web/upload/tinymce-source/12-Paris.jpg\" alt=\"\" width=\"350\" height=\"233\" /></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<p>&nbsp;</p>\r\n<p><iframe src=\"//www.youtube.com/embed/r7VY6_ADAEw?rel=0\" width=\"560\" height=\"315\" frameborder=\"0\" allowfullscreen=\"allowfullscreen\"></iframe></p>','data'),(15011,1,'pjDestination',1,'meta_title','Paris The City of Lovers','data'),(15012,1,'pjDestination',1,'meta_desc','Paris The City of Lovers description','data'),(15230,2,'pjDestination',1,'name','Hawai','data'),(15231,2,'pjDestination',1,'title','Hawai - Your dream summer vaction','data'),(15232,2,'pjDestination',1,'full_desc','<p>&nbsp;</p>\r\n<p><span style=\"font-weight: bold; font-size: 11pt;\">Neque porro quisquam est!</span></p>\r\n<p>&nbsp;</p>\r\n<p><span style=\"font-weight: bold;\">Qui dolorem ipsum quia dolor sit amet.</span></p>\r\n<p>&nbsp;</p>\r\n<p>Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur?</p>\r\n<p>&nbsp;</p>\r\n<table style=\"height: 82px;\" width=\"498\">\r\n<tbody>\r\n<tr>\r\n<td>\r\n<p><span style=\"font-size: 11pt; font-weight: bold;\">Lorem ipsum dolor sit amet.</span></p>\r\n<p>&nbsp;</p>\r\n<p><span style=\"font-weight: bold;\">Proin ante sapien, porta eu malesuada vitae, pulvinar eget erat.</span></p>\r\n<p>&nbsp;</p>\r\nProin ante sapien, porta eu malesuada vitae, pulvinar eget erat. Fusce eget orci ut erat sollicitudin venenatis quis quis lacus. Nullam feugiat risus quis diam interdum cursus. Donec quis sem vel felis consectetur adipiscing nec sed orci. Maecenas eget mi id turpis tempor vehicula.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>\r\n<td>&nbsp; <img src=\"app/web/upload/tinymce-source/Hawai - small 1.jpg\" alt=\"\" width=\"338\" height=\"241\" /></td>\r\n</tr>\r\n<tr>\r\n<td>&nbsp;\r\n<p><span style=\"font-size: 11pt; font-weight: bold;\">Lorem ipsum dolor sit amet.</span></p>\r\n<p>&nbsp;</p>\r\n<p><span style=\"font-weight: bold;\">Proin ante sapien, porta eu malesuada vitae, pulvinar eget erat.</span></p>\r\n<p>&nbsp;</p>\r\nProin ante sapien, porta eu malesuada vitae, pulvinar eget erat. Fusce eget orci ut erat sollicitudin venenatis quis quis lacus. Nullam feugiat risus quis diam interdum cursus. Donec quis sem vel felis consectetur adipiscing nec sed orci. Maecenas eget mi id turpis tempor vehicula.</td>\r\n<td>&nbsp; <img src=\"app/web/upload/tinymce-source/Hawai - small 2.jpg\" alt=\"\" width=\"338\" height=\"241\" /></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<p><iframe src=\"//www.youtube.com/embed/xzy5quOw-Bc?rel=0\" width=\"560\" height=\"315\" frameborder=\"0\" allowfullscreen=\"allowfullscreen\"></iframe></p>','data'),(15233,2,'pjDestination',1,'meta_title','Hawai - Your dream summer vaction','data'),(15234,2,'pjDestination',1,'meta_desc','Hawai destination description.','data'),(15251,1943,'pjField',1,'title','Manage Enquiries','script'),(15254,1944,'pjField',1,'title','Below you will find a list with all enquiries send by the website visitors to the package owners or you. All enquiries are added into the list with status \'Not confirmed\'. Status \'Confirmed\' is for your own or package owner usage. It will not trigger any system action. You can reply an enquiry using the email and contact data left by the website visitor. You can also add enquiries using the \'Add new enquiry\' tab above.','script'),(15257,1945,'pjField',1,'title','All the changes made to this logo have been saved.','script'),(15260,1946,'pjField',1,'title','Logo updated!','script'),(15263,1947,'pjField',1,'title','Update your website logo','script'),(15266,1948,'pjField',1,'title','Here you can update the logo of your website. The size is limited to 183 x 85 px. If your image is bigger than this you’ll be able to crop it during upload.','script'),(15269,1949,'pjField',1,'title','This is alternative tag that will show on mouse over on some browsers and helps search engine bots to understand what the image stands for.','script'),(15272,1950,'pjField',1,'title','This title will show if the image does not load for some reason.','script'),(15275,1951,'pjField',1,'title','Manage Comments','script'),(15278,1952,'pjField',1,'title','Here you will find a list with all reviews left by website visitors. Through Settings menu / Options tab you can choose whether to show visitors\' comments on the website after your approval or right after they are submitted. If you have chosen to approve them first, they will enter the system with status \'New\'. Change their status to \'Confirmed\' to show comments on the website. Leave the status to \'New\' if you wish to keep a review hided without deleting it. Each comment will show only on the page of the holiday package where it was posted.','script'),(15281,1953,'pjField',1,'title','Manage your website settings','script'),(15284,1954,'pjField',1,'title','Here you can manage the general settings of your website. You can show, hide and tune some of the website features. Please, review all of them carefully and set them as desired. ','script'),(15287,1955,'pjField',1,'title','General Options','script'),(15290,1956,'pjField',1,'title','Subscribe to newsletter feature','script'),(15293,1957,'pjField',1,'title','Show the newsletter subscription box on your home page if you wish to collect email subscribers. Otherwise, hide it. You can edit the box text through Languages Tab / Titles.','script'),(15296,1958,'pjField',1,'title','You can choose whether to show or not Average Users Rating for each holiday packages based on the visitors rating left with their reviews.','script'),(15299,1959,'pjField',1,'title','Below you will find a list with all holiday packages. You can search packages via the search form or filter them using the quick filter buttons. You can also sort packages using the small arrows in each column header. To delete, activate or inactivate few packages simultaneously, use the checkboxes and then choose an action from the \'Choose Action\' drop-down at the bottom of the table. Use the available options to quickly change the Publish status or extend expiration date of a package.','script'),(15302,1960,'pjField',1,'title','Packages','script'),(15305,1961,'pjField',1,'title','Edit','script'),(15308,1962,'pjField',1,'title','If you use multiple words in your URL it is highly recommended to use dash between them. For example: \'multiple-words\'. You cannot use space in your URL.','script'),(15311,1963,'pjField',1,'title','For best results fill in meaningful Meta Title having your best keyword phrase in it. The Meta Title should be related to the current page content. Keep it up to 70 characters. ','script'),(15314,1964,'pjField',1,'title','For best result write descriptive text that is related to the page content. Keep it up to 160 characters. ','script'),(15317,1965,'pjField',1,'title','Show on Home Page','script'),(15350,1966,'pjField',1,'title','Title','script'),(15353,1967,'pjField',1,'title','Date From/To','script'),(15422,1968,'pjField',1,'title','Best Deal price start from','script'),(15425,1969,'pjField',1,'title','Best Deal Discount','script'),(15572,1970,'pjField',1,'title','start from','script'),(15575,1971,'pjField',1,'title','Export All','script'),(15698,1972,'pjField',1,'title','SEO','script'),(15701,1973,'pjField',1,'title','Manage your SEO','script'),(15704,1974,'pjField',1,'title','Here you can manage the Meta Tags of your main website pages. For search engines it is important that your web pages have Meta tags.','script'),(15707,1975,'pjField',1,'title','Home page - Meta title','script'),(15710,1976,'pjField',1,'title','Home page - Meta description','script'),(15713,1977,'pjField',1,'title','Contact page - Meta title','script'),(15716,1978,'pjField',1,'title','Contact page - Meta description','script'),(15719,1979,'pjField',1,'title','Login page - Meta title','script'),(15722,1980,'pjField',1,'title','Login page - Meta description','script'),(15725,1981,'pjField',1,'title','Forgot password page - Meta description','script'),(15728,1982,'pjField',1,'title','Forgot password page - Meta title','script'),(15731,1983,'pjField',1,'title','Register page - Meta title','script'),(15734,1984,'pjField',1,'title','Register page - Meta description','script'),(15737,1985,'pjField',1,'title','Holiday Packages page - Meta description','script'),(15740,1986,'pjField',1,'title','Holiday Packages page - Meta title','script'),(15743,1987,'pjField',1,'title','Best Deals page - Meta title','script'),(15746,1988,'pjField',1,'title','Best Deals page - Meta description','script'),(15749,1989,'pjField',1,'title','All the changes made to SEO options have been saved.','script'),(15752,1990,'pjField',1,'title','SEO Options updated!','script'),(16001,1991,'pjField',1,'title','Package Summary','script'),(16004,1992,'pjField',1,'title','A summary of the main package options. You can manage package publishing on the website using Publish, Features and Best Deal options.','script'),(16007,1993,'pjField',1,'title','Manage package description. You can choose package Type, Rating, Season Availability and Nights. Type is the only mandatory package option. If you do not use the other options, then this data will not show at the website. Do not forget to add Package title as this is the most important message of your presentation. If you have multi language website, do not forget to fill in the data in all languages.','script'),(16019,1994,'pjField',1,'title','Package Details','script'),(16022,1995,'pjField',1,'title','Package is not published.','script'),(16025,1,'pjBanner',1,'image','app/web/upload/banners/1_5246790e6d7ff4437adcc72bb86c7f53.png','data'),(16026,1,'pjBanner',1,'url','http://www.phpjabbers.com/travel-website','data'),(16027,1,'pjBanner',1,'alt','Travel Website Banner','data'),(16028,1,'pjBanner',1,'title','Travel Website Banner','data'),(16029,1,'pjBanner',1,'code',NULL,'data'),(16076,1996,'pjField',1,'title','Languages','plugin'),(16079,1997,'pjField',1,'title','Translate','plugin'),(16082,1998,'pjField',1,'title','Languages','plugin'),(16085,1999,'pjField',1,'title','Add as many languages as you need to your script. For each of the languages added you need to translate all the text titles.','plugin'),(16088,2000,'pjField',1,'title','Titles','plugin'),(16091,2001,'pjField',1,'title','Using the form below you can edit all the text in the software.<br /><br />Each piece of text used in the software is saved in the database and has its own unique ID. In the first column below you can see the ID for each piece of text. To show these IDs in the script itself check the \"Show IDs\" checkbox and click Save button next to it. This will show the corresponding :ID: for each text message. Please, note that ONLY you will see these IDs. Now you can search for any ID and easily change and/or translate the text. Have in the mind that you shoud use : before and after the ID when you search for it.  <br /><br />Check our <a target=\"_blank\" href=\"http://www.phpjabbers.com/knowledgebase/other\">knowledgebase</a> and watch video tutorial how to change and/or translate the text.','plugin'),(16094,2002,'pjField',1,'title','Title','plugin'),(16097,2003,'pjField',1,'title','Flag','plugin'),(16100,2004,'pjField',1,'title','Is default','plugin'),(16103,2005,'pjField',1,'title','Order','plugin'),(16106,2006,'pjField',1,'title','Add Language','plugin'),(16109,2007,'pjField',1,'title','Field','plugin'),(16112,2008,'pjField',1,'title','Value','plugin'),(16115,2009,'pjField',1,'title','Back-end title','plugin'),(16118,2010,'pjField',1,'title','Front-end title','plugin'),(16121,2011,'pjField',1,'title','Special title','plugin'),(16124,2012,'pjField',1,'title','Titles Updated','plugin'),(16127,2013,'pjField',1,'title','All the changes made to titles have been saved.','plugin'),(16130,2014,'pjField',1,'title','Per page','plugin'),(16133,2015,'pjField',1,'title','Import error','plugin'),(16136,2016,'pjField',1,'title','Import failed due missing parameters.','plugin'),(16139,2017,'pjField',1,'title','Import complete','plugin'),(16142,2018,'pjField',1,'title','The import was performed successfully.','plugin'),(16145,2019,'pjField',1,'title','Import error','plugin'),(16148,2020,'pjField',1,'title','Import failed due empty data.','plugin'),(16151,2021,'pjField',1,'title','Import error','plugin'),(16154,2022,'pjField',1,'title','Import failed because file cannot be open.','plugin'),(16157,2023,'pjField',1,'title','Import / Export','plugin'),(16160,2024,'pjField',1,'title','Import','plugin'),(16163,2025,'pjField',1,'title','Export','plugin'),(16166,2026,'pjField',1,'title','Language','plugin'),(16169,2027,'pjField',1,'title','Browse your computer','plugin'),(16172,2028,'pjField',1,'title','Import / Export','plugin'),(16175,2029,'pjField',1,'title','Use form below to Import or Export CSV with all titles. Please, do not change first row and first and second column in the CSV file.','plugin'),(16178,2030,'pjField',1,'title','Delimiter','plugin'),(16181,2031,'pjField',1,'title','Comma','plugin'),(16184,2032,'pjField',1,'title','Semicolon','plugin'),(16187,2033,'pjField',1,'title','Tab','plugin'),(16190,2034,'pjField',1,'title','The following languages have been found. Select those you want to import.','plugin');
INSERT INTO `travel_multi_lang` VALUES (16193,2035,'pjField',1,'title','Import confirmation','plugin'),(16196,2036,'pjField',1,'title','Import failed','plugin'),(16199,2037,'pjField',1,'title','Missing, empty or invalid parameters.','plugin'),(16202,2038,'pjField',1,'title','Import failed','plugin'),(16205,2039,'pjField',1,'title','File have not been uploaded.','plugin'),(16208,2040,'pjField',1,'title','Import failed','plugin'),(16211,2041,'pjField',1,'title','Uploaded file cannot open for reading.','plugin'),(16214,2042,'pjField',1,'title','Import failed','plugin'),(16217,2043,'pjField',1,'title','New line(s) have been found.','plugin'),(16220,2044,'pjField',1,'title','Import failed','plugin'),(16223,2045,'pjField',1,'title','Uploaded file doesn\'t contain the necessary columns.','plugin'),(16226,2046,'pjField',1,'title','Import failed','plugin'),(16229,2047,'pjField',1,'title','Number of columns are not equal on every row.','plugin'),(16232,2048,'pjField',1,'title','Import failed','plugin'),(16235,2049,'pjField',1,'title','Invalid data found.','plugin'),(16238,2050,'pjField',1,'title','Import failed','plugin'),(16241,2051,'pjField',1,'title','Missing columns.','plugin'),(16244,2052,'pjField',1,'title','Import failed','plugin'),(16247,2053,'pjField',1,'title','Invalid data found.','plugin'),(16250,2054,'pjField',1,'title','Show IDs','plugin'),(16253,2055,'pjField',1,'title','ID will be displayed next to each text found in the software. You can then search for an ID to easily change or translate the text.','plugin'),(16256,2056,'pjField',1,'title','Confirm','plugin'),(16259,2057,'pjField',1,'title','Cancel','plugin'),(16262,2058,'pjField',1,'title','default','plugin'),(16265,2059,'pjField',1,'title','ID:','plugin'),(16268,2060,'pjField',1,'title','Show IDs','plugin'),(16271,2061,'pjField',1,'title','Backup','plugin'),(16274,2062,'pjField',1,'title','Backup complete!','plugin'),(16277,2063,'pjField',1,'title','Backup failed!','plugin'),(16280,2064,'pjField',1,'title','Backup failed!','plugin'),(16283,2065,'pjField',1,'title','We recommend you to regularly back up your database and files to prevent any loss of information.','plugin'),(16286,2066,'pjField',1,'title','All backup files have been saved.','plugin'),(16289,2067,'pjField',1,'title','No option was selected.','plugin'),(16292,2068,'pjField',1,'title','Backup not performed.','plugin'),(16295,2069,'pjField',1,'title','Backup','plugin'),(16298,2070,'pjField',1,'title','Backup database','plugin'),(16301,2071,'pjField',1,'title','Backup files','plugin'),(16304,2072,'pjField',1,'title','Backup','plugin'),(16307,2073,'pjField',1,'title','Backup failed!','plugin'),(16310,2074,'pjField',1,'title','Backup folder not found. Please ensure that \"app/web/backup\" folder exists.','plugin'),(16313,2075,'pjField',1,'title','Backup failed!','plugin'),(16316,2076,'pjField',1,'title','You need to set write permissions (chmod 777) to \"app/web/backup\" folder.','plugin'),(16319,2077,'pjField',1,'title','Log','plugin'),(16322,2078,'pjField',1,'title','Config log','plugin'),(16325,2079,'pjField',1,'title','Empty log','plugin'),(16328,2080,'pjField',1,'title','Config log updated.','plugin'),(16331,2081,'pjField',1,'title','The config log have been updated.','plugin'),(16334,2082,'pjField',1,'title','List','plugin'),(16337,2083,'pjField',1,'title','+ Add','plugin'),(16340,2084,'pjField',1,'title','Information','plugin'),(16343,2085,'pjField',1,'title','Please, note that after changing the scripts in the list below you will need to refresh the page to apply the new updates in the \"One admiN\" menu.','plugin'),(16346,2086,'pjField',1,'title','ALT','plugin'),(16349,2087,'pjField',1,'title','Watermark position','plugin'),(16352,2088,'pjField',1,'title','Position','plugin'),(16355,2089,'pjField',1,'title','Image settings','plugin'),(16358,2090,'pjField',1,'title','Are you sure you want to delete all images?','plugin'),(16361,2091,'pjField',1,'title','Are you sure you want to delete selected image?','plugin'),(16364,2092,'pjField',1,'title','Delete confirmation','plugin'),(16367,2093,'pjField',1,'title','You can compress the size of your images by lowering their quality. Usually after 80% compression quality change will not be visible for human eye.','plugin'),(16370,2094,'pjField',1,'title','Delete','plugin'),(16373,2095,'pjField',1,'title','Cancel','plugin'),(16376,2096,'pjField',1,'title','Save','plugin'),(16379,2097,'pjField',1,'title','Set watermark','plugin'),(16382,2098,'pjField',1,'title','Clear current one','plugin'),(16385,2099,'pjField',1,'title','Compress','plugin'),(16388,2100,'pjField',1,'title','Re-create thumbs','plugin'),(16391,2101,'pjField',1,'title','Top Left','plugin'),(16394,2102,'pjField',1,'title','Top Center','plugin'),(16397,2103,'pjField',1,'title','Bottom Left','plugin'),(16400,2104,'pjField',1,'title','Bottom Right','plugin'),(16403,2105,'pjField',1,'title','Bottom Center','plugin'),(16406,2106,'pjField',1,'title','Center Left','plugin'),(16409,2107,'pjField',1,'title','Center Right','plugin'),(16412,2108,'pjField',1,'title','Center Center','plugin'),(16415,2109,'pjField',1,'title','Top Right','plugin'),(16418,2110,'pjField',1,'title','No images uploaded yet.','plugin'),(16421,2111,'pjField',1,'title','Move','plugin'),(16424,2112,'pjField',1,'title','Edit','plugin'),(16427,2113,'pjField',1,'title','Delete','plugin'),(16430,2114,'pjField',1,'title','Resize/Crop','plugin'),(16433,2115,'pjField',1,'title','Rotate','plugin'),(16436,2116,'pjField',1,'title','Watermark','plugin'),(16439,2117,'pjField',1,'title','Compression','plugin'),(16442,2118,'pjField',1,'title','Delete All','plugin'),(16445,2119,'pjField',1,'title','Originals','plugin'),(16448,2120,'pjField',1,'title','Thumbs','plugin'),(16451,2121,'pjField',1,'title','photos','plugin'),(16454,2122,'pjField',1,'title','Upload','plugin'),(16457,2123,'pjField',1,'title','re-create from original','plugin'),(16460,2124,'pjField',1,'title','Original','plugin'),(16463,2125,'pjField',1,'title','Preview','plugin'),(16466,2126,'pjField',1,'title','Thumb','plugin'),(16469,2127,'pjField',1,'title','&laquo; Back','plugin'),(16472,2128,'pjField',1,'title','Move the outer parts of the rectangular and/or position it over the image to change framing, aspect ratio or accentuate an object.','plugin'),(16475,2129,'pjField',1,'title','Crop Image','plugin'),(16478,2130,'pjField',1,'title','Date/Time','plugin'),(16481,2131,'pjField',1,'title','MC Gross','plugin'),(16484,2132,'pjField',1,'title','MC Currency','plugin'),(16487,2133,'pjField',1,'title','Payer email','plugin'),(16490,2134,'pjField',1,'title','Txn type','plugin'),(16493,2135,'pjField',1,'title','Txn ID','plugin'),(16496,2136,'pjField',1,'title','Subscription ID','plugin'),(16499,2137,'pjField',1,'title','Foreign ID','plugin'),(16502,2138,'pjField',1,'title','Close','plugin'),(16505,2139,'pjField',1,'title','Transaction details','plugin'),(16508,2140,'pjField',1,'title','View','plugin'),(16511,2141,'pjField',1,'title','IPN','plugin'),(16514,2142,'pjField',1,'title','Country name','plugin'),(16517,2143,'pjField',1,'title','Alpha 2','plugin'),(16520,2144,'pjField',1,'title','Alpha 3','plugin'),(16523,2145,'pjField',1,'title','Status','plugin'),(16526,2146,'pjField',1,'title','Add +','plugin'),(16529,2147,'pjField',1,'title','Active','plugin'),(16532,2148,'pjField',1,'title','Inactive','plugin'),(16535,2149,'pjField',1,'title','Save','plugin'),(16538,2150,'pjField',1,'title','Cancel','plugin'),(16541,2151,'pjField',1,'title','Countries','plugin'),(16544,2152,'pjField',1,'title','Country updated','plugin'),(16547,2153,'pjField',1,'title','Country added','plugin'),(16550,2154,'pjField',1,'title','Country failed to add','plugin'),(16553,2155,'pjField',1,'title','Country not found','plugin'),(16556,2156,'pjField',1,'title','Add country','plugin'),(16559,2157,'pjField',1,'title','Update country','plugin'),(16562,2158,'pjField',1,'title','Manage countries','plugin'),(16565,2159,'pjField',1,'title','Country has been updated successfully.','plugin'),(16568,2160,'pjField',1,'title','Country has been added successfully.','plugin'),(16571,2161,'pjField',1,'title','Country has not been added successfully.','plugin'),(16574,2162,'pjField',1,'title','Country you are looking for has not been found.','plugin'),(16577,2163,'pjField',1,'title','Use form below to add a country.','plugin'),(16580,2164,'pjField',1,'title','Use form below to update a country.','plugin'),(16583,2165,'pjField',1,'title','Use grid below to organize your country list.','plugin'),(16586,2166,'pjField',1,'title','Are you sure you want to delete selected country?','plugin'),(16589,2167,'pjField',1,'title','Delete selected','plugin'),(16592,2168,'pjField',1,'title','All','plugin'),(16595,2169,'pjField',1,'title','Search','plugin'),(23490,12,'pjFeature',7,'name','Laundry area - garage','script'),(23511,1,'pjField',7,'title','添加语言','script'),(23512,2,'pjField',7,'title','忘记密码','script'),(23513,3,'pjField',7,'title','管理登录','script'),(23514,4,'pjField',7,'title','后台标题','script'),(23515,5,'pjField',7,'title','添加 +','script'),(23516,6,'pjField',7,'title','+ 添加行程','script'),(23517,7,'pjField',7,'title','« 返回','script'),(23518,9,'pjField',7,'title','取消','script'),(23519,10,'pjField',7,'title','继续','script'),(23520,11,'pjField',7,'title','删除','script'),(23521,12,'pjField',7,'title','获取坐标','script'),(23522,13,'pjField',7,'title','登录','script'),(23523,14,'pjField',7,'title','重置','script'),(23524,15,'pjField',7,'title','保存','script'),(23525,16,'pjField',7,'title','搜索','script'),(23526,17,'pjField',7,'title','发送','script'),(23527,18,'pjField',7,'title','修改','script'),(23528,19,'pjField',7,'title','时间','script'),(23529,20,'pjField',7,'title','Email','script'),(23530,21,'pjField',7,'title','您好 {Name},您的密码是: {Password}','script'),(23531,22,'pjField',7,'title','忘记密码','script'),(23532,23,'pjField',7,'title','前台标题','script'),(23533,62,'pjField',7,'title','确认','script'),(23534,63,'pjField',7,'title','取消','script'),(23535,64,'pjField',7,'title','删除','script'),(23536,65,'pjField',7,'title','确定','script'),(23537,66,'pjField',7,'title','选中项','script'),(23538,67,'pjField',7,'title','确定删除选中的记录吗？','script'),(23539,68,'pjField',7,'title','删除确认','script'),(23540,69,'pjField',7,'title','没有记录','script'),(23541,70,'pjField',7,'title','转到:','script'),(23542,71,'pjField',7,'title','每页显示','script'),(23543,72,'pjField',7,'title','下一页 »','script'),(23544,73,'pjField',7,'title','下一页','script'),(23545,74,'pjField',7,'title','« 上一页','script'),(23546,75,'pjField',7,'title','上一页','script'),(23547,76,'pjField',7,'title','总计:','script'),(23548,77,'pjField',7,'title','您可以在此处自定义系统发送邮件的格式，邮件正文左侧的标签可以加入到正文中，发送时会替换成相应的内容。您可以在设置 -> 通用菜单内修改邮件发送人的信息。','script'),(23549,78,'pjField',7,'title','邮件通知','script'),(23550,79,'pjField',7,'title','您可以在此处设置行程标签，在添加行程时可以直接勾选以下标签。','script'),(23551,80,'pjField',7,'title','输入标签名称然后点击保存按钮。','script'),(23552,81,'pjField',7,'title','添加标签','script'),(23553,82,'pjField',7,'title','标签列表','script'),(23554,83,'pjField',7,'title','修改标签名称然后点击保存按钮。','script'),(23555,84,'pjField',7,'title','修改标签','script'),(23556,85,'pjField',7,'title','填写完整的地之后，请点击“获取坐标”按钮，即可在地图上搜索对应地点，并可将地图展示给用户。','script'),(23557,86,'pjField',7,'title','地址','script'),(23558,87,'pjField',7,'title','Listing Bookings Body','script'),(23559,88,'pjField',7,'title','Listing Bookings Title','script'),(23560,89,'pjField',7,'title','Listing Contact Body','script'),(23561,90,'pjField',7,'title','Listing Contact Title','script'),(23562,91,'pjField',7,'title','To publish your package or to extend its expiration date (if the package has already been published) choose the appropriate submission period. If for the desired period charges are applicable, then click on ‘Buy now’ button and make the payment required. After payment is received the package will be automatically published / extended.','script'),(23563,92,'pjField',7,'title','Extend expiration date','script'),(23564,93,'pjField',7,'title','在这里您可以根据不同时间段设置价格。请至少设置一个价格，否则前台将不会显示行程价格。','script'),(23565,94,'pjField',7,'title','设置价格','script'),(23566,95,'pjField',7,'title','Languages Array Body','script'),(23567,96,'pjField',7,'title','Languages Arrays Title','script'),(23568,97,'pjField',7,'title','Languages Backend Body','script'),(23569,98,'pjField',7,'title','Languages Backend Title','script'),(23570,99,'pjField',7,'title','Languages Body','script'),(23571,100,'pjField',7,'title','Languages Frontend Body','script'),(23572,101,'pjField',7,'title','Languages Frontend Title','script'),(23573,102,'pjField',7,'title','Languages Title','script'),(23574,103,'pjField',7,'title','您可以在此处设置是否开启用户投稿功能。用户登录后才能投稿，您可以根据稿件显示时间收取不同费用。','script'),(23575,104,'pjField',7,'title','用户投稿','script'),(23576,105,'pjField',7,'title','在这里您可以添加、修改或删除行程类型，请至少保留一条行程类型。','script'),(23577,106,'pjField',7,'title','输入行程类型然后点击保存按钮。','script'),(23578,107,'pjField',7,'title','添加行程类型','script'),(23579,108,'pjField',7,'title','行程类型','script'),(23580,109,'pjField',7,'title','编辑行程类型然后点击保存按钮。','script'),(23581,110,'pjField',7,'title','编辑行程类型','script'),(23582,111,'pjField',7,'title','添加时间','script'),(23583,112,'pjField',7,'title','添加新申请','script'),(23584,113,'pjField',7,'title','添加用户','script'),(23585,114,'pjField',7,'title','秋季','script'),(23586,117,'pjField',7,'title','选择','script'),(23587,118,'pjField',7,'title','选择发布人','script'),(23588,119,'pjField',7,'title','选择行程','script'),(23589,120,'pjField',7,'title','评论','script'),(23590,121,'pjField',7,'title','Email','script'),(23591,122,'pjField',7,'title','姓名','script'),(23592,123,'pjField',7,'title','行程','script'),(23593,124,'pjField',7,'title','状态','script'),(23594,125,'pjField',7,'title','标题','script'),(23595,126,'pjField',7,'title','电子邮件','script'),(23596,127,'pjField',7,'title','传真','script'),(23597,128,'pjField',7,'title','姓','script'),(23598,129,'pjField',7,'title','名','script'),(23599,130,'pjField',7,'title','移动电话','script'),(23600,131,'pjField',7,'title','固定电话','script'),(23601,132,'pjField',7,'title','称谓','script'),(23602,133,'pjField',7,'title','网站','script'),(23603,134,'pjField',7,'title','省份','script'),(23604,135,'pjField',7,'title','天','script'),(23605,136,'pjField',7,'title','删除','script'),(23606,137,'pjField',7,'title','邮件正文','script'),(23607,138,'pjField',7,'title','主题','script'),(23608,139,'pjField',7,'title','申请','script'),(23609,140,'pjField',7,'title','Email','script'),(23610,141,'pjField',7,'title','开始时间','script'),(23611,142,'pjField',7,'title','姓名','script'),(23612,143,'pjField',7,'title','备注','script'),(23613,144,'pjField',7,'title','行程','script'),(23614,145,'pjField',7,'title','电话','script'),(23615,146,'pjField',7,'title','状态','script'),(23616,147,'pjField',7,'title','截止时间','script'),(23617,148,'pjField',7,'title','错误','script'),(23618,149,'pjField',7,'title','导出','script'),(23619,150,'pjField',7,'title','标签','script'),(23620,151,'pjField',7,'title','航班','script'),(23621,152,'pjField',7,'title','忘记密码','script'),(23622,153,'pjField',7,'title','推荐行程','script'),(23623,154,'pjField',7,'title','Step 1. Copy and paste the code below at the very top of your .php page. It should be line 1 of your .php web page.','script'),(23624,155,'pjField',7,'title','Step 2. Copy and paste the code below into your html code, where featured listings will be displayed.','script'),(23625,156,'pjField',7,'title','Step 3. Copy and paste the code below at the very bottom of your .php web page after all the other code.','script'),(23626,157,'pjField',7,'title','Listing','script'),(23627,158,'pjField',7,'title','Follow these steps to insert the Vacation Packages listing on your .php web page using PHP include code:','script'),(23628,159,'pjField',7,'title','Step 1. Copy and paste the code below at the very top of your .php page. It should be line 1 of your .php web page.','script'),(23629,160,'pjField',7,'title','Step 2. Copy and paste the code below into your html code, where the packages listing will be displayed.','script'),(23630,161,'pjField',7,'title','Step 2a (Optional). Copy and paste the code below inside the part of your page, where the meta tags will be printed.','script'),(23631,162,'pjField',7,'title','Step 3. Copy and paste the code below at the very bottom of your .php web page after all the other code.','script'),(23632,163,'pjField',7,'title','Follow these steps to insert the Featured Packages listing on your .php web page using PHP include code:','script'),(23633,164,'pjField',7,'title','IP地址','script'),(23634,165,'pjField',7,'title','已确认','script'),(23635,166,'pjField',7,'title','关键字','script'),(23636,167,'pjField',7,'title','修改时间','script'),(23637,168,'pjField',7,'title','请设置行程类型、状态、引用ID，所有项均为必填。若无法选择行程类型，请到设置 -> 行程类型中添加。','script'),(23638,169,'pjField',7,'title','地址','script'),(23639,170,'pjField',7,'title','添加新行程','script'),(23640,171,'pjField',7,'title','门票','script'),(23641,172,'pjField',7,'title','保险','script'),(23642,173,'pjField',7,'title','城市','script'),(23643,174,'pjField',7,'title','新评论提醒','script'),(23644,175,'pjField',7,'title','可用标签:<br/> {OwnerName} - 所有者姓名<br/> {Name} - 姓名<br/> {Email} - 电子邮件<br/> {Rating} - 评分<br/> {Title} - 标题<br/> {Comment} - 评论<br/> {RefID} - 行程引用ID<br/> {ListingTitle} - 行程标题','script'),(23645,176,'pjField',7,'title','新申请提醒','script'),(23646,177,'pjField',7,'title','可用标签:<br/> {OwnerName} - 所有者姓名<br/> {FullName} - 申请者姓名<br/> {Email} - 电子邮件<br/> {Phone} - 电话号码<br/> {Notes} - 附加信息<br/> {StartDate} - 开始时间<br/> {EndDate} - 结束时间<br/> {ListingID} - 行程引用ID<br/> {ListingTitle} - 行程标题<br/> {EnquiryID} - 申请ID<br/>','script'),(23647,178,'pjField',7,'title','省份','script'),(23648,179,'pjField',7,'title','详情','script'),(23649,180,'pjField',7,'title','电子邮件','script'),(23650,181,'pjField',7,'title','过期时间','script'),(23651,182,'pjField',7,'title','设置行程过期时间。发布状态设置为“根据过期时间自动发布”才有效。','script'),(23652,183,'pjField',7,'title','Extend expire date','script'),(23653,184,'pjField',7,'title','传真','script'),(23654,185,'pjField',7,'title','设置为推荐','script'),(23655,186,'pjField',7,'title','标签','script'),(23656,187,'pjField',7,'title','费用详情','script'),(23657,188,'pjField',7,'title','姓','script'),(23658,189,'pjField',7,'title','航班','script'),(23659,190,'pjField',7,'title','航班信息','script'),(23660,191,'pjField',7,'title','填写好完整地址后点击“获取坐标”按钮，即可获取经纬度。','script'),(23661,192,'pjField',7,'title','回程到达时间','script'),(23662,193,'pjField',7,'title','回程出发时间','script'),(23663,194,'pjField',7,'title','回程航班','script'),(23664,195,'pjField',7,'title','回程出发地点','script'),(23665,196,'pjField',7,'title','回程到达地点','script'),(23666,197,'pjField',7,'title','名','script'),(23667,198,'pjField',7,'title','纬度','script'),(23668,199,'pjField',7,'title','经度','script'),(23669,200,'pjField',7,'title','Meta 描述','script'),(23670,201,'pjField',7,'title','Meta 关键字','script'),(23671,202,'pjField',7,'title','Meta 标题','script'),(23672,203,'pjField',7,'title','移动电话','script'),(23673,204,'pjField',7,'title','去程到达时间','script'),(23674,205,'pjField',7,'title','去程出发时间','script'),(23675,206,'pjField',7,'title','去程航班','script'),(23676,207,'pjField',7,'title','去程出发地点','script'),(23677,208,'pjField',7,'title','去程到达地点','script'),(23678,209,'pjField',7,'title','发布人','script'),(23679,210,'pjField',7,'title','行程','script'),(23680,211,'pjField',7,'title','住宿','script'),(23681,212,'pjField',7,'title','电话','script'),(23682,213,'pjField',7,'title','照片','script'),(23683,214,'pjField',7,'title','其他说明','script'),(23684,215,'pjField',7,'title','价格','script'),(23685,216,'pjField',7,'title','开始时间','script'),(23686,217,'pjField',7,'title','未找到价格信息','script'),(23687,218,'pjField',7,'title','定价','script'),(23688,219,'pjField',7,'title','定价名称','script'),(23689,220,'pjField',7,'title','结束时间','script'),(23690,221,'pjField',7,'title','价格类型','script'),(23691,222,'pjField',7,'title','发布时间','script'),(23692,223,'pjField',7,'title','引用ID','script'),(23693,224,'pjField',7,'title','可用标签:</br> {Email} - 电子邮件</br> {Name} - 姓名','script'),(23694,225,'pjField',7,'title','新发布人注册提醒','script'),(23695,226,'pjField',7,'title','SEO','script'),(23696,227,'pjField',7,'title','状态','script'),(23697,228,'pjField',7,'title','发布状态','script'),(23698,229,'pjField',7,'title','选择“已发布”将在前台显示此信息，“未发布”不在前台显示。您也可以选择“根据过期时间自动显示”。','script'),(23699,230,'pjField',7,'title','概览','script'),(23700,231,'pjField',7,'title','说明','script'),(23701,232,'pjField',7,'title','标题','script'),(23702,233,'pjField',7,'title','网址','script'),(23703,234,'pjField',7,'title','邮编','script'),(23704,235,'pjField',7,'title','姓名','script'),(23705,236,'pjField',7,'title','天数','script'),(23706,237,'pjField',7,'title','否','script'),(23707,238,'pjField',7,'title','选项','script'),(23708,239,'pjField',7,'title','选项列表','script'),(23709,240,'pjField',7,'title','发布人','script'),(23710,241,'pjField',7,'title','显示发布人联系方式','script'),(23711,242,'pjField',7,'title','行程介绍','script'),(23712,243,'pjField',7,'title','行程标题','script'),(23713,244,'pjField',7,'title','电话','script'),(23714,245,'pjField',7,'title','星级','script'),(23715,246,'pjField',7,'title','角色','script'),(23716,247,'pjField',7,'title','推荐季节','script'),(23717,248,'pjField',7,'title','在地图上显示','script'),(23718,249,'pjField',7,'title','春季','script'),(23719,250,'pjField',7,'title','状态','script'),(23720,251,'pjField',7,'title','夏季','script'),(23721,252,'pjField',7,'title','购买须知','script'),(23722,253,'pjField',7,'title','类型','script'),(23723,254,'pjField',7,'title','修改评论','script'),(23724,255,'pjField',7,'title','修改申请','script'),(23725,256,'pjField',7,'title','修改用户','script'),(23726,257,'pjField',7,'title','注册时间','script'),(23727,258,'pjField',7,'title','值','script'),(23728,259,'pjField',7,'title','访问量','script'),(23729,260,'pjField',7,'title','冬季','script'),(23730,261,'pjField',7,'title','是','script'),(23731,262,'pjField',7,'title','免费','script'),(23732,263,'pjField',7,'title','时间','script'),(23733,264,'pjField',7,'title','价格','script'),(23734,265,'pjField',7,'title','Extend your period for FREE','script'),(23735,266,'pjField',7,'title','立刻购买','script'),(23736,267,'pjField',7,'title','返回','script'),(23737,268,'pjField',7,'title','Arrays titles','script'),(23738,269,'pjField',7,'title','语言','script'),(23739,270,'pjField',7,'title','标志','script'),(23740,271,'pjField',7,'title','默认','script'),(23741,272,'pjField',7,'title','顺序','script'),(23742,273,'pjField',7,'title','标题','script'),(23743,274,'pjField',7,'title','添加新行程','script'),(23744,276,'pjField',7,'title','评论','script'),(23745,277,'pjField',7,'title','省份','script'),(23746,278,'pjField',7,'title','控制台','script'),(23747,279,'pjField',7,'title','电子邮件','script'),(23748,280,'pjField',7,'title','申请','script'),(23749,281,'pjField',7,'title','标签','script'),(23750,282,'pjField',7,'title','安装','script'),(23751,283,'pjField',7,'title','多语言','script'),(23752,284,'pjField',7,'title','语言','script'),(23753,285,'pjField',7,'title','注销','script'),(23754,286,'pjField',7,'title','设置','script'),(23755,287,'pjField',7,'title','行程','script'),(23756,288,'pjField',7,'title','插件','script'),(23757,289,'pjField',7,'title','预览','script'),(23758,290,'pjField',7,'title','Profile','script'),(23759,291,'pjField',7,'title','投稿','script'),(23760,292,'pjField',7,'title','行程类型','script'),(23761,293,'pjField',7,'title','用户','script'),(23762,294,'pjField',7,'title','点击国旗选择要修改的语言','script'),(23763,295,'pjField',7,'title','允许投稿','script'),(23764,296,'pjField',7,'title','允许用户添加属性','script'),(23765,297,'pjField',7,'title','显示/隐藏“星级”','script'),(23766,298,'pjField',7,'title','评论审核','script'),(23767,299,'pjField',7,'title','货币','script'),(23768,300,'pjField',7,'title','日期格式','script'),(23769,301,'pjField',7,'title','邮件发送人','script'),(23770,302,'pjField',7,'title','每页显示行程个数','script'),(23771,303,'pjField',7,'title','新用户自动激活','script'),(23772,304,'pjField',7,'title','每页默认显示行程个数','script'),(23773,307,'pjField',7,'title','自动激活新发布人账号','script'),(23774,308,'pjField',7,'title','支付宝账号','script'),(23775,309,'pjField',7,'title','邮件发送方式','script'),(23776,310,'pjField',7,'title','SMTP主机','script'),(23777,311,'pjField',7,'title','SMTP密码','script'),(23778,312,'pjField',7,'title','SMTP端口','script'),(23779,313,'pjField',7,'title','SMTP用户名','script'),(23780,314,'pjField',7,'title','时区','script'),(23781,315,'pjField',7,'title','时间格式','script'),(23782,316,'pjField',7,'title','每周开始于','script'),(23783,317,'pjField',7,'title','您可以根据稿件显示时间收取不同费用。如果您想设置“免费试用期”，可先设置时间，并设置价格为0。如果您想设置免费投稿，请设置较长的时间，并设置价格为0。','script'),(23784,318,'pjField',7,'title','密码','script'),(23785,341,'pjField',7,'title','Revert status','script'),(23786,342,'pjField',7,'title','URL','script'),(23787,343,'pjField',7,'title','用户名','script'),(23788,344,'pjField',7,'title','已发布','script'),(23789,345,'pjField',7,'title','地址未找到','script'),(23790,346,'pjField',7,'title','确认选择','script'),(23791,347,'pjField',7,'title','日期格式','script'),(23792,348,'pjField',7,'title','发布日期','script'),(23793,349,'pjField',7,'title','过期时间','script'),(23794,350,'pjField',7,'title','是否确定删除选择记录','script'),(23795,351,'pjField',7,'title','删除选中项','script'),(23796,352,'pjField',7,'title','取消选择','script'),(23797,353,'pjField',7,'title','请输入有效的电子邮件地址','script'),(23798,354,'pjField',7,'title','该邮件已被使用','script'),(23799,355,'pjField',7,'title','过期时间','script'),(23800,356,'pjField',7,'title','导出选中','script'),(23801,357,'pjField',7,'title','自动','script'),(23802,358,'pjField',7,'title','延迟30天过期','script'),(23803,359,'pjField',7,'title','Extend expiration date','script'),(23804,360,'pjField',7,'title','请填写该项','script'),(23805,361,'pjField',7,'title','图片','script'),(23806,362,'pjField',7,'title','未发布','script'),(23807,363,'pjField',7,'title','行程','script'),(23808,364,'pjField',7,'title','发布全部','script'),(23809,365,'pjField',7,'title','全部取消发布','script'),(23810,366,'pjField',7,'title','发布选中','script'),(23811,367,'pjField',7,'title','Make selected inactive','script'),(23812,368,'pjField',7,'title','Name','script'),(23813,369,'pjField',7,'title','Make selected Inactive','script'),(23814,370,'pjField',7,'title','发布人','script'),(23815,371,'pjField',7,'title','Publish','script'),(23816,372,'pjField',7,'title','Make selected Active','script'),(23817,373,'pjField',7,'title','Ref ID','script'),(23818,374,'pjField',7,'title','Revert status','script'),(23819,375,'pjField',7,'title','Title','script'),(23820,376,'pjField',7,'title','View enquiries','script'),(23821,377,'pjField',7,'title','of','script'),(23822,378,'pjField',7,'title','Login','script'),(23823,379,'pjField',7,'title','Register','script'),(23824,380,'pjField',7,'title','Address','script'),(23825,381,'pjField',7,'title','到达时间','script'),(23826,382,'pjField',7,'title','Availability','script'),(23827,383,'pjField',7,'title','推荐季节','script'),(23828,384,'pjField',7,'title','评分','script'),(23829,385,'pjField',7,'title','购买须知','script'),(23830,386,'pjField',7,'title','发布人','script'),(23831,387,'pjField',7,'title','验证码','script'),(23832,388,'pjField',7,'title','门票','script'),(23833,389,'pjField',7,'title','保险','script'),(23834,390,'pjField',7,'title','评论','script'),(23835,391,'pjField',7,'title','评论','script'),(23836,392,'pjField',7,'title','出发时间','script'),(23837,393,'pjField',7,'title','详情','script'),(23838,394,'pjField',7,'title','查看详细','script'),(23839,395,'pjField',7,'title','对不起，当前行程已被禁用或删除。','script'),(23840,396,'pjField',7,'title','时长','script'),(23841,397,'pjField',7,'title','Email','script'),(23842,398,'pjField',7,'title','申请','script'),(23843,399,'pjField',7,'title','传真','script'),(23844,400,'pjField',7,'title','特色','script'),(23845,401,'pjField',7,'title','费用详情','script'),(23846,402,'pjField',7,'title','选择地点','script'),(23847,403,'pjField',7,'title','选择价格','script'),(23848,404,'pjField',7,'title','选择评分','script'),(23849,405,'pjField',7,'title','选择季节','script'),(23850,406,'pjField',7,'title','选择类型','script'),(23851,407,'pjField',7,'title','航班详细信息','script'),(23852,408,'pjField',7,'title','航班','script'),(23853,409,'pjField',7,'title','航班','script'),(23854,410,'pjField',7,'title','开始日期','script'),(23855,411,'pjField',7,'title','h','script'),(23856,412,'pjField',7,'title','回程到达时间','script'),(23857,413,'pjField',7,'title','回程出发时间','script'),(23858,414,'pjField',7,'title','回程航班','script'),(23859,415,'pjField',7,'title','回程出发地点','script'),(23860,416,'pjField',7,'title','回程到达地点','script'),(23861,417,'pjField',7,'title','地址','script'),(23862,418,'pjField',7,'title','m','script'),(23863,419,'pjField',7,'title','移动电话','script'),(23864,420,'pjField',7,'title','姓名','script'),(23865,421,'pjField',7,'title','天','script'),(23866,422,'pjField',7,'title','备注','script'),(23867,423,'pjField',7,'title','未找到行程','script'),(23868,424,'pjField',7,'title','没有评论','script'),(23869,425,'pjField',7,'title','of','script'),(23870,426,'pjField',7,'title','去程到达时间','script'),(23871,427,'pjField',7,'title','去程出发时间','script'),(23872,428,'pjField',7,'title','去程航班','script'),(23873,429,'pjField',7,'title','去程出发地点','script'),(23874,430,'pjField',7,'title','去程到达地点','script'),(23875,431,'pjField',7,'title','发布人联系方式','script'),(23876,432,'pjField',7,'title','行程','script'),(23877,433,'pjField',7,'title','密码','script'),(23878,434,'pjField',7,'title','每人','script'),(23879,435,'pjField',7,'title','住宿','script'),(23880,436,'pjField',7,'title','电话','script'),(23881,437,'pjField',7,'title','其他说明','script'),(23882,438,'pjField',7,'title','附加说明','script'),(23883,439,'pjField',7,'title','发表评论','script'),(23884,440,'pjField',7,'title','价格','script'),(23885,441,'pjField',7,'title','参考价格','script'),(23886,442,'pjField',7,'title','评分','script'),(23887,443,'pjField',7,'title','确认密码','script'),(23888,444,'pjField',7,'title','提交申请','script'),(23889,445,'pjField',7,'title','提交申请','script'),(23890,446,'pjField',7,'title','星','script'),(23891,447,'pjField',7,'title','星','script'),(23892,448,'pjField',7,'title','标题','script'),(23893,449,'pjField',7,'title','截止日期','script'),(23894,450,'pjField',7,'title','时间','script'),(23895,451,'pjField',7,'title','评分','script'),(23896,452,'pjField',7,'title','网址','script'),(23897,453,'pjField',7,'title','星','script'),(23898,454,'pjField',7,'title','返回','script'),(23899,455,'pjField',7,'title','取消过滤','script'),(23900,456,'pjField',7,'title','登录','script'),(23901,457,'pjField',7,'title','注册','script'),(23902,458,'pjField',7,'title','下一页','script'),(23903,459,'pjField',7,'title','上一页','script'),(23904,460,'pjField',7,'title','已审核','script'),(23905,461,'pjField',7,'title','待审核','script'),(23906,462,'pjField',7,'title','周日','script'),(23907,463,'pjField',7,'title','周一','script'),(23908,464,'pjField',7,'title','周二','script'),(23909,465,'pjField',7,'title','周三','script'),(23910,466,'pjField',7,'title','周四','script'),(23911,467,'pjField',7,'title','周五','script'),(23912,468,'pjField',7,'title','周六','script'),(23913,469,'pjField',7,'title','S','script'),(23914,470,'pjField',7,'title','M','script'),(23915,471,'pjField',7,'title','T','script'),(23916,472,'pjField',7,'title','W','script'),(23917,473,'pjField',7,'title','T','script'),(23918,474,'pjField',7,'title','F','script'),(23919,475,'pjField',7,'title','S','script'),(23920,476,'pjField',7,'title','已审核','script'),(23921,477,'pjField',7,'title','未审核','script'),(23922,478,'pjField',7,'title','该电子邮件未关联到任何账户','script'),(23923,479,'pjField',7,'title','详情请查阅电子邮件。','script'),(23924,480,'pjField',7,'title','抱歉，请重试。','script'),(23925,481,'pjField',7,'title','修改已保存','script'),(23926,482,'pjField',7,'title','请及时备份防止损失，点击链接下载备份文件','script'),(23927,483,'pjField',7,'title','备份已保存','script'),(23928,484,'pjField',7,'title','未选择操作','script'),(23929,485,'pjField',7,'title','备份失败','script'),(23930,486,'pjField',7,'title','评论已修改','script'),(23931,487,'pjField',7,'title','评论内容不合法','script'),(23932,488,'pjField',7,'title','对不起，当前评论不存在','script'),(23933,489,'pjField',7,'title','对不起，该评论对应的行程不存在','script'),(23934,490,'pjField',7,'title','申请修改成功','script'),(23935,491,'pjField',7,'title','新申请添加成功','script'),(23936,492,'pjField',7,'title','添加新申请失败','script'),(23937,493,'pjField',7,'title','对不起，申请不存在','script'),(23938,494,'pjField',7,'title','标签修改成功','script'),(23939,495,'pjField',7,'title','新标签添加成功','script'),(23940,496,'pjField',7,'title','添加新标签失败','script'),(23941,497,'pjField',7,'title','对不起，标签不存在','script'),(23942,498,'pjField',7,'title','行程修改成功','script'),(23943,499,'pjField',7,'title','新行程添加成功','script'),(23944,500,'pjField',7,'title','添加新行程失败','script'),(23945,501,'pjField',7,'title','对不起，行程不存在','script'),(23946,502,'pjField',7,'title','没有权限修改该行程','script'),(23947,503,'pjField',7,'title','计划延长成功','script'),(23948,504,'pjField',7,'title','可上传任意数量图片，可缩放、裁剪、旋转、压缩图片，拖动排序。','script'),(23949,505,'pjField',7,'title','在这里设置预订条款等信息，将显示在申请表单的右侧。','script'),(23950,506,'pjField',7,'title','标题修改成功','script'),(23951,507,'pjField',7,'title','设置修改成功','script'),(23952,508,'pjField',7,'title','投稿修改成功','script'),(23953,509,'pjField',7,'title','配置已保存','script'),(23954,510,'pjField',7,'title','订阅邮件通知成功','script'),(23955,511,'pjField',7,'title','设置成功','script'),(23956,512,'pjField',7,'title','修改成功','script'),(23957,513,'pjField',7,'title','添加类型成功','script'),(23958,514,'pjField',7,'title','添加类型失败','script'),(23959,515,'pjField',7,'title','抱歉，该类型不存在','script'),(23960,516,'pjField',7,'title','用户修改成功','script'),(23961,517,'pjField',7,'title','修改用户失败','script'),(23962,518,'pjField',7,'title','修改用户成功','script'),(23963,519,'pjField',7,'title','抱歉，添加用户失败','script'),(23964,520,'pjField',7,'title','用户不存在','script'),(23965,523,'pjField',7,'title','账号不存在','script'),(23966,524,'pjField',7,'title','密码已发送','script'),(23967,525,'pjField',7,'title','密码发送失败','script'),(23968,526,'pjField',7,'title','修改成功','script'),(23969,527,'pjField',7,'title','备份','script'),(23970,528,'pjField',7,'title','备份完成','script'),(23971,529,'pjField',7,'title','备份失败','script'),(23972,530,'pjField',7,'title','备份失败','script'),(23973,531,'pjField',7,'title','评论修改成功','script'),(23974,532,'pjField',7,'title','数据无效','script'),(23975,533,'pjField',7,'title','评论未找到','script'),(23976,534,'pjField',7,'title','行程不存在','script'),(23977,535,'pjField',7,'title','修改申请成功','script'),(23978,536,'pjField',7,'title','添加申请成功','script'),(23979,537,'pjField',7,'title','抱歉，添加申请失败','script'),(23980,538,'pjField',7,'title','申请未找到','script'),(23981,539,'pjField',7,'title','修改标签成功','script'),(23982,540,'pjField',7,'title','添加标签成功','script'),(23983,541,'pjField',7,'title','抱歉，添加标签失败','script'),(23984,542,'pjField',7,'title','标签未找到','script'),(23985,543,'pjField',7,'title','修改行程成功','script'),(23986,544,'pjField',7,'title','添加行程成功','script'),(23987,545,'pjField',7,'title','添加行程失败','script'),(23988,546,'pjField',7,'title','行程未找到','script'),(23989,547,'pjField',7,'title','错误','script'),(23990,548,'pjField',7,'title','系统提示','script'),(23991,549,'pjField',7,'title','图片','script'),(23992,550,'pjField',7,'title','政策条款','script'),(23993,551,'pjField',7,'title','选项修改成功','script'),(23994,552,'pjField',7,'title','投稿修改成功','script'),(23995,553,'pjField',7,'title','Installation Settings Updated','script'),(23996,554,'pjField',7,'title','邮件已添加','script'),(23997,555,'pjField',7,'title','邮件已修改','script'),(23998,556,'pjField',7,'title','类型已修改','script'),(23999,557,'pjField',7,'title','类型已添加','script'),(24000,558,'pjField',7,'title','类型添加失败','script'),(24001,559,'pjField',7,'title','类型未找到','script'),(24002,560,'pjField',7,'title','用户已修改','script'),(24003,561,'pjField',7,'title','用户修改失败','script'),(24004,562,'pjField',7,'title','用户已添加','script'),(24005,563,'pjField',7,'title','添加用户失败','script'),(24006,564,'pjField',7,'title','用户未找到','script'),(24007,567,'pjField',7,'title','已发布','script'),(24008,568,'pjField',7,'title','推荐','script'),(24009,569,'pjField',7,'title','未发布','script'),(24010,570,'pjField',7,'title','未推荐','script'),(24011,571,'pjField',7,'title','100 - 500','script'),(24012,572,'pjField',7,'title','500 - 1000','script'),(24013,573,'pjField',7,'title','1000 - 1500','script'),(24014,574,'pjField',7,'title','> 1500','script'),(24015,575,'pjField',7,'title','冬季','script'),(24016,576,'pjField',7,'title','春季','script'),(24017,577,'pjField',7,'title','夏季','script'),(24018,578,'pjField',7,'title','秋季','script'),(24019,579,'pjField',7,'title','输入数据无效','script'),(24020,580,'pjField',7,'title','请求提交成功','script'),(24021,581,'pjField',7,'title','抱歉，请求提交失败','script'),(24022,582,'pjField',7,'title','评论数据无效','script'),(24023,583,'pjField',7,'title','添加评论成功','script'),(24024,584,'pjField',7,'title','添加评论成功','script'),(24025,585,'pjField',7,'title','抱歉，添加评论失败','script'),(24026,586,'pjField',7,'title','请填写验证码','script'),(24027,587,'pjField',7,'title','验证码错误','script'),(24028,588,'pjField',7,'title','请填写评论内容','script'),(24029,589,'pjField',7,'title','请填写电子邮件','script'),(24030,590,'pjField',7,'title','电子邮件格式无效','script'),(24031,591,'pjField',7,'title','请填写姓名','script'),(24032,592,'pjField',7,'title','两次密码输入不一致','script'),(24033,593,'pjField',7,'title','请填写密码','script'),(24034,594,'pjField',7,'title','请确认您的密码','script'),(24035,595,'pjField',7,'title','用户名或密码错误','script'),(24036,596,'pjField',7,'title','Access denied','script'),(24037,597,'pjField',7,'title','账户已禁用','script'),(24038,598,'pjField',7,'title','一月','script'),(24039,599,'pjField',7,'title','十月','script'),(24040,600,'pjField',7,'title','十一月','script'),(24041,601,'pjField',7,'title','十二月','script'),(24042,602,'pjField',7,'title','二月','script'),(24043,603,'pjField',7,'title','三月','script'),(24044,604,'pjField',7,'title','四月','script'),(24045,605,'pjField',7,'title','五月','script'),(24046,606,'pjField',7,'title','六月','script'),(24047,607,'pjField',7,'title','七月','script'),(24048,608,'pjField',7,'title','八月','script'),(24049,609,'pjField',7,'title','九月','script'),(24050,610,'pjField',7,'title','Dr.','script'),(24051,611,'pjField',7,'title','小姐','script'),(24052,612,'pjField',7,'title','先生','script'),(24053,613,'pjField',7,'title','夫人','script'),(24054,614,'pjField',7,'title','女士','script'),(24055,615,'pjField',7,'title','其他','script'),(24056,616,'pjField',7,'title','Prof.','script'),(24057,617,'pjField',7,'title','Rev.','script'),(24058,618,'pjField',7,'title','每晚','script'),(24059,619,'pjField',7,'title','每人','script'),(24060,620,'pjField',7,'title','总价','script'),(24061,621,'pjField',7,'title','根据过期时间自动发布','script'),(24062,622,'pjField',7,'title','未发布','script'),(24063,623,'pjField',7,'title','已发布','script'),(24064,624,'pjField',7,'title','请填写电子邮件','script'),(24065,625,'pjField',7,'title','请填写密码','script'),(24066,626,'pjField',7,'title','请确认您的密码','script'),(24067,627,'pjField',7,'title','请填写姓名','script'),(24068,628,'pjField',7,'title','请填写验证码','script'),(24069,629,'pjField',7,'title','请填写电子邮件地址','script'),(24070,630,'pjField',7,'title','请填写密码','script'),(24071,631,'pjField',7,'title','请确认您的密码','script'),(24072,632,'pjField',7,'title','请填写姓名','script'),(24073,633,'pjField',7,'title','请填写验证码','script'),(24074,634,'pjField',7,'title','验证码错误','script'),(24075,635,'pjField',7,'title','电子邮件格式错误','script'),(24076,636,'pjField',7,'title','两次密码输入不一致','script'),(24077,637,'pjField',7,'title','该邮件已被占用','script'),(24078,638,'pjField',7,'title','创建用户成功','script'),(24079,639,'pjField',7,'title','创建用户成功','script'),(24080,640,'pjField',7,'title','一月','script'),(24081,641,'pjField',7,'title','十月','script'),(24082,642,'pjField',7,'title','十一月','script'),(24083,643,'pjField',7,'title','十二月','script'),(24084,644,'pjField',7,'title','二月','script'),(24085,645,'pjField',7,'title','三月','script'),(24086,646,'pjField',7,'title','四月','script'),(24087,647,'pjField',7,'title','五月','script'),(24088,648,'pjField',7,'title','六月','script'),(24089,649,'pjField',7,'title','七月','script'),(24090,650,'pjField',7,'title','八月','script'),(24091,651,'pjField',7,'title','九月','script'),(24092,652,'pjField',7,'title','您还没登录','script'),(24093,653,'pjField',7,'title','图片过大','script'),(24094,654,'pjField',7,'title','没有权限，访问失败','script'),(24095,655,'pjField',7,'title','数据为空','script'),(24096,656,'pjField',7,'title','演示版不允许该操作','script'),(24097,657,'pjField',7,'title','未找到合适的预订信息','script'),(24098,658,'pjField',7,'title','未找到预订信息','script'),(24099,659,'pjField',7,'title','没有权限修改该预订信息','script'),(24100,660,'pjField',7,'title','没有权限修改','script'),(24101,661,'pjField',7,'title','该电子邮件已存在','script'),(24102,662,'pjField',7,'title','注册成功，请等待审核。','script'),(24103,663,'pjField',7,'title','注册成功','script'),(24104,664,'pjField',7,'title','GMT-03:00','script'),(24105,665,'pjField',7,'title','GMT-04:00','script'),(24106,666,'pjField',7,'title','GMT-05:00','script'),(24107,667,'pjField',7,'title','GMT-06:00','script'),(24108,668,'pjField',7,'title','GMT-07:00','script'),(24109,669,'pjField',7,'title','GMT-08:00','script'),(24110,670,'pjField',7,'title','GMT-09:00','script'),(24111,671,'pjField',7,'title','GMT-01:00','script'),(24112,672,'pjField',7,'title','GMT-10:00','script'),(24113,673,'pjField',7,'title','GMT-11:00','script'),(24114,674,'pjField',7,'title','GMT-12:00','script'),(24115,675,'pjField',7,'title','GMT-02:00','script'),(24116,676,'pjField',7,'title','GMT','script'),(24117,677,'pjField',7,'title','GMT+03:00','script'),(24118,678,'pjField',7,'title','GMT+04:00','script'),(24119,679,'pjField',7,'title','GMT+05:00','script'),(24120,680,'pjField',7,'title','GMT+06:00','script'),(24121,681,'pjField',7,'title','GMT+07:00','script'),(24122,682,'pjField',7,'title','GMT+08:00','script'),(24123,683,'pjField',7,'title','GMT+09:00','script'),(24124,684,'pjField',7,'title','GMT+01:00','script'),(24125,685,'pjField',7,'title','GMT+10:00','script'),(24126,686,'pjField',7,'title','GMT+11:00','script'),(24127,687,'pjField',7,'title','GMT+12:00','script'),(24128,688,'pjField',7,'title','GMT+13:00','script'),(24129,689,'pjField',7,'title','GMT+02:00','script'),(24130,690,'pjField',7,'title','未激活','script'),(24131,691,'pjField',7,'title','已激活','script'),(24132,692,'pjField',7,'title','否','script'),(24133,693,'pjField',7,'title','是','script'),(24134,758,'pjField',7,'title','搜索','script'),(24135,759,'pjField',7,'title','季节','script'),(24136,760,'pjField',7,'title','类型','script'),(24137,764,'pjField',7,'title','清空','script'),(24138,765,'pjField',7,'title','搜索','script'),(24139,766,'pjField',7,'title','照片','script'),(24140,767,'pjField',7,'title','照片','script'),(24141,832,'pjField',7,'title','未激活','script'),(24142,833,'pjField',7,'title','排序','script'),(24143,835,'pjField',7,'title','每页显示','script'),(24144,836,'pjField',7,'title','行程','script'),(24145,837,'pjField',7,'title',NULL,'script'),(24146,838,'pjField',7,'title','10条','script'),(24147,839,'pjField',7,'title','20条','script'),(24148,840,'pjField',7,'title','30条','script'),(24149,841,'pjField',7,'title','50条','script'),(24150,842,'pjField',7,'title','100条','script'),(24151,843,'pjField',7,'title','输入省份或地区','script'),(24152,844,'pjField',7,'title','置顶','script'),(24153,845,'pjField',7,'title','警告','script'),(24154,846,'pjField',7,'title','价格重叠','script'),(24155,847,'pjField',7,'title','时间','script'),(24156,912,'pjField',7,'title','行程','script'),(24157,914,'pjField',7,'title','申请','script'),(24158,915,'pjField',7,'title','咨询','script'),(24159,916,'pjField',7,'title','评论','script'),(24160,917,'pjField',7,'title','评论','script'),(24161,918,'pjField',7,'title','最受欢迎','script'),(24162,919,'pjField',7,'title','最近申请','script'),(24163,920,'pjField',7,'title','最近评论','script'),(24164,921,'pjField',7,'title','访问','script'),(24165,922,'pjField',7,'title','访问','script'),(24166,923,'pjField',7,'title','暂无咨询','script'),(24167,924,'pjField',7,'title','晚','script'),(24168,925,'pjField',7,'title','晚','script'),(24169,926,'pjField',7,'title','暂无行程','script'),(24170,927,'pjField',7,'title','暂无评论','script'),(24171,928,'pjField',7,'title','至少添加一个类型，{ADD_TYPE_TAG}点击这里{ADD_TYPE_ENDTAG}添加。','script'),(24172,929,'pjField',7,'title','航班信息','script'),(24173,930,'pjField',7,'title','如果改行程包含航班信息，请选择“是”并填写相应的航班信息，将会显示在前台行程列表中。','script'),(24174,931,'pjField',7,'title','标签','script'),(24175,932,'pjField',7,'title','请勾选预置的标签，预置标签可在设置 -> 标签中修改。','script'),(24176,933,'pjField',7,'title','行程发布人','script'),(24177,934,'pjField',7,'title','您可以设置该行程的发布人','script'),(24178,935,'pjField',7,'title','SEO设置','script'),(24179,936,'pjField',7,'title','设置Meta标签有利于搜索引擎收录','script'),(24180,937,'pjField',7,'title','取消','script'),(24181,938,'pjField',7,'title','可选','script'),(24182,940,'pjField',7,'title','按照以下步骤开启SEO优化','script'),(24183,941,'pjField',7,'title','第1步：在网站根目录创建“.htaccess”文件，将以下代码粘贴至该文件','script'),(24184,942,'pjField',7,'title','（可选）如果网站样式有问题请将以下代码粘贴至网站HEAD标签内','script'),(24185,943,'pjField',7,'title','显示全部','script'),(24186,944,'pjField',7,'title','隐藏更多','script'),(24187,945,'pjField',7,'title','评论','script'),(24188,946,'pjField',7,'title','欢迎您登录本网站','script'),(24189,947,'pjField',7,'title','欢迎您注册本网站','script'),(24190,948,'pjField',7,'title','忘记密码','script'),(24191,949,'pjField',7,'title','请输入您注册时填写的电子邮件地址，我们将把密码发送至您的邮箱。','script'),(24192,950,'pjField',7,'title','发送','script'),(24193,951,'pjField',7,'title','密码找回邮件','script'),(24194,952,'pjField',7,'title','可用标签:<br/> {Password} - 密码','script'),(24195,953,'pjField',7,'title','请填写电子邮件','script'),(24196,954,'pjField',7,'title','请填写电子邮件','script'),(24197,955,'pjField',7,'title','电子邮件格式错误','script'),(24198,956,'pjField',7,'title','电子邮件不存在','script'),(24199,957,'pjField',7,'title','密码已经发送至您的邮箱','script'),(24200,958,'pjField',7,'title','ID','script'),(24201,959,'pjField',7,'title','(日期为空)','script'),(24202,960,'pjField',7,'title','(日期无效)','script'),(24203,961,'pjField',7,'title','(时间为空)','script'),(24204,962,'pjField',7,'title','(时间无效)','script'),(24205,963,'pjField',7,'title','系统自动生成ID，您也可以随时修改。','script'),(24206,964,'pjField',7,'title','推荐行程在前台列表显示“推荐”标签，同时会显示在首页推荐行程栏目中。','script'),(24207,965,'pjField',7,'title','选择是否显示发布人的联系方式','script'),(24208,966,'pjField',7,'title','请保证写法统一，例如“北京”，“北京市”在前台筛选时会作为不同城市。','script'),(24209,967,'pjField',7,'title','SEO标题，有利于搜索引擎收录','script'),(24210,968,'pjField',7,'title','SEO关键字，有利于搜索引擎收录','script'),(24211,969,'pjField',7,'title','SEO描述，有利于搜索引擎收录','script'),(24212,970,'pjField',7,'title','设置日期选择面板的显示方式','script'),(24213,971,'pjField',7,'title','设置日期选择面板的显示方式','script'),(24214,972,'pjField',7,'title','设置网站的默认货币','script'),(24215,973,'pjField',7,'title','当有新的申请时，将发送邮件通知给行程发布人。发布人为空时，邮件将发给系统管理员。','script'),(24216,974,'pjField',7,'title',' 当有新的申请时，将发送邮件通知给行程发布人。发布人为空时，邮件将发给系统管理员。','script'),(24217,975,'pjField',7,'title','有新用户注册时，系统将发邮件通知管理员。','script'),(24218,976,'pjField',7,'title','用户找回密码是发送该邮件','script'),(24219,977,'pjField',7,'title','无限制','script'),(24220,978,'pjField',7,'title','设置用户何时会收到邮件通知','script'),(24221,979,'pjField',7,'title','选择新用户是否需要审核','script'),(24222,980,'pjField',7,'title','管理系统用户','script'),(24223,981,'pjField',7,'title',' “管理员”拥有整站最高控制权限，“编辑”可访问除“通用设置”、“投稿”、“翻译”、“备份”、“管理员”外的其他功能，“发布人”可管理由其发布的行程及其申请与评论。','script'),(24224,982,'pjField',7,'title','添加新行程','script'),(24225,1000,'pjField',7,'title','请设置行程类型、引用ID，两项均为必填。引用ＩＤ由系统自动生成，您也可以随时修改。','script'),(24226,1001,'pjField',7,'title','行程概览','script'),(24227,1002,'pjField',7,'title','将行程状态设置为“未发布”将不在前台显示，设置为“已发布”并设置过期时间，系统将根据过期时间自动显示该行程，设置为“无限制”则会永久显示该行程。','script'),(24228,1003,'pjField',7,'title','航班信息','script'),(24229,1004,'pjField',7,'title','如果该行程包含航班信息，请选择“是”并填写航班信息。','script'),(24230,1005,'pjField',7,'title','标签','script'),(24231,1006,'pjField',7,'title','请选择标签','script'),(24232,1007,'pjField',7,'title','行程发布人','script'),(24233,1008,'pjField',7,'title','设置行程详细页是否显示联系信息','script'),(24234,1009,'pjField',7,'title','邮件通知','script'),(24235,1010,'pjField',7,'title','系统将会在以下情况自动发送邮件通知，您可以设置邮件的格式，可将标签插入至邮件正文中，发送时将会自动替换其中的内容。','script'),(24236,1,'pjNotification',7,'confirm_subject','【科威旅游管理系统】新申请提醒','script'),(24237,1,'pjNotification',7,'confirm_message','您好{OwnerName}，\r\n\r\n行程 {ListingID}有了新的申请\r\n\r\n申请ID :：{EnquiryID}\r\n申请人：{FullName}\r\nE-mail:：{Email}\r\n联系方式： {Phone}\r\n申请行程： {ListingTitle}, {ListingID}\r\n开始时间：{StartDate}\r\n截止时间： {EndDate}\r\n备注：{Notes}\r\n\r\n科威旅游管理系统\r\n','script'),(24238,1,'pjNotification',7,'notify_subject','【科威旅游管理系统】新评论提醒','script'),(24239,1,'pjNotification',7,'notify_message','您好 {OwnerName}，\r\n\r\n行程 {RefID} 有了新的评论\r\n\r\n评论人： {Name}\r\nE-mail:：{Email} \r\n评论行程： {ListingTitle}, {ListingID}\r\n评分： {Rating}\r\n评论标题： {Title}\r\n评论内容： {Comment}\r\n\r\n科威旅游管理系统\r\n','script'),(24240,1,'pjNotification',7,'new_account_subject','【科威旅游管理系统】新发布人注册提醒','script'),(24241,1,'pjNotification',7,'new_account_message','管理员您好，\r\n\r\n{Name} 刚刚注册了发布人账号，请登录后台审核.\r\n注册邮箱：{Email}\r\n\r\n科威旅游管理系统\r\n','script'),(24242,1,'pjNotification',7,'forgot_subject','【科威旅游管理系统】密码找回','script'),(24243,1,'pjNotification',7,'forgot_message','您好，\r\n\r\n您的密码是：{Password}\r\n\r\n科威旅游管理系统\r\n','script'),(24244,1081,'pjField',7,'title','回复','script'),(24245,1082,'pjField',7,'title','查看全部回复','script'),(24246,1083,'pjField',7,'title','输入省份或地区','script'),(24247,1084,'pjField',7,'title','整合方式','script'),(24248,1085,'pjField',7,'title','全部语言显示在同一页面','script'),(24249,1086,'pjField',7,'title','每一页面显示一种语言','script'),(24250,1087,'pjField',7,'title','若推荐行程超过该数量，则会从中随机显示。','script'),(24251,1089,'pjField',7,'title','评论不存在','script'),(24252,1090,'pjField',7,'title','评论内容不能为空','script'),(24253,1160,'pjField',7,'title','页面','script'),(24254,1161,'pjField',7,'title','目的地','script'),(24255,1162,'pjField',7,'title','首页幻灯片','script'),(24256,1163,'pjField',7,'title','添加目的地','script'),(24257,1164,'pjField',7,'title','省份','script'),(24258,1165,'pjField',7,'title','描述','script'),(24259,1166,'pjField',7,'title','目的地','script'),(24260,1167,'pjField',7,'title','修改目的地','script'),(24261,1168,'pjField',7,'title','全部','script'),(24262,1169,'pjField',7,'title','目的地未找到','script'),(24263,1170,'pjField',7,'title','目的地修改成功','script'),(24264,1171,'pjField',7,'title','目的地修改成功','script'),(24265,1172,'pjField',7,'title','目的地修改失败','script'),(24266,1173,'pjField',7,'title','目的地不存在','script'),(24267,1174,'pjField',7,'title','目的地修改成功','script'),(24268,1175,'pjField',7,'title','目的地添加成功','script'),(24269,1176,'pjField',7,'title','目的地添加失败','script'),(24270,1177,'pjField',7,'title','目的地管理','script'),(24271,1178,'pjField',7,'title','设置“显示在首页”后，该目的地将显示在首页相应的位置，设置为“未发布”可以取消显示。','script'),(24272,1179,'pjField',7,'title','添加目的地','script'),(24273,1180,'pjField',7,'title','填写下表添加目的地','script'),(24274,1181,'pjField',7,'title','修改目的地','script'),(24275,1182,'pjField',7,'title','填写下表添加目的地','script'),(24276,1183,'pjField',7,'title','添加页面','script'),(24277,1184,'pjField',7,'title','修改页面','script'),(24278,1185,'pjField',7,'title','描述','script'),(24279,1186,'pjField',7,'title','填写下表修改页面。缩略图大小为705 x 355px，过大系统会自动裁剪。','script'),(24280,1187,'pjField',7,'title','修改页面','script'),(24281,1188,'pjField',7,'title','填写下表添加页面','script'),(24282,1189,'pjField',7,'title','添加页面','script'),(24283,1190,'pjField',7,'title','您只能修改页面内容，不能添加或修改页面，也可以修改其状态为“未发布”来在前台隐藏。','script'),(24284,1191,'pjField',7,'title','管理页面','script'),(24285,1192,'pjField',7,'title','页面未找到','script'),(24286,1193,'pjField',7,'title','添加页面失败','script'),(24287,1194,'pjField',7,'title','添加页面成功','script'),(24288,1195,'pjField',7,'title','修改页面成功','script'),(24289,1196,'pjField',7,'title','页面不存在','script'),(24290,1197,'pjField',7,'title','页面添加失败','script'),(24291,1198,'pjField',7,'title','页面修改成功','script'),(24292,1199,'pjField',7,'title','页面修改成功','script'),(24293,1200,'pjField',7,'title','SEO标题','script'),(24294,1201,'pjField',7,'title','SEO关键字','script'),(24295,1202,'pjField',7,'title','标题','script'),(24296,1203,'pjField',7,'title','SEO URL','script'),(24297,1204,'pjField',7,'title','添加新幻灯片','script'),(24298,1205,'pjField',7,'title','修改幻灯片','script'),(24299,1206,'pjField',7,'title','排序','script'),(24300,1207,'pjField',7,'title','图片','script'),(24301,1208,'pjField',7,'title','URL','script'),(24302,1209,'pjField',7,'title','打开方式','script'),(24303,1210,'pjField',7,'title','标题','script'),(24304,1211,'pjField',7,'title','描述','script'),(24305,1212,'pjField',7,'title','新窗口打开','script'),(24306,1213,'pjField',7,'title','当前窗口打开','script'),(24307,1214,'pjField',7,'title','幻灯片大小291 x 302px，过大系统会自动裁剪。','script'),(24308,1215,'pjField',7,'title','添加幻灯片失败','script'),(24309,1216,'pjField',7,'title','管理首页幻灯片','script'),(24310,1217,'pjField',7,'title','建议最多添加8张幻灯片，以免减慢网站加载速度。','script'),(24311,1218,'pjField',7,'title','添加首页幻灯片','script'),(24312,1219,'pjField',7,'title','幻灯片大小291 x 302px，过大系统会自动裁剪。','script'),(24313,1220,'pjField',7,'title','修改幻灯片','script'),(24314,1221,'pjField',7,'title','幻灯片未找到','script'),(24315,1222,'pjField',7,'title','修改幻灯片成功','script'),(24316,1223,'pjField',7,'title','修改幻灯片成功','script'),(24317,1224,'pjField',7,'title','添加幻灯片失败','script'),(24318,1225,'pjField',7,'title','幻灯片不存在','script'),(24319,1226,'pjField',7,'title','修改幻灯片成功','script'),(24320,1227,'pjField',7,'title','添加幻灯片成功','script'),(24321,1228,'pjField',7,'title','删除确认','script'),(24322,1229,'pjField',7,'title','您确定删除选中图片吗？','script'),(24323,1230,'pjField',7,'title','裁剪','script'),(24324,1231,'pjField',7,'title','Seo URL','script'),(24325,1232,'pjField',7,'title','显示在首页','script'),(24326,1233,'pjField',7,'title','是','script'),(24327,1234,'pjField',7,'title','否','script'),(24328,1235,'pjField',7,'title','“优惠行程”将显示在首页优惠区域，并带有打折标签。','script'),(24329,1236,'pjField',7,'title','设置为优惠行程','script'),(24330,1237,'pjField',7,'title','全部','script'),(24331,1238,'pjField',7,'title','优惠行程','script'),(24332,1239,'pjField',7,'title','晚','script'),(24333,1240,'pjField',7,'title','联系邮件','script'),(24334,1241,'pjField',7,'title','可用标签：</br> {Name} - 姓名</br> {Email} - Email</br> {Phone} - 电话</br> {Question} - 问题标题</br> {IP} - IP地址','script'),(24335,1242,'pjField',7,'title','该邮件将发给网站管理员','script'),(24336,1,'pjNotification',7,'contact_subject','【科威旅游管理系统】新反馈提醒','script'),(24337,1,'pjNotification',7,'contact_message','您好，\r\n\r\n系统收到了新的反馈，请登录后台查看。\r\n\r\n姓名： {Name}\r\nEmail： {Email}\r\n联系方式：{Phone}\r\n咨询问题：{Question}\r\n\r\nIP: {IP}\r\n\r\n科威旅游管理系统\r\n','script'),(24338,1243,'pjField',7,'title','缩略图','script'),(24339,1244,'pjField',7,'title','缩略图','script'),(24340,1245,'pjField',7,'title','标题','script'),(24341,1246,'pjField',7,'title','标题','script'),(24342,1,'pjPage',7,'title','关于 - 科威旅行管理系统','script'),(24343,3,'pjPage',7,'title','服务条款 - 科威旅游管理系统','script'),(24344,2,'pjPage',7,'title','目的地 - 科威旅游管理系统','script'),(24345,1247,'pjField',7,'title','腾讯微博','script'),(24346,1248,'pjField',7,'title','新浪微博','script'),(24347,1249,'pjField',7,'title','订阅','script'),(24348,1250,'pjField',7,'title','添加订阅','script'),(24349,1251,'pjField',7,'title','修改订阅','script'),(24350,1252,'pjField',7,'title','Email','script'),(24351,1253,'pjField',7,'title','订阅时间','script'),(24352,1254,'pjField',7,'title','取消订阅时间','script'),(24353,1255,'pjField',7,'title','是否订阅','script'),(24354,1256,'pjField',7,'title','订阅已修改','script'),(24355,1257,'pjField',7,'title','订阅已修改','script'),(24356,1258,'pjField',7,'title','添加订阅失败','script'),(24357,1259,'pjField',7,'title','订阅不存在','script'),(24358,1260,'pjField',7,'title','以下为订阅列表，您可以导出该列表，发送通知邮件。','script'),(24359,1261,'pjField',7,'title','填写以下表单添加订阅','script'),(24360,1262,'pjField',7,'title','填写以下表单修改订阅','script'),(24361,1263,'pjField',7,'title','修改订阅','script'),(24362,1264,'pjField',7,'title','修改订阅成功','script'),(24363,1265,'pjField',7,'title','添加订阅成功','script'),(24364,1266,'pjField',7,'title','添加订阅失败','script'),(24365,1267,'pjField',7,'title','订阅未找到','script'),(24366,1268,'pjField',7,'title','订阅列表','script'),(24367,1269,'pjField',7,'title','添加订阅','script'),(24368,1270,'pjField',7,'title','该邮件已存在','script'),(24369,1271,'pjField',7,'title','电子邮件错误','script'),(24370,1396,'pjField',7,'title','添加Banner失败','script'),(24371,1397,'pjField',7,'title','Banner未找到','script'),(24372,1398,'pjField',7,'title','修改Banner成功','script'),(24373,1399,'pjField',7,'title','修改Banner成功','script'),(24374,1400,'pjField',7,'title','添加Banner失败','script'),(24375,1401,'pjField',7,'title','Banner不存在','script'),(24376,1402,'pjField',7,'title','修改Banner成功','script'),(24377,1403,'pjField',7,'title','添加Banner成功','script'),(24378,1404,'pjField',7,'title','填写下表修改Banner','script'),(24379,1405,'pjField',7,'title','管理Banner','script'),(24380,1406,'pjField',7,'title','Banner数量无上限，留空不显示','script'),(24381,1407,'pjField',7,'title','添加新Banner','script'),(24382,1408,'pjField',7,'title','填写下表添加Banner','script'),(24383,1409,'pjField',7,'title','修改Banner','script'),(24384,1410,'pjField',7,'title','添加Banner','script'),(24385,1411,'pjField',7,'title','修改Banner','script'),(24386,1412,'pjField',7,'title','URL','script'),(24387,1413,'pjField',7,'title','打开方式','script'),(24388,1414,'pjField',7,'title','Banner管理','script'),(24389,1415,'pjField',7,'title','类型','script'),(24390,1416,'pjField',7,'title','图片(JPG, PNG, GIF)','script'),(24391,1418,'pjField',7,'title','HTML代码(Iframe, Javascript, etc.)','script'),(24392,1419,'pjField',7,'title','HTML代码','script'),(24393,1420,'pjField',7,'title','图片','script'),(24394,1421,'pjField',7,'title','内容','script'),(24395,1422,'pjField',7,'title','图片替代文本','script'),(24396,1423,'pjField',7,'title','图片标题','script'),(24397,1424,'pjField',7,'title','问题发送成功','script'),(24398,1425,'pjField',7,'title','系统消息','script'),(24399,1426,'pjField',7,'title','系统消息','script'),(24400,1427,'pjField',7,'title','留言发送失败，请稍后再试','script'),(24401,1428,'pjField',7,'title','系统消息','script'),(24402,1429,'pjField',7,'title','缺少参数','script'),(24403,1430,'pjField',7,'title','系统消息','script'),(24404,1431,'pjField',7,'title','抱歉，本站未开启投稿功能','script'),(24405,1432,'pjField',7,'title','系统消息','script'),(24406,1433,'pjField',7,'title','密码已经发送至您的邮箱，请查收','script'),(24407,1434,'pjField',7,'title','系统消息','script'),(24408,1435,'pjField',7,'title','密码发送失败，请稍后再试','script'),(24409,1436,'pjField',7,'title','系统消息','script'),(24410,1437,'pjField',7,'title','缺少参数','script'),(24411,1438,'pjField',7,'title','系统消息','script'),(24412,1439,'pjField',7,'title','未知错误，请联系管理员','script'),(24413,1440,'pjField',7,'title','系统消息','script'),(24414,1441,'pjField',7,'title','未找到该用户','script'),(24415,1442,'pjField',7,'title','系统消息','script'),(24416,1443,'pjField',7,'title','注册成功','script'),(24417,1444,'pjField',7,'title','系统消息','script'),(24418,1445,'pjField',7,'title','验证邮件发送失败','script'),(24419,1446,'pjField',7,'title','缺少参数','script'),(24420,1447,'pjField',7,'title','系统消息','script'),(24421,1448,'pjField',7,'title','系统消息','script'),(24422,1449,'pjField',7,'title','系统消息','script'),(24423,1450,'pjField',7,'title','该邮箱已被使用','script'),(24424,1451,'pjField',7,'title','您还未注册，请稍后再试','script'),(24425,1452,'pjField',7,'title','系统消息','script'),(24426,1453,'pjField',7,'title','验证邮件发送失败','script'),(24427,1482,'pjField',7,'title','Logo','script'),(24428,1483,'pjField',7,'title','图片标题','script'),(24429,1484,'pjField',7,'title','图片替代文本','script'),(24430,1485,'pjField',7,'title','图片','script'),(24431,1,'pjOption',7,'title','Travel website','script'),(24432,1,'pjOption',7,'alt','Find your holiday home!','script'),(24433,1486,'pjField',7,'title','是','script'),(24434,1487,'pjField',7,'title','否','script'),(24435,1488,'pjField',7,'title','是（显示在首页）','script'),(24436,1,'pjPage',7,'name','关于我们','script'),(24437,1,'pjPage',7,'full_desc','<p>&nbsp;</p>\r\n<p><span style=\"font-weight: bold;\">Proin ante sapien, porta eu malesuada vitae, pulvinar eget erat.</span></p>\r\n<p>&nbsp;</p>\r\n<p>Proin ante sapien, porta eu malesuada vitae, pulvinar eget erat. Fusce eget orci ut erat sollicitudin venenatis quis quis lacus. Nullam feugiat risus quis diam interdum cursus. Donec quis sem vel felis consectetur adipiscing nec sed orci. Maecenas eget mi id turpis tempor vehicula.</p>\r\n<p>&nbsp;</p>\r\n<p>Proin ante sapien, porta eu malesuada vitae, pulvinar eget erat. Fusce eget orci ut erat sollicitudin venenatis quis quis lacus. Nullam feugiat risus quis diam interdum cursus. Donec quis sem vel felis consectetur adipiscing nec sed orci. Maecenas eget mi id turpis tempor vehicula.</p>\r\n<p>&nbsp;</p>\r\n<p>Proin ante sapien, porta eu malesuada vitae, pulvinar eget erat. Fusce eget orci ut erat sollicitudin venenatis quis quis lacus. Nullam feugiat risus quis diam interdum cursus. Donec quis sem vel felis consectetur adipiscing nec sed orci. Maecenas eget mi id turpis tempor vehicula.</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<table style=\"height: 82px;\" width=\"498\">\r\n<tbody>\r\n<tr>\r\n<td>\r\n<p><span style=\"font-size: 11pt; font-weight: bold;\">Lorem ipsum dolor sit amet.</span></p>\r\n<p>&nbsp;</p>\r\n<p><span style=\"font-weight: bold;\">Proin ante sapien, porta eu malesuada vitae, pulvinar eget erat.</span></p>\r\n<p>&nbsp;</p>\r\nProin ante sapien, porta eu malesuada vitae, pulvinar eget erat. Fusce eget orci ut erat sollicitudin venenatis quis quis lacus. Nullam feugiat risus quis diam interdum cursus. Donec quis sem vel felis consectetur adipiscing nec sed orci. Maecenas eget mi id turpis tempor vehicula.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>\r\n<td>&nbsp;<img src=\"app/web/upload/tinymce-source/About us iamge small.jpg\" alt=\"\" width=\"338\" height=\"241\" /></td>\r\n</tr>\r\n<tr>\r\n<td>&nbsp;\r\n<p><span style=\"font-size: 11pt; font-weight: bold;\">Lorem ipsum dolor sit amet.</span></p>\r\n<p>&nbsp;</p>\r\n<p><span style=\"font-weight: bold;\">Proin ante sapien, porta eu malesuada vitae, pulvinar eget erat.</span></p>\r\n<p>&nbsp;</p>\r\nProin ante sapien, porta eu malesuada vitae, pulvinar eget erat. Fusce eget orci ut erat sollicitudin venenatis quis quis lacus. Nullam feugiat risus quis diam interdum cursus. Donec quis sem vel felis consectetur adipiscing nec sed orci. Maecenas eget mi id turpis tempor vehicula.</td>\r\n<td>&nbsp; <img src=\"app/web/upload/tinymce-source/About us iamge small.jpg\" alt=\"\" width=\"338\" height=\"241\" /></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>','script'),(24438,1,'pjPage',7,'meta_title','关于 - 科威旅行管理系统','script'),(24439,1,'pjPage',7,'meta_desc','关于 - 科威旅行管理系统','script'),(24440,2,'pjPage',7,'name','目的地','script'),(24441,2,'pjPage',7,'full_desc','<p>&nbsp;</p>\r\n<p><span style=\"font-weight: bold; font-size: 11pt;\">Lorem ipsum dolor sit amet, consectetur adipiscing elit.</span></p>\r\n<p>&nbsp;</p>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc malesuada accumsan luctus. Sed consequat fermentum metus, eu accumsan mi. Nullam a diam sit amet purus tincidunt volutpat. Donec ante nunc, gravida sed congue sit amet, ultrices sed turpis. Etiam congue sed urna vel vestibulum. Ut tempus faucibus luctus.</p>\r\n<p>&nbsp;</p>\r\n<p>Proin posuere nulla commodo diam suscipit congue. Vivamus pulvinar sed odio non fringilla. Aliquam enim ante, lobortis non enim eget, fringilla fermentum leo. Vestibulum lacus erat, porta at aliquam eget, aliquam id ligula. Vivamus lobortis consequat felis, sit amet facilisis velit rhoncus vitae. Nunc consequat, purus ut sagittis mollis, diam magna consequat risus, in sagittis felis leo vel diam. Nulla laoreet sollicitudin magna, sit amet gravida mauris.</p>\r\n<p>&nbsp;</p>\r\n<table style=\"height: 82px;\" width=\"498\">\r\n<tbody>\r\n<tr>\r\n<td>\r\n<p><span style=\"font-size: 11pt; font-weight: bold;\">Lorem ipsum dolor sit amet.</span></p>\r\n<p>&nbsp;</p>\r\n<p><span style=\"font-weight: bold;\">Proin ante sapien, porta eu malesuada vitae, pulvinar eget erat.</span></p>\r\n<p>&nbsp;</p>\r\nProin ante sapien, porta eu malesuada vitae, pulvinar eget erat. Fusce eget orci ut erat sollicitudin venenatis quis quis lacus. Nullam feugiat risus quis diam interdum cursus. Donec quis sem vel felis consectetur adipiscing nec sed orci. Maecenas eget mi id turpis tempor vehicula.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>\r\n<td>&nbsp;<img src=\"app/web/upload/tinymce-source/About us iamge small.jpg\" alt=\"\" width=\"338\" height=\"241\" /></td>\r\n</tr>\r\n<tr>\r\n<td>&nbsp;\r\n<p><span style=\"font-size: 11pt; font-weight: bold;\">Lorem ipsum dolor sit amet.</span></p>\r\n<p>&nbsp;</p>\r\n<p><span style=\"font-weight: bold;\">Proin ante sapien, porta eu malesuada vitae, pulvinar eget erat.</span></p>\r\n<p>&nbsp;</p>\r\nProin ante sapien, porta eu malesuada vitae, pulvinar eget erat. Fusce eget orci ut erat sollicitudin venenatis quis quis lacus. Nullam feugiat risus quis diam interdum cursus. Donec quis sem vel felis consectetur adipiscing nec sed orci. Maecenas eget mi id turpis tempor vehicula.</td>\r\n<td>&nbsp; <img src=\"app/web/upload/tinymce-source/Hawai - small 2.jpg\" alt=\"\" width=\"338\" height=\"241\" /></td>\r\n</tr>\r\n</tbody>\r\n</table>','script'),(24442,2,'pjPage',7,'meta_title','目的地 - 科威旅游管理系统','script'),(24443,2,'pjPage',7,'meta_desc','目的地 - 科威旅游管理系统','script'),(24444,3,'pjPage',7,'name','服务条款','script'),(24445,3,'pjPage',7,'full_desc','<div id=\"lipsum\">\r\n<p>&nbsp;</p>\r\n<p><span style=\"font-weight: bold;\">Pellentesque volutpat sit amet sapien nec sagittis.</span></p>\r\n<p>&nbsp;</p>\r\n<p>Pellentesque volutpat sit amet sapien nec sagittis. Morbi malesuada ullamcorper turpis, vel aliquet dui tristique ac. Sed nunc nisi, vehicula ut lorem a, molestie semper risus. Nulla vehicula bibendum erat a facilisis. Curabitur tempor elit quis dapibus aliquet. Aliquam id quam vel dolor vehicula facilisis. Suspendisse eu arcu ac mi cursus consequat.</p>\r\n<p>&nbsp;</p>\r\n<p>Etiam hendrerit diam suscipit neque dignissim, in aliquam magna feugiat. Nullam eu consequat felis. Curabitur lacinia lectus non neque cursus tempus. Curabitur sit amet nulla adipiscing, porta metus nec, adipiscing quam.</p>\r\n<p>&nbsp;</p>\r\n<p>Sed nec magna interdum dui bibendum luctus. Duis nec sapien velit. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Nam placerat libero at quam dignissim, non fringilla ante interdum.</p>\r\n<p>&nbsp;</p>\r\n<p>Aliquam lobortis, est a luctus luctus, risus neque ullamcorper ligula, pharetra adipiscing purus orci condimentum velit. Quisque molestie porta elementum. Integer eleifend consectetur quam. Vestibulum vitae nulla nulla.</p>\r\n<p>&nbsp;</p>\r\n<p>Suspendisse pharetra, leo ut luctus commodo, diam leo laoreet leo, eu aliquam neque sem nec est.</p>\r\n</div>','script'),(24446,3,'pjPage',7,'meta_title','服务条款 - 科威旅游管理系统','script'),(24447,3,'pjPage',7,'meta_desc','服务条款 - 科威旅游管理系统','script'),(24460,1695,'pjField',7,'title','请填写手机号码','script'),(24461,1696,'pjField',7,'title','请填写咨询内容','script'),(24462,1697,'pjField',7,'title','点击刷新验证码','script'),(24463,1699,'pjField',7,'title','咨询内容','script'),(24464,1700,'pjField',7,'title','欢迎您与我们联系','script'),(24465,1701,'pjField',7,'title','联系我们','script'),(24466,1702,'pjField',7,'title','首页','script'),(24467,1703,'pjField',7,'title','行程','script'),(24468,1704,'pjField',7,'title','优惠','script'),(24469,1706,'pjField',7,'title','目的地','script'),(24470,1707,'pjField',7,'title','关于我们','script'),(24471,1708,'pjField',7,'title','联系我们','script'),(24472,1709,'pjField',7,'title','订阅','script'),(24473,1710,'pjField',7,'title','订阅最新资讯','script'),(24474,1711,'pjField',7,'title','输入电子邮件地址','script'),(24475,1712,'pjField',7,'title','关注腾讯微博','script'),(24476,1713,'pjField',7,'title','关注新浪微博','script'),(24477,1714,'pjField',7,'title','All rights reserved.<div style="display:none"><script language="javascript" type="text/javascript" src="http://js.users.51.la/18686940.js"></script></div>','script'),(24478,1715,'pjField',7,'title','服务条款','script'),(24479,1716,'pjField',7,'title','选择目的地','script'),(24480,1717,'pjField',7,'title','最受欢迎','script'),(24481,1718,'pjField',7,'title','优惠','script'),(24482,1719,'pjField',7,'title','推荐行程','script'),(24483,1720,'pjField',7,'title','搜索景点','script'),(24484,1721,'pjField',7,'title','价格','script'),(24485,1722,'pjField',7,'title','最低','script'),(24486,1723,'pjField',7,'title','表格视图','script'),(24487,1724,'pjField',7,'title','列表视图','script'),(24488,1725,'pjField',7,'title','地图','script'),(24489,1726,'pjField',7,'title','请填写备注','script'),(24490,1727,'pjField',7,'title','请填写标题','script'),(24491,1728,'pjField',7,'title','请至少填写6个字符','script'),(24492,1729,'pjField',7,'title','请最多填写6个字符','script'),(24493,1730,'pjField',7,'title','请填写开始日期','script'),(24494,1731,'pjField',7,'title','请填写结束日期','script'),(24507,1732,'pjField',7,'title','消息','script'),(24508,1733,'pjField',7,'title','优惠默认视图','script'),(24509,1734,'pjField',7,'title','行程默认视图','script'),(24510,1735,'pjField',7,'title','请开启您浏览器的JavaScript功能q','script'),(24511,1736,'pjField',7,'title','菜单','script'),(24512,1,'pjType',7,'name','主题游','script'),(24513,2,'pjType',7,'name','当季游','script'),(24514,3,'pjType',7,'name','周边游','script'),(24515,4,'pjType',7,'name','国外游','script'),(24516,5,'pjType',7,'name','国内游','script'),(24581,1,'pjDestination',7,'name','巴黎','script'),(24582,1,'pjDestination',7,'title','巴黎 - The City of Lovers','script'),(24583,1,'pjDestination',7,'full_desc','<p>&nbsp;</p>\r\n<p><span style=\"font-weight: bold; font-size: 11pt;\">走进巴黎</span></p>\r\n<p>&nbsp;</p>\r\n<p>巴黎是法国的首都，也是这个国家的心脏。法国的公路里程从巴黎圣母院开始，一块小小的石碑标志着这个国家的中心。 法国人有两种，一种是&ldquo;巴黎人&rdquo;，另一种是&ldquo;住在巴黎以外的人&rdquo;。 今天的巴黎人依然走在十九世纪的碎石路上，在这条大道的沿线，点缀着这些名字：协和广场、凯旋门、卢浮宫、巴黎圣母院&hellip;&hellip;在这条大道上走过的是雨果、波德莱尔、居里夫人、毕加索、乔伊斯&hellip;&hellip; 大多数游客心中向往的，是一个古老而浪漫的巴黎，一个极具历史感的巴黎。这里的名胜古迹已足以让人流连忘返，而另一个充满前卫与波西米亚气息的巴黎同样让人心驰神往。</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<table style=\"height: 1021px;\" width=\"884\" cellspacing=\"20\">\r\n<tbody>\r\n<tr>\r\n<td height=\"380\">\r\n<p><span style=\"font-size: 11pt; font-weight: bold;\">卢浮宫</span></p>\r\n<p>&nbsp;</p>\r\n<p><span style=\"font-weight: bold;\">除周二闭馆外，每天开放时间为9:00-18:00</span></p>\r\n<p>&nbsp;</p>\r\n卢浮宫作为世界三大博物馆之一而享誉全球，其艺术藏品种类之丰富、艺术价值之高令人难以想象，而它本身也是一座建筑瑰宝。卢浮宫始建于1204年，历经800多年扩建、重修达到今天的规模。它曾是塞纳河右岸的一座城堡，后来是法国王室的宫殿，1793年，卢浮宫正式对外开放成为公共博物馆。<br />卢浮宫占地面积（含草坪）约为45公顷，建筑物占地面积为4.8公顷。全长680米。它的整体建筑呈&ldquo;U&rdquo;形，分为新、老两部分。老卢浮宫建于路易十四时期，新卢浮宫建于拿破仑时代。博物馆收藏的艺术品已达40万件，其中包括雕塑、绘画、美术工艺及古代东方、古代埃及和古希腊罗马等7个门类。美籍华裔设计师贝聿铭设计的金字塔入口如今是卢浮宫的主入口，这一设计使参观路线更加合理化，这一当代建筑设计也与卢浮宫原本的古典风格完美融合，成为卢浮宫的新标志。&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;</td>\r\n<td>&nbsp; <img src=\"app/web/upload/tinymce-source/10-Paris.jpg\" alt=\"\" width=\"350\" height=\"176\" /></td>\r\n</tr>\r\n<tr>\r\n<td height=\"418\">&nbsp;\r\n<p><span style=\"font-size: 11pt; font-weight: bold;\">埃菲尔铁塔</span></p>\r\n<p>&nbsp;</p>\r\n<p><span style=\"font-weight: bold;\">1月1日-6月14日、9月2日-12月31日开放时间：9:30-23:45&nbsp;</span></p>\r\n<p>&nbsp;</p>\r\n埃菲尔铁塔是1889年巴黎世博会的产物，塔身高300米，天线高24米，总高324米。在建成之初，这座造型奇特的金属庞然大物曾经引起包括莫泊桑在内的法国人的反对。时光流逝，当年的反对之声已经消散在历史的尘嚣中，如今的埃菲尔铁塔是巴黎的绝对地标，法兰西的骄傲。<br />埃菲尔铁塔得名于设计它的桥梁工程师居斯塔夫-埃菲尔。建造埃菲尔铁塔的初衷，是为了纪念法国大革命100周年和迎接在巴黎举办的国际博览会。在建造之初，铁塔曾颇受争议，没想到在建成后，这座金属建筑竟产生了世界性的轰动效应，一举成为巴黎乃至整个法国的最具代表性的建筑。<br />在1931年纽约帝国大厦落成前，埃菲尔铁塔保持了45年世界最高建筑物的地位。如今铁塔每年接待近千万游客，塔内设有餐馆，酒吧，影院等设施，是休闲娱乐的好地方；这里还是俯瞰巴黎的最佳瞭望台，是结束巴黎之旅的最佳地点。</td>\r\n<td>&nbsp; <img src=\"app/web/upload/tinymce-source/12-Paris.jpg\" alt=\"\" width=\"350\" height=\"233\" /></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>','script'),(24584,1,'pjDestination',7,'meta_title','巴黎 - The City of Lovers','script'),(24585,1,'pjDestination',7,'meta_desc','巴黎 - The City of Lovers','script'),(24586,2,'pjDestination',7,'name','香港','script'),(24587,2,'pjDestination',7,'title','香港 - 东方之珠 风采依然浪漫','script'),(24588,2,'pjDestination',7,'full_desc','<p>&nbsp;</p>\r\n<p><span style=\"font-weight: bold; font-size: 11pt;\">走进香港</span></p>\r\n<p>&nbsp;</p>\r\n<p>香港作为中西文化汇流的聚点，高度的文化差异造就了香港成为国际性的大都会。这里可谓包罗万象，这是个浓缩的精华的世界，是繁华热闹的不夜城，它也成为了人人欲看的万象之都。 香港处于交通枢纽，零关税的商贸要地，使之赢得&ldquo;购物天堂&rdquo;的美誉，生活物品送往迎来，高端商品的价位让购物狂们心中作痒；长年华洋共处的文化背景，加上港岛自身文化与手艺的灵巧发挥，变幻出独树一格的港式粤菜；太平山缆车、浅水湾海景、维港夜景让这颗东方明珠浪漫依然&hellip;&hellip;感受都市辉煌，让我们一起来见识独具魅力的香港面貌吧！</p>\r\n<p>&nbsp;</p>\r\n<table style=\"height: 829px;\" width=\"873\" cellspacing=\"20\">\r\n<tbody>\r\n<tr>\r\n<td height=\"418\">\r\n<p><span style=\"font-size: 11pt; font-weight: bold;\">维多利亚港</span></p>\r\n<p>&nbsp;</p>\r\n<p><span style=\"font-weight: bold;\">全天开放。每晚8:00有&ldquo;幻彩咏香江&rdquo;灯光音乐汇演免费欣赏。</span></p>\r\n<p>&nbsp;</p>\r\n维多利亚港是亚洲的第一大海港，世界第三大。维多利亚港（简称维港，英语：Victoria Harbour）是位于香港的香港岛和九龙半岛之间的海港。由于港阔水深，为天然良港，香港亦因而有&ldquo;东方之珠&rdquo;、&ldquo;世界三大天然良港&rdquo;及&ldquo;世界三大夜景&rdquo;之美誉。维多利亚港的名字，来自英国的维多利亚女王。一年四季皆可自由进出。早年已被英国人看中有成为东亚地区优良港口的潜力，后来从清政府手上夺得香港，发展其远东的海上贸易事业。维多利亚港一直影响香港的历史和文化，主导香港的经济和旅游业发展，是香港成为国际大化大都市的关键之一。 &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;</td>\r\n<td>&nbsp; <img src=\"app/web/upload/tinymce-source/Hawai - small 1.jpg\" alt=\"\" width=\"338\" height=\"241\" /></td>\r\n</tr>\r\n<tr>\r\n<td height=\"304\">&nbsp;\r\n<p><span style=\"font-size: 11pt; font-weight: bold;\">香港海洋公园</span></p>\r\n<p>&nbsp;</p>\r\n<p><span style=\"font-weight: bold;\">10：00-19：00；高峰乐园关门时间18：00；停车场：9：00至公园关门后半小时。（适合早去，一般14：00左右是团队入园高峰时间）</span></p>\r\n<p>&nbsp;</p>\r\nP香港海洋公园（Hong Kong Ocean Park）是东南亚地区最大的海洋公园之一，公园建筑分为山上高峰乐园和山下海滨乐园两部分，以全长1.5公里的登山缆车连接。山上是香港海洋公园的主要部分，有海洋馆、海涛馆、海洋剧场、百鸟居；山下的香港海洋公园水上乐园，是亚洲第一个水上游乐中心，还有花园剧场、金鱼馆及仿照历代文物所建的集古村等。</td>\r\n<td>&nbsp; <img src=\"app/web/upload/tinymce-source/Hawai - small 2.jpg\" alt=\"\" width=\"338\" height=\"241\" /></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>','script'),(24589,2,'pjDestination',7,'meta_title','香港 - 东方之珠 风采依然浪漫','script'),(24590,2,'pjDestination',7,'meta_desc','香港 - 东方之珠 风采依然浪漫','script'),(24591,1943,'pjField',7,'title','管理申请','script'),(24592,1944,'pjField',7,'title','以下为用户的申请，所有新添加的申请默认均为“未审核”状态。','script'),(24593,1945,'pjField',7,'title','Logo修改成功','script'),(24594,1946,'pjField',7,'title','Logo修改成功','script'),(24595,1947,'pjField',7,'title','上传网站Logo','script'),(24596,1948,'pjField',7,'title','Logo大小为183 x 85 px，过大系统会自动裁剪','script'),(24597,1949,'pjField',7,'title','图片的替代文本，鼠标放在图片上时显示，有利于SEO','script'),(24598,1950,'pjField',7,'title','图片加载失败时显示该文字','script'),(24599,1951,'pjField',7,'title','评论管理','script'),(24600,1952,'pjField',7,'title','以下为评论列表，您可以在设置 -> 选项中设置是否开启评论审核功能。','script'),(24601,1953,'pjField',7,'title','网站设置','script'),(24602,1954,'pjField',7,'title','网站通用设置','script'),(24603,1955,'pjField',7,'title','通用设置','script'),(24604,1956,'pjField',7,'title','订阅功能','script'),(24605,1957,'pjField',7,'title','设置是否在首页显示订阅功能','script'),(24606,1958,'pjField',7,'title','设置是否显示评分','script'),(24607,1959,'pjField',7,'title','以下为行程列表，可快速搜索待修改行程','script'),(24608,1960,'pjField',7,'title','行程','script'),(24609,1961,'pjField',7,'title','编辑','script'),(24610,1962,'pjField',7,'title','不要在URL里添加空格','script'),(24611,1963,'pjField',7,'title','SEO标题，70字符以内，填写有利于搜索引擎收录','script'),(24612,1964,'pjField',7,'title','SEO描述，160字符以内，填写有利于搜索引擎收录','script'),(24613,1965,'pjField',7,'title','显示在首页','script'),(24614,1966,'pjField',7,'title','标题','script'),(24615,1967,'pjField',7,'title','起止时间','script'),(24616,1968,'pjField',7,'title','优惠后价格','script'),(24617,1969,'pjField',7,'title','优惠比例','script'),(24618,1970,'pjField',7,'title','优惠价格','script'),(24619,1971,'pjField',7,'title','导出全部','script'),(24620,1972,'pjField',7,'title','SEO','script'),(24621,1973,'pjField',7,'title','SEO设置','script'),(24622,1974,'pjField',7,'title','填写Meta标签有利于搜索引擎收录','script'),(24623,1975,'pjField',7,'title','首页 - Meta标题','script'),(24624,1976,'pjField',7,'title','首页 - Meta描述','script'),(24625,1977,'pjField',7,'title','联系我们 - Meta标题','script'),(24626,1978,'pjField',7,'title','联系我们 - Meta描述','script'),(24627,1979,'pjField',7,'title','登录页 - Meta标题','script'),(24628,1980,'pjField',7,'title','登录页 - Meta描述','script'),(24629,1981,'pjField',7,'title','找回密码页 - Meta描述','script'),(24630,1982,'pjField',7,'title','找回密码页 - Meta标题','script'),(24631,1983,'pjField',7,'title','注册页 - Meta标题','script'),(24632,1984,'pjField',7,'title','注册页page - Meta描述','script'),(24633,1985,'pjField',7,'title','行程页 - Meta描述','script'),(24634,1986,'pjField',7,'title','行程页 - Meta标题','script'),(24635,1987,'pjField',7,'title','优惠页 - Meta标题','script'),(24636,1988,'pjField',7,'title','优惠页 - Meta描述','script'),(24637,1989,'pjField',7,'title','SEO设置已保存','script'),(24638,1990,'pjField',7,'title','SEO设置已保存','script'),(24639,1991,'pjField',7,'title','行程概览','script'),(24640,1992,'pjField',7,'title','以下为行程概览','script'),(24641,1993,'pjField',7,'title','您可设置行程类型、评分、推荐季节、时间。','script'),(24642,1994,'pjField',7,'title','行程详细信息','script'),(24643,1995,'pjField',7,'title','发布行程失败','script'),(24644,1,'pjBanner',7,'image','app/web/upload/banners/1_5246790e6d7ff4437adcc72bb86c7f53.png','script'),(24645,1,'pjBanner',7,'url','http://www.phpjabbers.com/travel-website','script'),(24646,1,'pjBanner',7,'alt','Travel Website Banner','script'),(24647,1,'pjBanner',7,'title','Travel Website Banner','script'),(24648,1,'pjBanner',7,'code',NULL,'script'),(24661,1996,'pjField',7,'title','语言','script'),(24662,1997,'pjField',7,'title','翻译','script'),(24663,1998,'pjField',7,'title','语言','script'),(24664,1999,'pjField',7,'title','添加语言后需在“翻译”标签中翻译对应的语言','script'),(24665,2000,'pjField',7,'title','翻译','script'),(24666,2001,'pjField',7,'title','请在下面翻译对应的语言','script'),(24667,2002,'pjField',7,'title','翻译','script'),(24668,2003,'pjField',7,'title','国旗','script'),(24669,2004,'pjField',7,'title','是否默认','script'),(24670,2005,'pjField',7,'title','顺序','script'),(24671,2006,'pjField',7,'title','添加语言','script'),(24672,2007,'pjField',7,'title','Field','script'),(24673,2008,'pjField',7,'title','Value','script'),(24674,2009,'pjField',7,'title','后台标题','script'),(24675,2010,'pjField',7,'title','前台标题','script'),(24676,2011,'pjField',7,'title','特殊标题','script'),(24677,2012,'pjField',7,'title','翻译已修改','script'),(24678,2013,'pjField',7,'title','翻译已修改','script'),(24679,2014,'pjField',7,'title','每页','script'),(24680,2015,'pjField',7,'title','导入错误','script'),(24681,2016,'pjField',7,'title','缺少参数，导入失败','script'),(24682,2017,'pjField',7,'title','导入完成','script'),(24683,2018,'pjField',7,'title','导入完成','script'),(24684,2019,'pjField',7,'title','导入错误','script'),(24685,2020,'pjField',7,'title','数据为空，导入失败','script'),(24686,2021,'pjField',7,'title','导入错误','script'),(24687,2022,'pjField',7,'title','文件不能打开，导入失败','script'),(24688,2023,'pjField',7,'title','导入/导出','script'),(24689,2024,'pjField',7,'title','导入','script'),(24690,2025,'pjField',7,'title','导出','script'),(24691,2026,'pjField',7,'title','语言','script'),(24692,2027,'pjField',7,'title','浏览计算机','script'),(24693,2028,'pjField',7,'title','导入/导出','script'),(24694,2029,'pjField',7,'title','在下面导入或导出CSV文件，请不要修改表格的第一行','script'),(24695,2030,'pjField',7,'title','分隔符','script'),(24696,2031,'pjField',7,'title','逗号','script'),(24697,2032,'pjField',7,'title','分号','script'),(24698,2033,'pjField',7,'title','Tab','script'),(24699,2034,'pjField',7,'title','选择您要导入的语言','script'),(24700,2035,'pjField',7,'title','导入确认','script'),(24701,2036,'pjField',7,'title','导入失败','script'),(24702,2037,'pjField',7,'title','缺少参数','script'),(24703,2038,'pjField',7,'title','导入失败','script'),(24704,2039,'pjField',7,'title','文件上传失败','script'),(24705,2040,'pjField',7,'title','导入失败','script'),(24706,2041,'pjField',7,'title','文件不可读','script'),(24707,2042,'pjField',7,'title','导入失败','script'),(24708,2043,'pjField',7,'title','发现新行','script'),(24709,2044,'pjField',7,'title','导入失败','script'),(24710,2045,'pjField',7,'title','上传文件格式错误','script'),(24711,2046,'pjField',7,'title','导入失败','script'),(24712,2047,'pjField',7,'title','每行列数不相同','script'),(24713,2048,'pjField',7,'title','导入失败','script'),(24714,2049,'pjField',7,'title','数据无效','script'),(24715,2050,'pjField',7,'title','导入失败','script'),(24716,2051,'pjField',7,'title','缺少关键列','script'),(24717,2052,'pjField',7,'title','导入失败','script'),(24718,2053,'pjField',7,'title','数据无效','script'),(24719,2054,'pjField',7,'title','显示ID','script'),(24720,2055,'pjField',7,'title','ID会显示在网站对于内容之前，便于修改','script'),(24721,2056,'pjField',7,'title','确认','script'),(24722,2057,'pjField',7,'title','取消','script'),(24723,2058,'pjField',7,'title','默认','script'),(24724,2059,'pjField',7,'title','ID:','script'),(24725,2060,'pjField',7,'title','显示ID','script'),(24726,2061,'pjField',7,'title','备份','script'),(24727,2062,'pjField',7,'title','备份完成','script'),(24728,2063,'pjField',7,'title','备份失败','script'),(24729,2064,'pjField',7,'title','备份失败','script'),(24730,2065,'pjField',7,'title','建议经常备份防止损失','script'),(24731,2066,'pjField',7,'title','备份已保存','script'),(24732,2067,'pjField',7,'title','未选择操作','script'),(24733,2068,'pjField',7,'title','备份未执行','script'),(24734,2069,'pjField',7,'title','备份','script'),(24735,2070,'pjField',7,'title','备份数据库','script'),(24736,2071,'pjField',7,'title','备份文件','script'),(24737,2072,'pjField',7,'title','备份','script'),(24738,2073,'pjField',7,'title','备份失败','script'),(24739,2074,'pjField',7,'title','未选中备份文件夹，请检查\"app/web/backup\"文件夹是否存在','script'),(24740,2075,'pjField',7,'title','备份失败','script'),(24741,2076,'pjField',7,'title','请将\"app/web/backup\"文件夹设为可写（chmod 777）','script'),(24742,2077,'pjField',7,'title','日志','script'),(24743,2078,'pjField',7,'title','设置日志','script'),(24744,2079,'pjField',7,'title','空日志','script'),(24745,2080,'pjField',7,'title','日志修改成功','script'),(24746,2081,'pjField',7,'title','日志设置已保存','script'),(24747,2082,'pjField',7,'title','列表','script'),(24748,2083,'pjField',7,'title','+ 添加','script'),(24749,2084,'pjField',7,'title','信息','script'),(24750,2085,'pjField',7,'title','修改后请刷新才能生效','script'),(24751,2086,'pjField',7,'title','替换文本','script'),(24752,2087,'pjField',7,'title','水印位置','script'),(24753,2088,'pjField',7,'title','位置','script'),(24754,2089,'pjField',7,'title','图片设置','script'),(24755,2090,'pjField',7,'title','确定删除全部图片吗？','script'),(24756,2091,'pjField',7,'title','确定删除选中图片吗？','script'),(24757,2092,'pjField',7,'title','删除确认','script'),(24758,2093,'pjField',7,'title','您可以设置压缩比例，压缩80%以内不影响显示效果','script'),(24759,2094,'pjField',7,'title','删除','script'),(24760,2095,'pjField',7,'title','取消','script'),(24761,2096,'pjField',7,'title','保存','script'),(24762,2097,'pjField',7,'title','设置水印','script'),(24763,2098,'pjField',7,'title','清除当前','script'),(24764,2099,'pjField',7,'title','压缩','script'),(24765,2100,'pjField',7,'title','重建缩略图','script'),(24766,2101,'pjField',7,'title','左上角','script'),(24767,2102,'pjField',7,'title','上居中','script'),(24768,2103,'pjField',7,'title','左下角','script'),(24769,2104,'pjField',7,'title','右下角','script'),(24770,2105,'pjField',7,'title','底部居中','script'),(24771,2106,'pjField',7,'title','左侧垂直居中','script'),(24772,2107,'pjField',7,'title','右侧垂直居中','script'),(24773,2108,'pjField',7,'title','中心','script'),(24774,2109,'pjField',7,'title','右上角','script'),(24775,2110,'pjField',7,'title','您还未上传图片','script'),(24776,2111,'pjField',7,'title','移动','script'),(24777,2112,'pjField',7,'title','编辑','script'),(24778,2113,'pjField',7,'title','删除','script'),(24779,2114,'pjField',7,'title','裁剪','script'),(24780,2115,'pjField',7,'title','旋转','script'),(24781,2116,'pjField',7,'title','水印','script'),(24782,2117,'pjField',7,'title','压缩','script'),(24783,2118,'pjField',7,'title','删除全部','script'),(24784,2119,'pjField',7,'title','原始','script'),(24785,2120,'pjField',7,'title','缩略图','script'),(24786,2121,'pjField',7,'title','图片','script'),(24787,2122,'pjField',7,'title','上传','script'),(24788,2123,'pjField',7,'title','重建','script'),(24789,2124,'pjField',7,'title','原始','script'),(24790,2125,'pjField',7,'title','预览','script'),(24791,2126,'pjField',7,'title','缩略图','script'),(24792,2127,'pjField',7,'title','&laquo; 返回','script'),(24793,2128,'pjField',7,'title','拖动图片边缘设置裁剪大小','script'),(24794,2129,'pjField',7,'title','裁剪','script'),(24795,2130,'pjField',7,'title','时间','script'),(24796,2131,'pjField',7,'title','MC Gross','script'),(24797,2132,'pjField',7,'title','MC Currency','script'),(24798,2133,'pjField',7,'title','Payer email','script'),(24799,2134,'pjField',7,'title','Txn type','script'),(24800,2135,'pjField',7,'title','Txn ID','script'),(24801,2136,'pjField',7,'title','Subscription ID','script'),(24802,2137,'pjField',7,'title','Foreign ID','script'),(24803,2138,'pjField',7,'title','关闭','script'),(24804,2139,'pjField',7,'title','Transaction details','script'),(24805,2140,'pjField',7,'title','View','script'),(24806,2141,'pjField',7,'title','IPN','script'),(24807,2142,'pjField',7,'title','省份名','script'),(24808,2143,'pjField',7,'title','2字母缩写','script'),(24809,2144,'pjField',7,'title','3字母缩写','script'),(24810,2145,'pjField',7,'title','状态','script'),(24811,2146,'pjField',7,'title','添加 +','script'),(24812,2147,'pjField',7,'title','激活','script'),(24813,2148,'pjField',7,'title','未激活','script'),(24814,2149,'pjField',7,'title','保存','script'),(24815,2150,'pjField',7,'title','取消','script'),(24816,2151,'pjField',7,'title','省份列表','script'),(24817,2152,'pjField',7,'title','修改省份成功','script'),(24818,2153,'pjField',7,'title','添加省份成功','script'),(24819,2154,'pjField',7,'title','添加省份失败','script'),(24820,2155,'pjField',7,'title','省份未找到','script'),(24821,2156,'pjField',7,'title','添加省份','script'),(24822,2157,'pjField',7,'title','修改省份','script'),(24823,2158,'pjField',7,'title','省份管理','script'),(24824,2159,'pjField',7,'title','修改省份成功','script'),(24825,2160,'pjField',7,'title','添加省份成功','script'),(24826,2161,'pjField',7,'title','添加省份失败','script'),(24827,2162,'pjField',7,'title','省份未找到','script'),(24828,2163,'pjField',7,'title','填写下表添加省份','script'),(24829,2164,'pjField',7,'title','填写下表修改省份','script'),(24830,2165,'pjField',7,'title','以下为省份列表','script'),(24831,2166,'pjField',7,'title','确定删除选中省份吗？','script'),(24832,2167,'pjField',7,'title','删除选中','script'),(24833,2168,'pjField',7,'title','全部','script'),(24834,2169,'pjField',7,'title','搜索','script'),(26461,9,'pjListing',1,'title',NULL,'script'),(26462,9,'pjListing',1,'description',NULL,'script'),(26463,9,'pjListing',1,'flight_notes',NULL,'script'),(26464,9,'pjListing',1,'terms',NULL,'script'),(26465,9,'pjListing',1,'checkin',NULL,'script'),(26466,9,'pjListing',1,'checkout',NULL,'script'),(26467,9,'pjListing',1,'pets',NULL,'script'),(26468,9,'pjListing',1,'policies',NULL,'script'),(26469,9,'pjListing',1,'fees',NULL,'script'),(26470,9,'pjListing',1,'meta_title',NULL,'script'),(26471,9,'pjListing',1,'meta_keywords',NULL,'script'),(26472,9,'pjListing',1,'meta_description',NULL,'script'),(26473,9,'pjListing',7,'title','武汉3日经典游','script'),(26474,9,'pjListing',7,'description','<div class=\"day-path\">\r\n<div class=\"day-index day-index-1\">\r\n<p><strong>第1天</strong><br />武汉辛亥革命武昌起义纪念馆 - 黄鹤楼 - 户部巷 - 昙华林 - 武汉长江大桥<br />&ldquo;黄鹤楼会收 大约100元的门票，学生半价， 其余景点都没有门票的。公交车2元，带好零钱，没必要刷卡，折扣不多。开销主要 取决于吃和 住的质量了。户部巷虽然很有名，但 东西都不会太贵，几乎没有贵的离谱的（除了个别）。这一天是老武昌历史文化路线，周边有许多武昌特色的建筑，主要在蛇山一带。&rdquo;</p>\r\n<p>住宿：司门口商圈<br /><strong>第2天</strong><br />武汉湖北省博物馆 - 东湖 - 武汉大学 - 江汉路步行街 - 吉庆街 - 江汉关 - 黎黄陂路街头博物馆 - 江滩公园<br />&ldquo;这一天白天的行程主要安排在东湖附近，武汉大学就是一面环东湖的。东湖是中国最大的城中湖，近年刚刚被评为5A级风景区。湖上风景非常不错，江天一色，绿树成荫，还可以泛舟~晚上主要在汉口部分，游览的地方都很近，也都不大，纯步行就能走完，不过都很值得慢慢逛，主要是一些民国风情的洋房，一路上也到处都是吃的，各种类型的都有，因为太多了所以难以推荐，根据自己喜好确定吧。特别注意的是江滩附近晚上有许多酒吧，有兴趣可以去看一看，江汉路晚上也是特别繁华的，有很多小吃街。总行程可能有点紧，把江滩改到后一天游览，也是可以的。&rdquo;</p>\r\n<p>住宿：江汉路娱乐圈<br /><strong>第3天</strong><br />武汉古琴台 - 汉阳造艺术区 - 归元寺 - 龟山 - 晴川阁<br />&ldquo;汉阳主要以历史文化为主，小吃、商业街相对武昌、汉口少一些，不过也有很多。晚饭也可以再回到武昌或者汉口解决。晴川阁附近有到汉阳门码</p>\r\n</div>\r\n</div>','script'),(26475,9,'pjListing',7,'flight_notes',NULL,'script'),(26476,9,'pjListing',7,'terms','1、本产品报价是按照2成人入住1间房计算的价格，如出现单男单女，尽量安排该客人与其他同性别团友拼房；如不愿拼房或未能拼房，请补缴单房差。\r\n2、本产品报价是按照2成人入住1间房计算的价格，不接受拼房，如出现单男单女请补缴单房差。\r\n3、儿童费用已包含往返程机票，车位费，导游费，含早餐及正餐半餐。\r\n4、不含儿童餐费，若需要在酒店用餐，请您直接向酒店支付，敬请谅 解！\r\n5、由于12岁以下儿童费用为不占床之报价，若儿童需占床，请补房差。\r\n6、游客入住酒店后如需升级或者更换房型，需补交升级或者更换的房差费用。\r\n7、当地购物时请慎重考虑，把握好质量与价格，务必索要发票。','script'),(26477,9,'pjListing',7,'checkin','黄鹤楼、东湖','script'),(26478,9,'pjListing',7,'checkout','本单不包含保险','script'),(26479,9,'pjListing',7,'pets','珞珈山酒店','script'),(26480,9,'pjListing',7,'policies','购买成功后提前20分钟与客服进行联系预约，预约方式以页面为准！\r\n凭身份证直接消费，无需兑换实体票','script'),(26481,9,'pjListing',7,'fees','车费 135元\r\n餐饮费 300元\r\n住宿费 420元','script'),(26482,9,'pjListing',7,'meta_title',NULL,'script'),(26483,9,'pjListing',7,'meta_keywords',NULL,'script'),(26484,9,'pjListing',7,'meta_description',NULL,'script'),(26509,59,'pjFeature',1,'name',NULL,'data'),(26510,59,'pjFeature',7,'name','三日游','data'),(26511,60,'pjFeature',1,'name',NULL,'data'),(26512,60,'pjFeature',7,'name','周边游','data'),(26513,61,'pjFeature',1,'name',NULL,'data'),(26514,61,'pjFeature',7,'name','主题公园','data'),(26515,62,'pjFeature',1,'name',NULL,'data'),(26516,62,'pjFeature',7,'name','温泉','data'),(26517,63,'pjFeature',1,'name',NULL,'data'),(26518,63,'pjFeature',7,'name','海洋馆','data'),(26519,64,'pjFeature',1,'name',NULL,'data'),(26520,64,'pjFeature',7,'name','动植物园','data'),(26521,65,'pjFeature',1,'name',NULL,'data'),(26522,65,'pjFeature',7,'name','农家乐','data'),(26523,66,'pjFeature',1,'name',NULL,'data'),(26524,66,'pjFeature',7,'name','游船','data'),(26525,67,'pjFeature',1,'name',NULL,'data'),(26526,67,'pjFeature',7,'name','滑雪','data'),(26527,68,'pjFeature',1,'name',NULL,'data'),(26528,68,'pjFeature',7,'name','水上乐园','data'),(27521,10,'pjListing',1,'title',NULL,'script'),(27522,10,'pjListing',1,'description',NULL,'script'),(27523,10,'pjListing',1,'flight_notes',NULL,'script'),(27524,10,'pjListing',1,'terms',NULL,'script'),(27525,10,'pjListing',1,'checkin',NULL,'script'),(27526,10,'pjListing',1,'checkout',NULL,'script'),(27527,10,'pjListing',1,'pets',NULL,'script'),(27528,10,'pjListing',1,'policies',NULL,'script'),(27529,10,'pjListing',1,'fees',NULL,'script'),(27530,10,'pjListing',1,'meta_title',NULL,'script'),(27531,10,'pjListing',1,'meta_keywords',NULL,'script'),(27532,10,'pjListing',1,'meta_description',NULL,'script'),(27533,10,'pjListing',7,'title','【哈尔滨】东升雪谷（徒步穿越）雪乡、亚布力滑雪三日激情冰雪之旅','script'),(27534,10,'pjListing',7,'description','<p>D1 [第1天]<br />07：50XX地集合，<br />08：00出发前往【中国雪谷】&mdash;东升林场（车程6-7小时）<br />11：30左右到达山河屯镇或向阳镇停留一小时，吃午餐，午餐自理。<br />12：30继续出发，前往【中国雪谷】&mdash;东升林场<br />15：00左右到达穿越的起点东升林场，到达后入住东升农家&mdash;&mdash;秀山水民宿，安顿好后，可以四处去拍照游玩了，这里原生态保存完好，算的上是真是东北的农村。看袅袅炊烟，再听街上操着各种口音的游人欢乐的笑声，又彰显着这里的繁华。<br />17：00准时开饭，大家AA制，晚餐可以在住宿的老乡家吃地道的东北小鸡炖蘑菇、猪肉炖粉条等东北农家特色，还可以喝上二两地道的纯粮食小烧酒（晚餐不含：自费30元/人）。</p>\r\n<p>19：00举行今晚的重头戏&mdash;&mdash;篝火晚会，载歌载舞，导游带着大家准备各种好玩有意思的游戏。<br />温馨提醒：<br />1：哈尔滨&mdash;五常东升林场248公里，车程6-7小时。<br />2：提前到哈尔滨的游客，秀山水可代订一晚住宿！<br />3：东升林场目前没有被完全开发，原生态保存的相当完好，很多团友到雪乡后都觉得雪乡商业开发过度，<br />所以到了东升后一定不要偷懒，尽量在小村子周围多逛逛。<br />4：东升农家院的热水来之不易，洗漱的时候大家不要浪费，以保证人人都有充足的热水洗漱！<br />5：东升、雪乡的晚餐较贵，尤其是雪乡。本着对游客负责的态度，秀山水愿意组织团友将东升、雪乡的<br />两个晚餐自愿自费安排为集体桌餐。<br />6：东升、雪乡民宿为东北农家大炕，通常为4-8人炕，需男女分开。<br />D2 [第2天]<br />餐饮：早餐: 早餐 午餐: 自理 晚餐: 自理</p>\r\n<p><br />07：30吃早餐。<br />07：50早餐后统一往车上装大件行李，我们全程不负重，背上小件背包，准备好充足的食品，轻装上阵。<br />08：00开始穿越东升雪谷&mdash;羊草山&mdash;雪乡，从雪谷到雪乡在茫茫的&ldquo;林海雪原&rdquo;里穿越15公里, 上升高度800米, 穿越最高点1200米，用时5-6小时，东升穿越雪乡是本线路的精华之一，也是东北可以领略到最深的积雪醉美的自然雪景。<br />12：30到达雪谷穿越雪乡途中羊草山的最高点，中午大家可以在这个位置调整下，补充能量，团友可以根据自己的体力情况自行选择是否需要休息，如果体力好的朋友，一路下坡直接飞奔冲向雪乡。所以这一路上你是不会感到什么是累!<br />14：00-15：00抵达雪乡，入住秀山水民宿，简短休息会，体力好的可以去雪乡滑雪场滑雪或滑雪圈,摄影爱好者们拿着长枪短炮四处摄影创作，也可以自行在小村子四周逛逛。<br />17：00准时开饭，建议大家AA制围桌吃桌餐。（晚餐不含：自费30元/人)<br />19：00大家可以出去看看雪乡夜景。<br />20：00全部集合，秀山水民宿准备好了饺子馅跟面，大家一起动手包饺子,东北饺子那叫一个香，尤其是酸菜猪肉陷儿，是东北人的最爱。吃着自己动手包出来的饺子绝对好味！<br />温馨提醒：<br />1、雪谷穿越到雪乡全程15公里，但很多人心里会担心自己体力是否跟得上，往期7&mdash;8岁的小朋友都可<br />以完成穿越，心脏病、高血压患者和身体不适的团友或老人、特别小的儿童可以选择乘旅游车跟司机<br />师傅到雪乡。参加穿越团友把所有的行李都放到车上，我们是全程轻装徒步不负重。<br />2、秀山水为大家免费赠送热帖、百变头巾。免费提供雪套供大家使用，请注意保管，不要丢失。<br />3、进入穿越线路前，所以一定要听从导游指挥，不要擅自脱队。<br />4、为了保护雪乡的自然雪景，不要随便触碰其他民宿的雪景<br />5、穿越过程手机信号时有时无，所以早上尽量给家人发个信息，以免家人找不到你而担心。<br /><br /></p>','script'),(27535,10,'pjListing',7,'flight_notes','联合航空\r\nKN5507波音737(中)','script'),(27536,10,'pjListing',7,'terms','注意事项\r\n\r\n1、本产品报价是按照2成人入住1间房计算的价格，如出现单男单女，尽量安排该客人与其他同性别团友拼房；如不愿拼房或未能拼房，请补缴单房差。\r\n2、本产品报价是按照2成人入住1间房计算的价格，不接受拼房，如出现单男单女请补缴单房差。\r\n3、儿童费用已包含往返程机票，车位费，导游费，含早餐及正餐半餐。\r\n4、不含儿童餐费，若需要在酒店用餐，请您直接向酒店支付，敬请谅 解！\r\n5、由于12岁以下儿童费用为不占床之报价，若儿童需占床，请补房差。\r\n6、游客入住酒店后如需升级或者更换房型，需补交升级或者更换的房差费用。\r\n7、当地购物时请慎重考虑，把握好质量与价格，务必索要发票。','script'),(27537,10,'pjListing',7,'checkin','东升穿越门票，雪乡门票，亚布力省体委2小时滑雪','script'),(27538,10,'pjListing',7,'checkout','人身意外伤害保险，旅游责任险','script'),(27539,10,'pjListing',7,'pets','两晚民宿住宿','script'),(27540,10,'pjListing',7,'policies','1.2以下儿童：含当地旅游车车位、导游服务、炕位费，不占床、不含往返大交通、不含景区门票','script'),(27541,10,'pjListing',7,'fees','费用不包含\r\n\r\n【不可抗力】：因交通延阻、罢工、天气、飞机、机器故障、航班取消或更改时间等不可抗力原因所导致的额外费用\r\n【个人消费】：1、酒店内洗衣、理发、电话、传真、收费电视、饮品、烟酒等个人消费\r\n               2、购物等个人消费以及因个人疏忽、违章或违法引起的经济损失或赔偿费用\r\n               3、当地参加的自费项目以及 “费用包含”中不包含的其它项目\r\n【单房差】：1、单房差\r\n               2、升级舱位、升级酒店、升级房型等产品的差价\r\n【儿童】：1、儿童不含门票，届时请根据身高情况，在景区门口自行购买，敬请谅解\r\n               2、儿童不占床，如需占床请补交费用','script'),(27542,10,'pjListing',7,'meta_title',NULL,'script'),(27543,10,'pjListing',7,'meta_keywords',NULL,'script'),(27544,10,'pjListing',7,'meta_description',NULL,'script'),(27845,11,'pjListing',1,'title',NULL,'script'),(27846,11,'pjListing',1,'description',NULL,'script'),(27847,11,'pjListing',1,'flight_notes',NULL,'script'),(27848,11,'pjListing',1,'terms',NULL,'script'),(27849,11,'pjListing',1,'checkin',NULL,'script'),(27850,11,'pjListing',1,'checkout',NULL,'script'),(27851,11,'pjListing',1,'pets',NULL,'script'),(27852,11,'pjListing',1,'policies',NULL,'script'),(27853,11,'pjListing',1,'fees',NULL,'script'),(27854,11,'pjListing',1,'meta_title',NULL,'script'),(27855,11,'pjListing',1,'meta_keywords',NULL,'script'),(27856,11,'pjListing',1,'meta_description',NULL,'script'),(27857,11,'pjListing',7,'title','澳洲本地游，墨尔本往返，墨尔本市区观光、淘金場、十二門徒石','script'),(27858,11,'pjListing',7,'description','<p><br />D1 [第1天]<br />抵達墨爾本機場後接機開始市區觀光，行程內容: ST.Patrick&rsquo;s大教堂，庫克船長故居等。繼而乘坐雅拉河遊船($24/$14)遊覽雅拉河兩岸風光。然後登上南半球最高尤利卡觀景臺($19.5/$11)達88層，可360度欣賞全墨爾本景色。之後前往水族館($38/$22), 唐人街參觀及自由活動。途經全澳洲最大的皇冠賭場，午餐($18/$14)後前往企鵝島，途中停留於Phillip Island上的巧克力工廠參觀($15/$10)，此處有座全世界最大的巧克力瀑布，遊客可在此選購種類繁多的巧克力。繼而前往企鵝島(24.50/$12.25)，觀賞世界上最小的神仙企鵝歸巢。行程結束後返回酒店。墨爾本晚餐($18/$14)。<br />D2 [第2天]<br />餐饮：早餐: 早餐 午餐: 自理 晚餐: 自理</p>\r\n<p>早餐後前往160年歷史巴拉特市淘金場($60/27.8含礦洞纜車)，專業導遊帶領下乘搭纜車進入地下礦洞，了解當年華人淘金歷史，更可親手嘗試淘金樂趣。午餐於巴拉特的中國餐廳($18/14) 。然後前往維州的著名座標 &ldquo;十二門徒石&rdquo;，沿路一片片的牧場莊園更是突顯出澳洲南部的田園風情。自費乘坐當地觀光直升機($145)飽覽海上巍然聳立的巨岩及大自然締造的海峽風光，行程結束後送往機場。</p>\r\n<p>&nbsp;</p>','script'),(27859,11,'pjListing',7,'flight_notes',NULL,'script'),(27860,11,'pjListing',7,'terms','1.出发前一晚，车公司会以简讯通知游客服务司机的车牌与联繫电话，请游客报名时登记正确手机号码。团友前一晚8点尚未收到简讯需自行与我方联繫。\r\n2行程内门票以单一门口价爲准，团友须经由导游完成付费订购手续后则含景点往返交通费，如游客自行购买，本社概不提供任何交通接送服务，或客人额外支付接送服务费$60/人/天。 旅行社需提醒游客价格随著景点更新后导游会告知游客，游客需支付正确费用，若有争议，将由报名旅行社补足差额。\r\n3.客人若选择脱团，需额外加$30/人/天，报名时请预告知旅行社。\r\n4.出团须知请参看我司条例与限制版本。','script'),(27861,11,'pjListing',7,'checkin',NULL,'script'),(27862,11,'pjListing',7,'checkout',NULL,'script'),(27863,11,'pjListing',7,'pets',NULL,'script'),(27864,11,'pjListing',7,'policies','费用不包含\r\n\r\n1、单人房差: $65/晚; \r\n2、重大节庆及假期酒店附加费; 景点门票，餐费、司机及导游服务费$5./人/天。','script'),(27865,11,'pjListing',7,'fees','1、旅巴酒店接送交通费\r\n2、四星级酒店含早餐\r\n3、航空团另包国内段机票仅含手提行李，机场接送服务。','script'),(27866,11,'pjListing',7,'meta_title',NULL,'script'),(27867,11,'pjListing',7,'meta_keywords',NULL,'script'),(27868,11,'pjListing',7,'meta_description',NULL,'script'),(27977,12,'pjListing',1,'title',NULL,'script'),(27978,12,'pjListing',1,'description',NULL,'script'),(27979,12,'pjListing',1,'flight_notes',NULL,'script'),(27980,12,'pjListing',1,'terms',NULL,'script'),(27981,12,'pjListing',1,'checkin',NULL,'script'),(27982,12,'pjListing',1,'checkout',NULL,'script'),(27983,12,'pjListing',1,'pets',NULL,'script'),(27984,12,'pjListing',1,'policies',NULL,'script'),(27985,12,'pjListing',1,'fees',NULL,'script'),(27986,12,'pjListing',1,'meta_title',NULL,'script'),(27987,12,'pjListing',1,'meta_keywords',NULL,'script'),(27988,12,'pjListing',1,'meta_description',NULL,'script'),(27989,12,'pjListing',7,'title','重庆垫江乐天花谷、长寿菩提古镇一日游','script'),(27990,12,'pjListing',7,'description','<p>早上7：00市区集合出发（具体时间、地点以导游通知为准），经渝宜高速前往【长寿古镇】（车程约1个小时，游览时间不低于2小时）。步行游览参观寿星和麻姑塑像、穿过独具匠心，意静悠然的风雨桥、具有江南水乡特色的万寿河茶室 、酒吧、小吃、水车、木屋长廊风光带，信步于江南园林的缩影&ldquo;御龙潭公园&rdquo;，细品砖雕满布的福寿街，涉足气势恢宏的万寿路人文大道。</p>\r\n<p>逛完古镇后前往沙坪镇乐天村的【草莓采摘园】（车程约2小时，游览时间不低于20分钟），里面种植的有各种草莓，其中以台湾牛奶草莓和巧克力草莓为主。</p>\r\n<p>随后前往【乐天花谷】（步行约5-8分钟）。抵达后进入景区参观（游览时间不低于2.5个小时），乐天花谷距垫江县城10公里，占地面积1000亩，花谷内花卉种类繁多，品种上百种（具体花卉景观根据时节而定），目前能观赏到的有金盏菊花田、虞美人花田，让人们感受无限大自然的魅力与奥秘，展现出一个美丽的风情花谷，花内香气袭人，峰飞蝶舞，令人叹为观止。可零距离亲近大自然，可尽情拍照、玩耍，令人神清气爽，心旷神怡，真有天下花香袭人的美韵！乐天花谷景区内还有需要许多以欧式风格为主的景观，最具代表性的有蓝色地中海、圣托里尼小镇、欧式小镇、教堂，并以此作为景区的主题及观光亮点。游览结束后乘车返回，结束愉快旅程！​</p>','script'),(27991,12,'pjListing',7,'flight_notes',NULL,'script'),(27992,12,'pjListing',7,'terms','1、游客在线下单即视为，参团所有人员授权下单人委托我社工作人员代为签订书面旅游合同，且均身体健康适宜出游。\r\n2、18岁以下未成年人需直系亲属同行，如无监护人同行需其监护人签订未成年人出行同意书方可出游（模板找客服索取）\r\n3、谢绝孕妇参团，70岁以上（包含70岁）的老年人及特殊人群须完成《健康承诺书》的相关流程及手续（模板找客服索取）','script'),(27993,12,'pjListing',7,'checkin','乐天花谷大门票，长寿菩提古镇和草莓园无门票，门票不再享受任何证件优惠。','script'),(27994,12,'pjListing',7,'checkout','旅游意外险（游客须提供准确的身份名单，以保险公司承保为准），具体赔付细则详见保险公司相关理赔条款。 ','script'),(27995,12,'pjListing',7,'pets',NULL,'script'),(27996,12,'pjListing',7,'policies','费用不包含\r\n\r\n当日用餐及游客个人消费。 \r\n牛奶和巧克力草莓50/斤，其他品种25/斤。','script'),(27997,12,'pjListing',7,'fees','费用包含\r\n\r\n1、【交通】：正规合法空调旅游车(每人一正座、根据人数定车型)。 \r\n2、【门票】：乐天花谷大门票，长寿菩提古镇和草莓园无门票，门票不再享受任何证件优惠。 \r\n3、【导服】：具有合法资质持证导游（导服费：150元/团）。 \r\n4、【保险】：旅游意外险（游客须提供准确的身份名单，以保险公司承保为准），具体赔付细则详见保险公司相关理赔条款。 \r\n5、【小孩】：1.2米以下含车位、导服、保险，超过1.2米了按成人操作。','script'),(27998,12,'pjListing',7,'meta_title',NULL,'script'),(27999,12,'pjListing',7,'meta_keywords',NULL,'script'),(28000,12,'pjListing',7,'meta_description',NULL,'script'),(28001,13,'pjListing',1,'title',NULL,'script'),(28002,13,'pjListing',1,'description',NULL,'script'),(28003,13,'pjListing',1,'flight_notes',NULL,'script'),(28004,13,'pjListing',1,'terms',NULL,'script'),(28005,13,'pjListing',1,'checkin',NULL,'script'),(28006,13,'pjListing',1,'checkout',NULL,'script'),(28007,13,'pjListing',1,'pets',NULL,'script'),(28008,13,'pjListing',1,'policies',NULL,'script'),(28009,13,'pjListing',1,'fees',NULL,'script'),(28010,13,'pjListing',1,'meta_title',NULL,'script'),(28011,13,'pjListing',1,'meta_keywords',NULL,'script'),(28012,13,'pjListing',1,'meta_description',NULL,'script'),(28013,13,'pjListing',7,'title','【首都北京】游长城、天安门看升旗、故宫、颐和园、天坛','script'),(28014,13,'pjListing',7,'description','<p><br />D1 [第1天]</p>\r\n<p>抵京，（专人接站,举北京欢迎您蓝底白字导游旗,车游市容市貌,送入酒店,自由活动！）由于散客到站时间不同，在接站过程如有等候情况（因接站时间比较集中及交通堵塞，等候30分钟之内还请见谅！），请和客人提前说明并请谅解；请提示客人抵京时拿好手机，并保持畅通状态，方便地接社接站联系;</p>\r\n<p>D2 [第2天]</p>\r\n<p>酒店： 三星或同等酒店|玖玖连锁，凯嘉宾馆，龙福宫宾馆</p>\r\n<p>餐饮：早餐: 自理 午餐: 自理 晚餐: 自理</p>\r\n<p>早观【升旗仪式】，感受共和国永不谢幕的典礼（早餐打包）游览世界上最大的城市中心广场-【天安门广场】（30分钟），【毛主席纪念堂】（30分钟，政策性关闭除外），【人民英雄纪念碑】（30分钟左右）,外观素有&ldquo;城市中的剧院，剧院中的城市&rdquo;，漂浮于人造水面上有&ldquo;湖中明珠&rdquo;之称的国家大剧院及人民大会堂，后乘人力三轮车游览【老北京胡同】（车夫小费属个人意愿，与本社无关），游什刹海历史文化风景区，观银锭山&rdquo;、&ldquo;柳岸风荷&rdquo;等享有百年美誉的自然景观。中餐后参观世界文化遗产-【故宫博物院】（2小时），在雄伟威严的的皇家宫殿里，了解我国灿烂的历史和悠久的文化，寻找故事传说中昔日的辉煌与奢华。晚逛东华门小吃一条街，王府井步行街，天主大教堂和王府井百货大楼等著名建筑景观（1.0小时）。</p>\r\n<p>D3 [第3天]</p>\r\n<p>酒店： 三星或同等酒店|玖玖连锁，凯嘉宾馆，龙福宫宾馆</p>\r\n<p>餐饮：早餐: 自理 午餐: 自理 晚餐: 自理</p>\r\n<p>早餐后乘车前往昌平，沿途欣赏北京城郊优美风光,车观燕京八景之一的居庸叠翠，游览驰名中外的万里长城、登好汉坡、一览长城磅礴气势。 游览【八达岭长城】(120分钟)（门票已含）、世界八大奇迹之一八达岭长城(它宛如一条巨龙盘踞在中国北方辽阔的土地上，外观国家体育场&mdash;&mdash;【鸟巢外景】（30分钟）国家游泳馆&mdash;&mdash;【水立方外景】（30分钟）零距离体验2008激情奥运情怀。奥林匹克公园位于城市传统中轴线的延伸，意喻中国千年历史文化的延续。</p>\r\n<p>&nbsp;</p>','script'),(28015,13,'pjListing',7,'flight_notes',NULL,'script'),(28016,13,'pjListing',7,'terms','北京的气候：为典型的暖湿带半湿润大陆性季风气候，夏季炎热多雨，冬季寒冷干燥，春季较短，少雨多风，\r\n秋季晴好，温湿度宜人。年平均气温10-12摄氏度，1月最冷，平均气温-7-4摄氏度，7月最热，平均气温25-26\r\n摄氏度。年均降雨量600多毫米， 7、8月常有暴雨。夏季上午10点到下午3点日照强烈，外出时应当在皮\r\n肤暴露的地方适当涂些防晒霜，尽量穿色浅、质薄的衣服。北方气候干燥，南方游客到北京切记多喝水补充\r\n水分。','script'),(28017,13,'pjListing',7,'checkin','已含行程中景点首道大门票及赠送项目，标明的自费项目的除外。 ','script'),(28018,13,'pjListing',7,'checkout','旅行社责任保险','script'),(28019,13,'pjListing',7,'pets','单房差','script'),(28020,13,'pjListing',7,'policies','1).吃： 旅途中饮食宜清淡，尽量少吃方便面，多食蔬菜水果，防止便秘。不食用不卫生、不合格的食品和饮料。最好能自备水具，既方便又卫生。\r\n(2).住：为保证每天6至8小时的睡眠，住宿条件不求豪华，但求舒适安静，选2至4人间，与旅伴在一个房间，便于照顾。建议老年朋友们临睡前用热水泡脚，睡时将小腿和脚稍垫高，以防下肢水肿。\r\n(3).行：秋季是北京城最美的季节。属于旅游旺季，气候多变，故秋游不减衣，并提前准备雨具，以防不测风云，身体受凉。早晚温差大，老年人机体免疫与抗病能力下降，应随气候变化增减衣服，防止受凉。\r\n(4).游：大家出门在外旅游安全、舒适为主，不宜过度疲劳，一般参加了团队都有旅游包车。如果本身体质较弱或者水土不服，要及\r\n时就医，不然会引起身体不适，影响旅游。毛主席纪念堂需凭本人有效身份证件参观(周一闭馆），瞻仰毛主席遗容请按指定\r\n位置排队入场并保持次序；瞻仰其间不得穿奇装异服，背心，拖鞋等。不得携带大小包、照相机、水壶等入场参观，请交至\r\n导游看管后再排队参观，期间每人都需进行景点安检。\r\n(5).购: 餐厅,景区,洗手间等有商贩摊位,不属于旅行社安排购物场所,请理性消费并索要发票,与我社无关！\r\n(6).娱: 客人在自由活动期间,一定要注意自己的人身财产安全，尊重当地的传统及风俗习惯，根据《旅游法》规定，旅行社明确告知','script'),(28021,13,'pjListing',7,'fees','住宿：指定商务酒店标准间入住，所有酒店入住匙牌押金客人自理。\r\n门票：已含行程中景点首道大门票及赠送项目，标明的自费项目的除外。 \r\n用餐：行程中团队标准用餐，正餐为十人一桌，八菜一汤。自由活动期间用餐费请自理，如因自身原因放弃用餐，餐费不退。\r\n用车：全程空调旅游车。\r\n导游：当地中文导游，自由活动期间除外。\r\n服务：提供北京接送机。\r\n保险：旅行社责任保险。\r\n儿童价标准：年龄2~12周岁（含），不占床，含往返机票（含税），含当地旅游车车位，含导游服务，含半餐','script'),(28022,13,'pjListing',7,'meta_title',NULL,'script'),(28023,13,'pjListing',7,'meta_keywords',NULL,'script'),(28024,13,'pjListing',7,'meta_description',NULL,'script'),(28239,5,'pjSlide',1,'title',NULL,'data'),(28240,5,'pjSlide',1,'desc',NULL,'data'),(28241,5,'pjSlide',1,'url',NULL,'data'),(28242,5,'pjSlide',7,'title','武汉三日游','data'),(28243,5,'pjSlide',7,'desc','武汉三日游','data'),(28244,5,'pjSlide',7,'url','cn/3-9/','data'),(28245,6,'pjSlide',1,'title',NULL,'data'),(28246,6,'pjSlide',1,'desc',NULL,'data'),(28247,6,'pjSlide',1,'url',NULL,'data'),(28248,6,'pjSlide',7,'title','【哈尔滨】三日游','data'),(28249,6,'pjSlide',7,'desc','【哈尔滨】三日游','data'),(28250,6,'pjSlide',7,'url','cn/-10/','data'),(28257,7,'pjSlide',1,'title',NULL,'data'),(28258,7,'pjSlide',1,'desc',NULL,'data'),(28259,7,'pjSlide',1,'url',NULL,'data'),(28260,7,'pjSlide',7,'title','澳洲本地游，墨尔本往返','data'),(28261,7,'pjSlide',7,'desc','澳洲本地游，墨尔本往返','data');
INSERT INTO `travel_multi_lang` VALUES (28262,7,'pjSlide',7,'url','cn/-11/','data'),(28263,8,'pjSlide',1,'title',NULL,'data'),(28264,8,'pjSlide',1,'desc',NULL,'data'),(28265,8,'pjSlide',1,'url',NULL,'data'),(28266,8,'pjSlide',7,'title','重庆一日游','data'),(28267,8,'pjSlide',7,'desc','重庆一日游','data'),(28268,8,'pjSlide',7,'url','cn/-12/','data'),(28315,250,'pjCountry',1,'name',NULL,'data'),(28316,250,'pjCountry',7,'name','北京市','data'),(28317,251,'pjCountry',1,'name',NULL,'data'),(28318,251,'pjCountry',7,'name','天津市','data'),(28319,252,'pjCountry',1,'name',NULL,'data'),(28320,252,'pjCountry',7,'name','上海市','data'),(28321,253,'pjCountry',1,'name',NULL,'data'),(28322,253,'pjCountry',7,'name','重庆市','data'),(28323,254,'pjCountry',1,'name',NULL,'data'),(28324,254,'pjCountry',7,'name','河北省','data'),(28325,255,'pjCountry',1,'name',NULL,'data'),(28326,255,'pjCountry',7,'name','河南省','data'),(28327,256,'pjCountry',1,'name',NULL,'data'),(28328,256,'pjCountry',7,'name','湖北省','data'),(28329,257,'pjCountry',1,'name',NULL,'data'),(28330,257,'pjCountry',7,'name','湖南省','data'),(28331,258,'pjCountry',1,'name',NULL,'data'),(28332,258,'pjCountry',7,'name','江苏省','data'),(28333,259,'pjCountry',1,'name',NULL,'data'),(28334,259,'pjCountry',7,'name','江西省','data'),(28335,260,'pjCountry',1,'name',NULL,'data'),(28336,260,'pjCountry',7,'name','辽宁省','data'),(28337,261,'pjCountry',1,'name',NULL,'data'),(28338,261,'pjCountry',7,'name','吉林省','data'),(28339,262,'pjCountry',1,'name',NULL,'data'),(28340,262,'pjCountry',7,'name','黑龙江省','data'),(28341,263,'pjCountry',1,'name',NULL,'data'),(28342,263,'pjCountry',7,'name','陕西省','data'),(28343,264,'pjCountry',1,'name',NULL,'data'),(28344,264,'pjCountry',7,'name','山西省','data'),(28345,265,'pjCountry',1,'name',NULL,'data'),(28346,265,'pjCountry',7,'name','山东省','data'),(28347,266,'pjCountry',1,'name',NULL,'data'),(28348,266,'pjCountry',7,'name','四川省','data'),(28349,267,'pjCountry',1,'name',NULL,'data'),(28350,267,'pjCountry',7,'name','青海省','data'),(28351,268,'pjCountry',1,'name',NULL,'data'),(28352,268,'pjCountry',7,'name','安徽省','data'),(28353,269,'pjCountry',1,'name',NULL,'data'),(28354,269,'pjCountry',7,'name','海南省','data'),(28355,270,'pjCountry',1,'name',NULL,'data'),(28356,270,'pjCountry',7,'name','广东省','data'),(28357,271,'pjCountry',1,'name',NULL,'data'),(28358,271,'pjCountry',7,'name','贵州省','data'),(28359,272,'pjCountry',1,'name',NULL,'data'),(28360,272,'pjCountry',7,'name','浙江省','data'),(28361,273,'pjCountry',1,'name',NULL,'data'),(28362,273,'pjCountry',7,'name','福建省','data'),(28363,274,'pjCountry',1,'name',NULL,'data'),(28364,274,'pjCountry',7,'name','台湾省','data'),(28365,275,'pjCountry',1,'name',NULL,'data'),(28366,275,'pjCountry',7,'name','甘肃省','data'),(28367,276,'pjCountry',1,'name',NULL,'data'),(28368,276,'pjCountry',7,'name','云南省','data'),(28369,277,'pjCountry',1,'name',NULL,'data'),(28370,277,'pjCountry',7,'name','西藏自治区','data'),(28371,278,'pjCountry',1,'name',NULL,'data'),(28372,278,'pjCountry',7,'name','宁夏回族自治区','data'),(28373,279,'pjCountry',1,'name',NULL,'data'),(28374,279,'pjCountry',7,'name','广西壮族自治区','data'),(28375,280,'pjCountry',1,'name',NULL,'data'),(28376,280,'pjCountry',7,'name','新疆维吾尔自治区','data'),(28377,281,'pjCountry',1,'name',NULL,'data'),(28378,281,'pjCountry',7,'name','内蒙古自治区','data'),(28379,282,'pjCountry',1,'name',NULL,'data'),(28380,282,'pjCountry',7,'name','香港特别行政区','data'),(28381,283,'pjCountry',1,'name',NULL,'data'),(28382,283,'pjCountry',7,'name','澳门特别行政区','data'),(28383,284,'pjCountry',1,'name',NULL,'data'),(28384,284,'pjCountry',7,'name','其他国家或地区','data'),(28469,1,'pjOption',1,'home_m_title',NULL,'script'),(28470,1,'pjOption',1,'home_m_desc',NULL,'script'),(28471,1,'pjOption',1,'deals_m_title',NULL,'script'),(28472,1,'pjOption',1,'deals_m_desc',NULL,'script'),(28473,1,'pjOption',1,'pckg_m_title',NULL,'script'),(28474,1,'pjOption',1,'pckg_m_desc',NULL,'script'),(28475,1,'pjOption',1,'contact_m_title',NULL,'script'),(28476,1,'pjOption',1,'contact_m_desc',NULL,'script'),(28477,1,'pjOption',1,'login_m_title',NULL,'script'),(28478,1,'pjOption',1,'login_m_desc',NULL,'script'),(28479,1,'pjOption',1,'forgot_m_title',NULL,'script'),(28480,1,'pjOption',1,'forgot_m_desc',NULL,'script'),(28481,1,'pjOption',1,'register_m_title',NULL,'script'),(28482,1,'pjOption',1,'register_m_desc',NULL,'script'),(28483,1,'pjOption',7,'home_m_title','首页 - 科威旅游管理系统 V1.0','script'),(28484,1,'pjOption',7,'home_m_desc','首页 - 科威旅游管理系统 V1.0','script'),(28485,1,'pjOption',7,'deals_m_title','优惠 - 科威旅游管理系统 V1.0','script'),(28486,1,'pjOption',7,'deals_m_desc','优惠 - 科威旅游管理系统 V1.0','script'),(28487,1,'pjOption',7,'pckg_m_title','行程 - 科威旅游管理系统 V1.0','script'),(28488,1,'pjOption',7,'pckg_m_desc','行程 - 科威旅游管理系统 V1.0','script'),(28489,1,'pjOption',7,'contact_m_title','联系我们 - 科威旅游管理系统 V1.0','script'),(28490,1,'pjOption',7,'contact_m_desc','联系我们 - 科威旅游管理系统 V1.0','script'),(28491,1,'pjOption',7,'login_m_title','登录 - 科威旅游管理系统 V1.0','script'),(28492,1,'pjOption',7,'login_m_desc','登录 - 科威旅游管理系统 V1.0','script'),(28493,1,'pjOption',7,'forgot_m_title','找回密码 - 科威旅游管理系统 V1.0','script'),(28494,1,'pjOption',7,'forgot_m_desc','找回密码 - 科威旅游管理系统 V1.0','script'),(28495,1,'pjOption',7,'register_m_title','注册 - 科威旅游管理系统 V1.0','script'),(28496,1,'pjOption',7,'register_m_desc','注册 - 科威旅游管理系统 V1.0','script');

#
# Structure for table "travel_notifications"
#

DROP TABLE IF EXISTS `travel_notifications`;
CREATE TABLE `travel_notifications` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

#
# Data for table "travel_notifications"
#

INSERT INTO `travel_notifications` VALUES (1,1);

#
# Structure for table "travel_options"
#

DROP TABLE IF EXISTS `travel_options`;
CREATE TABLE `travel_options` (
  `foreign_id` int(10) unsigned NOT NULL DEFAULT '0',
  `key` varchar(255) NOT NULL DEFAULT '',
  `tab_id` tinyint(3) unsigned DEFAULT NULL,
  `value` text,
  `label` text,
  `type` enum('string','text','int','float','enum','bool') NOT NULL DEFAULT 'string',
  `order` int(10) unsigned DEFAULT NULL,
  `is_visible` tinyint(1) unsigned DEFAULT '1',
  `style` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`foreign_id`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# Data for table "travel_options"
#

INSERT INTO `travel_options` VALUES (1,'o_allow_add_package',2,'Yes|No::Yes','是|否','enum',1,1,NULL),(1,'o_comment_and_rating',1,'Show|Hide::Show','显示|隐藏','enum',9,1,NULL),(1,'o_comment_default_status',1,'Confirmed|New::Confirmed','关闭审核|开启审核','enum',10,1,NULL),(1,'o_currency',1,'AED|AFN|ALL|AMD|ANG|AOA|ARS|AUD|AWG|AZN|BAM|BBD|BDT|BGN|BHD|BIF|BMD|BND|BOB|BOV|BRL|BSD|BTN|BWP|BYR|BZD|CAD|CDF|CHE|CHF|CHW|CLF|CLP|CNY|COP|COU|CRC|CUC|CUP|CVE|CZK|DJF|DKK|DOP|DZD|EEK|EGP|ERN|ETB|EUR|FJD|FKP|GBP|GEL|GHS|GIP|GMD|GNF|GTQ|GYD|HKD|HNL|HRK|HTG|HUF|IDR|ILS|INR|IQD|IRR|ISK|JMD|JOD|JPY|KES|KGS|KHR|KMF|KPW|KRW|KWD|KYD|KZT|LAK|LBP|LKR|LRD|LSL|LTL|LVL|LYD|MAD|MDL|MGA|MKD|MMK|MNT|MOP|MRO|MUR|MVR|MWK|MXN|MXV|MYR|MZN|NAD|NGN|NIO|NOK|NPR|NZD|OMR|PAB|PEN|PGK|PHP|PKR|PLN|PYG|QAR|RON|RSD|RUB|RWF|SAR|SBD|SCR|SDG|SEK|SGD|SHP|SLL|SOS|SRD|STD|SYP|SZL|THB|TJS|TMT|TND|TOP|TRY|TTD|TWD|TZS|UAH|UGX|USD|USN|USS|UYU|UZS|VEF|VND|VUV|WST|XAF|XAG|XAU|XBA|XBB|XBC|XBD|XCD|XDR|XFU|XOF|XPD|XPF|XPT|XTS|XXX|YER|ZAR|ZMK|ZWL::CNY',NULL,'enum',1,1,NULL),(1,'o_date_format',1,'d.m.Y|m.d.Y|Y.m.d|j.n.Y|n.j.Y|Y.n.j|d/m/Y|m/d/Y|Y/m/d|j/n/Y|n/j/Y|Y/n/j|d-m-Y|m-d-Y|Y-m-d|j-n-Y|n-j-Y|Y-n-j::Y-n-j','d.m.Y (25.09.2012)|m.d.Y (09.25.2012)|Y.m.d (2012.09.25)|j.n.Y (25.9.2012)|n.j.Y (9.25.2012)|Y.n.j (2012.9.25)|d/m/Y (25/09/2012)|m/d/Y (09/25/2012)|Y/m/d (2012/09/25)|j/n/Y (25/9/2012)|n/j/Y (9/25/2012)|Y/n/j (2012/9/25)|d-m-Y (25-09-2012)|m-d-Y (09-25-2012)|Y-m-d (2012-09-25)|j-n-Y (25-9-2012)|n-j-Y (9-25-2012)|Y-n-j (2012-9-25)','enum',3,1,NULL),(1,'o_email_address',1,'email@domain.com',NULL,'string',11,1,NULL),(1,'o_facebook',1,'http://t.qq.com',NULL,'string',19,1,NULL),(1,'o_fields_index',99,'be18a22bb37b42ad437af9ac7b7f5633',NULL,'string',NULL,0,NULL),(1,'o_items_per_page',1,'10',NULL,'int',5,1,NULL),(1,'o_logo_original',99,'app/web/upload/logo/o_c4ca4238a0b923820dcc509a6f75849b.png',NULL,'string',NULL,0,NULL),(1,'o_logo_thumb',99,'app/web/upload/logo/t_c4ca4238a0b923820dcc509a6f75849b.png',NULL,'string',NULL,0,NULL),(1,'o_multi_lang',99,'1|0::1',NULL,'enum',NULL,0,NULL),(1,'o_owner_is_active',2,'Yes|No::No','是|否','enum',2,1,NULL),(1,'o_paypal_address',2,'alipay@domain.com',NULL,'string',3,1,NULL),(1,'o_send_email',1,'mail|smtp::mail','PHP mail()|SMTP','enum',12,1,NULL),(1,'o_smtp_host',1,NULL,NULL,'string',13,1,NULL),(1,'o_smtp_pass',1,NULL,NULL,'string',16,1,NULL),(1,'o_smtp_port',1,'25',NULL,'int',14,1,NULL),(1,'o_smtp_user',1,NULL,NULL,'string',15,1,NULL),(1,'o_timezone',1,'-43200|-39600|-36000|-32400|-28800|-25200|-21600|-18000|-14400|-10800|-7200|-3600|0|3600|7200|10800|14400|18000|21600|25200|28800|32400|36000|39600|43200|46800::28800','GMT-12:00|GMT-11:00|GMT-10:00|GMT-09:00|GMT-08:00|GMT-07:00|GMT-06:00|GMT-05:00|GMT-04:00|GMT-03:00|GMT-02:00|GMT-01:00|GMT|GMT+01:00|GMT+02:00|GMT+03:00|GMT+04:00|GMT+05:00|GMT+06:00|GMT+07:00|GMT+08:00|GMT+09:00|GMT+10:00|GMT+11:00|GMT+12:00|GMT+13:00','enum',17,1,NULL),(1,'o_time_format',1,'H:i|G:i|h:i|h:i a|h:i A|g:i|g:i a|g:i A::H:i','H:i (09:45)|G:i (9:45)|h:i (09:45)|h:i a (09:45 am)|h:i A (09:45 AM)|g:i (9:45)|g:i a (9:45 am)|g:i A (9:45 AM)','enum',4,1,NULL),(1,'o_twitter',1,'http://weibo.com',NULL,'string',18,1,NULL),(1,'o_update_2015_04_06_14_45_32.sql_c07bb8134863f611db32dd2455e9ce6f',99,'2015-10-05 10:29:39',NULL,'string',NULL,1,NULL),(1,'o_update_2015_04_09_03_33_52.sql_97905699a36549827cc01f221064553a',99,'2015-10-05 10:29:39',NULL,'string',NULL,1,NULL),(1,'o_update_2015_06_05_08_12_45.sql_0dc791f152e3928082983a84b4d6c005',99,'2015-10-05 10:29:39',NULL,'string',NULL,1,NULL),(1,'o_update_2015_06_05_17_22_11.sql_a6e11cbd45bd65ed6a90fb262eabde8a',99,'2015-10-05 10:29:39',NULL,'string',NULL,1,NULL),(1,'o_view_deals',1,'list|grid|map::grid','列表|表格|地图','enum',8,1,NULL),(1,'o_view_packages',1,'list|grid|map::list','列表|表格|地图','enum',7,1,NULL),(1,'o_view_subscribe',1,'1|0::1','显示|隐藏','enum',6,1,NULL),(1,'o_week_start',1,'0|1|2|3|4|5|6::1','星期日|星期一|星期二|星期三|星期四|星期五|星期六','enum',2,1,NULL),(1,'private_key',99,'OpwcHZFNwiMu0icw/BTEwren36gG8sEUXs8PLQMKhGiV7Ci0O/BDhFK8EQGKRRpmcwJu7G5SKNzpBOKXVwM1LgKrAzXV2P5FhjyPCGI8Szt41xnrXX5f1dlPUujfUmlz5NmI9PETeY8vHWry6VHiKIDV8pOFqiUue/CPnVQXKwpnVEcCk8+NJh5cHZ2/2KimXBVVOsngX0qOfEgRFynxYtvykh8O/jbxVKSEryr3j2DpUsPDiHeAZC6yEaRkYyuaPc4ZAXw5j6+rBYQiHeGlYubam1Sm+RP4rDwphYXD28LfijL13lcI2ywwPy7FRN2gvt5o6UbRnBiEwSERrxh1/w==',NULL,'string',NULL,1,'string');

#
# Structure for table "travel_pages"
#

DROP TABLE IF EXISTS `travel_pages`;
CREATE TABLE `travel_pages` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `seo_url` varchar(100) DEFAULT NULL,
  `image_original` varchar(255) DEFAULT NULL,
  `image_thumb` varchar(255) DEFAULT NULL,
  `status` enum('T','F') DEFAULT 'T',
  PRIMARY KEY (`id`),
  UNIQUE KEY `seo_url` (`seo_url`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

#
# Data for table "travel_pages"
#

INSERT INTO `travel_pages` VALUES (1,'about-us','app/web/upload/pages/o_c4ca4238a0b923820dcc509a6f75849b.jpg','app/web/upload/pages/t_c4ca4238a0b923820dcc509a6f75849b.jpg','T'),(2,'destinations','app/web/upload/pages/o_c81e728d9d4c2f636f067f89cc14862c.jpg','app/web/upload/pages/t_c81e728d9d4c2f636f067f89cc14862c.jpg','T'),(3,'terms-of-use','app/web/upload/pages/o_eccbc87e4b5ce2fe28308fd9f2a7baf3.jpg','app/web/upload/pages/t_eccbc87e4b5ce2fe28308fd9f2a7baf3.jpg','T');

#
# Structure for table "travel_payments"
#

DROP TABLE IF EXISTS `travel_payments`;
CREATE TABLE `travel_payments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `listing_id` int(10) unsigned DEFAULT NULL,
  `txn_id` varchar(255) DEFAULT NULL,
  `processed_on` datetime DEFAULT NULL,
  `date_from` date DEFAULT NULL,
  `date_to` date DEFAULT NULL,
  `price` decimal(9,2) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `listing_id` (`listing_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# Data for table "travel_payments"
#


#
# Structure for table "travel_periods"
#

DROP TABLE IF EXISTS `travel_periods`;
CREATE TABLE `travel_periods` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `days` smallint(5) unsigned DEFAULT NULL,
  `price` decimal(9,2) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

#
# Data for table "travel_periods"
#

INSERT INTO `travel_periods` VALUES (1,10,49.00),(2,20,79.00),(3,30,99.00),(4,40,109.00),(5,50,119.00);

#
# Structure for table "travel_plugin_country"
#

DROP TABLE IF EXISTS `travel_plugin_country`;
CREATE TABLE `travel_plugin_country` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `alpha_2` varchar(2) DEFAULT NULL,
  `alpha_3` varchar(3) DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  UNIQUE KEY `alpha_2` (`alpha_2`),
  UNIQUE KEY `alpha_3` (`alpha_3`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=285 DEFAULT CHARSET=utf8;

#
# Data for table "travel_plugin_country"
#

INSERT INTO `travel_plugin_country` VALUES (250,'BJ','BJS','T'),(251,'TJ','TJS','T'),(252,'SH','SHS','T'),(253,'CQ','CQS','T'),(254,'HB','HBS','T'),(255,'HN','HNS','T'),(256,'HU','HUS','T'),(257,'HA','HAS','T'),(258,'JS','JSS','T'),(259,'JX','JXS','T'),(260,'LN','LNS','T'),(261,'JL','JLS','T'),(262,'HL','HLJ','T'),(263,'SX','SXS','T'),(264,'SA','SAS','T'),(265,'SD','SDS','T'),(266,'SC','SCS','T'),(267,'QH','QHS','T'),(268,'AH','AHS','T'),(269,'HI','HIS','T'),(270,'GD','GDS','T'),(271,'GZ','GZS','T'),(272,'ZJ','ZJS','T'),(273,'FJ','FJS','T'),(274,'TW','TWS','T'),(275,'GS','GSS','T'),(276,'YN','YNS','T'),(277,'TI','TIB','T'),(278,'NX','NXS','T'),(279,'GX','GXS','T'),(280,'XJ','XJS','T'),(281,'MO','MOG','T'),(282,'HK','HKD','T'),(283,'MA','MAC','T'),(284,'OT','OTH','T');

#
# Structure for table "travel_plugin_gallery"
#

DROP TABLE IF EXISTS `travel_plugin_gallery`;
CREATE TABLE `travel_plugin_gallery` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `foreign_id` int(10) unsigned DEFAULT NULL,
  `hash` varchar(32) DEFAULT NULL,
  `mime_type` varchar(255) DEFAULT NULL,
  `small_path` varchar(255) DEFAULT NULL,
  `small_size` int(10) unsigned DEFAULT NULL,
  `small_width` smallint(5) unsigned DEFAULT NULL,
  `small_height` smallint(5) unsigned DEFAULT NULL,
  `medium_path` varchar(255) DEFAULT NULL,
  `medium_size` int(10) unsigned DEFAULT NULL,
  `medium_width` smallint(5) unsigned DEFAULT NULL,
  `medium_height` smallint(5) unsigned DEFAULT NULL,
  `large_path` varchar(255) DEFAULT NULL,
  `large_size` int(10) unsigned DEFAULT NULL,
  `large_width` smallint(5) unsigned DEFAULT NULL,
  `large_height` smallint(5) unsigned DEFAULT NULL,
  `source_path` varchar(255) DEFAULT NULL,
  `source_size` int(10) unsigned DEFAULT NULL,
  `source_width` smallint(5) unsigned DEFAULT NULL,
  `source_height` smallint(5) unsigned DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `alt` varchar(255) DEFAULT NULL,
  `watermark` varchar(255) DEFAULT NULL,
  `sort` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `foreign_id` (`foreign_id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=62 DEFAULT CHARSET=utf8;

#
# Data for table "travel_plugin_gallery"
#

INSERT INTO `travel_plugin_gallery` VALUES (35,9,NULL,'image/jpeg','app/web/upload/small/9_aa49963fa7d68ba48e520d673d7a1f73.jpg',5680,184,138,'app/web/upload/medium/9_aa49963fa7d68ba48e520d673d7a1f73.jpg',28006,571,353,'app/web/upload/large/9_aa49963fa7d68ba48e520d673d7a1f73.jpg',20577,380,330,'app/web/upload/source/9_aa49963fa7d68ba48e520d673d7a1f73.jpg',246654,980,330,'1.jpg',NULL,NULL,1),(36,9,NULL,'image/jpeg','app/web/upload/small/9_aa2c5467e86f1381f0a41eae84e15b2f.jpg',4836,184,138,'app/web/upload/medium/9_aa2c5467e86f1381f0a41eae84e15b2f.jpg',28716,571,353,'app/web/upload/large/9_aa2c5467e86f1381f0a41eae84e15b2f.jpg',213519,1600,1067,'app/web/upload/source/9_aa2c5467e86f1381f0a41eae84e15b2f.jpg',793998,1600,1067,'2.jpg',NULL,NULL,2),(37,9,NULL,'image/jpeg','app/web/upload/small/9_bee0ad7a24706ba475bbf5726a8342a3.jpg',3498,184,138,'app/web/upload/medium/9_bee0ad7a24706ba475bbf5726a8342a3.jpg',15711,571,353,'app/web/upload/large/9_bee0ad7a24706ba475bbf5726a8342a3.jpg',43002,1024,683,'app/web/upload/source/9_bee0ad7a24706ba475bbf5726a8342a3.jpg',372574,1024,683,'3.jpg',NULL,NULL,3),(38,9,NULL,'image/jpeg','app/web/upload/small/9_226f88dea667971ca53b66fafc288e2a.jpg',2996,184,138,'app/web/upload/medium/9_226f88dea667971ca53b66fafc288e2a.jpg',15821,571,353,'app/web/upload/large/9_226f88dea667971ca53b66fafc288e2a.jpg',59245,1024,683,'app/web/upload/source/9_226f88dea667971ca53b66fafc288e2a.jpg',294231,1024,683,'4.jpg',NULL,NULL,4),(39,9,NULL,'image/jpeg','app/web/upload/small/9_db8b523a8c5cc814de8df04dc2a4bb6f.jpg',5096,184,138,'app/web/upload/medium/9_db8b523a8c5cc814de8df04dc2a4bb6f.jpg',24740,571,353,'app/web/upload/large/9_db8b523a8c5cc814de8df04dc2a4bb6f.jpg',30112,700,330,'app/web/upload/source/9_db8b523a8c5cc814de8df04dc2a4bb6f.jpg',135648,700,330,'5.jpg',NULL,NULL,5),(40,10,NULL,'image/jpeg','app/web/upload/small/10_82e327defcd424d5b687b30420c11b9d.jpg',6092,184,138,'app/web/upload/medium/10_82e327defcd424d5b687b30420c11b9d.jpg',35789,571,353,'app/web/upload/large/10_82e327defcd424d5b687b30420c11b9d.jpg',243143,1600,1066,'app/web/upload/source/10_82e327defcd424d5b687b30420c11b9d.jpg',720157,1600,1066,'1.jpg',NULL,NULL,1),(41,10,NULL,'image/jpeg','app/web/upload/small/10_f9474866f2c99e6976639d539d208978.jpg',4763,184,138,'app/web/upload/medium/10_f9474866f2c99e6976639d539d208978.jpg',27022,571,353,'app/web/upload/large/10_f9474866f2c99e6976639d539d208978.jpg',96082,1024,682,'app/web/upload/source/10_f9474866f2c99e6976639d539d208978.jpg',456558,1024,682,'2.jpg',NULL,NULL,2),(42,10,NULL,'image/jpeg','app/web/upload/small/10_4b7062a56fda6494aaf87d27df041de8.jpg',4315,184,138,'app/web/upload/medium/10_4b7062a56fda6494aaf87d27df041de8.jpg',19342,571,353,'app/web/upload/large/10_4b7062a56fda6494aaf87d27df041de8.jpg',46583,962,641,'app/web/upload/source/10_4b7062a56fda6494aaf87d27df041de8.jpg',293940,962,641,'3.jpg',NULL,NULL,3),(44,10,NULL,'image/jpeg','app/web/upload/small/10_99b8a9e43e18be00b539068cf5cb7cd8.jpg',3671,184,138,'app/web/upload/medium/10_99b8a9e43e18be00b539068cf5cb7cd8.jpg',16981,571,353,'app/web/upload/large/10_99b8a9e43e18be00b539068cf5cb7cd8.jpg',29957,752,500,'app/web/upload/source/10_99b8a9e43e18be00b539068cf5cb7cd8.jpg',224393,752,500,'5.jpg',NULL,NULL,5),(46,10,NULL,'image/jpeg','app/web/upload/small/10_b6d2d43f3b5efad660855becd826ea9b.jpg',4301,184,138,'app/web/upload/medium/10_b6d2d43f3b5efad660855becd826ea9b.jpg',21961,571,353,'app/web/upload/large/10_b6d2d43f3b5efad660855becd826ea9b.jpg',150531,1600,1067,'app/web/upload/source/10_b6d2d43f3b5efad660855becd826ea9b.jpg',677640,1600,1067,'4.jpg',NULL,NULL,6),(47,11,NULL,'image/jpeg','app/web/upload/small/11_d0354605ba52ae9b44bb127f67d0bca6.jpg',4661,184,138,'app/web/upload/medium/11_d0354605ba52ae9b44bb127f67d0bca6.jpg',25394,571,353,'app/web/upload/large/11_d0354605ba52ae9b44bb127f67d0bca6.jpg',135233,1280,853,'app/web/upload/source/11_d0354605ba52ae9b44bb127f67d0bca6.jpg',393016,1280,853,'1.jpg',NULL,NULL,1),(48,11,NULL,'image/jpeg','app/web/upload/small/11_cb1fdf4d39aa007864801b1cf2bcf914.jpg',4830,184,138,'app/web/upload/medium/11_cb1fdf4d39aa007864801b1cf2bcf914.jpg',23806,571,353,'app/web/upload/large/11_cb1fdf4d39aa007864801b1cf2bcf914.jpg',69929,1020,680,'app/web/upload/source/11_cb1fdf4d39aa007864801b1cf2bcf914.jpg',233600,1020,680,'2.jpg',NULL,NULL,2),(49,11,NULL,'image/jpeg','app/web/upload/small/11_4df753da2caf1d86bcfa8596f2963cdd.jpg',4483,184,138,'app/web/upload/medium/11_4df753da2caf1d86bcfa8596f2963cdd.jpg',25582,571,353,'app/web/upload/large/11_4df753da2caf1d86bcfa8596f2963cdd.jpg',88057,1024,683,'app/web/upload/source/11_4df753da2caf1d86bcfa8596f2963cdd.jpg',292440,1024,683,'3.jpg',NULL,NULL,3),(50,11,NULL,'image/jpeg','app/web/upload/small/11_dde1c282cb1fca7f7f00cb406fe41f1c.jpg',5785,184,138,'app/web/upload/medium/11_dde1c282cb1fca7f7f00cb406fe41f1c.jpg',39010,571,353,'app/web/upload/large/11_dde1c282cb1fca7f7f00cb406fe41f1c.jpg',142536,1024,683,'app/web/upload/source/11_dde1c282cb1fca7f7f00cb406fe41f1c.jpg',435549,1024,683,'4.jpg',NULL,NULL,4),(51,11,NULL,'image/jpeg','app/web/upload/small/11_c9d4026650f74bec51f03bf90516b6c9.jpg',3955,184,138,'app/web/upload/medium/11_c9d4026650f74bec51f03bf90516b6c9.jpg',21145,571,353,'app/web/upload/large/11_c9d4026650f74bec51f03bf90516b6c9.jpg',50277,800,533,'app/web/upload/source/11_c9d4026650f74bec51f03bf90516b6c9.jpg',151112,800,533,'5.jpg',NULL,NULL,5),(52,12,NULL,'image/jpeg','app/web/upload/small/12_94f615febf461efd264da93bd2a46fd4.jpg',5132,184,138,'app/web/upload/medium/12_94f615febf461efd264da93bd2a46fd4.jpg',25484,571,353,'app/web/upload/large/12_94f615febf461efd264da93bd2a46fd4.jpg',16197,410,331,'app/web/upload/source/12_94f615febf461efd264da93bd2a46fd4.jpg',138655,980,331,'1.jpg',NULL,NULL,1),(53,12,NULL,'image/jpeg','app/web/upload/small/12_5f57c1877dfa728fcacf6ebe15298f41.jpg',5348,184,138,'app/web/upload/medium/12_5f57c1877dfa728fcacf6ebe15298f41.jpg',25204,571,353,'app/web/upload/large/12_5f57c1877dfa728fcacf6ebe15298f41.jpg',41947,980,330,'app/web/upload/source/12_5f57c1877dfa728fcacf6ebe15298f41.jpg',207075,980,330,'2.jpg',NULL,NULL,2),(54,12,NULL,'image/jpeg','app/web/upload/small/12_2d30510e451854712b772fa6e0fd71b9.jpg',3908,184,138,'app/web/upload/medium/12_2d30510e451854712b772fa6e0fd71b9.jpg',21304,571,353,'app/web/upload/large/12_2d30510e451854712b772fa6e0fd71b9.jpg',63541,1028,512,'app/web/upload/source/12_2d30510e451854712b772fa6e0fd71b9.jpg',285228,1028,512,'3.jpg',NULL,NULL,3),(55,12,NULL,'image/jpeg','app/web/upload/small/12_293dd1817265757ad74e3c32e0e1f00f.jpg',4761,184,138,'app/web/upload/medium/12_293dd1817265757ad74e3c32e0e1f00f.jpg',27379,571,353,'app/web/upload/large/12_293dd1817265757ad74e3c32e0e1f00f.jpg',84555,1024,768,'app/web/upload/source/12_293dd1817265757ad74e3c32e0e1f00f.jpg',374718,1024,768,'4.jpg',NULL,NULL,4),(56,12,NULL,'image/jpeg','app/web/upload/small/12_a28da8579cef3d22b43101d78cf321f9.jpg',4664,184,138,'app/web/upload/medium/12_a28da8579cef3d22b43101d78cf321f9.jpg',24692,571,353,'app/web/upload/large/12_a28da8579cef3d22b43101d78cf321f9.jpg',67888,968,648,'app/web/upload/source/12_a28da8579cef3d22b43101d78cf321f9.jpg',312653,968,648,'5.jpg',NULL,NULL,5),(57,13,NULL,'image/jpeg','app/web/upload/small/13_d9a579a710b51058b081d0718c6053ff.jpg',2261,184,138,'app/web/upload/medium/13_d9a579a710b51058b081d0718c6053ff.jpg',11767,571,353,'app/web/upload/large/13_d9a579a710b51058b081d0718c6053ff.jpg',84852,1600,1200,'app/web/upload/source/13_d9a579a710b51058b081d0718c6053ff.jpg',413298,1600,1200,'1.jpg',NULL,NULL,1),(58,13,NULL,'image/jpeg','app/web/upload/small/13_afdb0cb0d26cbf18c5fd41d0c54a0b4f.jpg',5676,184,138,'app/web/upload/medium/13_afdb0cb0d26cbf18c5fd41d0c54a0b4f.jpg',29267,571,353,'app/web/upload/large/13_afdb0cb0d26cbf18c5fd41d0c54a0b4f.jpg',102606,1280,720,'app/web/upload/source/13_afdb0cb0d26cbf18c5fd41d0c54a0b4f.jpg',585558,1280,720,'2.jpg',NULL,NULL,2),(59,13,NULL,'image/jpeg','app/web/upload/small/13_d5031d67cf786349613a04e1a1d375d3.jpg',4046,184,138,'app/web/upload/medium/13_d5031d67cf786349613a04e1a1d375d3.jpg',20089,571,353,'app/web/upload/large/13_d5031d67cf786349613a04e1a1d375d3.jpg',72184,1280,720,'app/web/upload/source/13_d5031d67cf786349613a04e1a1d375d3.jpg',486702,1280,720,'3.jpg',NULL,NULL,3),(60,13,NULL,'image/jpeg','app/web/upload/small/13_db197d56b3a6a34b2bbe4448220f0e6e.jpg',3464,184,138,'app/web/upload/medium/13_db197d56b3a6a34b2bbe4448220f0e6e.jpg',17620,571,353,'app/web/upload/large/13_db197d56b3a6a34b2bbe4448220f0e6e.jpg',31323,800,537,'app/web/upload/source/13_db197d56b3a6a34b2bbe4448220f0e6e.jpg',150741,800,537,'4.jpg',NULL,NULL,4),(61,13,NULL,'image/jpeg','app/web/upload/small/13_fe9b032782f29bb036c14f082a567f5b.jpg',4248,184,138,'app/web/upload/medium/13_fe9b032782f29bb036c14f082a567f5b.jpg',20038,571,353,'app/web/upload/large/13_fe9b032782f29bb036c14f082a567f5b.jpg',67200,1200,797,'app/web/upload/source/13_fe9b032782f29bb036c14f082a567f5b.jpg',267548,1200,797,'5.jpg',NULL,NULL,5);

#
# Structure for table "travel_plugin_locale"
#

DROP TABLE IF EXISTS `travel_plugin_locale`;
CREATE TABLE `travel_plugin_locale` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `language_iso` varchar(2) DEFAULT NULL,
  `sort` int(10) unsigned DEFAULT NULL,
  `is_default` tinyint(1) unsigned DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `language_iso` (`language_iso`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8;

#
# Data for table "travel_plugin_locale"
#

INSERT INTO `travel_plugin_locale` VALUES (1,'gb',1,0),(7,'cn',2,1);

#
# Structure for table "travel_plugin_locale_languages"
#

DROP TABLE IF EXISTS `travel_plugin_locale_languages`;
CREATE TABLE `travel_plugin_locale_languages` (
  `iso` varchar(2) NOT NULL DEFAULT '',
  `title` varchar(255) DEFAULT NULL,
  `file` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`iso`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# Data for table "travel_plugin_locale_languages"
#

INSERT INTO `travel_plugin_locale_languages` VALUES ('aa','Afar',NULL),('ab','Abkhazian',NULL),('ae','Avestan','ae.png'),('af','Afrikaans','af.png'),('ak','Akan',NULL),('am','Amharic','am.png'),('an','Aragonese','an.png'),('as','Assamese','as.png'),('av','Avaric',NULL),('ay','Aymara',NULL),('ba','Bashkir','ba.png'),('be','Belarusian','be.png'),('bg','Bulgarian','bg.png'),('bh','Bihari','bh.png'),('bi','Bislama','bi.png'),('bm','Bambara','bm.png'),('bn','Bengali','bn.png'),('bo','Tibetan','bo.png'),('br','Breton','br.png'),('bs','Bosnian','bs.png'),('ca','Catalan','catalonia.png'),('ce','Chechen',NULL),('ch','Chamorro','ch.png'),('cn','Chinese','cn.png'),('co','Corsican','co.png'),('cr','Cree','cr.png'),('cs','Czech','cz.png'),('cu','Church Slavic','cu.png'),('cv','Chuvash','cv.png'),('cy','Welsh','cy.png'),('da','Danish','dk.png'),('de','German','de.png'),('dz','Dzongkha','dz.png'),('ee','Ewe','ee.png'),('el','Greek','gr.png'),('eo','Esperanto',NULL),('es','Spanish','es.png'),('et','Estonian','et.png'),('eu','Basque','eu.png'),('ff','Fulah',NULL),('fi','Finnish','fi.png'),('fj','Fijian','fj.png'),('fo','Faroese','fo.png'),('fr','French','fr.png'),('fy','Western Frisian',NULL),('ga','Irish','ga.png'),('gb','English - UK','gb.png'),('gd','Scottish Gaelic','gd.png'),('gl','Galician','gl.png'),('gn','Guarani','gn.png'),('gu','Gujarati','gu.png'),('gv','Manx',NULL),('ha','Hausa',NULL),('hi','Hindi',NULL),('ho','Hiri Motu',NULL),('hr','Croatian','hr.png'),('ht','Haitian','ht.png'),('hu','Hungarian','hu.png'),('hy','Armenian',NULL),('hz','Herero',NULL),('ia','Interlingua (International Auxiliary Language Association)',NULL),('id','Indonesian','id.png'),('ie','Interlingue','ie.png'),('ig','Igbo',NULL),('ii','Sichuan Yi',NULL),('ik','Inupiaq',NULL),('io','Ido','io.png'),('is','Icelandic','is.png'),('it','Italian','it.png'),('iu','Inuktitut',NULL),('ka','Georgian',NULL),('kg','Kongo','kg.png'),('ki','Kikuyu','ki.png'),('kj','Kwanyama',NULL),('kl','Kalaallisut',NULL),('km','Khmer','km.png'),('kn','Kannada','kn.png'),('ko','Korean',NULL),('kr','Kanuri','kr.png'),('kv','Komi',NULL),('kw','Cornish','kw.png'),('ky','Kirghiz','ky.png'),('la','Latin','la.png'),('lb','Luxembourgish','lb.png'),('lg','Ganda',NULL),('li','Limburgish','li.png'),('ln','Lingala',NULL),('lo','Lao',NULL),('lt','Lithuanian','lt.png'),('lu','Luba-Katanga','lu.png'),('lv','Latvian','lv.png'),('mg','Malagasy','mg.png'),('mh','Marshallese','mh.png'),('mi','Maori',NULL),('mk','Macedonian','mk.png'),('mn','Mongolian','mn.png'),('mr','Marathi','mr.png'),('mt','Maltese','mt.png'),('my','Burmese','my.png'),('na','Nauru','na.png'),('nb','Norwegian Bokmal',NULL),('nd','North Ndebele',NULL),('ne','Nepali','ne.png'),('ng','English - Nigeria','ng.png'),('nl','Dutch','nl.png'),('nn','Norwegian Nynorsk',NULL),('no','Norwegian','no.png'),('nr','South Ndebele','nr.png'),('nv','Navajo',NULL),('ny','Chichewa',NULL),('oc','Occitan',NULL),('oj','Ojibwa',NULL),('om','Oromo','om.png'),('or','Oriya',NULL),('os','Ossetian',NULL),('pi','Pali',NULL),('pl','Polish','pl.png'),('pt','Portuguese','pt.png'),('qu','Quechua',NULL),('rm','Raeto-Romance',NULL),('rn','Kirundi',NULL),('ro','Romanian','ro.png'),('ru','Russian','ru.png'),('rw','Kinyarwanda','rw.png'),('sa','Sanskrit','sa.png'),('sc','Sardinian','sc.png'),('se','Northern Sami','se.png'),('sg','Sango','sg.png'),('si','Sinhala','si.png'),('sk','Slovak','sk.png'),('sl','Slovenian','sl.png'),('sm','Samoan','sm.png'),('sn','Shona','sn.png'),('sq','Albanian','al.png'),('sr','Serbian','sr.png'),('ss','Swati',NULL),('st','Southern Sotho','st.png'),('su','Sundanese',NULL),('sv','Swedish','se.png'),('sw','Swahili',NULL),('ta','Tamil',NULL),('te','Telugu',NULL),('tg','Tajik','tg.png'),('th','Thai','th.png'),('ti','Tigrinya',NULL),('tl','Tagalog','tl.png'),('tn','Tswana','tn.png'),('to','Tonga','to.png'),('tr','Turkish','tr.png'),('ts','Tsonga',NULL),('tt','Tatar','tt.png'),('tw','Twi','tw.png'),('ty','Tahitian',NULL),('uk','Ukrainian',NULL),('us','English - USA','us.png'),('uz','Uzbek','uz.png'),('ve','Venda','ve.png'),('vi','Vietnamese','vi.png'),('vo','Volapuk',NULL),('wa','Walloon','wa.png'),('wo','Wolof',NULL),('xh','Xhosa',NULL),('yo','Yoruba',NULL),('za','Zhuang','za.png'),('zu','Zulu',NULL);

#
# Structure for table "travel_plugin_log"
#

DROP TABLE IF EXISTS `travel_plugin_log`;
CREATE TABLE `travel_plugin_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `filename` varchar(255) DEFAULT NULL,
  `function` varchar(255) DEFAULT NULL,
  `value` text,
  `created` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# Data for table "travel_plugin_log"
#


#
# Structure for table "travel_plugin_log_config"
#

DROP TABLE IF EXISTS `travel_plugin_log_config`;
CREATE TABLE `travel_plugin_log_config` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `filename` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# Data for table "travel_plugin_log_config"
#


#
# Structure for table "travel_plugin_one_admin"
#

DROP TABLE IF EXISTS `travel_plugin_one_admin`;
CREATE TABLE `travel_plugin_one_admin` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `url` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `password` blob,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# Data for table "travel_plugin_one_admin"
#


#
# Structure for table "travel_plugin_paypal"
#

DROP TABLE IF EXISTS `travel_plugin_paypal`;
CREATE TABLE `travel_plugin_paypal` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `foreign_id` int(10) unsigned DEFAULT NULL,
  `subscr_id` varchar(25) DEFAULT NULL,
  `txn_id` varchar(25) DEFAULT NULL,
  `txn_type` varchar(50) DEFAULT NULL,
  `mc_gross` decimal(9,2) unsigned DEFAULT NULL,
  `mc_currency` varchar(3) DEFAULT NULL,
  `payer_email` varchar(255) DEFAULT NULL,
  `dt` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `fid` (`foreign_id`,`subscr_id`,`txn_id`,`txn_type`),
  UNIQUE KEY `txn_id` (`txn_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# Data for table "travel_plugin_paypal"
#


#
# Structure for table "travel_prices"
#

DROP TABLE IF EXISTS `travel_prices`;
CREATE TABLE `travel_prices` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `listing_id` int(10) unsigned NOT NULL,
  `price_title` varchar(255) DEFAULT NULL,
  `price_type` enum('person','night','total') DEFAULT NULL,
  `date_from` date DEFAULT NULL,
  `date_to` date DEFAULT NULL,
  `price` decimal(15,2) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `listing_id` (`listing_id`)
) ENGINE=InnoDB AUTO_INCREMENT=227 DEFAULT CHARSET=utf8;

#
# Data for table "travel_prices"
#

INSERT INTO `travel_prices` VALUES (218,13,'默认价格','person','2015-11-01','2015-11-30',365.00),(220,11,'价格','total','2015-11-01','2015-12-31',15550.00),(221,10,'优惠价格','total','2015-10-01','2016-03-01',1152.00),(224,12,'默认价格','total','2015-11-01','2015-11-30',220.00),(225,9,'春季价格','person','2015-02-02','2015-05-01',200.00),(226,9,'秋季价格','person','2015-08-08','2015-11-02',248.00);

#
# Structure for table "travel_roles"
#

DROP TABLE IF EXISTS `travel_roles`;
CREATE TABLE `travel_roles` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `role` varchar(255) DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

#
# Data for table "travel_roles"
#

INSERT INTO `travel_roles` VALUES (1,'admin','T'),(2,'editor','T'),(3,'owner','T');

#
# Structure for table "travel_slides"
#

DROP TABLE IF EXISTS `travel_slides`;
CREATE TABLE `travel_slides` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `image_original` varchar(255) DEFAULT NULL,
  `image_thumb` varchar(255) DEFAULT NULL,
  `target` enum('_blank','_self') DEFAULT '_self',
  `sort` int(10) unsigned DEFAULT NULL,
  `status` enum('T','F') DEFAULT 'T',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;

#
# Data for table "travel_slides"
#

INSERT INTO `travel_slides` VALUES (5,'app/web/upload/slides/o_e4da3b7fbbce2345d7772b0674a318d5.jpg','app/web/upload/slides/t_e4da3b7fbbce2345d7772b0674a318d5.jpg','_blank',1,'T'),(6,'app/web/upload/slides/o_1679091c5a880faf6fb5e6087eb1b2dc.jpg','app/web/upload/slides/t_1679091c5a880faf6fb5e6087eb1b2dc.jpg','_blank',1,'T'),(7,'app/web/upload/slides/o_8f14e45fceea167a5a36dedd4bea2543.jpg','app/web/upload/slides/t_8f14e45fceea167a5a36dedd4bea2543.jpg','_blank',1,'T'),(8,'app/web/upload/slides/o_c9f0f895fb98ab9159f51fd0297e236d.jpg','app/web/upload/slides/t_c9f0f895fb98ab9159f51fd0297e236d.jpg','_blank',1,'T');

#
# Structure for table "travel_subscriptions"
#

DROP TABLE IF EXISTS `travel_subscriptions`;
CREATE TABLE `travel_subscriptions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(255) DEFAULT NULL,
  `is_subscribed` enum('T','F') DEFAULT NULL,
  `date_subscr` date DEFAULT NULL,
  `date_unsubscr` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# Data for table "travel_subscriptions"
#


#
# Structure for table "travel_types"
#

DROP TABLE IF EXISTS `travel_types`;
CREATE TABLE `travel_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `status` enum('T','F') DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

#
# Data for table "travel_types"
#

INSERT INTO `travel_types` VALUES (1,'T'),(2,'T'),(3,'T'),(4,'T'),(5,'T');

#
# Structure for table "travel_users"
#

DROP TABLE IF EXISTS `travel_users`;
CREATE TABLE `travel_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `role_id` int(10) unsigned NOT NULL,
  `email` varchar(255) DEFAULT NULL,
  `password` blob,
  `name` varchar(255) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `contact_title` enum('mr','mrs','miss','ms','dr','prof','rev','other') DEFAULT NULL,
  `contact_phone` varchar(255) DEFAULT NULL,
  `contact_mobile` varchar(255) DEFAULT NULL,
  `contact_fax` varchar(255) DEFAULT NULL,
  `contact_url` varchar(255) DEFAULT NULL,
  `created` datetime NOT NULL,
  `last_login` datetime DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  `is_active` enum('T','F') NOT NULL DEFAULT 'F',
  `ip` varchar(15) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`),
  KEY `role_id` (`role_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

#
# Data for table "travel_users"
#

