<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjUtil extends pjToolkit
{
	static public function getPricesFilter()
	{
		return array(
			1 => array(100, 500),
			2 => array(500, 1000),
			3 => array(1000, 1500),
			4 => array(1500, 9999999)
		);
	}
	
	static public function uuid()
	{
		return chr(rand(65,90)) . chr(rand(65,90)) . time();
	}

	static public function html2txt($document){
		$search = array('@<script[^>]*?>.*?</script>@si',
		               '@<[\/\!]*?[^<>]*?>@si',
		               '@<style[^>]*?>.*?</style>@siU',
		               '@<![\s\S]*?--[ \t\n\r]*>@'
		);
		$text = preg_replace($search, '', $document);
		return $text;
	}
	
	static public function truncateDescription($string, $limit, $break=".", $pad="..."){
		if(strlen($string) <= $limit)
			return $string;
//		if(false !== ($breakpoint = strpos($string, $break, $limit)))
//		{
//			if($breakpoint < strlen($string) - 1)
//			{
				$string = mb_substr($string, 0, $limit / 2, 'utf-8') . $pad;
//			}
//		}
		return $string;
	}
	
	static public function printRating($rating)
	{
		?>
		<div class="vpl-comment-rating">
			<?php
			for($i = 1; $i <= 5; $i++)
			{
				if($i <= $rating)
				{
					?><span class="yellow-star"></span><?php
				}else{
					?><span></span><?php
				}
			}
			?>
		</div>
		<?php
	}
	
	static public function getTotalDuration($start, $end)
	{
		$diff = array();
		
		$one_hour = 60*60;
		$start = strtotime($start);
		$end = strtotime($end);
		if($end - $start >= 0)
		{
			$diff['hours'] = floor(($end - $start)/$one_hour);
			$diff['mins'] = floor((($end - $start)%$one_hour) / 60);
		}
		return $diff;
	}
	
	static public function buildFrontUrl($base_url, $get)
	{
		$url = $base_url;
		if(isset($get['view']))
		{
			$url .= '&view=' . $get['view'];
		}
		if(isset($get['item_per_page']))
		{
			$url .= '&item_per_page=' . $get['item_per_page'];
		}
		if(isset($get['sortby']))
		{
			$url .= '&sortby=' . $get['sortby'];
		}
		if(isset($get['direction']))
		{
			$url .= '&direction=' . $get['direction'];
		}
		if(isset($get['pjPage']))
		{
			$url .= '&pjPage=' . $get['pjPage'];
		}
		if(isset($get['listing_search']))
		{
			$url .= '&listing_search=' . $get['listing_search'];
		}
		if(isset($get['location']))
		{
			$url .= '&location=' . $get['location'];
		}
		if(isset($get['season']))
		{
			$url .= '&season=' . $get['season'];
		}
		if(isset($get['type']))
		{
			$url .= '&type=' . $get['type'];
		}
		if(isset($get['price_from']))
		{
			$url .= '&price_from=' . $get['price_from'];
		}
		if(isset($get['price_to']))
		{
			$url .= '&price_to=' . $get['price_to'];
		}
		if(isset($get['rating_from']))
		{
			$url .= '&rating_from=' . $get['rating_from'];
		}
		if(isset($get['rating_to']))
		{
			$url .= '&rating_to=' . $get['rating_to'];
		}
		
		return $url;
	}
	
	static public function getSortingUrl($url)
	{
		$sorting_url = $url;
		$sorting_url = str_replace('&sortby=price', '', $sorting_url);
		$sorting_url = str_replace('&sortby=stars', '', $sorting_url);
		$sorting_url = str_replace('&direction=asc', '', $sorting_url);
		$sorting_url = str_replace('&direction=desc', '', $sorting_url);
		return $sorting_url;
	}

	static public function friendlyURL($str, $divider='-')
	{
		$str = mb_strtolower($str, mb_detect_encoding($str)); // change everything to lowercase
		$str = trim($str); // trim leading and trailing spaces
		$str = preg_replace('/[_|\s]+/', $divider, $str); // change all spaces and underscores to a hyphen
		$str = preg_replace('/\x{00C5}/u', 'AA', $str);
		$str = preg_replace('/\x{00C6}/u', 'AE', $str);
		$str = preg_replace('/\x{00D8}/u', 'OE', $str);
		$str = preg_replace('/\x{00E5}/u', 'aa', $str);
		$str = preg_replace('/\x{00E6}/u', 'ae', $str);
		$str = preg_replace('/\x{00F8}/u', 'oe', $str);
		$str = preg_replace('/[^a-z\x{0400}-\x{04FF}0-9-]+/u', '', $str); // remove all non-cyrillic, non-numeric characters except the hyphen
		$str = preg_replace('/[-]+/', $divider, $str); // replace multiple instances of the hyphen with a single instance
		$str = preg_replace('/^-+|-+$/', '', $str); // trim leading and trailing hyphens
		return $str;
	}
	
	static public function frontNotice($title, $body, $icon = true, $sanitize = true)
	{
		?>
		<div class="notice-box">
			<?php if ($icon) : ?>
			<span class="notice-icon">&nbsp;</span>
			<?php endif; ?>
			<?php
			if (!empty($title))
			{
				printf('<span class="notice-title">%s</span>', $sanitize ? pjSanitize::html($title) : stripslashes($title));
			}
			if (!empty($body))
			{
				printf('<span class="notice-body">%s</span>', $sanitize ? pjSanitize::html($body) : stripslashes($body));
			}
			?>
		</div>
		<?php
	}
	
	static public function getClientIp()
	{
		if (isset($_SERVER['HTTP_CLIENT_IP']))
		{
			return $_SERVER['HTTP_CLIENT_IP'];
		} else if(isset($_SERVER['HTTP_X_FORWARDED_FOR'])) {
			return $_SERVER['HTTP_X_FORWARDED_FOR'];
		} else if(isset($_SERVER['HTTP_X_FORWARDED'])) {
			return $_SERVER['HTTP_X_FORWARDED'];
		} else if(isset($_SERVER['HTTP_FORWARDED_FOR'])) {
			return $_SERVER['HTTP_FORWARDED_FOR'];
		} else if(isset($_SERVER['HTTP_FORWARDED'])) {
			return $_SERVER['HTTP_FORWARDED'];
		} else if(isset($_SERVER['REMOTE_ADDR'])) {
			return $_SERVER['REMOTE_ADDR'];
		}

		return 'UNKNOWN';
	}

	static public function convertLinks($text)
	{
		$text = preg_replace('/(((f|ht){1}tps?:\/\/)[-a-zA-Z0-9@:;%_\+.~#?&\/\/=]+)/', '<a href="\\1" target="_blank" rel="nofollow">\\1</a>', $text);
		$text = preg_replace('/([[:space:]()[{}])(www.[-a-zA-Z0-9@:;%_\+.~#?&\/\/=]+)/', '\\1<a href="http://\\2" target="_blank" rel="nofollow">\\2</a>', $text);
		$text = preg_replace('/(([0-9a-zA-Z\.\-\_]+)@([0-9a-zA-Z\.\-\_]+)\.([0-9a-zA-Z\.\-\_]+))/', '<a href="mailto:$1" rel="nofollow">$1</a>', $text);

		return $text;
	}
}
?>