<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjAdmin extends pjAppController
{
	public $defaultUser = 'admin_user';
	
	public $requireLogin = true;
	
	protected $imageExt = array('gif', 'png', 'jpg', 'jpeg');
	
	protected $imageType = array('image/gif', 'image/png', 'image/jpeg', 'image/pjpeg', 'image/jpg');
	
	public function __construct($requireLogin=null)
	{
		$this->setLayout('pjActionAdmin');
		
		if (!is_null($requireLogin) && is_bool($requireLogin))
		{
			$this->requireLogin = $requireLogin;
		}
		
		if ($this->requireLogin)
		{
			if (!$this->isLoged() && !in_array(@$_GET['action'], array('pjActionLogin', 'pjActionForgot')))
			{
				pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdmin&action=pjActionLogin");
			}
		}
	}
	
	public function beforeRender()
	{
		
	}
		
	public function pjActionIndex()
	{
		$this->checkLogin();
		
		if ($this->isAdmin() || $this->isEditor() || $this->isOwner())
		{
			$pjListingModel = pjListingModel::factory();
			$pjEnquiryModel = pjEnquiryModel::factory();
			$pjCommentModel = pjCommentModel::factory();
			
			if ($this->isOwner())
			{
				$pjListingModel->where('t1.owner_id', $this->getUserId());
				$pjEnquiryModel->where("t1.listing_id IN(SELECT TL.id FROM `".$pjListingModel->getTable()."` TL WHERE TL.owner_id = ".$this->getUserId().")");
				$pjCommentModel->where("t1.listing_id IN(SELECT TL.id FROM `".$pjListingModel->getTable()."` TL WHERE TL.owner_id = ".$this->getUserId().")");
			}
			
			$number_of_packages = $pjListingModel->findCount()->getData();
			$number_of_enquiries = $pjEnquiryModel->findCount()->getData();
			$number_of_comments = $pjCommentModel->findCount()->getData();
			
			$pjListingModel->reset()
				->select(sprintf("t1.id, t1.views, t1.address_city, t2.content AS title, t3.content AS type,
					(SELECT `small_path` FROM `%s` WHERE `foreign_id` = `t1`.`id` ORDER BY `sort` ASC LIMIT 1) AS `pic`,
					(SELECT COUNT(*) FROM `%s` WHERE `listing_id` = `t1`.`id` LIMIT 1) AS `enquiries`",
					pjGalleryModel::factory()->getTable(), $pjEnquiryModel->getTable()))
				->join('pjMultiLang', "t2.model='pjListing' AND t2.foreign_id=t1.id AND t2.field='title' AND t2.locale='".$this->getLocaleId()."'", 'left outer')
				->join('pjMultiLang', "t3.model='pjType' AND t3.foreign_id=t1.type_id AND t3.field='name' AND t3.locale='".$this->getLocaleId()."'", 'left outer')
				->limit(3)
				->orderBy('t1.views DESC');
		
			$pjEnquiryModel->reset()
				->select("t1.id, t1.name, t1.created, t1.date_from, t1.date_to, t2.owner_id, t3.content AS title")
				->join('pjListing', 't2.id=t1.listing_id', 'inner')
				->join('pjMultiLang', "t3.model='pjListing' AND t3.foreign_id=t1.listing_id AND t3.field='title' AND t3.locale='".$this->getLocaleId()."'", 'left outer')
				->limit(5)
				->orderBy('t1.created DESC');
			
			$pjCommentModel->reset()
				->select("t1.id, t1.name, t1.created, t1.title, t3.content AS package_title")
				->join('pjListing', 't2.id=t1.listing_id', 'inner')
				->join('pjMultiLang', "t3.model='pjListing' AND t3.foreign_id=t1.listing_id AND t3.field='title' AND t3.locale='".$this->getLocaleId()."'", 'left outer')
				->limit(5)
				->orderBy('t1.created DESC');
			
			if ($this->isOwner())
			{
				$pjListingModel->where('t1.owner_id', $this->getUserId());
				$pjEnquiryModel->where("t1.listing_id IN(SELECT TL.id FROM `".$pjListingModel->getTable()."` TL WHERE TL.owner_id = ".$this->getUserId().")");
				$pjCommentModel->where("t1.listing_id IN(SELECT TL.id FROM `".$pjListingModel->getTable()."` TL WHERE TL.owner_id = ".$this->getUserId().")");
			}

			$listing_arr = $pjListingModel->findAll()->getData();
			$enquiry_arr = $pjEnquiryModel->findAll()->getData();
			$comment_arr = $pjCommentModel->findAll()->getData();
			
			$this->set('number_of_packages', $number_of_packages);
			$this->set('number_of_enquiries', $number_of_enquiries);
			$this->set('number_of_comments', $number_of_comments);
			
			$this->set('listing_arr', $listing_arr);
			$this->set('enquiry_arr', $enquiry_arr);
			$this->set('comment_arr', $comment_arr);
			
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionForgot()
	{
		$this->setLayout('pjActionAdminLogin');
		
		if (isset($_POST['forgot_user']))
		{
			if (!isset($_POST['forgot_email']) || !pjValidation::pjActionNotEmpty($_POST['forgot_email']) || !pjValidation::pjActionEmail($_POST['forgot_email']))
			{
				pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdmin&action=pjActionForgot&err=AA10");
			}
			$pjUserModel = pjUserModel::factory();
			$user = $pjUserModel
				->where('t1.email', $_POST['forgot_email'])
				->limit(1)
				->findAll()
				->getData();
				
			if (count($user) != 1)
			{
				pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdmin&action=pjActionForgot&err=AA10");
			} else {
				$user = $user[0];
				
				$Email = new pjEmail();
				$Email
					->setTo($user['email'])
					->setFrom($user['email'])
					->setSubject(__('emailForgotSubject', true));
				
				if ($this->option_arr['o_send_email'] == 'smtp')
				{
					$Email
						->setTransport('smtp')
						->setSmtpHost($this->option_arr['o_smtp_host'])
						->setSmtpPort($this->option_arr['o_smtp_port'])
						->setSmtpUser($this->option_arr['o_smtp_user'])
						->setSmtpPass($this->option_arr['o_smtp_pass'])
					;
				}
				
				$body = str_replace(
					array('{Name}', '{Password}'),
					array($user['name'], $user['password']),
					__('emailForgotBody', true)
				);

				if ($Email->send($body))
				{
					$err = "AA11";
				} else {
					$err = "AA12";
				}
				pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdmin&action=pjActionForgot&err=$err");
			}
		} else {
			$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
			$this->appendJs('pjAdmin.js');
		}
	}
	
	public function pjActionMessages()
	{
		$this->setAjax(true);
		$this->setLayout('pjActionEmpty');
		header("Content-Type: text/javascript; charset=utf-8");
	}
	
	public function pjActionLogin()
	{
		$this->setLayout('pjActionAdminLogin');
		
		if (isset($_POST['login_user']))
		{
			if (!isset($_POST['login_email']) || !isset($_POST['login_password']) ||
				!pjValidation::pjActionNotEmpty($_POST['login_email']) ||
				!pjValidation::pjActionNotEmpty($_POST['login_password']) ||
				!pjValidation::pjActionEmail($_POST['login_email']))
			{
				// Data not validate
				pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdmin&action=pjActionLogin&err=4");
			}
			$pjUserModel = pjUserModel::factory();

			$user = $pjUserModel
				->where('t1.email', $_POST['login_email'])
				//->where(sprintf("t1.password = AES_ENCRYPT('%s', '%s')", $pjUserModel->escapeString($_POST['login_password']), PJ_SALT))
				->limit(1)
				->findAll()
				->getData();
			if (count($user) !== 1)
			{
				# Login failed
				pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdmin&action=pjActionLogin&err=1");
			}
			$user = $user[0];

			$pjLoginModel = pjLoginModel::factory();
			if ($pjLoginModel->isBruteForce($user['id']))
			{
				# Account is locked
				pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdmin&action=pjActionLogin&err=x1");
			}
			
			if ($user['password'] !== $_POST['login_password'])
			{
				$pjLoginModel
					->reset()
					->setAttributes(array(
						'user_id' => $user['id'],
						'ip' => pjUtil::getClientIp(),
						'is_successful' => 0
					))
					->insert();
				
				# Password doesn't match
				pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdmin&action=pjActionLogin&err=x2");
			}
				
			if (!in_array($user['role_id'], array(1,2,3)))
			{
				# Login denied
				pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdmin&action=pjActionLogin&err=2");
			}

			if ($user['status'] != 'T')
			{
				# Login forbidden
				pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdmin&action=pjActionLogin&err=3");
			}

			# Login succeed
			session_regenerate_id(true);
			$_SESSION = array();
				
			$last_login = date("Y-m-d H:i:s");
   			$_SESSION[$this->defaultUser] = array(
   				'id' => $user['id'],
   				'role_id' => $user['role_id'],
   				'login_string' => crypt($user['password'] . $_SERVER['HTTP_USER_AGENT']),
    			'time' => time()
   			);

   			$pjLoginModel
   				->reset()
   				->setAttributes(array(
					'user_id' => $user['id'],
					'ip' => pjUtil::getClientIp(),
					'is_successful' => 1
				))
				->insert();
				
   			# Update
   			$data = array();
   			$data['last_login'] = $last_login;
   			$pjUserModel->reset()->setAttributes(array('id' => $user['id']))->modify($data);

			if ($this->isAdmin()|| $this->isEditor() || $this->isOwner())
    		{
				pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdmin&action=pjActionIndex");
			}
		} else {
			$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
			$this->appendJs('pjAdmin.js');
		}
	}
	
	public function pjActionLogout()
	{
		if ($this->isLoged())
        {
        	$_SESSION[$this->defaultUser] = NULL;
        	unset($_SESSION[$this->defaultUser]);
        }
       	pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdmin&action=pjActionLogin");
	}
	
	public function pjActionProfile()
	{
		$this->checkLogin();
		
		if (!$this->isAdmin())
		{
			if (isset($_POST['profile_update']))
			{
				$pjUserModel = pjUserModel::factory();
				$arr = $pjUserModel->find($this->getUserId())->getData();
				$data = array();
				$data['role_id'] = $arr['role_id'];
				$data['status'] = $arr['status'];
				$post = array_merge($_POST, $data);
				if (!$pjUserModel->validates($post))
				{
					pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdmin&action=pjActionProfile&err=AA14");
				}
				$pjUserModel->set('id', $this->getUserId())->modify($post);
				
				pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdmin&action=pjActionProfile&err=AA13");
			} else {
				$this->set('arr', pjUserModel::factory()->find($this->getUserId())->getData());
				$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('pjAdmin.js');
			}
		} else {
			$this->set('status', 2);
		}
	}
}
?>