<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjAdminLogos extends pjAdmin
{
	public function pjActionDeleteLogoImage()
	{
		$this->setAjax(true);
	
		if ($this->isXHR() && $this->isLoged())
		{
			$pjOptionModel = pjOptionModel::factory();
			$arr = $pjOptionModel->getPairs($this->getForeignId());
			if (!empty($arr))
			{
				$pjOptionModel
					->reset()
					->where('foreign_id', $this->getForeignId())
					->whereIn('`key`', array('o_logo_original', 'o_logo_thumb'))
					->modifyAll(array('value' => ':NULL'));
				
				@clearstatcache();
				if (!empty($arr['o_logo_original']) && is_file(PJ_INSTALL_PATH . $arr['o_logo_original']))
				{
					@unlink(PJ_INSTALL_PATH . $arr['o_logo_original']);
				}
				@clearstatcache();
				if (!empty($arr['o_logo_thumb']) && is_file(PJ_INSTALL_PATH . $arr['o_logo_thumb']))
				{
					@unlink(PJ_INSTALL_PATH . $arr['o_logo_thumb']);
				}
				pjAppController::jsonResponse(array('status' => 'OK', 'code' => 200, 'text' => 'Logo image have been deleted.'));
			}
			pjAppController::jsonResponse(array('status' => 'ERR', 'code' => 100, 'text' => 'Logo not found.'));
		}
		exit;
	}
	
	public function pjActionIndex()
	{
		$this->checkLogin();

		if ($this->isAdmin() || $this->isEditor())
		{
			if (isset($_POST['logo_update']))
			{
				if (isset($_POST['i18n']))
				{
					pjMultiLangModel::factory()->updateMultiLang($_POST['i18n'], $this->getForeignId(), 'pjOption');
				}
				pjUtil::redirect(PJ_INSTALL_URL . "index.php?controller=pjAdminLogos&action=pjActionIndex&err=ALG01");
				
			}
			
			$arr = pjOptionModel::factory()->getPairs($this->getForeignId());
					
			/*if (empty($arr))
			{
				pjUtil::redirect(PJ_INSTALL_URL. "index.php?controller=pjAdminLogos&action=pjActionIndex&err=ALG08");
			}*/
			$arr['i18n'] = pjMultiLangModel::factory()->getMultiLang($this->getForeignId(), 'pjOption');
			$this->set('arr', $arr);
			
			$locale_arr = pjLocaleModel::factory()->select('t1.*, t2.file')
				->join('pjLocaleLanguage', 't2.iso=t1.language_iso', 'left outer')
				->where('t2.file IS NOT NULL')
				->orderBy('t1.sort ASC')->findAll()->getData();
			
			$lp_arr = array();
			foreach ($locale_arr as $item)
			{
				$lp_arr[$item['id']."_"] = $item['file']; //Hack for jquery $.extend, to prevent (re)order of numeric keys in object
			}
			$this->set('lp_arr', $locale_arr);
			$this->set('locale_str', pjAppController::jsonEncode($lp_arr));
			
			$this->appendCss('zino.core.css', PJ_THIRD_PARTY_PATH . 'zinoui/');
			$this->appendCss('zino.upload.css', PJ_THIRD_PARTY_PATH . 'zinoui/');
			$this->appendJs('zino.upload.min.js', PJ_THIRD_PARTY_PATH . 'zinoui/');
			$this->appendCss('jquery.Jcrop.min.css', PJ_THIRD_PARTY_PATH . 'jcrop/css/');
			$this->appendJs('jquery.Jcrop.min.js', PJ_THIRD_PARTY_PATH . 'jcrop/js/');
			$this->appendJs('jquery.validate.js', PJ_THIRD_PARTY_PATH . 'validate/');
			$this->appendJs('jquery.multilang.js', PJ_FRAMEWORK_LIBS_PATH . 'pj/js/');
			$this->appendJs('jquery.tipsy.js', PJ_THIRD_PARTY_PATH . 'tipsy/');
			$this->appendCss('jquery.tipsy.css', PJ_THIRD_PARTY_PATH . 'tipsy/');
			$this->appendJs('pjAdminLogos.js');
			$this->appendJs('index.php?controller=pjAdmin&action=pjActionMessages', PJ_INSTALL_URL, true);
		} else {
			$this->set('status', 2);
		}
	}
	
	private function __crop($src, $dst, $x, $y, $w, $h, $targ_w = 183, $targ_h = 85, $jpeg_quality = 100)
	{
		$info = getimagesize($src);
		switch ($info[2])
		{
			case IMAGETYPE_JPEG:
				$img_r = @imagecreatefromjpeg($src);
				break;
			case IMAGETYPE_GIF:
				$img_r = @imagecreatefromgif($src);
				break;
			case IMAGETYPE_PNG:
				$img_r = @imagecreatefrompng($src);
				break;
		}
		
		$dst_r = imagecreatetruecolor($targ_w, $targ_h);
		switch ($info[2])
		{
			case IMAGETYPE_GIF:
			case IMAGETYPE_PNG:
				imagealphablending($dst_r, false);
				imagesavealpha($dst_r, true);
				$transparent = imagecolorallocatealpha($dst_r, 255, 255, 255, 127);
				imagefilledrectangle($dst_r, 0, 0, $targ_w, $targ_h, $transparent);
				break;
		}
		
		imagecopyresampled($dst_r, $img_r, 0, 0, $x, $y, $targ_w, $targ_h, $w, $h);
		
		switch ($info[2])
		{
			case IMAGETYPE_JPEG:
				return imagejpeg($dst_r, $dst, $jpeg_quality);
				break;
			case IMAGETYPE_GIF:
				return imagegif($dst_r, $dst);
				break;
			case IMAGETYPE_PNG:
				return imagepng($dst_r, $dst);
				break;
		}
		
		return false;
	}
	
	public function pjActionCrop()
	{
		$this->setAjax(true);
	
		if ($this->isXHR() && $this->isLoged())
		{
			$pjOptionModel = pjOptionModel::factory();
			
			if (isset($_POST['x']) && isset($_POST['y']) && isset($_POST['w']) && isset($_POST['h']))
			{
				$arr = $pjOptionModel->getPairs($this->getForeignId());
					
				if (!empty($arr) && !empty($arr['o_logo_original']))
				{
					$dst = PJ_UPLOAD_PATH . 'logo/t_' . md5($this->getForeignId()) . '.' . pjUtil::getFileExtension(basename($arr['o_logo_original']));
					if ($this->__crop($arr['o_logo_original'], $dst, $_POST['x'], $_POST['y'], $_POST['w'], $_POST['h']))
					{
						$pjOptionModel
							->reset()
							->where('foreign_id', $this->getForeignId())
							->where('`key`', 'o_logo_thumb')
							->limit(1)
							->modifyAll(array('value' => $dst));
							
						pjAppController::jsonResponse(array('status' => 'OK', 'code' => 200, 'text' => 'Image have been cropped.'));
					}
				}
			} else {
				
				$this->set('arr', $pjOptionModel->getPairs($this->getForeignId()));
				return;
			}
		}
	}
	
	public function pjActionImage()
	{
		$this->setAjax(true);
	
		if ($this->isXHR() && $this->isLoged())
		{
			$this->set('arr', pjOptionModel::factory()->getPairs($this->getForeignId()));
		}
	}
	
	public function pjActionUpload()
	{
		$this->setAjax(true);
	
		if ($this->isXHR() && $this->isLoged())
		{
			if (isset($_FILES['image']) && !empty($_FILES['image']))
			{
				$image = new pjImage();
				$image
					->setAllowedExt($this->imageExt)
					->setAllowedTypes($this->imageType)
				;
				if ($image->load($_FILES['image']))
				{
					$ext = $image->getExtension();
					$dst = PJ_UPLOAD_PATH . 'logo/o_' . md5($this->getForeignId()) . '.' . $ext;
					
					$image->loadImage();
					$width = $image->getWidth();
					$height = $image->getHeight();
					if ($width > 800)
					{
						$image->resizeToWidth(800);
					}
					if ($height > 800)
					{
						$image->resizeToHeight(800);
					}
					if ($width <= 800 && $height <= 800)
					{
						$image->resize($width, $height);
					}
					
					$info = $image->getImageSize();
					$image->saveImage($dst, $info[2]);
					
					pjOptionModel::factory()
						->where('foreign_id', $this->getForeignId())
						->where('`key`', 'o_logo_original')
						->limit(1)
						->modifyAll(array('value' => $dst));
					
					$dst_thumb = PJ_UPLOAD_PATH . 'logo/t_' . md5($this->getForeignId()) . '.' . $ext;
					if ($this->__crop($dst, $dst_thumb, 0, 0, 183, 85))
					{
						pjOptionModel::factory()
							->where('foreign_id', $this->getForeignId())
							->where('`key`', 'o_logo_thumb')
							->limit(1)
							->modifyAll(array('value' => $dst_thumb));
					}
					
					pjAppController::jsonResponse(array('status' => 'OK', 'code' => 200, 'text' => 'Image have been uploaded.'));
				}
				pjAppController::jsonResponse(array('status' => 'ERR', 'code' => 100, 'text' => $image->getError()));
			}
			pjAppController::jsonResponse(array('status' => 'ERR', 'code' => 101, 'text' => 'Image not uploaded.'));
		}
		exit;
	}
}
?>