<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjAppController extends pjController
{
	public $models = array();

	public $defaultLocale = 'admin_locale_id';
	
	public $defaultFields = 'fields';
	
	public $defaultFieldsIndex = 'fields_index';
	
	protected function loadSetFields($force=FALSE)
	{
		$registry = pjRegistry::getInstance();
		if ($force
				|| !isset($_SESSION[$this->defaultFieldsIndex])
				|| $_SESSION[$this->defaultFieldsIndex] != $this->option_arr['o_fields_index']
				|| !isset($_SESSION[$this->defaultFields])
				|| empty($_SESSION[$this->defaultFields]))
		{
			pjAppController::setFields($this->getLocaleId());
	
			if ($registry->is('fields'))
			{
				$_SESSION[$this->defaultFields] = $registry->get('fields');
			}
			$_SESSION[$this->defaultFieldsIndex] = $this->option_arr['o_fields_index'];
		}
	
		if (isset($_SESSION[$this->defaultFields]) && !empty($_SESSION[$this->defaultFields]))
		{
			$registry->set('fields', $_SESSION[$this->defaultFields]);
		}
			
		return TRUE;
	}
	
	public static function setTimezone($timezone="UTC")
    {
    	if (in_array(version_compare(phpversion(), '5.1.0'), array(0,1)))
		{
			date_default_timezone_set($timezone);
		} else {
			$safe_mode = ini_get('safe_mode');
			if ($safe_mode)
			{
				putenv("TZ=".$timezone);
			}
		}
    }

	public static function setMySQLServerTime($offset="-0:00")
    {
		pjAppModel::factory()->prepare("SET SESSION time_zone = :offset;")->exec(compact('offset'));
    }
    
	public function setTime()
	{
		if (isset($this->option_arr['o_timezone']))
		{
			$offset = $this->option_arr['o_timezone'] / 3600;
			if ($offset > 0)
			{
				$offset = "-".$offset;
			} elseif ($offset < 0) {
				$offset = "+".abs($offset);
			} elseif ($offset === 0) {
				$offset = "+0";
			}
	
			pjAppController::setTimezone('Etc/GMT' . $offset);
			if (strpos($offset, '-') !== false)
			{
				$offset = str_replace('-', '+', $offset);
			} elseif (strpos($offset, '+') !== false) {
				$offset = str_replace('+', '-', $offset);
			}
			pjAppController::setMySQLServerTime($offset . ":00");
		}
	}
    
    public function beforeFilter()
    {
    	$this->appendJs('jquery-1.8.2.min.js', PJ_THIRD_PARTY_PATH . 'jquery/');
    	$this->appendJs('pjAdminCore.js');
    	$this->appendCss('reset.css');
    	
    	$this->appendJs('jquery-ui.custom.min.js', PJ_THIRD_PARTY_PATH . 'jquery_ui/js/');
		$this->appendCss('jquery-ui.min.css', PJ_THIRD_PARTY_PATH . 'jquery_ui/css/smoothness/');
				
		$this->appendCss('pj-all.css', PJ_FRAMEWORK_LIBS_PATH . 'pj/css/');
		$this->appendCss('admin.css');
		
    	if ($_GET['controller'] != 'pjInstaller')
		{
			$this->models['Option'] = pjOptionModel::factory();
			$this->option_arr = $this->models['Option']->getPairs($this->getForeignId());
			$this->set('option_arr', $this->option_arr);
			$this->setTime();
			
			if (!isset($_SESSION[$this->defaultLocale]))
			{
				$locale_arr = pjLocaleModel::factory()->where('is_default', 1)->limit(1)->findAll()->getData();
				if (count($locale_arr) === 1)
				{
					$this->setLocaleId($locale_arr[0]['id']);
				}
			}
			
			$this->loadSetFields();
		}
    }
    
    public function getForeignId()
    {
    	return 1;
    }
    
    public static function setFields($locale)
    {
    	if(isset($_SESSION['lang_show_id']) && (int) $_SESSION['lang_show_id'] == 1)
		{
			$fields = pjMultiLangModel::factory()
				->select('CONCAT(t1.content, CONCAT(":", t2.id, ":")) AS content, t2.key')
				->join('pjField', "t2.id=t1.foreign_id", 'inner')
				->where('t1.locale', $locale)
				->where('t1.model', 'pjField')
				->where('t1.field', 'title')
				->findAll()
				->getDataPair('key', 'content');
		}else{
			$fields = pjMultiLangModel::factory()
				->select('t1.content, t2.key')
				->join('pjField', "t2.id=t1.foreign_id", 'inner')
				->where('t1.locale', $locale)
				->where('t1.model', 'pjField')
				->where('t1.field', 'title')
				->findAll()
				->getDataPair('key', 'content');
		}
		$registry = pjRegistry::getInstance();
		$tmp = array();
		if ($registry->is('fields'))
		{
			$tmp = $registry->get('fields');
		}
		$arrays = array();
		foreach ($fields as $key => $value)
		{
			if (strpos($key, '_ARRAY_') !== false)
			{
				list($prefix, $suffix) = explode("_ARRAY_", $key);
				if (!isset($arrays[$prefix]))
				{
					$arrays[$prefix] = array();
				}
				$arrays[$prefix][$suffix] = $value;
			}
		}
		require PJ_CONFIG_PATH . 'settings.inc.php';
		$fields = array_merge($tmp, $fields, $settings, $arrays);
		$registry->set('fields', $fields);
    }

    public static function jsonDecode($str)
	{
		$Services_JSON = new pjServices_JSON();
		return $Services_JSON->decode($str);
	}
	
	public static function jsonEncode($arr)
	{
		$Services_JSON = new pjServices_JSON();
		return $Services_JSON->encode($arr);
	}
	
	public static function jsonResponse($arr)
	{
		header("Content-Type: application/json; charset=utf-8");
		echo pjAppController::jsonEncode($arr);
		exit;
	}
	
	public function isLoged()
    {
        if (isset($_SESSION[$this->defaultUser],
        	$_SESSION[$this->defaultUser]['id'],
        	$_SESSION[$this->defaultUser]['login_string'],
        	$_SESSION[$this->defaultUser]['time']))
        {
        	$now = time();
        	$expiration = 3600; // 1 hour
        	if ($_SESSION[$this->defaultUser]['time'] + $expiration < $now)
        	{
        		return false;
        	}

			$user = pjUserModel::factory()->find($_SESSION[$this->defaultUser]['id'])->getData();

			# User not found
			if (empty($user))
			{
				return false;
			}

			# Login string doesn't match
			if (crypt($user['password'] . $_SERVER['HTTP_USER_AGENT'], $_SESSION[$this->defaultUser]['login_string']) != $_SESSION[$this->defaultUser]['login_string'])
			{
				return false;
			}

			# Logged In
			$_SESSION[$this->defaultUser]['time'] = $now;
			return true;
	    }
	    return false;
    }
    
	public function isEditor()
	{
		return $this->getRoleId() == 2;
	}

	public function isOwner()
	{
		return $this->getRoleId() == 3;
	}
	
	public function isCountryReady()
	{
		return $this->isAdmin();
	}

	public function getLocaleId()
	{
		return isset($_SESSION[$this->defaultLocale]) && (int) $_SESSION[$this->defaultLocale] > 0 ? (int) $_SESSION[$this->defaultLocale] : false;
	}
	
	public function getDefaultView()
	{
		return isset($_SESSION[$this->defaultView]) && $_SESSION[$this->defaultView] != '' ? $_SESSION[$this->defaultView] : 'list';
	}
	public function getDefaultItemPerPage()
	{
		return isset($_SESSION[$this->defaultItemPerPage]) && (int) $_SESSION[$this->defaultItemPerPage] > 0 ? (int) $_SESSION[$this->defaultItemPerPage] : $this->option_arr['o_items_per_page'];
	}
	
	public function setLocaleId($locale_id)
	{
		$_SESSION[$this->defaultLocale] = (int) $locale_id;
	}
	
	public function pjActionAfterInstall()
	{
		$this->setLayout('pjActionEmpty');
		
		$rows = array(
			array(1, 1, NULL, 'image/jpeg', 'app/web/upload/small/1_0995adb46da7bf225e5f94180f3bd664.jpg', 2546, 90, 68, 'app/web/upload/medium/1_0995adb46da7bf225e5f94180f3bd664.jpg', 8866, 215, 161, 'app/web/upload/large/1_0995adb46da7bf225e5f94180f3bd664.jpg', 167884, 1402, 935, 'app/web/upload/source/1_0995adb46da7bf225e5f94180f3bd664.jpg', 470316, 1402, 935, 'Deal - Limelight Lodge 3.jpg', 'Limelight Lodge', NULL, 1),
			array(2, 1, NULL, 'image/jpeg', 'app/web/upload/small/1_7048e6c3d1d94101e5fa8418ec342720.jpg', 3185, 90, 68, 'app/web/upload/medium/1_7048e6c3d1d94101e5fa8418ec342720.jpg', 13239, 215, 161, 'app/web/upload/large/1_7048e6c3d1d94101e5fa8418ec342720.jpg', 316793, 1402, 935, 'app/web/upload/source/1_7048e6c3d1d94101e5fa8418ec342720.jpg', 829741, 1402, 935, 'Deal - Limelight Lodge 1.jpg', 'Limelight Lodge', NULL, 2),
			array(3, 1, NULL, 'image/jpeg', 'app/web/upload/small/1_53f0e7710463505afb6ae6dcaeb7c393.jpg', 2737, 90, 68, 'app/web/upload/medium/1_53f0e7710463505afb6ae6dcaeb7c393.jpg', 8375, 215, 161, 'app/web/upload/large/1_53f0e7710463505afb6ae6dcaeb7c393.jpg', 160331, 1402, 935, 'app/web/upload/source/1_53f0e7710463505afb6ae6dcaeb7c393.jpg', 668032, 1402, 935, 'Deal - Limelight Lodge 2.jpg', 'Limelight Lodge', NULL, 3),
			array(4, 1, NULL, 'image/jpeg', 'app/web/upload/small/1_e9774b31857eaf20ed59045c12f84896.jpg', 2660, 90, 68, 'app/web/upload/medium/1_e9774b31857eaf20ed59045c12f84896.jpg', 10682, 215, 161, 'app/web/upload/large/1_e9774b31857eaf20ed59045c12f84896.jpg', 212355, 1402, 935, 'app/web/upload/source/1_e9774b31857eaf20ed59045c12f84896.jpg', 732877, 1402, 935, 'Deal - Limelight Lodge 4.jpg', 'Limelight Lodge', NULL, 4),
			array(5, 1, NULL, 'image/jpeg', 'app/web/upload/small/1_96b82243b6149df5cd5227e0fc0e568a.jpg', 2845, 90, 68, 'app/web/upload/medium/1_96b82243b6149df5cd5227e0fc0e568a.jpg', 9027, 215, 161, 'app/web/upload/large/1_96b82243b6149df5cd5227e0fc0e568a.jpg', 172035, 1402, 935, 'app/web/upload/source/1_96b82243b6149df5cd5227e0fc0e568a.jpg', 564505, 1402, 935, 'Deal - Limelight Lodge 5.jpg', 'Limelight Lodge', NULL, 5),
			array(6, 2, NULL, 'image/jpeg', 'app/web/upload/small/2_7ca6f42d23329a0217f9bbf9bb9ac475.jpg', 8798, 90, 68, 'app/web/upload/medium/2_7ca6f42d23329a0217f9bbf9bb9ac475.jpg', 36493, 215, 161, 'app/web/upload/large/2_7ca6f42d23329a0217f9bbf9bb9ac475.jpg', 339521, 1000, 560, 'app/web/upload/source/2_7ca6f42d23329a0217f9bbf9bb9ac475.jpg', 135790, 1000, 560, '008.jpg', NULL, NULL, 1),
			array(7, 2, NULL, 'image/jpeg', 'app/web/upload/small/2_68ce1b26f3e5e2ea49361fbda53dd1c4.jpg', 8871, 90, 68, 'app/web/upload/medium/2_68ce1b26f3e5e2ea49361fbda53dd1c4.jpg', 37570, 215, 161, 'app/web/upload/large/2_68ce1b26f3e5e2ea49361fbda53dd1c4.jpg', 284133, 740, 465, 'app/web/upload/source/2_68ce1b26f3e5e2ea49361fbda53dd1c4.jpg', 141973, 740, 465, '002.jpg', NULL, NULL, 2),
			array(8, 2, NULL, 'image/jpeg', 'app/web/upload/small/2_76a9e244c44fd3f1896b07b5206eaef5.jpg', 9327, 90, 68, 'app/web/upload/medium/2_76a9e244c44fd3f1896b07b5206eaef5.jpg', 36328, 215, 161, 'app/web/upload/large/2_76a9e244c44fd3f1896b07b5206eaef5.jpg', 346661, 1024, 768, 'app/web/upload/source/2_76a9e244c44fd3f1896b07b5206eaef5.jpg', 147436, 1024, 768, '005.jpg', NULL, NULL, 3),
			array(9, 2, NULL, 'image/jpeg', 'app/web/upload/small/2_1f6800b0dd96228a1aad8a7c67592960.jpg', 8642, 90, 68, 'app/web/upload/medium/2_1f6800b0dd96228a1aad8a7c67592960.jpg', 37191, 215, 161, 'app/web/upload/large/2_1f6800b0dd96228a1aad8a7c67592960.jpg', 560492, 1400, 795, 'app/web/upload/source/2_1f6800b0dd96228a1aad8a7c67592960.jpg', 179869, 1400, 795, '007.jpg', NULL, NULL, 4),
			array(10, 2, NULL, 'image/jpeg', 'app/web/upload/small/2_26f10dca1cb7df17b8dbcfbd3ac3ffa4.jpg', 7813, 90, 68, 'app/web/upload/medium/2_26f10dca1cb7df17b8dbcfbd3ac3ffa4.jpg', 30839, 215, 161, 'app/web/upload/large/2_26f10dca1cb7df17b8dbcfbd3ac3ffa4.jpg', 198020, 800, 544, 'app/web/upload/source/2_26f10dca1cb7df17b8dbcfbd3ac3ffa4.jpg', 94092, 800, 544, '020.jpg', NULL, NULL, 5),
			array(11, 3, NULL, 'image/jpeg', 'app/web/upload/small/3_23322162c4a75d14e724cf17f40e3fea.jpg', 8061, 90, 68, 'app/web/upload/medium/3_23322162c4a75d14e724cf17f40e3fea.jpg', 30818, 215, 161, 'app/web/upload/large/3_23322162c4a75d14e724cf17f40e3fea.jpg', 442522, 1280, 662, 'app/web/upload/source/3_23322162c4a75d14e724cf17f40e3fea.jpg', 457513, 1280, 662, '017.jpg', NULL, NULL, 2),
			array(13, 3, NULL, 'image/jpeg', 'app/web/upload/small/3_fe2b4effa96d8faf581c9fcf22cec8b0.jpg', 7159, 90, 68, 'app/web/upload/medium/3_fe2b4effa96d8faf581c9fcf22cec8b0.jpg', 28832, 215, 161, 'app/web/upload/large/3_fe2b4effa96d8faf581c9fcf22cec8b0.jpg', 163889, 705, 355, 'app/web/upload/source/3_fe2b4effa96d8faf581c9fcf22cec8b0.jpg', 174668, 705, 355, '10-Paris.jpg', NULL, NULL, 1),
			array(15, 3, NULL, 'image/jpeg', 'app/web/upload/small/3_ebc31f971aa01fbee608461db403ebed.jpg', 8642, 90, 68, 'app/web/upload/medium/3_ebc31f971aa01fbee608461db403ebed.jpg', 37191, 215, 161, 'app/web/upload/large/3_ebc31f971aa01fbee608461db403ebed.jpg', 560492, 1400, 795, 'app/web/upload/source/3_ebc31f971aa01fbee608461db403ebed.jpg', 179869, 1400, 795, '007.jpg', NULL, NULL, 5),
			array(16, 3, NULL, 'image/jpeg', 'app/web/upload/small/3_d2422414e95a352a7b91f4d7364416bb.jpg', 8886, 90, 68, 'app/web/upload/medium/3_d2422414e95a352a7b91f4d7364416bb.jpg', 37175, 215, 161, 'app/web/upload/large/3_d2422414e95a352a7b91f4d7364416bb.jpg', 248556, 970, 486, 'app/web/upload/source/3_d2422414e95a352a7b91f4d7364416bb.jpg', 93620, 970, 486, '010.jpg', NULL, NULL, 4),
			array(17, 3, NULL, 'image/jpeg', 'app/web/upload/small/3_443dca937e40f52ae4910765b6185e70.jpg', 8815, 90, 68, 'app/web/upload/medium/3_443dca937e40f52ae4910765b6185e70.jpg', 37428, 215, 161, 'app/web/upload/large/3_443dca937e40f52ae4910765b6185e70.jpg', 480958, 1024, 576, 'app/web/upload/source/3_443dca937e40f52ae4910765b6185e70.jpg', 262656, 1024, 576, '012.jpg', NULL, NULL, 6),
			array(18, 4, NULL, 'image/jpeg', 'app/web/upload/small/4_dd602a2728fc7d941e5db62b219774ec.jpg', 2319, 90, 68, 'app/web/upload/medium/4_dd602a2728fc7d941e5db62b219774ec.jpg', 7459, 215, 161, 'app/web/upload/large/4_dd602a2728fc7d941e5db62b219774ec.jpg', 59294, 800, 500, 'app/web/upload/source/4_dd602a2728fc7d941e5db62b219774ec.jpg', 204634, 800, 500, '042.jpg', 'Beach Resort', NULL, 1),
			array(19, 4, NULL, 'image/jpeg', 'app/web/upload/small/4_f851f19293df1e49409b359e40122f7e.jpg', 8625, 90, 68, 'app/web/upload/medium/4_f851f19293df1e49409b359e40122f7e.jpg', 36942, 215, 161, 'app/web/upload/large/4_f851f19293df1e49409b359e40122f7e.jpg', 1160466, 1997, 1329, 'app/web/upload/source/4_f851f19293df1e49409b359e40122f7e.jpg', 386602, 1997, 1329, '041.jpg', NULL, NULL, 2),
			array(20, 4, NULL, 'image/jpeg', 'app/web/upload/small/4_98d146cae0c802d40007be9042c41e2c.jpg', 7697, 90, 68, 'app/web/upload/medium/4_98d146cae0c802d40007be9042c41e2c.jpg', 28587, 215, 161, 'app/web/upload/large/4_98d146cae0c802d40007be9042c41e2c.jpg', 244821, 1024, 686, 'app/web/upload/source/4_98d146cae0c802d40007be9042c41e2c.jpg', 109654, 1024, 686, '018.jpg', NULL, NULL, 3),
			array(21, 4, NULL, 'image/jpeg', 'app/web/upload/small/4_27b41a976a63917ccb18a13fa0152131.jpg', 9081, 90, 68, 'app/web/upload/medium/4_27b41a976a63917ccb18a13fa0152131.jpg', 38237, 215, 161, 'app/web/upload/large/4_27b41a976a63917ccb18a13fa0152131.jpg', 546335, 1366, 768, 'app/web/upload/source/4_27b41a976a63917ccb18a13fa0152131.jpg', 262348, 1366, 768, '039.jpg', NULL, NULL, 4),
			array(22, 5, NULL, 'image/jpeg', 'app/web/upload/small/5_5783ab060e319a4e6ffacdab16453cc7.jpg', 9209, 90, 68, 'app/web/upload/medium/5_5783ab060e319a4e6ffacdab16453cc7.jpg', 38616, 215, 161, 'app/web/upload/large/5_5783ab060e319a4e6ffacdab16453cc7.jpg', 487286, 1309, 873, 'app/web/upload/source/5_5783ab060e319a4e6ffacdab16453cc7.jpg', 188991, 1309, 873, '033.JPG', NULL, NULL, 1),
			array(23, 5, NULL, 'image/jpeg', 'app/web/upload/small/5_19034e42993429b4c3e4f0ecc0580392.jpg', 10269, 90, 68, 'app/web/upload/medium/5_19034e42993429b4c3e4f0ecc0580392.jpg', 46811, 215, 161, 'app/web/upload/large/5_19034e42993429b4c3e4f0ecc0580392.jpg', 3739811, 2560, 1440, 'app/web/upload/source/5_19034e42993429b4c3e4f0ecc0580392.jpg', 3716709, 2560, 1440, '040.jpg', NULL, NULL, 2),
			array(24, 5, NULL, 'image/jpeg', 'app/web/upload/small/5_296571183378ae22f444e324dac1bbf1.jpg', 10597, 90, 68, 'app/web/upload/medium/5_296571183378ae22f444e324dac1bbf1.jpg', 48587, 215, 161, 'app/web/upload/large/5_296571183378ae22f444e324dac1bbf1.jpg', 847353, 1152, 768, 'app/web/upload/source/5_296571183378ae22f444e324dac1bbf1.jpg', 379359, 1152, 768, '037.jpg', NULL, NULL, 3),
			array(25, 5, NULL, 'image/jpeg', 'app/web/upload/small/5_dbaeb89f3e75ae7ae83330310cd129a3.jpg', 8394, 90, 68, 'app/web/upload/medium/5_dbaeb89f3e75ae7ae83330310cd129a3.jpg', 34601, 215, 161, 'app/web/upload/large/5_dbaeb89f3e75ae7ae83330310cd129a3.jpg', 962091, 1920, 1080, 'app/web/upload/source/5_dbaeb89f3e75ae7ae83330310cd129a3.jpg', 447106, 1920, 1080, '030.jpg', NULL, NULL, 4),
			array(26, 5, NULL, 'image/jpeg', 'app/web/upload/small/5_da8db38dfbd812a8ecd6a4acee52549f.jpg', 9382, 90, 68, 'app/web/upload/medium/5_da8db38dfbd812a8ecd6a4acee52549f.jpg', 38009, 215, 161, 'app/web/upload/large/5_da8db38dfbd812a8ecd6a4acee52549f.jpg', 494010, 900, 675, 'app/web/upload/source/5_da8db38dfbd812a8ecd6a4acee52549f.jpg', 578170, 900, 675, '025.jpg', NULL, NULL, 5),
			array(27, 6, NULL, 'image/jpeg', 'app/web/upload/small/6_8503ebe0201a1386d79d30bf7973a83d.jpg', 2912, 90, 68, 'app/web/upload/medium/6_8503ebe0201a1386d79d30bf7973a83d.jpg', 10769, 215, 161, 'app/web/upload/large/6_8503ebe0201a1386d79d30bf7973a83d.jpg', 259027, 1280, 960, 'app/web/upload/source/6_8503ebe0201a1386d79d30bf7973a83d.jpg', 687109, 1280, 960, 'Malam-Jabba-Ski-Resort.jpg', 'Ski Resort', NULL, 1),
			array(28, 6, NULL, 'image/jpeg', 'app/web/upload/small/6_c339168df7f37a306563a4f350525e8e.jpg', 7715, 90, 68, 'app/web/upload/medium/6_c339168df7f37a306563a4f350525e8e.jpg', 30086, 215, 161, 'app/web/upload/large/6_c339168df7f37a306563a4f350525e8e.jpg', 1302816, 1698, 1131, 'app/web/upload/source/6_c339168df7f37a306563a4f350525e8e.jpg', 2000245, 1698, 1131, 'Skiier w- view 2.jpg', NULL, NULL, 2),
			array(29, 6, NULL, 'image/jpeg', 'app/web/upload/small/6_e7fd5b6619c34d31f8730c17844e12a6.jpg', 9327, 90, 68, 'app/web/upload/medium/6_e7fd5b6619c34d31f8730c17844e12a6.jpg', 36328, 215, 161, 'app/web/upload/large/6_e7fd5b6619c34d31f8730c17844e12a6.jpg', 346661, 1024, 768, 'app/web/upload/source/6_e7fd5b6619c34d31f8730c17844e12a6.jpg', 147436, 1024, 768, '005.jpg', NULL, NULL, 3),
			array(30, 6, NULL, 'image/jpeg', 'app/web/upload/small/6_ea1c7d0e47e691b78133f43048e4d427.jpg', 8606, 90, 68, 'app/web/upload/medium/6_ea1c7d0e47e691b78133f43048e4d427.jpg', 39140, 215, 161, 'app/web/upload/large/6_ea1c7d0e47e691b78133f43048e4d427.jpg', 396319, 1000, 560, 'app/web/upload/source/6_ea1c7d0e47e691b78133f43048e4d427.jpg', 159174, 1000, 560, '019.jpg', NULL, NULL, 4),
			array(31, 7, NULL, 'image/jpeg', 'app/web/upload/small/7_2257dd0dadbfa606f53ce46d60d96499.jpg', 8260, 90, 68, 'app/web/upload/medium/7_2257dd0dadbfa606f53ce46d60d96499.jpg', 34682, 215, 161, 'app/web/upload/large/7_2257dd0dadbfa606f53ce46d60d96499.jpg', 909409, 1626, 1086, 'app/web/upload/source/7_2257dd0dadbfa606f53ce46d60d96499.jpg', 596276, 1626, 1086, '031.jpg', NULL, NULL, 1),
			array(32, 7, NULL, 'image/jpeg', 'app/web/upload/small/7_47618e2b0fdef83010ed0eb119af41a2.jpg', 8081, 90, 68, 'app/web/upload/medium/7_47618e2b0fdef83010ed0eb119af41a2.jpg', 32391, 215, 161, 'app/web/upload/large/7_47618e2b0fdef83010ed0eb119af41a2.jpg', 409330, 1024, 768, 'app/web/upload/source/7_47618e2b0fdef83010ed0eb119af41a2.jpg', 169294, 1024, 768, '032.jpg', NULL, NULL, 4),
			array(33, 7, NULL, 'image/jpeg', 'app/web/upload/small/7_e4cd61c69e2a8044f408f46d1748fda2.jpg', 10597, 90, 68, 'app/web/upload/medium/7_e4cd61c69e2a8044f408f46d1748fda2.jpg', 48587, 215, 161, 'app/web/upload/large/7_e4cd61c69e2a8044f408f46d1748fda2.jpg', 847353, 1152, 768, 'app/web/upload/source/7_e4cd61c69e2a8044f408f46d1748fda2.jpg', 379359, 1152, 768, '037.jpg', NULL, NULL, 2),
			array(34, 7, NULL, 'image/jpeg', 'app/web/upload/small/7_56567b1ddaa85f2e4e028b98144087dd.jpg', 9297, 90, 68, 'app/web/upload/medium/7_56567b1ddaa85f2e4e028b98144087dd.jpg', 39498, 215, 161, 'app/web/upload/large/7_56567b1ddaa85f2e4e028b98144087dd.jpg', 1340828, 1920, 1440, 'app/web/upload/source/7_56567b1ddaa85f2e4e028b98144087dd.jpg', 482386, 1920, 1440, '029.jpg', NULL, NULL, 3)
		);
		
		pjGalleryModel::factory()
			->setBatchFields(array('id', 'foreign_id', 'hash', 'mime_type', 'small_path', 'small_size', 'small_width', 'small_height', 'medium_path', 'medium_size', 'medium_width', 'medium_height', 'large_path', 'large_size', 'large_width', 'large_height', 'source_path', 'source_size', 'source_width', 'source_height', 'name', 'alt', 'watermark', 'sort'))
			->setBatchRows($rows)
			->insertBatch();
			
		pjLocaleModel::factory()->set('id', 2)->modify(array('language_iso' => 'it'));
			
		return array('status' => 'OK', 'code' => 200, 'text' => '');
	}
	
	public function pjActionCheckInstall()
	{
		$this->setLayout('pjActionEmpty');
		
		$result = array('status' => 'OK', 'code' => 200, 'text' => 'Operation succeeded', 'info' => array());
		$folders = array(
			'app/web/backup',
			'app/web/upload',
			'app/web/upload/banners',
			'app/web/upload/destinations',
			'app/web/upload/large',
			'app/web/upload/logo',
			'app/web/upload/medium',
			'app/web/upload/mini',
			'app/web/upload/pages',
			'app/web/upload/slides',
			'app/web/upload/small',
			'app/web/upload/source',
			'app/web/upload/tinymce-source',
			'app/web/upload/tinymce-thumbs'
		);
		foreach ($folders as $dir)
		{
			if (!is_writable($dir))
			{
				$result['status'] = 'ERR';
				$result['code'] = 101;
				$result['text'] = 'Permission requirement';
				$result['info'][] = sprintf('Folder \'<span class="bold">%1$s</span>\' is not writable. You need to set write permissions (chmod 777) to directory located at \'<span class="bold">%1$s</span>\'', $dir);
			}
		}
		
		return $result;
	}
	
	public function getFromEmail()
	{
		$email = $this->option_arr['o_email_address'];
		if($email == '')
		{
			$arr = pjUserModel::factory()->find(1)->getData();
			$email = $arr['email'];
		}
		return $email;
	}
	
}
?>