<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjDestinationModel extends pjAppModel
{
	protected $primaryKey = 'id';

	protected $table = 'destinations';

	protected $schema = array(
		array('name' => 'id', 'type' => 'int', 'default' => ':NULL'),
		array('name' => 'seo_url', 'type' => 'varchar', 'default' => ':NULL'),
		array('name' => 'country_id', 'type' => 'int', 'default' => ':NULL'),
		array('name' => 'image_original', 'type' => 'varchar', 'default' => ':NULL'),
		array('name' => 'image_thumb', 'type' => 'varchar', 'default' => ':NULL'),
		array('name' => 'on_home', 'type' => 'tinyint', 'default' => 0),
		array('name' => 'status', 'type' => 'enum', 'default' => 'T')
	);

	protected $validate = array(
		'rules' => array(
			'seo_url' => array(
				'pjActionRequired' => true,
				'pjActionCustom' => '/^[\w\-]+$/'
			),
			'country_id' => array(
				'pjActionNumeric' => true,
				'pjActionRequired' => true
			),
			'on_home' => array(
				'pjActionNumeric' => true,
				'pjActionRequired' => true
			),
			'status' => 'pjActionRequired'
		)
	);
	
	protected $i18n = array('name', 'title', 'full_desc', 'meta_title', 'meta_desc');

	public static function factory($attr=array())
	{
		return new pjDestinationModel($attr);
	}
}
?>