<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjEnquiryModel extends pjAppModel
{
	protected $primaryKey = 'id';

	protected $table = 'enquiries';

	protected $schema = array(
		array('name' => 'id', 'type' => 'int', 'default' => ':NULL'),
		array('name' => 'listing_id', 'type' => 'int', 'default' => ':NULL'),
		array('name' => 'date_from', 'type' => 'date', 'default' => ':NULL'),
		array('name' => 'date_to', 'type' => 'date', 'default' => ':NULL'),
		array('name' => 'name', 'type' => 'varchar', 'default' => ':NULL'),
		array('name' => 'email', 'type' => 'varchar', 'default' => ':NULL'),
		array('name' => 'phone', 'type' => 'varchar', 'default' => ':NULL'),
		array('name' => 'notes', 'type' => 'text', 'default' => ':NULL'),
		array('name' => 'created', 'type' => 'datetime', 'default' => ':NOW()'),
		array('name' => 'status', 'type' => 'enum', 'default' => 'New')
	);

	protected $validate = array(
		'rules' => array(
			'listing_id' => array(
				'pjActionNumeric' => true,
				'pjActionRequired' => true
			),
			'date_from' => array(
				'rule' => array('pjActionDate', 'ymd', '/\d{4}-\d{2}-\d{2}/'),
				'pjActionRequired' => true,
				'pjActionNotEmpty' => true
			),
			'date_to' => array(
				'rule' => array('pjActionDate', 'ymd', '/\d{4}-\d{2}-\d{2}/'),
				'pjActionRequired' => true,
				'pjActionNotEmpty' => true
			),
			'name' => array(
				'pjActionRequired' => true,
				'pjActionNotEmpty' => true
			),
			'status' => 'pjActionRequired'
		)
	);

	public static function factory($attr=array())
	{
		return new pjEnquiryModel($attr);
	}
}
?>