<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjLoginModel extends pjAppModel
{
	protected $primaryKey = 'id';

	protected $table = 'logins';

	protected $schema = array(
		array('name' => 'id', 'type' => 'int', 'default' => ':NULL'),
		array('name' => 'user_id', 'type' => 'int', 'default' => ':NULL'),
		array('name' => 'created', 'type' => 'datetime', 'default' => ':NOW()'),
		array('name' => 'ip', 'type' => 'varchar', 'default' => ':NULL'),
		array('name' => 'is_successful', 'type' => 'tinyint', 'default' => 0)
	);
	
	public function isBruteForce($user_id)
	{
		$count = $this
			->reset()
			->where('t1.user_id', $user_id)
			->where("t1.created > SUBTIME(NOW(), '02:00:00')")
			->where('t1.is_successful', 0)
			->findCount()
			->getData();

		if ($count >= 5)
		{
			return true;
		}

		return false;
	}
	
	public static function factory($attr=array())
	{
		return new pjLoginModel($attr);
	}
}
?>