<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjPageModel extends pjAppModel
{
	protected $primaryKey = 'id';

	protected $table = 'pages';

	protected $schema = array(
		array('name' => 'id', 'type' => 'int', 'default' => ':NULL'),
		array('name' => 'seo_url', 'type' => 'varchar', 'default' => ':NULL'),
		array('name' => 'image_original', 'type' => 'varchar', 'default' => ':NULL'),
		array('name' => 'image_thumb', 'type' => 'varchar', 'default' => ':NULL'),
		array('name' => 'status', 'type' => 'enum', 'default' => 'T')
	);

	protected $validate = array(
		'rules' => array(
			'seo_url' => array(
				'pjActionRequired' => true,
				'pjActionCustom' => '/^[\w\-]+$/'
			),
			'status' => 'pjActionRequired'
		)
	);

	protected $i18n = array('name', 'title', 'full_desc', 'meta_title', 'meta_desc');
	
	public static function factory($attr=array())
	{
		return new pjPageModel($attr);
	}
}
?>