<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjSubscriptionModel extends pjAppModel
{
	protected $primaryKey = 'id';

	protected $table = 'subscriptions';

	protected $schema = array(
		array('name' => 'id', 'type' => 'int', 'default' => ':NULL'),
		array('name' => 'email', 'type' => 'varchar', 'default' => ':NULL'),
		array('name' => 'is_subscribed', 'type' => 'enum', 'default' => ':NULL'),
		array('name' => 'date_subscr', 'type' => 'date', 'default' => ':NULL'),
		array('name' => 'date_unsubscr', 'type' => 'date', 'default' => ':NULL')
	);

	protected $validate = array(
		'rules' => array(
			'email' => array(
				'pjActionRequired' => true,
				'pjActionEmail' => true
			),
			'is_subscribed' => 'pjActionRequired'
		)
	);

	public static function factory($attr=array())
	{
		return new pjSubscriptionModel($attr);
	}
}
?>