<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {
	$week_start = isset($tpl['option_arr']['o_week_start']) && in_array((int) $tpl['option_arr']['o_week_start'], range(0,6)) ? (int) $tpl['option_arr']['o_week_start'] : 0;
	$jqDateFormat = pjUtil::jqDateFormat($tpl['option_arr']['o_date_format']);
	?>
	<div class="ui-tabs ui-widget ui-widget-content ui-corner-all b10">
		<ul class="ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all">
			<li class="ui-state-default ui-corner-top"><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminListings&amp;action=pjActionIndex"><?php __('menuPackages'); ?></a></li>
			<li class="ui-state-default ui-corner-top ui-tabs-active ui-state-active"><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminListings&amp;action=pjActionCreate"><?php __('menuAddPackage'); ?></a></li>
		</ul>
	</div>
	<?php
	if($controller->isOwner())
	{
		pjUtil::printNotice(__('infoAddPackageTitle', true), __('infoAddPackageBody', true));
	}else{
		pjUtil::printNotice(__('lblListingAddTitle', true), __('lblListingAddDesc', true));
	}
	?>
	<form action="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminListings&amp;action=pjActionCreate" method="post" id="frmCreateListing" class="form pj-form">
		<input type="hidden" name="listing_create" value="1" />
		<p>
			<label class="title"><?php __('lblListingRefid'); ?></label>
			<span class="inline_block">
				<input type="text" name="listing_refid" id="listing_refid" value="<?php echo pjUtil::uuid(); ?>" class="pj-form-field required" />
				<a href="#" class="pj-form-langbar-tip listing-tip" title="<?php echo pjSanitize::html(__('lblListingRefIDTip', true)); ?>"></a>
			</span>
		</p>
		<?php
		if(!empty($tpl['type_arr']))
		{
			?>
			<p>
				<label class="title"><?php __('lblType'); ?></label>
				<span class="inline_block">
					<select name="type_id" id="type_id" class="pj-form-field w200 required">
						<option value="">-- <?php __('lblChoose'); ?> --</option>
						<?php
						foreach ($tpl['type_arr'] as $v)
						{
							?><option value="<?php echo $v['id']; ?>"><?php echo stripslashes($v['name']); ?></option><?php
						}
						?>
					</select>
				</span>
			</p>
			<?php
		}else{
			$add_type_message = __('lblAddTypeMessage', true);
			$add_type_message = str_replace('{ADD_TYPE_TAG}', '<a href="'.$_SERVER['PHP_SELF'].'?controller=pjAdminTypes&amp;action=pjActionCreate">', $add_type_message);
			$add_type_message = str_replace('{ADD_TYPE_ENDTAG}', '</a>', $add_type_message);
			?>
			<p>
				<label class="title"><?php __('lblType'); ?></label>
				<span class="inline_block">
					<label class="content"><?php echo $add_type_message;?></label>
				</span>
			</p>
			<?php
		}
		if (!$controller->isOwner())
		{
			?>
			<p>
				<label class="title"><?php __('lblListingStatus'); ?></label>
				<span class="inline_block">
					<select name="status" id="status" class="pj-form-field w200 required">
						<option value="">-- <?php __('lblChoose'); ?> --</option>
						<?php
						foreach (__('publish_status', true) as $k => $v)
						{
							?><option value="<?php echo $k; ?>"><?php echo stripslashes($v); ?></option><?php
						}
						?>
					</select>
					<a href="#" class="pj-form-langbar-tip listing-tip" title="<?php __('lblListingStatusTip'); ?>"></a>
				</span>
			</p>
			<p id="expiration_container" style="display:none;">
				<label class="title"><?php __('lblListingExpire'); ?></label>
				<span class="pj-form-field-custom pj-form-field-custom-after">
					<input type="text" name="expire" id="expire" class="pj-form-field pointer w80 datepick" readonly="readonly" rel="<?php echo $week_start; ?>" rev="<?php echo $jqDateFormat; ?>" value="<?php echo date($tpl['option_arr']['o_date_format']); ?>" />
					<span class="pj-form-field-after"><abbr class="pj-form-field-icon-date"></abbr></span>
					<a href="#" class="pj-form-langbar-tip listing-tip" title="<?php __('lblListingExpireTip'); ?>"></a>
				</span>
			</p>
			<p>
				<label class="title"><?php __('lblListingFeatured'); ?></label>
				<span class="left">
					<?php
					foreach (__('_yesno', true) as $k => $v)
					{
						?>
						<label class="r5"><input type="radio" name="is_featured" value="<?php echo $k; ?>"<?php echo 'F' == $k ? ' checked="checked"' : NULL; ?> /> <?php echo $v; ?></label>
						<?php
					}
					?>
					<a href="#" class="pj-form-langbar-tip listing-tip" title="<?php echo pjSanitize::html(__('lblListingFeaturedTip', true)); ?>"></a>
				</span>
			</p>
			<p>
				<label class="title"><?php __('lblListingBestDeal'); ?></label>
				<span class="left">
					<?php
					foreach (__('_bool_deal', true) as $k => $v)
					{
						?>
						<label class="r5"><input type="radio" name="is_best_deal" value="<?php echo $k; ?>"<?php echo 0 === (int) $k ? ' checked="checked"' : NULL; ?> /> <?php echo $v; ?></label>
						<?php
					}
					?>
					<a href="#" class="pj-form-langbar-tip listing-tip" title="<?php echo pjSanitize::html(__('lblListingBestDealTip', true)); ?>"></a>
				</span>
			</p>
			<div class="boxBd" style="display: none">
				<p>
					<label class="title"><?php __('listing_bd_price'); ?></label>
					<span class="pj-form-field-custom pj-form-field-custom-before">
						<span class="pj-form-field-before"><abbr class="pj-form-field-icon-text"><?php echo pjUtil::formatCurrencySign(NULL, $tpl['option_arr']['o_currency'], ""); ?></abbr></span>
						<input type="text" name="bd_price" class="pj-form-field w70 align_right" />
					</span>
				</p>
				<p>
					<label class="title"><?php __('listing_bd_discount'); ?></label>
					<span class="pj-form-field-custom pj-form-field-custom-after">
						<input type="text" name="bd_discount" class="pj-form-field w70" />
						<span class="pj-form-field-after"><abbr class="pj-form-field-icon-text">%</abbr></span>
					</span>
				</p>
			</div>
			<?php
		}
		?>
		
		<p>
			<label class="title">&nbsp;</label>
			<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button" />
		</p>
	</form>
	<script type="text/javascript">
	var myLabel = myLabel || {};
	myLabel.field_required = "<?php __('vk_field_required'); ?>";
	
	</script>
	<?php
}
?>