<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {
	$titles = __('error_titles', true);
	$bodies = __('error_bodies', true);
	if (isset($_GET['err']))
	{
		pjUtil::printNotice(@$titles[$_GET['err']], @$bodies[$_GET['err']]);
	}
	?>
	<div class="ui-tabs ui-widget ui-widget-content ui-corner-all b10">
		<ul class="ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all">
			<li class="ui-state-default ui-corner-top ui-tabs-active ui-state-active"><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminListings&amp;action=pjActionIndex"><?php __('menuPackages'); ?></a></li>
			<li class="ui-state-default ui-corner-top"><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminListings&amp;action=pjActionCreate"><?php __('menuAddPackage'); ?></a></li>
		</ul>
	</div>
	
	<?php pjUtil::printNotice(@$titles['AL11'], @$bodies['AL11']); ?>
	
	<div class="b10">
		<form action="" method="get" class="float_left pj-form frm-filter">
			<input type="text" name="q" class="pj-form-field pj-form-field-search w150" placeholder="<?php __('btnSearch'); ?>" />
			<button type="button" class="pj-button pj-button-detailed"><span class="pj-button-detailed-arrow"></span></button>
		</form>
		<?php
		$filter = __('filter', true);
		?>
		<div class="float_right t5">
			<a href="#" class="pj-button btn-all"><?php __('lblAll'); ?></a>
			<a href="#" class="pj-button btn-filter btn-status" data-column="status" data-value="T"><?php echo $filter['active']; ?></a>
			<a href="#" class="pj-button btn-filter btn-status" data-column="status" data-value="F"><?php echo $filter['inactive']; ?></a>
			<a href="#" class="pj-button btn-filter btn-featured" data-column="is_featured" data-value="T"><?php echo $filter['featured']; ?></a>
			<a href="#" class="pj-button btn-filter btn-best_deal" data-column="is_best_deal" data-value="1,2"><?php echo $filter['best_deal']; ?></a>
		</div>
		<br class="clear_both" />
	</div>
	
	<div class="pj-form-filter-advanced" style="display: none">
		<span class="pj-menu-list-arrow"></span>
		<form action="" method="get" class="form pj-form pj-form-search frm-filter-advanced">
			<div class="float_left w350">
				<p>
					<label class="title"><?php __('lblListingRefid'); ?></label>
					<input type="text" name="listing_refid" id="listing_refid" class="pj-form-field w150" />
				</p>
				
				<p>
					<label class="title"><?php __('lblKeyword'); ?></label>
					<input type="text" name="keyword" id="keyword" class="pj-form-field w150" />
				</p>
				<p>
					<label class="title"><?php __('lblType'); ?></label>
					<select name="type_id" id="type_id" class="pj-form-field w150">
						<option value="">-- <?php __('lblChoose'); ?> --</option>
						<?php
						foreach ($tpl['type_arr'] as $v)
						{
							?><option value="<?php echo $v['id']; ?>"<?php echo isset($_GET['type_id']) && (int) $_GET['type_id'] == $v['id'] ? ' selected="selected"' : NULL; ?>><?php echo stripslashes($v['name']); ?></option><?php
						}
						?>
					</select>
				</p>
			</div>
			<div class="float_right w350">
				<?php
				if ($controller->isAdmin())
				{
					?>
					<p style="overflow: visible;">
						<label class="title"><?php __('lblListingOwner'); ?></label>
						<select name="owner_id" id="owner_id" class="pj-form-field w150">
							<option value="">-- <?php __('lblChoose'); ?> --</option>
							<?php
							foreach ($tpl['user_arr'] as $v)
							{
								?><option value="<?php echo $v['id']; ?>"<?php echo isset($_GET['user_id']) && (int) $_GET['user_id'] == $v['id'] ? ' selected="selected"' : NULL; ?>><?php echo stripslashes($v['name']); ?></option><?php
							}
							?>
						</select>
					</p>
					<?php
				}
				?>
				<p>
					<label class="title"><?php __('lblListingState'); ?></label>
					<input type="text" name="address_state" id="address_state" class="pj-form-field w150" />
				</p>
				<p>
					<label class="title"><?php __('lblListingCity'); ?></label>
					<input type="text" name="address_city" id="address_city" class="pj-form-field w150" />
				</p>
			</div>
			<br class="clear_both" />
			<p>
				<label class="title"><?php __('lblListingCountry'); ?></label>
				<select name="country_id" id="country_id" class="pj-form-field w350">
					<option value="">-- <?php __('lblChoose'); ?> --</option>
					<?php
					foreach ($tpl['country_arr'] as $v)
					{
						?><option value="<?php echo $v['id']; ?>"<?php echo isset($_GET['country_id']) && (int) $_GET['country_id'] == $v['id'] ? ' selected="selected"' : NULL; ?>><?php echo stripslashes($v['name']); ?></option><?php
					}
					?>
				</select>
			</p>
			<p>
				<label class="title">&nbsp;</label>
				<input type="submit" value="<?php __('btnSearch', false, true); ?>" class="pj-button" />
				<input type="reset" value="<?php __('btnCancel', false, true); ?>" class="pj-button" />
			</p>
		</form>
	</div>
	
	<div id="grid"></div>
	<script type="text/javascript">
	var pjGrid = pjGrid || {};
	pjGrid.jqDateFormat = "<?php echo pjUtil::jqDateFormat($tpl['option_arr']['o_date_format']); ?>";
	pjGrid.jsDateFormat = "<?php echo pjUtil::jsDateFormat($tpl['option_arr']['o_date_format']); ?>";
	pjGrid.queryString = "";
	pjGrid.isOwner = <?php echo $controller->isOwner() ? 'true' : 'false'; ?>;
	pjGrid.isEditor = <?php echo $controller->isEditor() ? 'true' : 'false'; ?>;
	<?php
	if (isset($_GET['user_id']) && (int) $_GET['user_id'] > 0)
	{
		?>pjGrid.queryString += "&user_id=<?php echo (int) $_GET['user_id']; ?>";<?php
	}
	?>
	var myLabel = myLabel || {};
	myLabel.view_enquiries = "<?php __('vk_view_enquiries', false, true); ?>";
	myLabel.image = "<?php __('vk_image', false, true); ?>";
	myLabel.title = "<?php __('lblPackageTitleGrid', false, true); ?>";
	myLabel.type = "<?php __('lblType', false, true); ?>";
	myLabel.publish = "<?php __('vk_publish', false, true); ?>";
	myLabel.active = "<?php __('vk_active', false, true); ?>";
	myLabel.inactive = "<?php __('vk_inactive', false, true); ?>";
	myLabel.delete_selected = "<?php __('vk_delete_selected', false, true); ?>";
	myLabel.delete_confirmation = "<?php __('vk_delete_confirmation', false, true); ?>";
	myLabel.published = "<?php __('vk_published', false, true); ?>";
	myLabel.not_published = "<?php __('vk_not_published', false, true); ?>";
	myLabel.extend_exp_date = "<?php __('vk_extend_exp_date', false, true); ?>";
	myLabel.expire = "<?php __('vk_expire', false, true); ?>";
	myLabel.exp_date = "<?php __('vk_exp_date', false, true); ?>";
	myLabel.owner = "<?php __('vk_owner', false, true); ?>";
	myLabel.exp_date_plus_30 = "<?php __('vk_exp_date_plus_30', false, true); ?>";
	myLabel.view_enquiries = "<?php __('vk_view_enquiries', false, true); ?>";
	myLabel.not_active = "<?php __('lblNotActive', false, true); ?>";
	myLabel.unlimited = "<?php __('lblUnlimited', false, true);?>";
	myLabel.lblEdit = "<?php __('lblEdit', false, true);?>";
	myLabel.lblDelete = "<?php __('lblDelete', false, true);?>";
	</script>
	<?php
}
?>