<?php
$URL = PJ_INSTALL_URL . $controller->getLanguage() . '/';
?>
<!DOCTYPE html>
<html lang="<?php echo $controller->getLanguage(); ?>">
	<head>
		<title><?php echo @$tpl['meta_arr']['title']; ?></title>
		<meta charset="utf-8">
		<meta http-equiv="X-UA-Compatible" content="IE=edge">
		<meta name="viewport" content="width=device-width, initial-scale=1">
		<meta name="description" content="<?php echo pjSanitize::html(@$tpl['meta_arr']['desc']); ?>" />
		<meta name="robots" content="index,follow" />
		<base href="<?php echo PJ_INSTALL_URL; ?>" />
		<?php
		foreach ($controller->getCss() as $css)
		{
			echo '<link type="text/css" rel="stylesheet" href="'.(isset($css['remote']) && $css['remote'] ? NULL : PJ_INSTALL_URL).$css['path'].htmlspecialchars($css['file']).'" />';
		}
		foreach ($controller->getJs() as $js)
		{
			echo '<script src="'.(isset($js['remote']) && $js['remote'] ? NULL : PJ_INSTALL_URL).$js['path'].htmlspecialchars($js['file']).'"></script>';
		}
		?>
		<!--[if gte IE 9]>
		<script src="<?php echo PJ_INSTALL_URL . PJ_THIRD_PARTY_PATH; ?>/html5shiv/html5shiv.js"></script>
		<script src="<?php echo PJ_INSTALL_URL . PJ_THIRD_PARTY_PATH; ?>/respond/respond.min.js"></script>
	    <![endif]-->
	</head>
	<body>
		<div id="wrapper">
			<div id="header-outer">
				<div id="header">
					<div class="container row">
					
						<?php
						if (isset($tpl['option_arr']['o_logo_thumb']) && !empty($tpl['option_arr']['o_logo_thumb']) && is_file(PJ_INSTALL_PATH . $tpl['option_arr']['o_logo_thumb']))
						{
							?><a class="logo" href="<?php echo $URL; ?>" title="<?php echo pjSanitize::html(@$tpl['option_arr']['title']); ?>"><img src="<?php echo PJ_INSTALL_URL . $tpl['option_arr']['o_logo_thumb']; ?>" alt="<?php echo pjSanitize::html(@$tpl['option_arr']['alt']); ?>" /></a><?php
						}
						?>
						
						<div class="locale-account">
							<?php
							if (isset($tpl['locale_arr']) && is_array($tpl['locale_arr']) && !empty($tpl['locale_arr']))
							{
								?>
								<div class="locale-nav dropdown-nav">
									<a href="<?php echo $URL; ?>" class="dropdown-toggle dropdown-closed"><img src="<?php echo PJ_INSTALL_URL; ?>core/framework/libs/pj/img/flags/<?php echo @$tpl['locale_arr'][$controller->getLocaleId()]['file']; ?>" alt="<?php echo pjSanitize::html(@$tpl['locale_arr'][$controller->getLocaleId()]['title']); ?>" /> <?php echo pjSanitize::html(@$tpl['locale_arr'][$controller->getLocaleId()]['title']); ?></a>
									<ul>
									<?php
									$iso = array();
									$uri = array();
									$locales = array();
									foreach ($tpl['locale_arr'] as $locale)
									{
										$iso[] = $locale['language_iso'];
										$uri[] = PJ_INSTALL_URL . $locale['language_iso'] . '/';
									}
									$scheme = isset($_SERVER['REQUEST_SCHEME']) ? $_SERVER['REQUEST_SCHEME'] : 'http';
									$server = isset($_SERVER['HTTP_HOST']) && !empty($_SERVER['HTTP_HOST']) ? $_SERVER['HTTP_HOST'] : $_SERVER['SERVER_NAME'];
									$build_url = sprintf("%s://%s%s", $scheme, $server, $_SERVER["REQUEST_URI"]);
									if (preg_match('/\/(' . join("|", $iso) . ')\//', $build_url))
									{
										foreach ($tpl['locale_arr'] as $locale)
										{
											$locales[$locale['id']] = str_replace($uri, PJ_INSTALL_URL.$locale['language_iso'].'/', $build_url);
										}
									} else {
										foreach ($tpl['locale_arr'] as $locale)
										{
											$locales[$locale['id']] = PJ_INSTALL_URL . $locale['language_iso'] . '/';
										}
									}
						
									foreach ($tpl['locale_arr'] as $locale)
									{
										$href = $locales[$locale['id']];
										if (in_array($_GET['action'], array('pjActionHolidayPackages', 'pjActionBestDeals')))
										{
											$href = rtrim($href, "/") . "/#!/search/";
										}
										?><li><a href="<?php echo $href; ?>"<?php echo $locale['id'] != $controller->getLocaleId() ? NULL : ' class="active"'; ?>><img src="<?php echo PJ_INSTALL_URL; ?>core/framework/libs/pj/img/flags/<?php echo $locale['file']; ?>" alt="<?php echo pjSanitize::html($locale['title']); ?>" /> <?php echo pjSanitize::html($locale['title']); ?></a></li><?php
									}
									?>
									</ul>
								</div><?php
							}
							if ($tpl['option_arr']['o_allow_add_package'] == 'Yes')
							{
								?>
								<ul class="secondary-nav">
									<li><a href="<?php echo $URL; ?>login/"><?php __('front_menu_login'); ?></a></li>
									<li><a href="<?php echo $URL; ?>register/"><?php __('front_menu_register'); ?></a></li>
								</ul>
								<?php
							}
							?>
						</div>
						
						<?php
						$menu = array();
						$menu[] = array('text' => __('front_menu_home', true), 'href' => '', 'is_active' => ($_GET['controller'] == 'pjWebPages' && $_GET['action'] == 'pjActionIndex'));
						$menu[] = array('text' => __('front_menu_packages', true), 'href' => 'holiday-packages/#!/search/', 'is_active' => ($_GET['controller'] == 'pjWebPages' && $_GET['action'] == 'pjActionHolidayPackages'));
						$menu[] = array('text' => __('front_menu_deals', true), 'href' => 'best-deals/#!/search/', 'is_active' => ($_GET['controller'] == 'pjWebPages' && $_GET['action'] == 'pjActionBestDeals'));
						if (isset($tpl['page_arr'], $tpl['page_arr'][2]) && $tpl['page_arr'][2]['status'] == 'T')
						{
							$menu[] = array('text' => __('front_menu_destinations', true), 'href' => $tpl['page_arr'][2]['seo_url'] . '/', 'is_active' => (($_GET['controller'] == 'pjWebPages' && $_GET['action'] == 'pjActionDestinations') || ($_GET['action'] == 'pjActionPage' && (int) @$tpl['arr']['id'] === 2)));
						}
						if (isset($tpl['page_arr'], $tpl['page_arr'][1]) && $tpl['page_arr'][1]['status'] == 'T')
						{
							$menu[] = array('text' => __('front_menu_about', true), 'href' => $tpl['page_arr'][1]['seo_url'] . '/', 'is_active' => ($_GET['action'] == 'pjActionPage' && (int) @$tpl['arr']['id'] === 1));
						}
						$menu[] = array('text' => __('front_menu_contact', true), 'href' => 'contact/', 'is_active' => ($_GET['controller'] == 'pjWebPages' && $_GET['action'] == 'pjActionContact'));
						?>
						
						<ul class="primary-nav">
						<?php
						foreach ($menu as $item)
						{
							?><li><a href="<?php echo $URL . $item['href']; ?>"<?php echo !$item['is_active'] ? NULL : ' class="active"'; ?>><?php echo $item['text']; ?></a></li><?php
						}
						?>
						</ul>
						
						<div class="mobile-nav dropdown-nav">
							<a href="#" class="dropdown-toggle dropdown-closed"><?php
							$mobile_active = false;
							foreach ($menu as $item)
							{
								if ($item['is_active'])
								{
									echo $item['text'];
									$mobile_active = true;
									break;
								}
							}
							if (!$mobile_active)
							{
								__('front_menu_select');
							}
							?></a>
							<ul>
							<?php
							foreach ($menu as $item)
							{
								?><li><a href="<?php echo $URL . $item['href']; ?>"<?php echo !$item['is_active'] ? NULL : ' class="active"'; ?>><?php echo $item['text']; ?></a></li><?php
							}
							?>
							</ul>
						</div>
					</div>
				</div>
			</div>
			<div id="main-outer" class="<?php
			if ($_GET['controller'] == 'pjWebPages' && $_GET['action'] == 'pjActionIndex')
			{
				echo 'main-home';
			} elseif ($_GET['controller'] == 'pjWebPages' && in_array($_GET['action'], array(
				'pjActionContact',
				'pjActionDestinations', 'pjActionLogin', 'pjActionForgot',
				'pjActionRegister'))) {
				echo 'main-page';
			} else {
				echo 'main-inside';
			}
			?>">
				<div id="main">
					<div class="container container-main row">
					<?php require $content_tpl; ?>
					</div>
				</div>
			</div>
			<div id="footer-outer">
				<div id="footer">
					<div class="container row">
						<ul class="footer-nav">
						<?php
						foreach ($menu as $item)
						{
							?><li><a href="<?php echo $URL . $item['href']; ?>"<?php echo !$item['is_active'] ? NULL : ' class="active"'; ?>><?php echo $item['text']; ?></a></li><?php
						}
						?>
						</ul>
						
						<?php
						if (isset($tpl['page_arr'], $tpl['page_arr'][3]) && $tpl['page_arr'][3]['status'] == 'T')
						{
							?>
							<ul class="footer-nav">
								<li><a href="<?php echo $URL . $tpl['page_arr'][3]['seo_url']; ?>/"<?php echo $_GET['action'] != 'pjActionPage' || (int) @$tpl['arr']['id'] !== 3 ? NULL : ' class="active"'; ?>><?php __('front_menu_terms'); ?></a></li>
							</ul>
							<?php
						}
						?>
						
						<div class="footer-copy">&copy; <?php echo date("Y"); ?> <?php __('front_label_copyright'); ?></div>
					</div>
				</div>
			</div>
		</div>
		<script type="text/javascript">
		var tConfig = {
			url: "<?php echo $URL; ?>",
			folder: "<?php echo PJ_INSTALL_FOLDER; ?>"
			<?php
			if (isset($tpl['price_arr'], $tpl['price_arr']['min_price'], $tpl['price_arr']['max_price']))
			{
				printf(",min_price: %s", (int) $tpl['price_arr']['min_price']);
				printf(",max_price: %s", (int) $tpl['price_arr']['max_price']);
			}
			?>
		};
		</script>
		<noscript>
        	<div id="noscript-warning"><?php __('front_noscript'); ?></div>
		</noscript>
	</body>
</html>