<?php
if (isset($tpl['deals_arr']) && !empty($tpl['deals_arr']))
{
	$filter_seasons = __('filter_seasons', true);
	foreach ($tpl['deals_arr'] as $item)
	{
		$detail_url = sprintf("%s%s-%u/", $URL, pjUtil::friendlyURL($item['listing_title']), $item['id']);
		$title = pjSanitize::html($item['listing_title']);
		$alt = NULL;
		$img = $item['image'];
		if (strpos($item['image'], "|") !== FALSE)
		{
			list($img, $alt) = explode("|", $item['image']);
		}
		if (!empty($img) && is_file(PJ_INSTALL_PATH . $img))
		{
			$image = $img;
		} else {
			$image = PJ_IMG_PATH . 'site/noimg-small.jpg';
		}
		?>
		<div class="spot-package">
			<a href="<?php echo $detail_url; ?>" class="spot-package-pic">
				<img src="<?php echo PJ_INSTALL_URL . $image; ?>" alt="<?php echo !empty($alt) ? pjSanitize::html($alt) : $title; ?>" />
				<span class="spot-package-hidden">
					<?php
					if($tpl['option_arr']['o_comment_and_rating'] == 'Show')
					{ 
						?>
						<span class="spot-package-stars"><span class="spot-package-rating spot-package-stars-<?php echo (int) $item['listing_rating']; ?>"></span></span>
						<?php
					}
					$avail_arr = array();
					if (!empty($item['listing_season']))
					{
						$season_arr = explode("|", $item['listing_season']);
						foreach($season_arr as $key => $val)
						{
							$avail_arr[] = $filter_seasons[$val];
						}
						if (!empty($avail_arr))
						{
							?><span class="spot-package-season"><?php echo join(", ", $avail_arr); ?></span><?php
						}
					}
					if (!empty($item['listing_nights']))
					{
						$nights = $item['listing_nights'];
						if ($item['listing_nights'] > 1)
						{
							$nights .= ' ' . __('front_label_nights', true);
						} else {
							$nights .= ' ' . __('front_label_night', true);
						}
						?><span class="spot-package-nights"><?php echo pjMultibyte::strtolower($nights); ?></span><?php
					}
					if ($item['flight_included'] == 'T')
					{
						?><span class="spot-package-flight"><?php __('front_label_flight_included'); ?></span><?php
					}
					?>
				</span>
				<span class="spot-package-badge">- <?php echo (float) $item['bd_discount']; ?> %</span>
			</a>
			<div class="spot-package-title"><a href="<?php echo $detail_url; ?>" title="<?php echo $title; ?>"><?php echo $title; ?></a></div>
			<?php
			$location = NULL;
			if (!empty($item['address_city']))
			{
				$location = pjSanitize::html($item['address_city']);
			}
			if (!empty($item['country_title']))
			{
				if (!empty($location))
				{
					$location .= ', ' . pjSanitize::html($item['country_title']);
				} else {
					$location .= pjSanitize::html($item['country_title']);
				}
			}
			if (!empty($location))
			{
				?><div class="spot-package-loc"><?php echo $location; ?></div><?php
			}
			if (!empty($item['type']))
			{
				?><div class="spot-package-category"><?php echo pjSanitize::html($item['type']); ?></div><?php
			}
			if (!empty($item['price_from']))
			{
				?><div class="spot-package-price"><span class="spot-package-strike"><?php echo pjUtil::formatCurrencySign(ceil($item['price_from']), $tpl['option_arr']['o_currency']); ?></span> <?php echo pjUtil::formatCurrencySign(ceil($item['bd_price']), $tpl['option_arr']['o_currency']); ?></div><?php
			}
			?>
		</div>
		<?php
	}
}
?>