<?php
$available_views = array('list', 'grid', 'map');
$default_view = isset($_GET['is_best_deal']) ? $tpl['option_arr']['o_view_deals'] : $tpl['option_arr']['o_view_packages'];
$price_from = isset($_GET['price_from']) ? (int) $_GET['price_from'] :  $tpl['price_arr']['min_price'];
$price_to = isset($_GET['price_to']) ? (int) $_GET['price_to'] : $tpl['price_arr']['max_price'];
$price_to = isset($_GET['price_to']) ? (int) $_GET['price_to'] : 100000;
$rating_from = isset($_GET['rating_from']) ? (int) $_GET['rating_from'] : 1;
$rating_to = isset($_GET['rating_to']) ? (int) $_GET['rating_to'] : 5;
$view = (isset($_GET['view']) && in_array($_GET['view'], $available_views)) ? $_GET['view'] : (in_array($default_view, $available_views) ? $default_view : 'list');
$row_count = isset($_GET['row_count']) && (int) $_GET['row_count'] > 0 ? (int) $_GET['row_count'] : $controller->getDefaultItemPerPage();
$filter_seasons = __('filter_seasons', true);

if (isset($_GET['is_best_deal']))
{
	?>
	<form action="<?php echo $URL; ?>best-deal/" method="get" id="filter-<?php echo $filter_suffix; ?>" class="form form-filter" style="display: none">
		<input type="hidden" name="view" value="<?php echo $view; ?>" />
		<input type="hidden" name="row_count" value="<?php echo $row_count; ?>" />
		<input type="hidden" name="rand" value="<?php echo rand(1000, 999999); ?>" />
	</form>
	<?php
} else {
	?>
	<div class="filter row">
		<div class="filter-control">
		
			<a href="#" class="filter-control-item" data-content="filter-content-season"><?php __('front_label_filter_by_season'); ?></a><?php
			?><a href="#" class="filter-control-item" data-content="filter-content-type"><?php __('front_label_filter_by_type'); ?></a><?php
			?><a href="#" class="filter-control-item" data-content="filter-content-price"><?php __('front_label_filter_by_price'); ?></a><?php
			?><a href="#" class="filter-control-item" data-content="filter-content-rating"><?php __('front_label_filter_by_rating'); ?></a>
			
			<form action="<?php echo $URL; ?>holiday-packages/" method="get" id="filter-<?php echo $filter_suffix; ?>" class="form form-filter" style="display: inline-block">
				<?php
				if (isset($_GET['season']) && is_array($_GET['season']))
				{
					foreach ($_GET['season'] as $season)
					{
						?><input type="hidden" name="season[]" value="<?php echo $season; ?>" /><?php
					}
				}
				if (isset($_GET['type']) && is_array($_GET['type']))
				{
					foreach ($_GET['type'] as $type)
					{
						?><input type="hidden" name="type[]" value="<?php echo $type; ?>" /><?php
					}
				}
				?>
				<input type="hidden" name="price_from" value="<?php echo $price_from; ?>" />
				<input type="hidden" name="price_to" value="<?php echo $price_to; ?>" />
				<input type="hidden" name="rating_from" value="<?php echo $rating_from; ?>" />
				<input type="hidden" name="rating_to" value="<?php echo $rating_to; ?>" />
				<input type="text" name="q" class="form-field" autocomplete="off" value="<?php echo pjSanitize::html(@$_GET['q']); ?>" placeholder="<?php __('front_label_type_country', false, true); ?>" />
				<input type="hidden" name="view" value="<?php echo $view; ?>" />
				<input type="hidden" name="row_count" value="<?php echo $row_count; ?>" />
				<input type="hidden" name="rand" value="<?php echo rand(1000, 999999); ?>" />
				<input type="submit" value="<?php __('front_button_find_holiday', false, true); ?>" class="button" />
			</form>
		
		</div>
	
		<div class="filter-content filter-content-season">
			<?php
			foreach ($filter_seasons as $k => $v)
			{
				if (isset($_GET['season']) && is_array($_GET['season']) && in_array($k, $_GET['season']))
				{
					?><a href="#" class="filter-content-item filter-content-item-disabled" data-section="season" data-value="<?php echo $k; ?>"><?php echo $v; ?> (<?php echo @$tpl['season_arr']['cnt_'.$k];?>)</a><?php
				} else {
					?><a href="#" class="filter-content-item" data-section="season" data-value="<?php echo $k; ?>"><?php echo $v; ?> (<?php echo @$tpl['season_arr']['cnt_'.$k];?>)</a><?php
				}
			}
			?>
		</div>
		<div class="filter-content filter-content-type">
			<?php
			if (isset($tpl['type_arr']))
			{
				foreach ($tpl['type_arr'] as $type)
				{
					if (isset($_GET['type']) && is_array($_GET['type']) && in_array($type['id'], $_GET['type']))
					{
						?><a href="#" class="filter-content-item filter-content-item-disabled" data-section="type" data-value="<?php echo $type['id']; ?>"><?php echo $type['name']; ?> (<?php echo $type['number_of_packages'];?>)</a><?php
					} else {
						?><a href="#" class="filter-content-item" data-section="type" data-value="<?php echo $type['id']; ?>"><?php echo $type['name']; ?> (<?php echo $type['number_of_packages'];?>)</a><?php
					}
				}
			}
			?>
		</div>
		<div class="filter-content filter-content-price">
			<?php
			$filter_price_from = pjUtil::formatCurrencySign(number_format($price_from, 2), $tpl['option_arr']['o_currency']);
			$filter_price_to = pjUtil::formatCurrencySign(number_format($price_to, 2), $tpl['option_arr']['o_currency']);
			?>
			<label class="vpl-price-legend"><?php __('front_label_price_filter'); ?>: <span id="vpl_filter_price" data-currency="<?php echo $tpl['option_arr']['o_currency']; ?>"><?php echo $filter_price_from . ' - ' . $filter_price_to ;?></span></label>
			<div class="vpl-price-slider-container">
				<div id="filter-slider-price" data-price_from="<?php echo $price_from; ?>" data-price_to="<?php echo $price_to; ?>"></div>
			</div>
			<div class="vpl-price-labels">
				<label class="vpl-max-price"><?php echo pjUtil::formatCurrencySign($tpl['price_arr']['max_price'], $tpl['option_arr']['o_currency']); ?></label>
			</div>
		</div>
		<div class="filter-content filter-content-rating">
			<div id="filter-slider-rating" data-rating_from="<?php echo $rating_from; ?>" data-rating_to="<?php echo $rating_to; ?>"></div>
			<div class="vpl-rating-labels">
				<?php
				foreach(range(1, 5) as $v)
				{
					?><label class="vpl-rating-star<?php echo $v == 5 ? ' vpl-rating-star-last' : null;?><?php echo $v == 1 ? ' vpl-rating-star-first' : null;?>" lang="<?php echo $v;?>">|<br/><?php echo $v . ' ' . ($v != 1 ? __('front_label_stars', true) : __('front_label_star', true)); ?></label><?php
				}
				?>
			</div>
		</div>
		
		<div class="filter-selected">
		<?php
		$clear = false;
		if (isset($_GET['season']) && is_array($_GET['season']))
		{
			foreach ($_GET['season'] as $key)
			{
				$clear = true;
				?><a href="#" class="filter-content-item filter-content-item-active" data-section="season" data-value="<?php echo $key; ?>"><?php echo pjSanitize::html($filter_seasons[$key]); ?> (<?php echo @$tpl['season_arr']['cnt_'.$key];?>)</a><?php
			}
		}
		if (isset($_GET['type']) && is_array($_GET['type']))
		{
			foreach ($_GET['type'] as $key)
			{
				$clear = true;
				?><a href="#" class="filter-content-item filter-content-item-active" data-section="type" data-value="<?php echo $key; ?>"><?php echo pjSanitize::html(@$tpl['type_arr'][$key]['name']); ?> (<?php echo (int) @$tpl['type_arr'][$key]['number_of_packages']; ?>)</a><?php
			}
		}
		if (isset($_GET['price_from']) && isset($_GET['price_to']) && !($_GET['price_from'] == 0 && $_GET['price_to'] == 1500))
		{
			$clear = true;
			?><a href="#" class="filter-content-item filter-content-item-active" data-section="price"><?php echo pjUtil::formatCurrencySign(number_format($_GET['price_from'], 2, ".", ","), $tpl['option_arr']['o_currency']); ?> - <?php echo pjUtil::formatCurrencySign(number_format($_GET['price_to'], 2, ".", ","), $tpl['option_arr']['o_currency']); ?></a><?php
		}
		if (isset($_GET['rating_from']) && isset($_GET['rating_to']) && !($_GET['rating_from'] == 1 && $_GET['rating_to'] == 5))
		{
			$clear = true;
			?><a href="#" class="filter-content-item filter-content-item-active" data-section="rating"><?php echo (int) $_GET['rating_from']; ?> stars - <?php echo (int) $_GET['rating_to']; ?> stars</a><?php
		}
		if (isset($_GET['q']) && !empty($_GET['q']))
		{
			$clear = true;
			?><a href="#" class="filter-content-item filter-content-item-active" data-section="q"><?php echo pjSanitize::html($_GET['q']); ?></a><?php
		}
		?>
			<a href="#" class="filter-clear"<?php echo $clear ? NULL : ' style="display:none"'; ?>><?php __('front_link_clear_filter'); ?></a>
		</div>
		
	</div>
	<?php
}
?>