<?php
$week_start = isset($tpl['option_arr']['o_week_start']) && in_array((int) $tpl['option_arr']['o_week_start'], range(0,6)) ? (int) $tpl['option_arr']['o_week_start'] : 0;
$jqDateFormat = pjUtil::jqDateFormat($tpl['option_arr']['o_date_format']);
$sys = __('front_sys', true);
?>
<div class="listing-enquiry row">
	<div class="listing-enquiry-form" id="enquiry">
		<h2 class="listing-h2"><?php __('front_label_enquiry'); ?></h2>
		<form action="" method="post" id="form-enquiry" class="form">
			<input type="hidden" name="booking_form" value="1" />
			<input type="hidden" name="listing_id" value="<?php echo $_GET['id']; ?>" />
			<input type="hidden" name="folder" value="<?php echo PJ_INSTALL_FOLDER; ?>" />
			<?php
			if (isset($tpl['enquiry_message']))
			{
				$front_err = __('front_error', true);
				if ($tpl['enquiry_message'] == 'FR02')
				{
					?><div class="vpl-message"><?php echo $front_err[$tpl['enquiry_message']];?></div><?php
				} else {
					if ($tpl['enquiry_message'] == 'FR03')
					{
						?><div class="vpl-error"><?php echo $front_err[$tpl['enquiry_message']];?></div><?php
					} else {
						$register_status = __('register_status', true);
						?><div class="vpl-error"><?php echo $register_status[$tpl['enquiry_message']];?></div><?php
					}
				}
			}
			?>
			<p class="form-row">
				<label class="form-field-label" for="name"><?php __('front_label_name'); ?></label>
				<span class="form-field-wrap">
					<input type="text" name="name" id="name" class="form-field" value="" data-msg-required="<?php echo pjSanitize::html($sys['bf_name']); ?>" />
				</span>
			</p>
			<p class="form-row">
				<label class="form-field-label" for="email"><?php __('front_label_email'); ?></label>
				<span class="form-field-wrap">
					<input type="text" name="email" id="email" class="form-field" value="" data-msg-required="<?php echo pjSanitize::html($sys['bf_email']); ?>" data-msg-email="<?php echo pjSanitize::html($sys['bf_email_inv']); ?>" />
				</span>
			</p>
			<p class="form-row">
				<label class="form-field-label" for="phone"><?php __('front_label_phone'); ?></label>
				<span class="form-field-wrap">
					<input type="text" name="phone" id="phone" class="form-field" value="" data-msg-required="<?php echo pjSanitize::html($sys['bf_phone']); ?>" />
				</span>
			</p>
			<p class="form-row">
				<label class="form-field-label" for="date_from"><?php __('front_label_from'); ?></label>
				<span class="form-field-wrap">
					<input type="text" name="date_from" id="date_from" class="form-field form-field-date" readonly="readonly" value="" data-first="<?php echo $week_start; ?>" data-format="<?php echo $jqDateFormat; ?>" data-msg-required="<?php echo pjSanitize::html($sys['bf_date_from']); ?>" />
				</span>
			</p>
			<p class="form-row">
				<label class="form-field-label" for="date_to"><?php __('front_label_to'); ?></label>
				<span class="form-field-wrap">
					<input type="text" name="date_to" id="date_to" class="form-field form-field-date" readonly="readonly" value="" data-first="<?php echo $week_start; ?>" data-format="<?php echo $jqDateFormat; ?>" data-msg-required="<?php echo pjSanitize::html($sys['bf_date_to']); ?>" />
				</span>
			</p>
			<p class="form-row">
				<label class="form-field-label" for="notes"><?php __('front_label_notes'); ?></label>
				<span class="form-field-wrap">
					<textarea name="notes" id="notes" class="form-field" data-msg-required="<?php echo pjSanitize::html($sys['bf_notes']); ?>"></textarea>
				</span>
			</p>
			<p class="form-row">
				<label class="form-field-label" for="captcha"><?php __('front_label_captcha'); ?></label>
				<span class="form-field-wrap">
					<input type="text" name="captcha" id="captcha" class="form-field form-field-captcha" maxlength="6" autocomplete="off" data-msg-required="<?php echo pjSanitize::html($sys['bf_captcha']); ?>" data-msg-remote="<?php echo pjSanitize::html($sys['bf_captcha_inc']); ?>" data-msg-remote="<?php echo pjSanitize::html($sys['bf_captcha_inc']); ?>" data-msg-minlength="<?php echo pjSanitize::html($sys['bf_captcha_min']); ?>" data-msg-maxlength="<?php echo pjSanitize::html($sys['bf_captcha_max']); ?>" />
					<img class="form-captcha" src="<?php echo PJ_INSTALL_FOLDER; ?>captcha/?rand=<?php echo isset($_SERVER['REQUEST_TIME']) ? $_SERVER['REQUEST_TIME'] : rand(1000, 999999); ?>" alt="Captcha" class="form-captcha" title="<?php __('front_label_reload', false, true); ?>" />
				</span>
			</p>
			<p class="form-row">
				<label class="form-field-label form-field-label-empty">&nbsp;</label>
				<input type="submit" class="button" value="<?php __('front_label_send_request', false, true); ?>" />
			</p>
			<div class="form-message" style="display: none"></div>
		</form>
	</div>
	<div class="listing-enquiry-terms">
		<h2 class="listing-h2"><?php __('front_label_booking_terms'); ?></h2>
		<div class="listing-content"><?php echo nl2br(stripslashes($tpl['arr']['listing_terms'])); ?></div>
	</div>
</div>