<?php
$show_outbound = false;
$show_inbound = false;
if (!empty($tpl['arr']['outbound_from'])
	|| !empty($tpl['arr']['outbound_to'])
	|| !empty($tpl['arr']['outbound_departs'])
	|| !empty($tpl['arr']['outbound_arrives']))
{
	$show_outbound = true;
}
if (!empty($tpl['arr']['inbound_from'])
	|| !empty($tpl['arr']['inbound_to'])
	|| !empty($tpl['arr']['inbound_departs'])
	|| !empty($tpl['arr']['inbound_arrives']))
{
	$show_inbound = true;
}

if ($tpl['arr']['flight_included'] == 'T'
	&& ($show_outbound || $show_inbound || !empty($tpl['arr']['flight_notes']))
)
{
	?>
	<div class="listing-section listing-section-clean">
		<div class="listing-section-inner">
			<h2 class="listing-h2"><?php __('front_label_flight_info'); ?></h2>
		</div>
		<?php
		if ($show_outbound)
		{
			?>
			<div class="listing-flight-row row">
				<div class="listing-flight-cell listing-flight-title"><?php __('front_label_outbound_flight'); ?></div>
				<div class="listing-flight-cell listing-flight-departure">
					<div class="listing-flight-cell-item listing-flight-cell-item-title"><?php __('front_label_departure'); ?></div>
					<?php
					if(!empty($tpl['arr']['outbound_departs']))
					{
						?><div class="listing-flight-cell-item listing-flight-cell-item-datetime"><?php echo pjUtil::formatDate(date('Y-m-d', strtotime($tpl['arr']['outbound_departs'])), 'Y-m-d', $tpl['option_arr']['o_date_format']) . ' ' . pjUtil::formatTime(date('H:i:s', strtotime($tpl['arr']['outbound_departs'])), 'H:i:s', $tpl['option_arr']['o_time_format']); ?></div><?php
					}
					if(!empty($tpl['arr']['outbound_from']))
					{
						?><div class="listing-flight-cell-item listing-flight-cell-item-location"><?php echo pjSanitize::html($tpl['arr']['outbound_from']); ?></div><?php
					}
					?>
				</div>
				<div class="listing-flight-cell listing-flight-duration">
					<div class="listing-flight-cell-item listing-flight-cell-item-title"><?php __('front_label_duration'); ?></div>
					<?php
					$duration = '&nbsp;';
					if (!empty($tpl['arr']['outbound_departs']) && !empty($tpl['arr']['outbound_arrives']))
					{
						$diff = pjUtil::getTotalDuration($tpl['arr']['outbound_departs'], $tpl['arr']['outbound_arrives']);
						if (!empty($diff))
						{
							$duration =  $diff['hours'] . __('front_label_hour', true) . ' ' . $diff['mins'] . __('front_label_minute', true);
						}
					}
					?>
					<div class="listing-flight-cell-item listing-flight-cell-item-location"><?php echo $duration != '&nbsp;' ? __('front_label_total_duration', true) .':' : NULL; ?></div>
					<div class="listing-flight-cell-item listing-flight-cell-item-time"><?php echo $duration; ?></div>
				</div>
				<div class="listing-flight-cell listing-flight-arrival">
					<div class="listing-flight-cell-item listing-flight-cell-item-title"><?php __('front_label_arrival'); ?></div>
					<?php
					if(!empty($tpl['arr']['outbound_arrives']))
					{
						?><div class="listing-flight-cell-item listing-flight-cell-item-datetime"><?php echo pjUtil::formatDate(date('Y-m-d', strtotime($tpl['arr']['outbound_arrives'])), 'Y-m-d', $tpl['option_arr']['o_date_format']) . ' ' . pjUtil::formatTime(date('H:i:s', strtotime($tpl['arr']['outbound_arrives'])), 'H:i:s', $tpl['option_arr']['o_time_format']); ?></div><?php
					}
					if(!empty($tpl['arr']['outbound_to']))
					{
						?><div class="listing-flight-cell-item listing-flight-cell-item-location"><?php echo pjSanitize::html($tpl['arr']['outbound_to']); ?></div><?php
					}
					?>
				</div>
			</div>
			<?php
		}
		if ($show_inbound)
		{
			?>
			<div class="listing-flight-row row">
				<div class="listing-flight-cell listing-flight-title"><?php __('front_label_inbound_flight'); ?></div>
				<div class="listing-flight-cell listing-flight-departure">
					<div class="listing-flight-cell-item listing-flight-cell-item-title"><?php __('front_label_departure'); ?></div>
					<?php
					if(!empty($tpl['arr']['inbound_departs']))
					{
						?><div class="listing-flight-cell-item listing-flight-cell-item-datetime"><?php echo pjUtil::formatDate(date('Y-m-d', strtotime($tpl['arr']['inbound_departs'])), 'Y-m-d', $tpl['option_arr']['o_date_format']) . ' ' . pjUtil::formatTime(date('H:i:s', strtotime($tpl['arr']['inbound_departs'])), 'H:i:s', $tpl['option_arr']['o_time_format']); ?></div><?php
					}
					if(!empty($tpl['arr']['inbound_from']))
					{
						?><div class="listing-flight-cell-item listing-flight-cell-item-location"><?php echo pjSanitize::html($tpl['arr']['inbound_from']); ?></div><?php
					}
					?>
				</div>
				<div class="listing-flight-cell listing-flight-duration">
					<div class="listing-flight-cell-item listing-flight-cell-item-title"><?php __('front_label_duration'); ?></div>
					<?php
					$duration = '&nbsp;';
					if(!empty($tpl['arr']['inbound_departs']) && !empty($tpl['arr']['inbound_arrives']))
					{
						$diff = pjUtil::getTotalDuration($tpl['arr']['inbound_departs'], $tpl['arr']['inbound_arrives']);
						if(!empty($diff))
						{
							$duration = $diff['hours'] . __('front_label_hour', true) . ' ' . $diff['mins'] . __('front_label_minute', true);
						}
					}
					?>
					<div class="listing-flight-cell-item listing-flight-cell-item-location"><?php echo $duration != '&nbsp;' ? __('front_label_total_duration', true) .':' : NULL; ?></div>
					<div class="listing-flight-cell-item listing-flight-cell-item-time"><?php echo $duration; ?></div>
				</div>
				<div class="listing-flight-cell listing-flight-arrival">
					<div class="listing-flight-cell-item listing-flight-cell-item-title"><?php __('front_label_arrival'); ?></div>
					<?php
					if(!empty($tpl['arr']['inbound_arrives']))
					{
						?><div class="listing-flight-cell-item listing-flight-cell-item-datetime"><?php echo pjUtil::formatDate(date('Y-m-d', strtotime($tpl['arr']['inbound_arrives'])), 'Y-m-d', $tpl['option_arr']['o_date_format']) . ' ' . pjUtil::formatTime(date('H:i:s', strtotime($tpl['arr']['inbound_arrives'])), 'H:i:s', $tpl['option_arr']['o_time_format']); ?></div><?php
					}
					if(!empty($tpl['arr']['inbound_to']))
					{
						?><div class="listing-flight-cell-item listing-flight-cell-item-location"><?php echo pjSanitize::html($tpl['arr']['inbound_to']); ?></div><?php
					}
					?>
				</div>
			</div>
			<?php
		}
		if (!empty($tpl['arr']['flight_notes']))
		{
			?>
			<div class="listing-flight-row-details row">
				<div class="listing-flight-cell listing-flight-title"><?php __('front_label_flight_details'); ?></div>
				<div class="listing-flight-cell listing-flight-details"><?php echo nl2br(stripslashes($tpl['arr']['flight_notes'])); ?></div>
			</div>
			<?php
		}
		?>
	</div>
	<?php
}
?>