<div class="listing-section row">
<?php
if ($tpl['arr']['address_map'] == 1)
{
	if (!empty($tpl['arr']['lat']) && !empty($tpl['arr']['lng']))
	{
		$line1 = array();
		$line2 = array();
		if(!empty($tpl['arr']['address_content']))
		{
			$line1[] = $tpl['arr']['address_content'];
		}
		if (!empty($tpl['arr']['address_postcode']))
		{
			$line1[] = $tpl['arr']['address_postcode'];
		}
		if (!empty($tpl['arr']['address_city']))
		{
			$line2[] = $tpl['arr']['address_city'];
		}
		if (!empty($tpl['arr']['country_title']))
		{
			$line2[] = $tpl['arr']['country_title'];
		}
		?>
		<h2 class="listing-h2"><?php __('front_label_location'); ?></h2>
		<div id="listing-map-canvas" class="listing-map-canvas"></div>
		<div class="listing-map-location">
		<?php
		if (!empty($line1) || !empty($line2))
		{
			 echo join(", ", $line1) . ', ' . join(", ", $line2);
		}
		?>
		</div>
		<script type="text/javascript" src="http://maps.google.com/maps/api/js?sensor=false"></script>
		<script type="text/javascript">
		(function () {
			var map;
			function googleMapsInit() {
				var options = {
					zoom: 12,
					mapTypeId: google.maps.MapTypeId.ROADMAP
				};
				map = new google.maps.Map(document.getElementById("listing-map-canvas"), options);
			}
			function codeAddress(lat, lng, contentString) {
				var myLatlng = new google.maps.LatLng(lat, lng);
				map.setCenter(myLatlng);
				var marker = new google.maps.Marker({
					map: map,
					icon: '<?php echo PJ_INSTALL_URL . PJ_IMG_PATH ;?>site/marker.png',
					position: myLatlng
				});
				if (contentString.length > 0 && contentString != "") {
					var infoWindow = new google.maps.InfoWindow({
						content: contentString
					});
					google.maps.event.addListener(marker, "click", function() {
						infoWindow.open(map, marker);
					});
				}
			}
			<?php
			$html = $address = array();
			if (!empty($tpl['arr']['country_title']))
			{
				$address[] = stripslashes($tpl['arr']['country_title']);
			}
			if (!empty($tpl['arr']['address_state']))
			{
				$address[] = stripslashes($tpl['arr']['address_state']);
			}
			if (!empty($tpl['arr']['address_city']))
			{
				$address[] = stripslashes($tpl['arr']['address_city']);
			}
			if (!empty($tpl['arr']['address_postcode']))
			{
				$address[] = stripslashes($tpl['arr']['address_postcode']);
			}
			$html[] = '<div class="vpl-info-mapview">';
			if (!empty($tpl['arr']['listing_title']))
			{
				$html[] = '<label class="vpl-map-title">'.pjSanitize::html($tpl['arr']['listing_title']).'<\/label>';
			}
			$html[] = '<label class="vpl-map-address"><span>'. __('front_label_address', true, true) . '<\/span>: ' . join(", ", $address) . '<\/label>';
			
			$html[] = '<\/div>';
			?>
			googleMapsInit();
			codeAddress(<?php echo $tpl['arr']['lat']; ?>, <?php echo $tpl['arr']['lng']; ?>, '<?php echo join("", $html); ?>');
		})();
		</script>
		<?php
	}
}
?>
</div>