<?php
if (isset($tpl['arr']) && !empty($tpl['arr']))
{
	?>
	<div class="row">
	<?php
	foreach($tpl['arr'] as $k => $v)
	{
		$title = pjSanitize::html($v['listing_title']);
		$detail_url = sprintf("%s%s-%u/", $URL, pjUtil::friendlyURL($v['listing_title']), $v['id']);
		
		$image = PJ_INSTALL_URL . PJ_IMG_PATH . 'site/noimg-grid.jpg';
		if (!empty($v['large_image']) && is_file(PJ_INSTALL_PATH . $v['large_image']))
		{
			$image = PJ_INSTALL_URL . $v['large_image'];
		}
		$location = '';
		if (!empty($v['address_city']))
		{
			$location = stripslashes($v['address_city']);
		}
		if (!empty($v['country_title']))
		{
			if ($location != '')
			{
				$location .= ', ' . stripslashes($v['country_title']);
			} else {
				$location .= stripslashes($v['country_title']);
			}
		}
		$avail_arr = array();
		if (!empty($v['listing_season']))
		{
			$filter_seasons = __('filter_seasons', true);
			$season_arr = explode("|", $v['listing_season']);
			foreach($season_arr as $key => $val)
			{
				$avail_arr[] = $filter_seasons[$val];
			}
		}
		
		$price = 'n/a';
		if (!empty($v['max']) && !empty($v['min']))
		{
			if ($v['max'] != $v['min'])
			{
				$price = pjUtil::formatCurrencySign(ceil($v['min']), $tpl['option_arr']['o_currency']) . ' - ' . pjUtil::formatCurrencySign(ceil($v['max']), $tpl['option_arr']['o_currency']);
			} else {
				$price = pjUtil::formatCurrencySign(ceil($v['min']), $tpl['option_arr']['o_currency']);
			}
		}
		
		?>
		<div class="grid-item">
			<div class="grid-item-inner">
				<div class="grid-head">
					<a href="<?php echo $detail_url; ?>"><?php echo $title; ?></a>
					<?php
					if (!empty($v['listing_rating']))
					{
						?><div class="grid-rating"><span class="grid-stars"><span class="grid-stars-inner grid-stars-<?php echo (int) $v['listing_rating']; ?>"></span></span></div><?php
					}
					?>
				</div>
				<div class="grid-pic">
					<a href="<?php echo $detail_url; ?>">
						<?php
						if (!isset($_GET['is_best_deal']))
						{
							if ($v['is_featured'] == 'T')
							{
								?><span class="grid-featured">featured</span><?php
							}
							if ((int) $v['is_best_deal'] !== 0)
							{
								?><span class="grid-badge">- <?php echo (float) $v['bd_discount']; ?> %</span><?php
							}
						} else {
							if ((int) $v['is_best_deal'] !== 0)
							{
								?><span class="grid-featured">best deal</span><?php
								?><span class="grid-badge">- <?php echo (float) $v['bd_discount']; ?> %</span><?php
							}
						}
						?>
						<img src="<?php echo $image; ?>" alt="<?php echo $title; ?>" />
						<span class="grid-hidden"><span class="grid-hidden-inner"><?php echo pjUtil::truncateDescription(pjUtil::html2txt($v['listing_description']), 220, ' '); ?></span></span>
					</a>
				</div>
				<div class="grid-details">
					<div class="grid-details-inner">
						<div class="grid-price-location">
							<div class="grid-price"><?php
							if ((int) $v['is_best_deal'] !== 0)
							{
								?><span class="grid-price-strike"><?php echo $price; ?></span> <?php echo pjUtil::formatCurrencySign(ceil($v['bd_price']), $tpl['option_arr']['o_currency']); ?><?php
							} else {
								echo $price;
							}
							?></div>
							<div class="grid-location"><?php echo $location; ?></div>
						</div>
						<?php
						if (!empty($avail_arr))
						{
							?>
							<div class="grid-availability">
								<label><?php __('front_label_available'); ?>:</label>
								<span><?php echo join(", ", $avail_arr); ?></span>
							</div>
							<?php
						}
						if (!empty($v['listing_nights']) || $v['flight_included'] == 'T')
						{
							?><div class="grid-nights-flight"><?php
							if (!empty($v['listing_nights']))
							{
								$nights = $v['listing_nights'];
								if ($v['listing_nights'] > 1)
								{
									$nights .= ' ' . __('front_label_nights', true);
								} else {
									$nights .= ' ' . __('front_label_night', true);
								}
								?>
								<div class="grid-nights"><?php echo pjMultibyte::strtolower($nights); ?></div><?php
							}
							if ($v['flight_included'] == 'T')
							{
								?><div class="grid-flight"><?php __('front_label_flight_included'); ?></div><?php
							}
							?></div><?php
						}
						
						if ($v['number_of_comments'] > 0 && $tpl['option_arr']['o_comment_and_rating'] == 'Show')
						{
							?>
							<div class="grid-avg-rating">
								<?php __('front_label_users_rating'); ?>:
								<a class="" href="<?php echo $detail_url . '#comments'; ?>"><?php echo number_format($v['avg_rating'],1) . ' / ' . $v['number_of_comments'] . ' ' . __('front_label_review', true); ?></a>
							</div>
							<?php
						}
						 
						?>
					</div>
				</div>
				<div class="grid-buttons">
					<a class="button" href="<?php echo $detail_url; ?>"><?php echo pjMultibyte::strtolower(__('front_label_details', true)); ?></a>
					<a class="button button-gray" href="<?php echo $detail_url . '#enquiry'; ?>"><?php echo pjMultibyte::strtolower(__('front_label_send_enquiry', true)); ?></a>
				</div>
			</div>
		</div>
		<?php
	}
	?>
	</div>
	<?php
	include dirname(__FILE__) . '/pagination.php';
} else {
	?><div class="grid-empty">No packages found.</div><?php
}
?>