<?php
if (isset($tpl['arr']) && !empty($tpl['arr']))
{
	foreach ($tpl['arr'] as $v)
	{
		$title = pjSanitize::html($v['listing_title']);
		$detail_url = sprintf("%s%s-%u/", $URL, pjUtil::friendlyURL($v['listing_title']), $v['id']);
		
		$image = PJ_INSTALL_URL . PJ_IMG_PATH . 'site/noimg-medium.jpg';
		if (!empty($v['large_image']) && is_file(PJ_INSTALL_PATH . $v['large_image']))
		{
			$image = PJ_INSTALL_URL . $v['large_image'];
		}
		$location = '';
		if (!empty($v['address_city']))
		{
			$location = stripslashes($v['address_city']);
		}
		if (!empty($v['country_title']))
		{
			if ($location != '')
			{
				$location .= ', ' . stripslashes($v['country_title']);
			} else {
				$location .= stripslashes($v['country_title']);
			}
		}
		$avail_arr = array();
		if (!empty($v['listing_season']))
		{
			$filter_seasons = __('filter_seasons', true);
			$season_arr = explode("|", $v['listing_season']);
			foreach($season_arr as $key => $val)
			{
				$avail_arr[] = $filter_seasons[$val];
			}
		}
		
		$price = 'n/a';
		if (!empty($v['max']) && !empty($v['min']))
		{
			if ($v['max'] != $v['min'])
			{
				$price = pjUtil::formatCurrencySign(ceil($v['min']), $tpl['option_arr']['o_currency']) . ' - ' . pjUtil::formatCurrencySign(ceil($v['max']), $tpl['option_arr']['o_currency']);
			} else {
				$price = pjUtil::formatCurrencySign(ceil($v['min']), $tpl['option_arr']['o_currency']);
			}
		}
		?>
		<div class="list-item row">
			<div class="list-head row">
				<a href="<?php echo $detail_url; ?>"><?php echo $title;?></a>
				<?php
				if($tpl['option_arr']['o_comment_and_rating'] == 'Show')
				{ 
					?>
					<div class="list-rating"><span class="list-stars"><span class="list-stars-inner list-stars-<?php echo (int) $v['listing_rating']; ?>"></span></span></div>
					<?php
				} 
				?>
			</div>
			<div class="list-content row">
				<div class="list-pic">
					<?php
					if (!isset($_GET['is_best_deal']))
					{
						if ($v['is_featured'] == 'T')
						{
							?><div class="list-featured">推 荐 行 程</div><?php
						}
						if ((int) $v['is_best_deal'] !== 0)
						{
							?><div class="list-badge">- <?php echo (float) $v['bd_discount']; ?> %</div><?php
						}
					} else {
						if ((int) $v['is_best_deal'] !== 0)
						{
							?><div class="list-featured">优惠</div><?php
							?><div class="list-badge">- <?php echo (float) $v['bd_discount']; ?> %</div><?php
						}
					}
					?>
					<a href="<?php echo $detail_url; ?>"><img src="<?php echo $image; ?>" alt="<?php echo $title; ?>" /></a>
				</div>
				<div class="list-details">
					<div class="list-details-inner">
						<div class="list-price-location row">
							<div class="list-price"><?php
							if ((int) $v['is_best_deal'] !== 0)
							{
								?><span class="list-price-strike"><?php echo $price; ?></span> <?php echo pjUtil::formatCurrencySign(ceil($v['bd_price']), $tpl['option_arr']['o_currency']); ?><?php
							} else {
								echo $price;
							}
							?></div>
							<?php
							if (!empty($location))
							{
								?><div class="list-location"><?php echo $location;?></div><?php
							}
							?>
						</div>
						<?php
						if (!empty($avail_arr))
						{
							?>
							<div class="list-availability">
								<?php __('front_label_available'); ?>:
								<span><?php echo join(", ", $avail_arr); ?></span>
							</div>
							<?php
						}
						?>
						<div class="list-other row">
							<?php
							if (!empty($v['listing_nights']))
							{
								$nights = $v['listing_nights'];
								if ($v['listing_nights'] > 1)
								{
									$nights .= ' ' . __('front_label_nights', true);
								} else {
									$nights .= ' ' . __('front_label_night', true);
								}
								?><div class="list-nights"><?php echo pjMultibyte::strtolower($nights); ?></div><?php
							}
							if ($v['flight_included'] == 'T')
							{
								?>
								<div class="list-flight"><?php __('front_label_flight_included'); ?></div>
								<?php
							}
							if ($v['number_of_comments'] > 0 && $tpl['option_arr']['o_comment_and_rating'] == 'Show')
							{
								?>
								<div class="list-avg-rating">
									<?php __('front_label_users_rating'); ?>:
									<a href="<?php echo $detail_url . '#comments'; ?>"><?php echo number_format($v['avg_rating'],1) . ' / ' . $v['number_of_comments'] . ' ' . __('front_label_review', true); ?></a>
								</div>
								<?php
							}
							?>
						</div>
						<div class="list-desc">
							<?php echo stripslashes(pjUtil::truncateDescription(pjUtil::html2txt($v['listing_description']), 270, ' ')); ?>
						</div>
						<div class="list-buttons">
							<a class="button" href="<?php echo $detail_url; ?>"><?php echo pjMultibyte::strtolower(__('front_label_details', true)); ?></a>
							<a class="button button-gray" href="<?php echo $detail_url . '#enquiry'; ?>"><?php echo pjMultibyte::strtolower(__('front_label_send_enquiry', true)); ?></a>
						</div>
					</div>
				</div>
			</div>
		</div>
		<?php
	}
	include dirname(__FILE__) . '/pagination.php';
} else {
	?><div class="list-empty">No packages found.</div><?php
}
?>