<h1><?php __('front_label_contact'); ?></h1>

<div class="page-outer page-contact">
	<div class="page-inner">
		<?php
		if (isset($_GET['err']) && !empty($_GET['err']))
		{
			$titles = __('error_titles', true);
			$bodies = __('error_bodies', true);
			pjUtil::frontNotice(@$titles[$_GET['err']], @$bodies[$_GET['err']]);
		}
		$sys = __('front_sys', true);
		?>

		<p class="page-text"><?php __('front_contact_info'); ?></p>
	
		<form action="<?php echo $URL; ?>contact/" method="post" class="form" id="form-contact">
			<input type="hidden" name="contact_send" value="1" />
			<p class="form-row">
				<label class="form-field-label" for="name"><?php __('front_label_name'); ?></label>
				<span class="form-field-wrap">
					<input type="text" name="name" id="name" class="form-field" data-msg-required="<?php echo pjSanitize::html($sys['bf_name']); ?>" />
				</span>
			</p>
			<p class="form-row">
				<label class="form-field-label" for="email"><?php __('front_label_email'); ?></label>
				<span class="form-field-wrap">
					<input type="text" name="email" id="email" class="form-field" data-msg-required="<?php echo pjSanitize::html($sys['bf_email']); ?>" data-msg-email="<?php echo pjSanitize::html($sys['bf_email_inv']); ?>" />
				</span>
			</p>
			<p class="form-row">
				<label class="form-field-label" for="phone"><?php __('front_label_phone'); ?></label>
				<span class="form-field-wrap">
					<input type="text" name="phone" id="phone" class="form-field" data-msg-required="<?php echo pjSanitize::html($sys['bf_phone']); ?>" />
				</span>
			</p>
			<p class="form-row">
				<label class="form-field-label" for="question"><?php __('front_label_question'); ?></label>
				<span class="form-field-wrap">
					<textarea name="question" id="question" class="form-field" data-msg-required="<?php echo pjSanitize::html($sys['bf_question']); ?>"></textarea>
				</span>
			</p>
			<p class="form-row">
				<label class="form-field-label" for="captcha"><?php __('front_label_captcha'); ?></label>
				<span class="form-field-wrap">
					<input type="text" name="captcha" id="captcha" class="form-field form-field-captcha" maxlength="6" autocomplete="off" data-msg-required="<?php echo pjSanitize::html($sys['bf_captcha']); ?>" data-msg-remote="<?php echo pjSanitize::html($sys['bf_captcha_inc']); ?>" data-msg-minlength="<?php echo pjSanitize::html($sys['bf_captcha_min']); ?>" data-msg-maxlength="<?php echo pjSanitize::html($sys['bf_captcha_max']); ?>" />
					<img src="<?php echo PJ_INSTALL_FOLDER; ?>captcha/?rand=<?php echo rand(1000, 999999); ?>" alt="Captcha" class="form-captcha" title="<?php __('front_label_reload', false, true); ?>" />
				</span>
			</p>
			<p class="form-row">
				<label class="form-field-label">&nbsp;</label>
				<input type="submit" class="button" value="<?php __('front_button_send', false, true); ?>" />
			</p>
		</form>
	</div>
</div>

<div class="panel-outer social-box page-contact">
<?php include dirname(__FILE__) . '/elements/follow.php'; ?>
</div>
<?php if ((int) $tpl['option_arr']['o_view_subscribe'] === 1) : ?>
<div class="panel-outer subscribe-box page-contact">
	<div class="panel-inner">
	<?php include dirname(__FILE__) . '/elements/subscribe.php'; ?>
	</div>
</div>
<?php endif; ?>