<div class="landing row">
	<div class="carousel-navi carousel-navi-left"><a href="#" class="carousel-navi-prev landing-prev"></a></div>
	<div id="carousel-landing" class="owl-carousel">
	<?php
	foreach ($tpl['slide_arr'] as $slide)
	{
		?>
		<div class="landing-item">
			<a href="<?php echo pjSanitize::html($slide['url']); ?>" target="<?php echo pjSanitize::html($slide['target']); ?>" class="landing-item-pic">
				<img src="<?php echo pjSanitize::html($slide['image_thumb']); ?>" alt="<?php echo pjSanitize::html($slide['title']); ?>" />
				<span class="landing-item-offer">
					<span class="landing-item-offer-inner"><?php echo pjSanitize::html($slide['title']); ?></span>
				</span>
				<span class="landing-item-hidden">
					<span class="landing-item-hidden-inner">
						<span class="landing-item-title"><?php echo pjSanitize::html($slide['title']); ?></span>
						<span class="landing-item-desc"><?php echo pjSanitize::html($slide['desc']); ?></span>
					</span>
				</span>
			</a>
	    </div>
	    <?php
	}
	?>
	</div>
	<div class="carousel-navi carousel-navi-right"><a href="#" class="carousel-navi-next landing-next"></a></div>
</div>

<?php
$filter_suffix = 'home';
include dirname(__FILE__) . '/elements/filter.php';
?>

<div class="row">

	<div class="main-box row">
		<?php
		if (isset($tpl['featured_arr']) && !empty($tpl['featured_arr']))
		{
			?>
			<div class="panel-outer panel-package">
				<section id="featured" class="panel-inner row">
					<h3><?php __('front_label_featured'); ?></h3>
					<div class="carousel-nav carousel-nav-left"><a href="#" class="carousel-nav-prev featured-prev"></a></div>
					<div id="carousel-featured" class="owl-carousel">
					<?php include dirname(__FILE__) . '/elements/featured.php'; ?>
					</div>
					<div class="carousel-nav carousel-nav-right"><a href="#" class="carousel-nav-next featured-next"></a></div>
				</section>
			</div>
			<?php
		}
		if (isset($tpl['deals_arr']) && !empty($tpl['deals_arr']))
		{
			?>
			<div class="panel-outer panel-package">
				<section id="best-deals" class="panel-inner row">
					<h3><?php __('front_label_deals'); ?></h3>
					<div class="carousel-nav carousel-nav-left"><a href="#" class="carousel-nav-prev deals-prev"></a></div>
					<div id="carousel-deals" class="owl-carousel">
					<?php include dirname(__FILE__) . '/elements/best-deals.php'; ?>
					</div>
					<div class="carousel-nav carousel-nav-right"><a href="#" class="carousel-nav-next deals-next"></a></div>
				</section>
			</div>
			<?php
		}
		?>
	</div>
	
	<div class="sidebar-box row">
		<?php
		if (isset($tpl['banner_arr']) && !empty($tpl['banner_arr']))
		{
			?>
			<div class="banner-box">
			<?php
			switch ($tpl['banner_arr']['type'])
			{
				case 'image':
					if (!empty($tpl['banner_arr']['image']) && is_file(PJ_INSTALL_PATH . $tpl['banner_arr']['image']))
					{
						if (!empty($tpl['banner_arr']['url']) && pjValidation::pjActionUrl($tpl['banner_arr']['url']))
						{
							?><a href="<?php echo $tpl['banner_arr']['url']; ?>" title="<?php echo pjSanitize::html(@$tpl['banner_arr']['title']); ?>"<?php echo !empty($tpl['banner_arr']['target']) ? sprintf(' target="%s"', $tpl['banner_arr']['target']) : NULL; ?>><img src="<?php echo PJ_INSTALL_URL . $tpl['banner_arr']['image']; ?>" alt="<?php echo pjSanitize::html(@$tpl['banner_arr']['alt']); ?>" /></a><?php
						} else {
							?><img src="<?php echo PJ_INSTALL_URL . $tpl['banner_arr']['image']; ?>" alt="<?php echo pjSanitize::html(@$tpl['banner_arr']['alt']); ?>" /><?php
						}
					}
					break;
				case 'code':
					echo $tpl['banner_arr']['code'];
					break;
			}
			?>
			</div>
			<?php
		}
		?>
		
		<div class="panel-outer subscribe-box">
			<div class="panel-inner">
			<?php include dirname(__FILE__) . '/elements/subscribe.php'; ?>
			</div>
		</div>
		<div class="panel-outer social-box">
		<?php include dirname(__FILE__) . '/elements/follow.php'; ?>
		</div>
	</div>

</div>

<?php
if (isset($tpl['dest_arr']) && !empty($tpl['dest_arr']))
{
	?>
	<div class="panel-outer panel-dest row">
		<section id="destinations" class="panel-inner row">
			<h3><?php __('front_label_popular_dest'); ?></h3>
			<?php
			$cnt = count($tpl['dest_arr']);
			$columns = 6;
			$per_column = floor($cnt / $columns);
			$remainder = $cnt % $columns;
			$end = 0;
			foreach (range(1, $columns) as $column)
			{
				?>
				<ul class="list list-dest">
				<?php
				$start = $end;
				$end = $start + $per_column;
				if ($remainder > 0 && $column <= $remainder)
				{
					$end += 1;
				}
				for ($j = $start; $j < $end; $j++)
				{
					?><li><a href="<?php echo $URL; ?>destinations/<?php echo $tpl['dest_arr'][$j]['seo_url']; ?>/"><?php echo pjSanitize::html($tpl['dest_arr'][$j]['name']); ?></a> <span>(<?php echo pjSanitize::html($tpl['dest_arr'][$j]['country']); ?>)</span></li><?php
				}
				?>
				</ul>
				<?php
			}
			?>
			<div class="dest-nav dropdown-nav">
				<a href="#" class="dropdown-toggle dropdown-closed"><?php __('front_label_select_dest'); ?></a>
				<ul>
				<?php
				foreach ($tpl['dest_arr'] as $dest)
				{
					?><li><a href="<?php echo $URL; ?>destinations/<?php echo $dest['seo_url']; ?>/"><?php echo pjSanitize::html($dest['name']); ?></a></li><?php
				}
				?>
				</ul>
			</div>
		</section>
	</div>
	<?php
}
?>