<div class="page-outer">
	<div class="page-inner">
		<?php
		if(!isset($tpl['expired']))
		{ 
			?>
			<div class="listing row">
			<?php
			if (isset($tpl['arr']))
			{
				$detail_url = sprintf("%s%s-%u/", $URL, pjUtil::friendlyURL($tpl['arr']['listing_title']), $tpl['arr']['id']);
				
				$avail_arr = array();
				if (!empty($tpl['arr']['listing_season']))
				{
					$filter_seasons = __('filter_seasons', true);
					$season_arr = explode("|", $tpl['arr']['listing_season']);
					foreach($season_arr as $key => $val)
					{
						$avail_arr[] = $filter_seasons[$val];
					}
				}
				
				$price = 'n/a';
				if (!empty($tpl['arr']['max']) && !empty($tpl['arr']['min']))
				{
					if ($tpl['arr']['max'] != $tpl['arr']['min'])
					{
						$price = pjUtil::formatCurrencySign(ceil($tpl['arr']['min']), $tpl['option_arr']['o_currency']) . ' - ' . pjUtil::formatCurrencySign(ceil($tpl['arr']['max']), $tpl['option_arr']['o_currency']);
					} else {
						$price = pjUtil::formatCurrencySign(ceil($tpl['arr']['min']), $tpl['option_arr']['o_currency']);
					}
				}
				$title = pjSanitize::html($tpl['arr']['listing_title']);
				?>
				<div class="listing-head row">
					<div class="listing-title"><?php echo $title; ?></div>
					<div class="listing-refid"><?php __('front_label_id'); ?>: <?php echo pjSanitize::html($tpl['arr']['listing_refid']); ?></div>
					<?php
					if($tpl['option_arr']['o_comment_and_rating'] == 'Show')
					{ 
						?>
						<div class="listing-rating"><span class="listing-stars"><span class="listing-stars-inner listing-stars-<?php echo (int) $tpl['arr']['listing_rating']; ?>"></span></span></div>
						<?php
					} 
					?>
				</div>
				<div class="listing-main row">
					<div class="listing-gallery">
						<?php
						if (isset($tpl['gallery_arr']) && !empty($tpl['gallery_arr']))
						{
							?>
							<div id="sync1" class="owl-carousel">
							<?php
							foreach ($tpl['gallery_arr'] as $v)
							{
								?><img src="<?php echo PJ_INSTALL_URL . $v['medium_path']; ?>" alt="<?php echo !empty($v['alt']) ? pjSanitize::html($v['alt']) : $title; ?>" /><?php
							}
							?>
							</div>
							<div class="sync2-wrapper row">
								<div class="sync2-left"><a href="#" class="gallery-nav gallery-prev"></a></div>
								<div class="sync2-middle">
									<div id="sync2" class="owl-carousel">
									<?php
									foreach ($tpl['gallery_arr'] as $v)
									{
										?><img src="<?php echo PJ_INSTALL_URL . $v['small_path']; ?>" alt="<?php echo !empty($v['alt']) ? pjSanitize::html($v['alt']) : $title; ?>" /><?php
									}
									?>
									</div>
								</div>
								<div class="sync2-right"><a href="#" class="gallery-nav gallery-next"></a></div>
							</div>
							<?php
						}
						?>
					</div>
					<div class="listing-details">
						<div class="listing-details-inner">
							<?php
							if ((int) $tpl['arr']['is_best_deal'] > 0 && (float) $tpl['arr']['bd_price'] > 0)
							{
								?><div class="listing-price"><span><?php __('front_label_start_from'); ?></span> <?php echo pjUtil::formatCurrencySign(ceil($tpl['arr']['bd_price']), $tpl['option_arr']['o_currency']); ?></div><?php
								?><div class="listing-price-strike"><?php echo $price; ?></div><?php
							} else {
								?><div class="listing-price"><?php echo $price; ?></div><?php
							}
							?>
							<div class="listing-available">
								<label><?php __('front_label_available'); ?>:</label>&nbsp;
								<span><?php echo join(", ", $avail_arr); ?></span>
							</div>
							<?php
							if (!empty($tpl['arr']['listing_nights']))
							{
								$nights = $tpl['arr']['listing_nights'];
								if ($tpl['arr']['listing_nights'] > 1)
								{
									$nights .= ' ' . __('front_label_nights', true);
								} else {
									$nights .= ' ' . __('front_label_night', true);
								}
								?><div class="listing-nights"><?php echo pjMultibyte::strtolower($nights); ?></div><?php
							}
							if ($tpl['arr']['flight_included'] == 'T')
							{
								?><div class="listing-flight"><?php __('front_label_flight_included'); ?></div><?php
							}
							if ($tpl['arr']['number_of_comments'] > 0 && $tpl['option_arr']['o_comment_and_rating'] == 'Show')
							{
								$r = round($tpl['arr']['avg_rating'], 1);
								$average = strpos($r, '.0') === FALSE ? $r : round($r, 0);
								?><div class="listing-avg">
									<div class="listing-avg-rating"><?php __('front_label_avg_users_rating'); ?>:</div>
									<div class="listing-avg-review"><span><?php echo $average; ?></span> / <?php echo $tpl['arr']['number_of_comments']; ?> <?php __('front_label_reviews'); ?></div>
									<div class="listing-avg-goto"><a href="<?php echo $detail_url; ?>#comments"><?php __('front_label_view_all_reviews'); ?></a></div>
								</div><?php
							}
							include dirname(__FILE__) . '/elements/share.php';
							?>
						</div>
					</div>
				</div>
				
				<div class="listing-section">
					<h2 class="listing-h2"><?php __('front_label_description'); ?></h2>
					<div class=""><?php echo nl2br(stripslashes($tpl['arr']['listing_description'])); ?></div>
				</div>
				
				<?php
				if ($tpl['arr']['address_map'] == 1)
				{
			        include dirname(__FILE__) . '/elements/listing-map.php';
				}
				if (isset($tpl['feature_arr']) && !empty($tpl['feature_arr']))
				{
					?>
					<div class="listing-section">
						<h2 class="listing-h2"><?php __('front_label_features'); ?></h2>
						<ul class="listing-features row">
							<?php
							foreach ($tpl['feature_arr'] as $k => $v)
							{
								?><li><?php echo pjSanitize::html($v['feature_title']); ?></li><?php
							}
							?>
						</ul>
					</div>
					<?php
				}
				include dirname(__FILE__) . '/elements/listing-flight.php';
				
				if (isset($tpl['price_arr']) && !empty($tpl['price_arr']))
				{
					?>
					<div class="listing-section listing-section-clean">
						<div class="listing-section-inner">
							<h2 class="listing-h2"><?php __('front_label_prices'); ?></h2>
						</div>
						<div class="listing-prices">
							<div class="listing-price-row listing-price-row-head row">
								<div class="listing-price-cell listing-price-package"><?php __('front_label_package'); ?></div>
								<div class="listing-price-cell listing-price-from"><?php __('front_label_from'); ?></div>
								<div class="listing-price-cell listing-price-to"><?php __('front_label_to'); ?></div>
								<div class="listing-price-cell listing-price-value"><?php __('front_label_price'); ?></div>
							</div>
							<?php
							$price_types = __('price_types', true);
							foreach ($tpl['price_arr'] as $k => $v)
							{
								?>
								<div class="listing-price-row row">
									<div class="listing-price-cell listing-price-package"><?php echo $v['price_title'];?></div>
									<div class="listing-price-cell listing-price-from listing-price-meta"><?php __('front_label_from'); ?></div>
									<div class="listing-price-cell listing-price-from"><?php echo pjUtil::formatDate(date('Y-m-d', strtotime($v['date_from'])), 'Y-m-d', $tpl['option_arr']['o_date_format']); ?></div>
									<div class="listing-price-cell listing-price-to listing-price-meta"><?php __('front_label_to'); ?></div>
									<div class="listing-price-cell listing-price-to"><?php echo pjUtil::formatDate(date('Y-m-d', strtotime($v['date_to'])), 'Y-m-d', $tpl['option_arr']['o_date_format']); ?></div>
									<div class="listing-price-cell listing-price-value listing-price-meta"><?php __('front_label_price'); ?></div>
									<div class="listing-price-cell listing-price-value"><span><?php echo pjUtil::formatCurrencySign(ceil($v['price']), $tpl['option_arr']['o_currency'], ' '); ?></span> <?php echo $price_types[$v['price_type']];?></div>
								</div>
								<?php
							}
							?>
						</div>
					</div>
					<?php
				}
				include dirname(__FILE__) . '/elements/listing-policies.php';
				if($tpl['arr']['owner_show'] == 'T')
				{
					include dirname(__FILE__) . '/elements/contact.php';
				} 
				?>
				<div class="listing-section listing-section-clean">
				<?php include dirname(__FILE__) . '/elements/listing-enquiry.php'; ?>
				</div>
				<div class="listing-section listing-section-clean">
					<?php include dirname(__FILE__) . '/elements/listing-comments.php'; ?>
				</div>
				<?php
			}
		
			?>
			</div>
		<?php
		}else{
			__('front_package_expired');
		}
		?>
	</div>
</div>