var jQuery_1_8_2 = jQuery_1_8_2 || $.noConflict();
(function ($, undefined) {
	$(function () {
		var	$frmCreateBanner = $("#frmCreateBanner"),
			$frmUpdateBanner = $("#frmUpdateBanner"),
			validate = ($.fn.validate !== undefined),
			datagrid = ($.fn.datagrid !== undefined);
		
		if ($frmCreateBanner.length > 0 && validate) {
			$frmCreateBanner.validate({
				errorPlacement: function (error, element) {
					error.insertAfter(element.parent());
				},
				onkeyup: false,
				errorClass: "err",
				wrapper: "em",
				ignore: ""
			});
		}
		
		if ($frmUpdateBanner.length > 0 && validate) {
			$frmUpdateBanner.validate({
				errorPlacement: function (error, element) {
					error.insertAfter(element.parent());
				},
				onkeyup: false,
				errorClass: "err",
				wrapper: "em",
				ignore: ""
			});
		}
		
		function formatImage(str, obj) {
			switch (obj.type) {
			case 'image':
				if (obj.image != null) {
					return ['<a href="index.php?controller=pjAdminBanners&action=pjActionUpdate&id=', obj.id, '"><img src="', obj.image, '?', Math.floor(Math.random() * 999999), '" alt="" style="border: none; vertical-align: middle; max-width: 100px; max-height: 100px" /></a>'].join("");
				}
				break;
			case 'code':
				return obj.code;
				return obj.code
					.replace(/&/g, "&amp;")
					.replace(/</g, "&lt;")
					.replace(/>/g, "&gt;")
					.replace(/"/g, "&quot;")
					.replace(/'/g, "&#039;");
				break;
			}
			
			return "---";
		}
		if ($("#grid").length > 0 && datagrid) {
			var $grid = $("#grid").datagrid({
				buttons: [{type: "edit", url: "index.php?controller=pjAdminBanners&action=pjActionUpdate&id={:id}", title: myLabel.lblEdit},
				          {type: "delete", url: "index.php?controller=pjAdminBanners&action=pjActionDeleteBanner&id={:id}", title: myLabel.lblDelete}
				          ],
				columns: [{text: "", type: "text", sortable: true, editable: false, width: 450, renderer: formatImage},
				          {text: myLabel.type, type: "text", sortable: true, editable: false},
				          {text: myLabel.status, type: "select", sortable: true, editable: true, options: [
				                                                                                     {label: myLabel.active, value: "T"}, 
				                                                                                     {label: myLabel.inactive, value: "F"}
				                                                                                     ], applyClass: "pj-status"}],
				dataUrl: "index.php?controller=pjAdminBanners&action=pjActionGetBanner",
				dataType: "json",
				fields: ['image', 'type', 'status'],
				paginator: {
					actions: [
					   {text: myLabel.delete_selected, url: "index.php?controller=pjAdminBanners&action=pjActionDeleteBannerBulk",  ajax: false, render: true, confirmation: myLabel.delete_confirmation},
					   {text: myLabel.make_active, url: "index.php?controller=pjAdminBanners&action=pjActionStatusBanner&status=T", render: true},
					   {text: myLabel.make_inactive, url: "index.php?controller=pjAdminBanners&action=pjActionStatusBanner&status=F", render: true}
					],
					gotoPage: true,
					paginate: true,
					total: true,
					rowCount: true
				},
				saveUrl: "index.php?controller=pjAdminBanners&action=pjActionSaveBanner&id={:id}",
				select: {
					field: "id",
					name: "record[]"
				}
			});
		}
		
		$("#content").on("change", "#type", function (e) {
			switch ($(this).find("option:selected").val()) {
			case 'image':
				$(".boxCode").hide();
				$(".boxImage").show();
				break;
			case 'code':
				$(".boxCode").show();
				$(".boxImage").hide();
				break;
			default:
				$(".boxCode, .boxImage").hide();
			}
		});
		
		$(document).on("click", ".btn-all", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			$(this).addClass("pj-button-active").siblings(".pj-button").removeClass("pj-button-active");
			var content = $grid.datagrid("option", "content"),
				cache = $grid.datagrid("option", "cache");
			$.extend(cache, {
				status: "",
				q: ""
			});
			$grid.datagrid("option", "cache", cache);
			$grid.datagrid("load", "index.php?controller=pjAdminBanners&action=pjActionGetBanner", "id", "DESC", content.page, content.rowCount);
			return false;
		}).on("click", ".btn-filter", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var $this = $(this),
				content = $grid.datagrid("option", "content"),
				cache = $grid.datagrid("option", "cache"),
				obj = {};
			$this.addClass("pj-button-active").siblings(".pj-button").removeClass("pj-button-active");
			obj.status = "";
			obj[$this.data("column")] = $this.data("value");
			$.extend(cache, obj);
			$grid.datagrid("option", "cache", cache);
			$grid.datagrid("load", "index.php?controller=pjAdminBanners&action=pjActionGetBanner", "id", "DESC", content.page, content.rowCount);
			return false;
		}).on("submit", ".frm-filter", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var $this = $(this),
				content = $grid.datagrid("option", "content"),
				cache = $grid.datagrid("option", "cache");
			$.extend(cache, {
				q: $this.find("input[name='q']").val()
			});
			$grid.datagrid("option", "cache", cache);
			$grid.datagrid("load", "index.php?controller=pjAdminBanners&action=pjActionGetBanner", "id", "DESC", content.page, content.rowCount);
			return false;
		});
	});
})(jQuery_1_8_2);