var jQuery_1_8_2 = jQuery_1_8_2 || $.noConflict();
(function ($, undefined) {
	$(function () {
		var	$frmUpdateLogo = $("#frmUpdateLogo"),
			$dialogLogoDelete = $("#dialogLogoDelete"),
			$dialogLogoCrop = $("#dialogLogoCrop"),
			$upload = $("#upload"),
			tipsy = ($.fn.tipsy !== undefined),
			Jcrop = ($.fn.Jcrop !== undefined),
			zinoUpload = ($.fn.zinoUpload !== undefined),
			validate = ($.fn.validate !== undefined),
			dialog = ($.fn.dialog !== undefined);
		
		if (tipsy) {
			$(".center-langbar-tip").tipsy({
				offset: 1,
				opacity: 1,
				html: true,
				className: "tipsy-listing-center"
			});
		}
		
		if ($frmUpdateLogo.length > 0 && validate) {
			$frmUpdateLogo.validate({
				errorPlacement: function (error, element) {
					error.insertAfter(element.parent());
				},
				onkeyup: false,
				errorClass: "err",
				wrapper: "em",
				ignore: "",
				invalidHandler: function (event, validator) {
					$(".pj-multilang-wrap").each(function( index ) {
						if($(this).attr('data-index') == myLabel.localeId)
						{
							$(this).css('display','block');
						}else{
							$(this).css('display','none');
						}
					});
					$(".pj-form-langbar-item").each(function( index ) {
						if($(this).attr('data-index') == myLabel.localeId)
						{
							$(this).addClass('pj-form-langbar-item-active');
						}else{
							$(this).removeClass('pj-form-langbar-item-active');
						}
					});
				}
			});
		}
		
		$("#content").on("click", ".delete-logo", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			if ($dialogLogoDelete.length > 0 && dialog) {
				$dialogLogoDelete.dialog("open");
			}
			return false;
		}).on("click", ".crop-logo", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			if ($dialogLogoCrop.length > 0 && dialog) {
				openCropDialog.call(null);
			}
			return false;
		});
		
		function getThumb() {
			$.get("index.php?controller=pjAdminLogos&action=pjActionImage").done(function (data) {
				$("#box-logo").html(data);
			});
		}
		
		function openCropDialog() {
			$.get("index.php?controller=pjAdminLogos&action=pjActionCrop").done(function (data) {
				$dialogLogoCrop.html(data);
				window.setTimeout(function () {
					$dialogLogoCrop.dialog("open");
				}, 100);
				
				$dialogLogoCrop.find("img").Jcrop({
					aspectRatio: 183/85,
					allowResize: true,
					allowSelect: false,
	                setSelect: [0, 0, 183, 85],
	                boxWidth: 800,
	                boxHeight: 600,
	                bgColor: "white",
	                onSelect: function(c) {
	                    var $frm = $dialogLogoCrop.find("form");
	                    if ($frm.length > 0) {
	                        $frm.find("input[name='x']").val(c.x);
	                        $frm.find("input[name='x2']").val(c.x2);
	                        $frm.find("input[name='y']").val(c.y);
	                        $frm.find("input[name='y2']").val(c.y2);
	                        $frm.find("input[name='w']").val(c.w);
	                        $frm.find("input[name='h']").val(c.h);
	                    }
	                }
	            }).on("load", function () {
					$dialogLogoCrop.dialog("option", "position", "center");
	            });
			});
		}
		
		if ($upload.length > 0 && zinoUpload) {
			$upload.zinoUpload({
		        url: "index.php?controller=pjAdminLogos&action=pjActionUpload",
		        method: "POST",
		        name: "image",
		        complete: function (event, ui) {
		            if (ui.response.status == 'OK') {
		            	getThumb.call(null);
		            	openCropDialog.call(null);
		            }
		        }
		    });
		}
		
		if ($dialogLogoDelete.length > 0 && dialog) {
			$dialogLogoDelete.dialog({
				autoOpen: false,
				draggable: false, 
				resizable: false,
				modal: true,
				buttons: (function () {
					var btns = {};
					btns['OK'] = function () {
						$.post("index.php?controller=pjAdminLogos&action=pjActionDeleteLogoImage").done(function (data) {
							if (data.status == 'OK') {
								$("#box-logo").html("");
							}
						});
						$dialogLogoDelete.dialog("close");
					};
					btns['Cancel'] = function () {
						$(this).dialog("close");
					};
					return btns;
				})()
			});
		}
		
		if ($dialogLogoCrop.length > 0 && dialog) {
			$dialogLogoCrop.dialog({
				autoOpen: false,
				draggable: false, 
				resizable: false,
				modal: true,
				width: 'auto',
				buttons: (function () {
					var btns = {};
					btns['OK'] = function () {
						$.post("index.php?controller=pjAdminLogos&action=pjActionCrop", $dialogLogoCrop.find("form").serialize()).done(function (data) {
							if (data.status == 'OK') {
								getThumb.call(null);
							}
						});
						$dialogLogoCrop.dialog("close");
					};
					btns['Cancel'] = function () {
						$(this).dialog("close");
					};
					return btns;
				})()
			});
		}
	});
})(jQuery_1_8_2);