var jQuery_1_8_2 = jQuery_1_8_2 || $.noConflict();
(function ($, undefined) {
	$(function () {
		var	$frmCreateSubscription = $("#frmCreateSubscription"),
			$frmUpdateSubscription = $("#frmUpdateSubscription"),
			validate = ($.fn.validate !== undefined),
			datagrid = ($.fn.datagrid !== undefined);
		
		if ($frmCreateSubscription.length > 0 && validate) {
			$frmCreateSubscription.validate({
				rules: {
					email: {
						required: true,
						email: true,
						remote: "index.php?controller=pjAdminSubscriptions&action=pjActionCheckEmail"
					}
				},
				errorPlacement: function (error, element) {
					error.insertAfter(element.parent());
				},
				onkeyup: false,
				errorClass: "err",
				wrapper: "em",
				ignore: ""
			});
		}
		if ($frmUpdateSubscription.length > 0 && validate) {
			$frmUpdateSubscription.validate({
				rules: {
					email: {
						required: true,
						email: true,
						remote: "index.php?controller=pjAdminSubscriptions&action=pjActionCheckEmail&id=" + $frmUpdateSubscription.find("input[name='id']").val()
					}
				},
				errorPlacement: function (error, element) {
					error.insertAfter(element.parent());
				},
				onkeyup: false,
				errorClass: "err",
				wrapper: "em",
				ignore: ""
			});
		}
		
		if ($("#grid").length > 0 && datagrid) {
			var $grid = $("#grid").datagrid({
				buttons: [{type: "edit", url: "index.php?controller=pjAdminSubscriptions&action=pjActionUpdate&id={:id}", title: myLabel.lblEdit},
				          {type: "delete", url: "index.php?controller=pjAdminSubscriptions&action=pjActionDeleteSubscription&id={:id}", title: myLabel.lblDelete}
				          ],
				columns: [{text: myLabel.email, type: "text", sortable: true, editable: true, width: 490, editableWidth: 400},
				          {text: myLabel.date_subscr, type: "text", sortable: true, editable: false}
				],
				dataUrl: "index.php?controller=pjAdminSubscriptions&action=pjActionGetSubscription",
				dataType: "json",
				fields: ['email', 'date_subscr'],
				paginator: {
					actions: [
					   {text: myLabel.delete_selected, url: "index.php?controller=pjAdminSubscriptions&action=pjActionDeleteSubscriptionBulk", ajax: false, render: true, confirmation: myLabel.delete_confirmation},
					   {text: myLabel.make_active, url: "index.php?controller=pjAdminSubscriptions&action=pjActionToggleSubscription&is_subscribed=T", render: true},
					   {text: myLabel.make_inactive, url: "index.php?controller=pjAdminSubscriptions&action=pjActionToggleSubscription&is_subscribed=F", render: true},
					   {text: myLabel.exported, url: "index.php?controller=pjAdminSubscriptions&action=pjActionExportSubscription", ajax: false}
					],
					gotoPage: true,
					paginate: true,
					total: true,
					rowCount: true
				},
				saveUrl: "index.php?controller=pjAdminSubscriptions&action=pjActionSaveSubscription&id={:id}",
				select: {
					field: "id",
					name: "record[]"
				}
			});
		}
		
		$(document).on("click", ".btn-all", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			$(this).addClass("pj-button-active").siblings(".pj-button").removeClass("pj-button-active");
			var content = $grid.datagrid("option", "content"),
				cache = $grid.datagrid("option", "cache");
			$.extend(cache, {
				is_subscribed: "",
				q: ""
			});
			$grid.datagrid("option", "cache", cache);
			$grid.datagrid("load", "index.php?controller=pjAdminSubscriptions&action=pjActionGetSubscription", "date_subscr", "DESC", content.page, content.rowCount);
			return false;
		}).on("click", ".btn-filter", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var $this = $(this),
				content = $grid.datagrid("option", "content"),
				cache = $grid.datagrid("option", "cache"),
				obj = {};
			$this.addClass("pj-button-active").siblings(".pj-button").removeClass("pj-button-active");
			obj.is_subscribed = "";
			obj[$this.data("column")] = $this.data("value");
			$.extend(cache, obj);
			$grid.datagrid("option", "cache", cache);
			$grid.datagrid("load", "index.php?controller=pjAdminSubscriptions&action=pjActionGetSubscription", "date_subscr", "DESC", content.page, content.rowCount);
			return false;
		}).on("submit", ".frm-filter", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var $this = $(this),
				content = $grid.datagrid("option", "content"),
				cache = $grid.datagrid("option", "cache");
			$.extend(cache, {
				q: $this.find("input[name='q']").val()
			});
			$grid.datagrid("option", "cache", cache);
			$grid.datagrid("load", "index.php?controller=pjAdminSubscriptions&action=pjActionGetSubscription", "date_subscr", "DESC", content.page, content.rowCount);
			return false;
		});
	});
})(jQuery_1_8_2);